!/**
 * Highcharts JS v11.4.0 (2024-03-04)
 *
 * Boost module
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/Boost/Boostables.js",[],function(){return["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"]}),i(e,"Extensions/Boost/BoostableMap.js",[e["Extensions/Boost/Boostables.js"]],function(t){let e={};return t.forEach(t=>{e[t]=!0}),e}),i(e,"Extensions/Boost/BoostChart.js",[e["Extensions/Boost/BoostableMap.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i){let{composed:s}=e,{addEvent:o,pick:r,pushUnique:n}=i;function a(e){let i=e.series,s=e.boost=e.boost||{},o=e.options.boost||{},n=r(o.seriesThreshold,50);if(i.length>=n)return!0;if(1===i.length)return!1;let a=o.allowForce;if(void 0===a){for(let t of(a=!0,e.xAxis))if(r(t.min,-1/0)>r(t.dataMin,-1/0)||r(t.max,1/0)<r(t.dataMax,1/0)){a=!1;break}}if(void 0!==s.forceChartBoost){if(a)return s.forceChartBoost;s.forceChartBoost=void 0}let l=0,h=0,d;for(let e of i)0!==(d=e.options).boostThreshold&&!1!==e.visible&&"heatmap"!==e.type&&(t[e.type]&&++l,function(...t){let e=-Number.MAX_VALUE;return t.forEach(function(t){if(null!=t&&void 0!==t.length&&t.length>0)return e=t.length,!0}),e}(e.processedXData,d.data,e.points)>=(d.boostThreshold||Number.MAX_VALUE)&&++h);return s.forceChartBoost=a&&(l===i.length&&h===l||h>5),s.forceChartBoost}function l(t){function e(){t.boost&&t.boost.wgl&&a(t)&&t.boost.wgl.render(t)}o(t,"predraw",function(){t.boost=t.boost||{},t.boost.forceChartBoost=void 0,t.boosted=!1,t.axes.some(t=>t.isPanning)||t.boost.clear?.(),t.boost.canvas&&t.boost.wgl&&a(t)&&t.boost.wgl.allocateBuffer(t),t.boost.markerGroup&&t.xAxis&&t.xAxis.length>0&&t.yAxis&&t.yAxis.length>0&&t.boost.markerGroup.translate(t.xAxis[0].pos,t.yAxis[0].pos)}),o(t,"load",e,{order:-1}),o(t,"redraw",e);let i=-1,s=-1;o(t.pointer,"afterGetHoverData",()=>{let e=t.hoverSeries;if(t.boost=t.boost||{},t.boost.markerGroup&&e){let o=t.inverted?e.yAxis:e.xAxis,r=t.inverted?e.xAxis:e.yAxis;(o&&o.pos!==i||r&&r.pos!==s)&&(t.boost.markerGroup.translate(o.pos,r.pos),i=o.pos,s=r.pos)}})}return{compose:function(t,e){return e&&n(s,"Boost.Chart")&&t.prototype.callbacks.push(l),t},getBoostClipRect:function(t,e){let i={x:t.plotLeft,y:t.plotTop,width:t.plotWidth,height:t.navigator?t.navigator.top+t.navigator.height-t.plotTop:t.plotHeight};if(e.getClipBox){let{xAxis:s,yAxis:o}=e;if(i=e.getClipBox(),t.inverted){let t=i.width;i.width=i.height,i.height=t,i.x=o.pos,i.y=s.pos}else i.x=s.pos,i.y=o.pos}if(e===t){let e=t.inverted?t.xAxis:t.yAxis;e.length<=1&&(i.y=Math.min(e[0].pos,i.y),i.height=e[0].pos-t.plotTop+e[0].len)}return i},isChartSeriesBoosting:a}}),i(e,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}}),i(e,"Extensions/Boost/WGLShader.js",[e["Core/Utilities.js"]],function(t){let{clamp:e,error:i,pick:s}=t;return class{constructor(t){if(this.errors=[],this.uLocations={},this.gl=t,t&&!this.createShader())return}bind(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)}createShader(){let t=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),e=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),i=t=>this.gl.getUniformLocation(this.shaderProgram,t);return t&&e?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,t),this.gl.attachShader(this.shaderProgram,e),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=i("uPMatrix"),this.psUniform=i("pSize"),this.fcUniform=i("fillColor"),this.isBubbleUniform=i("isBubble"),this.bubbleSizeAbsUniform=i("bubbleSizeAbs"),this.bubbleSizeAreaUniform=i("bubbleSizeByArea"),this.uSamplerUniform=i("uSampler"),this.skipTranslationUniform=i("skipTranslation"),this.isCircleUniform=i("isCircle"),this.isInverted=i("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)}handleErrors(){this.errors.length&&i("[highcharts boost] shader error - "+this.errors.join("\n"))}stringToProgram(t,e){let i=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,t),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)}destroy(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)}fillColorUniform(){return this.fcUniform}getProgram(){return this.shaderProgram}pointSizeUniform(){return this.psUniform}perspectiveUniform(){return this.pUniform}reset(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))}setBubbleUniforms(t,i,o,r=1){let n=t.options,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&t.is("bubble")){let h=t.getPxExtremes();a=s(n.zMin,e(i,!1===n.displayNegative?n.zThreshold:-Number.MAX_VALUE,a)),l=s(n.zMax,Math.max(l,o)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==t.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,t.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",h.minPxSize*r),this.setUniform("bubbleMaxSize",h.maxPxSize*r),this.setUniform("bubbleZMin",a),this.setUniform("bubbleZMax",l),this.setUniform("bubbleZThreshold",t.options.zThreshold)}}setColor(t){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,t[0]/255,t[1]/255,t[2]/255,t[3])}setDrawAsCircle(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,t?1:0)}setInverted(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,t)}setPMatrix(t){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,t)}setPointSize(t){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,t)}setSkipTranslation(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===t?1:0)}setTexture(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,t)}setUniform(t,e){if(this.gl&&this.shaderProgram){let i=this.uLocations[t]=this.uLocations[t]||this.gl.getUniformLocation(this.shaderProgram,t);this.gl.uniform1f(i,e)}}}}),i(e,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return class{constructor(t,e,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=t,this.shader=e}allocate(t){this.iterator=-1,this.preAllocated=new Float32Array(4*t)}bind(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)}build(t,e,i){let s;return(this.data=t||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(s=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||s,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),e),this.gl.enableVertexAttribArray(this.vertAttribute),s=!1,!0):(this.destroy(),!1)}destroy(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]}push(t,e,i,s){this.preAllocated&&(this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=s)}render(t,e,i){let s=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!s&&((!t||t>s||t<0)&&(t=0),(!e||e>s)&&(e=s),!(t>=e)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],t/this.components,(e-t)/this.components),!0))}}}),i(e,"Extensions/Boost/WGLRenderer.js",[e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLDrawMode.js"],e["Extensions/Boost/WGLShader.js"],e["Extensions/Boost/WGLVertexBuffer.js"]],function(t,e,i,s,o,r){let{parse:n}=t,{doc:a,win:l}=e,{isNumber:h,isObject:d,merge:c,objectEach:u,pick:g}=i,f={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},p={scatter:!0,bubble:!0},m=["webgl","experimental-webgl","moz-webgl","webkit-3d"];class b{static orthoMatrix(t,e){return[2/t,0,0,0,0,-(2/e),0,0,0,0,-2,0,-1,1,-1,1]}static seriesPointCount(t){let e,i,s;return t.boosted?(e=!!t.options.stacking,i=t.xData||t.options.xData||t.processedXData,s=(e?t.data:i||t.options.data).length,"treemap"===t.type?s*=12:"heatmap"===t.type?s*=6:f[t.type]&&(s*=2),s):0}constructor(t){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=t,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}getPixelRatio(){return this.settings.pixelRatio||l.devicePixelRatio||1}setOptions(t){"pixelRatio"in t||(t.pixelRatio=1),c(!0,this.settings,t)}allocateBuffer(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.series.forEach(t=>{t.boosted&&(i+=b.seriesPointCount(t))}),e&&e.allocate(i))}allocateBufferForSingleSeries(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.boosted&&(i=b.seriesPointCount(t)),e&&e.allocate(i))}clear(){let t=this.gl;t&&t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)}pushSeriesData(t,e){let i=this.data,s=this.settings,o=this.vbuffer,r=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),{chart:a,options:l,sorted:h,xAxis:c,yAxis:u}=t,g=!!l.stacking,p=l.data,m=t.xAxis.getExtremes(),b=m.min-(t.xAxis.minPointOffset||0),x=m.max+(t.xAxis.minPointOffset||0),A=t.yAxis.getExtremes(),v=A.min-(t.yAxis.minPointOffset||0),y=A.max+(t.yAxis.minPointOffset||0),P=t.xData||l.xData||t.processedXData,T=t.yData||l.yData||t.processedYData,E=t.zData||l.zData||t.processedZData,S=!P||0===P.length,M=l.connectNulls,C=t.points||!1,U=g?t.data:P||p,R={x:Number.MAX_VALUE,y:0},k={x:-Number.MAX_VALUE,y:0},D=void 0===a.index,w=f[t.type],B=l.zoneAxis||"y",L=l.zones||!1,N=l.threshold,_=this.getPixelRatio(),z=t.chart.plotWidth,I=!1,G=!1,O,X,V=0,j=!1,F,Y,H,W,K=-1,Z=!1,q=!1,Q,J=!1,$=!1,tt=!1,te=!1,ti=!0,ts=!0,to,tr=!1,tn=!1,ta=0;if(l.boostData&&l.boostData.length>0)return;l.gapSize&&(tn="value"!==l.gapUnit?l.gapSize*t.closestPointRange:l.gapSize),L&&(to=[],L.forEach((t,e)=>{if(t.color){let i=n(t.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,to[e]=i,tr||void 0!==t.value||(tr=i)}}),tr||(tr=n(t.pointAttribs&&t.pointAttribs().fill||t.color).rgba,tr[0]/=255,tr[1]/=255,tr[2]/=255)),a.inverted&&(z=t.chart.plotHeight),t.closestPointRangePx=Number.MAX_VALUE;let tl=t=>{t&&(e.colorData.push(t[0]),e.colorData.push(t[1]),e.colorData.push(t[2]),e.colorData.push(t[3]))},th=(t,r,n,a=1,l)=>{tl(l),1!==_&&(!s.useGPUTranslations||e.skipTranslation)&&(t*=_,r*=_,a*=_),s.usePreallocated&&o?(o.push(t,r,n?1:0,a),ta+=4):(i.push(t),i.push(r),i.push(n?_:0),i.push(a))},td=()=>{e.segments.length&&(e.segments[e.segments.length-1].to=i.length||ta)},tc=()=>{e.segments.length&&e.segments[e.segments.length-1].from===(i.length||ta)||(td(),e.segments.push({from:i.length||ta}))},tu=(t,e,i,s,o)=>{tl(o),th(t+i,e),tl(o),th(t,e),tl(o),th(t,e+s),tl(o),th(t,e+s),tl(o),th(t+i,e+s),tl(o),th(t+i,e)};if(tc(),C&&C.length>0){e.skipTranslation=!0,e.drawMode="TRIANGLES",C[0].node&&C[0].node.levelDynamic&&C.sort((t,e)=>{if(t.node){if(t.node.levelDynamic>e.node.levelDynamic)return 1;if(t.node.levelDynamic<e.node.levelDynamic)return -1}return 0}),C.forEach(e=>{let i,s;let o=e.plotY;if(void 0!==o&&!isNaN(o)&&null!==e.y&&e.shapeArgs){let{x:o=0,y:r=0,width:l=0,height:h=0}=e.shapeArgs;i=(s=a.styledMode?e.series.colorAttribs(e):s=e.series.pointAttribs(e))["stroke-width"]||0,tt=n(s.fill).rgba,tt[0]/=255,tt[1]/=255,tt[2]/=255,t.is("treemap")&&(i=i||1,X=n(s.stroke).rgba,X[0]/=255,X[1]/=255,X[2]/=255,tu(o,r,l,h,X),i/=2),t.is("heatmap")&&a.inverted&&(o=c.len-o,r=u.len-r,l=-l,h=-h),tu(o+i,r+i,l-2*i,h-2*i,tt)}}),td();return}for(;K<U.length-1;){if(void 0===(H=U[++K]))continue;if(D)break;let i=p&&p[K];if(!S&&d(i,!0)&&i.color&&(tt=n(i.color).rgba,tt[0]/=255,tt[1]/=255,tt[2]/=255),S?(F=H[0],Y=H[1],U[K+1]&&(q=U[K+1][0]),U[K-1]&&(Z=U[K-1][0]),H.length>=3&&(W=H[2],H[2]>e.zMax&&(e.zMax=H[2]),H[2]<e.zMin&&(e.zMin=H[2]))):(F=H,Y=T[K],U[K+1]&&(q=U[K+1]),U[K-1]&&(Z=U[K-1]),E&&E.length&&(W=E[K],E[K]>e.zMax&&(e.zMax=E[K]),E[K]<e.zMin&&(e.zMin=E[K]))),!M&&(null===F||null===Y)){tc();continue}if(q&&q>=b&&q<=x&&(J=!0),Z&&Z>=b&&Z<=x&&($=!0),r?(S&&(Y=H.slice(1,3)),Q=Y[0],Y=Y[1]):g&&(F=H.x,Q=(Y=H.stackY)-H.y),null!=v&&null!=y&&(ti=Y>=v&&Y<=y),F>x&&k.x<x&&(k.x=F,k.y=Y),F<b&&R.x>b&&(R.x=F,R.y=Y),null!==Y||!M){if(null===Y||!ti&&!J&&!$){tc();continue}if(h&&(q>=b||F>=b)&&(Z<=x||F<=x)&&(te=!0),te||J||$){if(tn&&F-Z>tn&&tc(),L){let t;L.some((e,i)=>{let s=L[i-1];return"x"===B?void 0!==e.value&&F<=e.value&&(to[i]&&(!s||F>=s.value)&&(t=to[i]),!0):void 0!==e.value&&Y<=e.value&&(to[i]&&(!s||Y>=s.value)&&(t=to[i]),!0)}),tt=t||tr||tt}if(s.useGPUTranslations||(e.skipTranslation=!0,F=c.toPixels(F,!0),Y=u.toPixels(Y,!0),!(F>z)||"POINTS"!==e.drawMode)){if(e.hasMarkers&&te&&!1!==I&&(t.closestPointRangePx=Math.min(t.closestPointRangePx,Math.abs(F-I))),!s.useGPUTranslations&&!s.usePreallocated&&I&&1>Math.abs(F-I)&&G&&1>Math.abs(Y-G)){s.debug.showSkipSummary&&++V;continue}w&&(O=Q,(!1===Q||void 0===Q)&&(O=Y<0?Y:0),(r||g)&&!u.logarithmic||(O=Math.max(null===N?v:N,v)),s.useGPUTranslations||(O=u.toPixels(O,!0)),th(F,O,0,0,tt)),l.step&&!ts&&th(F,G,0,2,tt),th(F,Y,0,"bubble"===t.type?W||1:2,tt),I=F,G=Y,j=!0,ts=!1}}}}s.debug.showSkipSummary&&console.log("skipped points:",V);let tg=(t,i)=>{if(s.useGPUTranslations||(e.skipTranslation=!0,t.x=c.toPixels(t.x,!0),t.y=u.toPixels(t.y,!0)),i){this.data=[t.x,t.y,0,2].concat(this.data);return}th(t.x,t.y,0,2)};!j&&!1!==M&&"line_strip"===t.drawMode&&(R.x<Number.MAX_VALUE&&tg(R,!0),k.x>-Number.MAX_VALUE&&tg(k)),td()}pushSeries(t){let e=this.markerData,i=this.series,o=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=e.length),o.debug.timeSeriesProcessing&&console.time("building "+t.type+" series");let r={segments:[],markerFrom:e.length,colorData:[],series:t,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!t.options.marker&&!1!==t.options.marker.enabled,showMarkers:!0,drawMode:s[t.type]||"LINE_STRIP"};t.index>=i.length?i.push(r):i[t.index]=r,this.pushSeriesData(t,r),o.debug.timeSeriesProcessing&&console.timeEnd("building "+t.type+" series")}flush(){let t=this.vbuffer;this.data=[],this.markerData=[],this.series=[],t&&t.destroy()}setXAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("xAxisTrans",t.transA*i),e.setUniform("xAxisMin",t.min),e.setUniform("xAxisMinPad",t.minPixelPadding*i),e.setUniform("xAxisPointRange",t.pointRange),e.setUniform("xAxisLen",t.len*i),e.setUniform("xAxisPos",t.pos*i),e.setUniform("xAxisCVSCoord",!t.horiz),e.setUniform("xAxisIsLog",!!t.logarithmic),e.setUniform("xAxisReversed",!!t.reversed)}setYAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("yAxisTrans",t.transA*i),e.setUniform("yAxisMin",t.min),e.setUniform("yAxisMinPad",t.minPixelPadding*i),e.setUniform("yAxisPointRange",t.pointRange),e.setUniform("yAxisLen",t.len*i),e.setUniform("yAxisPos",t.pos*i),e.setUniform("yAxisCVSCoord",!t.horiz),e.setUniform("yAxisIsLog",!!t.logarithmic),e.setUniform("yAxisReversed",!!t.reversed)}setThreshold(t,e){let i=this.shader;i&&(i.setUniform("hasThreshold",t),i.setUniform("translatedThreshold",e))}renderChart(i){let s=this.gl,o=this.settings,a=this.shader,l=this.vbuffer,d=this.getPixelRatio();if(!i)return!1;this.width=i.chartWidth*d,this.height=i.chartHeight*d;let c=this.height,u=this.width;if(!s||!a||!u||!c)return!1;o.debug.timeRendering&&console.time("gl rendering"),s.canvas.width=u,s.canvas.height=c,a.bind(),s.viewport(0,0,u,c),a.setPMatrix(b.orthoMatrix(u,c)),o.lineWidth>1&&!e.isMS&&s.lineWidth(o.lineWidth),l&&(l.build(this.data,"aVertexPosition",4),l.bind()),a.setInverted(i.inverted),this.series.forEach((e,c)=>{let u=e.series.options,f=u.marker,m=void 0!==u.lineWidth?u.lineWidth:1,b=u.threshold,x=h(b),A=e.series.yAxis.getThreshold(b),v=g(u.marker?u.marker.enabled:null,!!e.series.xAxis.isRadial||null,e.series.closestPointRangePx>2*((u.marker?u.marker.radius:10)||10)),y=this.textureHandles[f&&f.symbol||e.series.symbol]||this.textureHandles.circle,P,T,E,S=[];if(0!==e.segments.length&&e.segments[0].from!==e.segments[0].to&&(y.isReady&&(s.bindTexture(s.TEXTURE_2D,y.handle),a.setTexture(y.handle)),i.styledMode?E=e.series.markerGroup&&e.series.markerGroup.getStyle("fill"):(E="POINTS"===e.drawMode&&e.series.pointAttribs&&e.series.pointAttribs().fill||e.series.color,u.colorByPoint&&(E=e.series.chart.options.colors[c])),e.series.fillOpacity&&u.fillOpacity&&(E=new t(E).setOpacity(g(u.fillOpacity,1)).get()),S=n(E).rgba,o.useAlpha||(S[3]=1),"LINES"===e.drawMode&&o.useAlpha&&S[3]<1&&(S[3]/=10),"add"===u.boostBlending?(s.blendFunc(s.SRC_ALPHA,s.ONE),s.blendEquation(s.FUNC_ADD)):"mult"===u.boostBlending||"multiply"===u.boostBlending?s.blendFunc(s.DST_COLOR,s.ZERO):"darken"===u.boostBlending?(s.blendFunc(s.ONE,s.ONE),s.blendEquation(s.FUNC_MIN)):s.blendFuncSeparate(s.SRC_ALPHA,s.ONE_MINUS_SRC_ALPHA,s.ONE,s.ONE_MINUS_SRC_ALPHA),a.reset(),e.colorData.length>0?(a.setUniform("hasColor",1),(T=new r(s,a)).build(Array(e.segments[0].from).concat(e.colorData),"aColor",4),T.bind()):(a.setUniform("hasColor",0),s.disableVertexAttribArray(s.getAttribLocation(a.getProgram(),"aColor"))),a.setColor(S),this.setXAxis(e.series.xAxis),this.setYAxis(e.series.yAxis),this.setThreshold(x,A),"POINTS"===e.drawMode&&a.setPointSize(2*g(u.marker&&u.marker.radius,.5)*d),a.setSkipTranslation(e.skipTranslation),"bubble"===e.series.type&&a.setBubbleUniforms(e.series,e.zMin,e.zMax,d),a.setDrawAsCircle(p[e.series.type]||!1),l)){if(m>0||"LINE_STRIP"!==e.drawMode)for(P=0;P<e.segments.length;P++)l.render(e.segments[P].from,e.segments[P].to,e.drawMode);if(e.hasMarkers&&v)for(a.setPointSize(2*g(u.marker&&u.marker.radius,5)*d),a.setDrawAsCircle(!0),P=0;P<e.segments.length;P++)l.render(e.segments[P].from,e.segments[P].to,"POINTS")}}),o.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()}render(t){if(this.clear(),t.renderer.forExport)return this.renderChart(t);this.isInited?this.renderChart(t):setTimeout(()=>{this.render(t)},1)}setSize(t,e){let i=this.shader;i&&(this.width!==t||this.height!==e)&&(this.width=t,this.height=e,i.bind(),i.setPMatrix(b.orthoMatrix(t,e)))}init(t,e){let i=this.settings;if(this.isInited=!1,!t)return!1;i.debug.timeSetup&&console.time("gl setup");for(let e=0;e<m.length&&(this.gl=t.getContext(m[e],{}),!this.gl);++e);let s=this.gl;if(!s)return!1;e||this.flush(),s.enable(s.BLEND),s.blendFunc(s.SRC_ALPHA,s.ONE_MINUS_SRC_ALPHA),s.disable(s.DEPTH_TEST),s.depthFunc(s.LESS);let n=this.shader=new o(s);if(!n)return!1;this.vbuffer=new r(s,n);let l=(t,e)=>{let i={isReady:!1,texture:a.createElement("canvas"),handle:s.createTexture()},o=i.texture.getContext("2d");this.textureHandles[t]=i,i.texture.width=512,i.texture.height=512,o.mozImageSmoothingEnabled=!1,o.webkitImageSmoothingEnabled=!1,o.msImageSmoothingEnabled=!1,o.imageSmoothingEnabled=!1,o.strokeStyle="rgba(255, 255, 255, 0)",o.fillStyle="#FFF",e(o);try{s.activeTexture(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,i.handle),s.texImage2D(s.TEXTURE_2D,0,s.RGBA,s.RGBA,s.UNSIGNED_BYTE,i.texture),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.bindTexture(s.TEXTURE_2D,null),i.isReady=!0}catch(t){}};return l("circle",t=>{t.beginPath(),t.arc(256,256,256,0,2*Math.PI),t.stroke(),t.fill()}),l("square",t=>{t.fillRect(0,0,512,512)}),l("diamond",t=>{t.beginPath(),t.moveTo(256,0),t.lineTo(512,256),t.lineTo(256,512),t.lineTo(0,256),t.lineTo(256,0),t.fill()}),l("triangle",t=>{t.beginPath(),t.moveTo(0,512),t.lineTo(256,0),t.lineTo(512,512),t.lineTo(0,512),t.fill()}),l("triangle-down",t=>{t.beginPath(),t.moveTo(0,0),t.lineTo(256,512),t.lineTo(512,0),t.lineTo(0,0),t.fill()}),this.isInited=!0,i.debug.timeSetup&&console.timeEnd("gl setup"),!0}destroy(){let t=this.gl,e=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),e&&e.destroy(),t&&(u(this.textureHandles,e=>{e.handle&&t.deleteTexture(e.handle)}),t.canvas.width=1,t.canvas.height=1)}}return b}),i(e,"Extensions/Boost/BoostSeries.js",[e["Extensions/Boost/BoostableMap.js"],e["Extensions/Boost/Boostables.js"],e["Extensions/Boost/BoostChart.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLRenderer.js"]],function(t,e,i,s,o,r,n){let a,l;let{getBoostClipRect:h,isChartSeriesBoosting:d}=i,{getOptions:c}=s,{composed:u,doc:g,noop:f,win:p}=o,{addEvent:m,destroyObjectProperties:b,error:x,extend:A,fireEvent:v,isArray:y,isNumber:P,pick:T,pushUnique:E,wrap:S,defined:M}=r;function C(t,e){let i=e.boost;t&&i&&i.target&&i.canvas&&!d(e.chart)&&t.allocateBufferForSingleSeries(e)}function U(t){return T(t&&t.options&&t.options.boost&&t.options.boost.enabled,!0)}function R(t,e){let i=t.constructor,s=t.seriesGroup||e.group,o=t.chartWidth,r=t.chartHeight,a=t,c="undefined"!=typeof SVGForeignObjectElement,u=(a=d(t)?t:e).boost=a.boost||{};if(c=!1,l||(l=g.createElement("canvas")),!u.target&&(u.canvas=l,t.renderer.forExport||!c?(a.renderTarget=u.target=t.renderer.image("",0,0,o,r).addClass("highcharts-boost-canvas").add(s),u.clear=function(){u.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},u.copy=function(){u.resize(),u.target.attr({href:u.canvas.toDataURL("image/png")})}):(u.targetFo=t.renderer.createElement("foreignObject").add(s),a.renderTarget=u.target=g.createElement("canvas"),u.targetCtx=u.target.getContext("2d"),u.targetFo.element.appendChild(u.target),u.clear=function(){u.target.width=u.canvas.width,u.target.height=u.canvas.height},u.copy=function(){u.target.width=u.canvas.width,u.target.height=u.canvas.height,u.targetCtx.drawImage(u.canvas,0,0)}),u.resize=function(){o=t.chartWidth,r=t.chartHeight,(u.targetFo||u.target).attr({x:0,y:0,width:o,height:r}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1}),a instanceof i&&a.boost.markerGroup.translate(t.plotLeft,t.plotTop)},u.clipRect=t.renderer.clipRect(),(u.targetFo||u.target).attr({zIndex:e.options.zIndex}),a instanceof i&&(a.boost.markerGroup=a.renderer.g().add(s).translate(e.xAxis.pos,e.yAxis.pos))),u.canvas.width=o,u.canvas.height=r,u.clipRect){let e=h(t,a),i=e.width===t.clipBox.width&&e.height===t.clipBox.height?s:u.targetFo||u.target;u.clipRect.attr(e),i?.clip(u.clipRect)}return u.resize(),u.clear(),!u.wgl&&(u.wgl=new n(t=>{t.settings.debug.timeBufferCopy&&console.time("buffer copy"),u.copy(),t.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),u.wgl.init(u.canvas)||x("[highcharts boost] - unable to init WebGL renderer"),u.wgl.setOptions(t.options.boost||{}),a instanceof i&&u.wgl.allocateBuffer(t)),u.wgl.setSize(o,r),u.wgl}function k(t){let e=t.points;if(e){let t,i;for(i=0;i<e.length;i+=1)(t=e[i])&&t.destroyElements&&t.destroyElements()}for(let e of(["graph","area","tracker"].forEach(e=>{let i=t[e];i&&(t[e]=i.destroy())}),t.zones))b(e,void 0,!0)}function D(t,e,i,s,o,r){let n=(o=o||0)+(s=s||3e3),a=!0;for(;a&&o<n&&o<t.length;)a=e(t[o],o),++o;a&&(o<t.length?r?D(t,e,i,s,o,r):p.requestAnimationFrame?p.requestAnimationFrame(function(){D(t,e,i,s,o)}):setTimeout(D,0,t,e,i,s,o):i&&i())}function w(t,e){let i=t.options,s=i.data,o=t.xAxis&&t.xAxis.options,r=t.yAxis&&t.yAxis.options,n=t.colorAxis&&t.colorAxis.options;return s.length>(i.boostThreshold||Number.MAX_VALUE)&&P(r.min)&&P(r.max)&&(!e||P(o.min)&&P(o.max))&&(!n||P(n.min)&&P(n.max))}let B=(t,e)=>!t.forceCrop&&(d(t.chart)||(e?e.length:0)>=(t.options.boostThreshold||Number.MAX_VALUE));function L(){let t=this,e=t.chart;e.boost&&e.boost.markerGroup===t.markerGroup&&(t.markerGroup=null),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=null)}function N(){let t=this.boost;t&&t.canvas&&t.target&&(t.wgl&&t.wgl.clear(),t.clear&&t.clear())}function _(t){let e=t.boost;e&&e.canvas&&e.target&&e.wgl&&!d(t.chart)&&e.wgl.render(t.chart)}function z(t,e){let i=t.options,s=t.xAxis,o=t.pointClass;if(e instanceof o)return e;let r=t.xData||i.xData||t.processedXData||!1,n=new o(t,(t.options.data||[])[e.i],r?r[e.i]:void 0);return n.category=T(s.categories?s.categories[n.x]:n.x,n.x),n.dist=e.dist,n.distX=e.distX,n.plotX=e.plotX,n.plotY=e.plotY,n.index=e.i,n.percentage=e.percentage,n.isInside=t.isPointInside(n),n}function I(t){var e,i,s,o;let{options:r,xAxis:n,yAxis:a}=this;if(!this.isDirty&&!n.isDirty&&!a.isDirty&&!t)return!1;this.yAxis.setTickInterval();let l=r.boostThreshold||0,h=r.cropThreshold,d=r.data||this.data,c=this.xData,u=n.getExtremes(),g=u.max??Number.MAX_VALUE,f=u.min??-Number.MAX_VALUE,p=this.yData,m=a.getExtremes(),b=m.max??Number.MAX_VALUE,x=m.min??-Number.MAX_VALUE;if(!this.boosted&&n.old&&a.old&&f>=(n.old.min??-Number.MAX_VALUE)&&g<=(n.old.max??Number.MAX_VALUE)&&x>=(a.old.min??-Number.MAX_VALUE)&&b<=(a.old.max??Number.MAX_VALUE))return this.processedXData??(this.processedXData=c),this.processedYData??(this.processedYData=p),!0;if(!l||d.length<l||h&&!this.forceCrop&&!this.getExtremesFromAll&&!r.getExtremesFromAll&&d.length<h)return this.processedXData=c,this.processedYData=p,!0;let A=[],v=[],y=[],T=!(P(u.max)||P(u.min)),E=!(P(m.max)||P(m.min)),S=!1,M,C=c[0],U=c[0],R,k=p[0],D=p[0];for(let t=0,e=c.length;t<e;++t)M=c[t],R=p[t],M>=f&&M<=g&&R>=x&&R<=b?(A.push({x:M,y:R}),v.push(M),y.push(R),T&&(C=Math.max(C,M),U=Math.min(U,M)),E&&(k=Math.max(k,R),D=Math.min(D,R))):S=!0;return T&&((e=n.options).max??(e.max=C),(i=n.options).min??(i.min=U)),E&&((s=a.options).max??(s.max=k),(o=a.options).min??(o.min=D)),this.cropped=S,this.cropStart=0,this.processedXData=v,this.processedYData=y,B(this,v)||(this.processedData=A),!0}function G(){let t=this.options||{},e=this.chart,i=this.xAxis,s=this.yAxis,o=t.xData||this.processedXData,r=t.yData||this.processedYData,n=this.processedData||t.data,l=i.getExtremes(),h=l.min-(i.minPointOffset||0),c=l.max+(i.minPointOffset||0),u=s.getExtremes(),g=u.min-(s.minPointOffset||0),p=u.max+(s.minPointOffset||0),m={},b=!!this.sampling,x=t.enableMouseTracking,A=t.threshold,y=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),P=!!t.stacking,T=this.cropStart||0,E=this.requireSorting,S=!o,U="x"===t.findNearestPointBy,w=this.xData||this.options.xData||this.processedXData||!1,B=!1,L,N=s.getThreshold(A),z,I,G,O;if(i.isPanning||s.isPanning||(B=R(e,this),e.boosted=!0,!this.visible))return;(this.points||this.graph)&&k(this),d(e)?(this.markerGroup&&this.markerGroup!==e.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=e.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(e.boost&&this.markerGroup===e.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,e.seriesGroup));let X=this.points=[],V=(t,o,r,n)=>{let l=!!w&&w[T+r],h=t=>{e.inverted&&(t=i.len-t,o=s.len-o),X.push({destroy:f,x:l,clientX:t,plotX:t,plotY:o,i:T+r,percentage:n})};t=Math.ceil(t),a=U?t:t+","+o,x&&(m[a]?l===w[w.length-1]&&(X.length--,h(t)):(m[a]=!0,h(t)))};this.buildKDTree=f,v(this,"renderCanvas"),B&&(C(B,this),B.pushSeries(this),_(this));let j=B.settings;e.renderer.forExport||(j.debug.timeKDTree&&console.time("kd tree building"),D(P?this.data.slice(T):o||n,function(t,o){let n=void 0===e.index,a,l,d,u,f,m=!1,x=!0;return!M(t)||(!n&&(S?(a=t[0],l=t[1]):(a=t,l=r[o]),y?(S&&(l=t.slice(1,3)),m=l[0],l=l[1]):P&&(a=t.x,m=(l=t.stackY)-t.y,f=t.percentage),E||(x=(l||0)>=g&&l<=p),null!==l&&a>=h&&a<=c&&x&&(d=i.toPixels(a,!0),b?((void 0===G||d===L)&&(y||(m=l),(void 0===O||l>I)&&(I=l,O=o),(void 0===G||m<z)&&(z=m,G=o)),U&&d===L||(void 0!==G&&(u=s.toPixels(I,!0),N=s.toPixels(z,!0),V(d,u,O,f),N!==u&&V(d,N,G,f)),G=O=void 0,L=d)):V(d,u=Math.ceil(s.toPixels(l,!0)),o,f))),!n)},()=>{v(this,"renderedCanvas"),delete this.buildKDTree,this.options&&this.buildKDTree(),j.debug.timeKDTree&&console.timeEnd("kd tree building")}))}function O(t){let e=!0;if(this.chart.options&&this.chart.options.boost&&(e=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!e||!this.boosted)return t.call(this);this.chart.boosted=!0;let i=R(this.chart,this);i&&(C(i,this),i.pushSeries(this)),_(this)}function X(t){if(this.boosted){if(w(this))return{};if(this.xAxis.isPanning||this.yAxis.isPanning)return this}return t.apply(this,[].slice.call(arguments,1))}function V(e){let i=this.options.data;if(U(this.chart)&&t[this.type]){let t=this.is("scatter")&&!this.is("bubble");if(!B(this,i)||t||this.options.stacking||!w(this,!0)){if(this.boosted&&(this.xAxis?.isPanning||this.yAxis?.isPanning))return;t&&!this.yAxis.treeGrid?I.call(this,arguments[1]):e.apply(this,[].slice.call(arguments,1)),i=this.processedXData}if(this.boosted=B(this,i),this.boosted){let t;this.options.data&&this.options.data.length&&!P(t=this.getFirstValidPoint(this.options.data))&&!y(t)&&x(12,!1,this.chart),function(t){t.boost=t.boost||{getPoint:e=>z(t,e)};let e=t.boost.altered=[];if(["allowDG","directTouch","stickyTracking"].forEach(i=>{e.push({prop:i,val:t[i],own:Object.hasOwnProperty.call(t,i)})}),t.allowDG=!1,t.directTouch=!1,t.stickyTracking=!0,t.finishedAnimating=!0,t.labelBySeries&&(t.labelBySeries=t.labelBySeries.destroy()),t.is("scatter")&&t.data.length){for(let e of t.data)e?.destroy?.();t.data.length=0,t.points.length=0,delete t.processedData}}(this)}else!function(t){let e=t.boost;e&&((e.altered||[]).forEach(e=>{e.own?t[e.prop]=e.val:delete t[e.prop]}),e.clear&&e.clear())}(this)}else e.apply(this,[].slice.call(arguments,1))}function j(t){let e=t.apply(this,[].slice.call(arguments,1));return this.boost&&e?this.boost.getPoint(e):e}return{compose:function(i,s,o){if(E(u,"Boost.Series")){let r=c().plotOptions,n=i.prototype;if(m(i,"destroy",L),m(i,"hide",N),o&&(n.renderCanvas=G),S(n,"getExtremes",X),S(n,"processData",V),S(n,"searchPoint",j),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(e=>(function(e,i,s){function o(e){let i=this.options.stacking&&("translate"===s||"generatePoints"===s);this.boosted&&!i&&U(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&t[this.type]&&0!==this.options.boostThreshold?"render"===s&&this.renderCanvas&&this.renderCanvas():e.call(this)}if(S(e,s,o),"translate"===s)for(let t of["column","arearange","columnrange","heatmap","treemap"])i[t]&&S(i[t].prototype,s,o)})(n,s,e)),e.forEach(t=>{let e=r[t];e&&(e.boostThreshold=5e3,e.boostData=[],s[t].prototype.fillOpacity=!0)}),o){let{area:t,areaspline:e,bubble:i,column:o,heatmap:r,scatter:n,treemap:a}=s;if(t&&A(t.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),e&&A(e.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),i){let t=i.prototype;delete t.buildKDTree,S(t,"markerAttribs",function(t){return!this.boosted&&t.apply(this,[].slice.call(arguments,1))})}o&&A(o.prototype,{fill:!0,sampling:!0}),n&&(n.prototype.fill=!0),[r,a].forEach(t=>{t&&S(t.prototype,"drawPoints",O)})}}return i},destroyGraphics:k,eachAsync:D,getPoint:z}}),i(e,"Extensions/BoostCanvas.js",[e["Extensions/Boost/BoostChart.js"],e["Extensions/Boost/BoostSeries.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,s,o){var r;let{getBoostClipRect:n,isChartSeriesBoosting:a}=t,{destroyGraphics:l}=e,{parse:h}=i,{doc:d,noop:c}=s,{addEvent:u,fireEvent:g,isNumber:f,merge:p,pick:m,wrap:b}=o;return function(t){let s;let r="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";function x(t,e,i,s,o){o&&e!==o.clientX&&(t.moveTo(o.clientX,o.yBottom),t.lineTo(o.clientX,o.plotY),t.lineTo(e,i),t.lineTo(e,s))}function A(t,e,i,s,o){t.moveTo(e,i),t.arc(e,i,this.radii&&this.radii[o],0,2*Math.PI,!1)}function v(t,e,i,s){t.rect(e-1,i,1,s-i)}function y(){this.boost&&this.boost.copy&&this.boost.copy()}function P(){let t=this.boost||{};t.target&&t.target.attr({href:r}),t.canvas&&t.canvas.getContext("2d").clearRect(0,0,t.canvas.width,t.canvas.height)}function T(){a(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()}function E(t,e,i){t.lineTo(e,i)}function S(){let t;let e=this.chart,i=a(e)?e:this,s=i===e?e.seriesGroup:e.seriesGroup||this.group,o=e.chartWidth,l=e.chartHeight,h=function(t,e,i,s,o,r,n){t.call(this,i,e,s,o,r,n)},c=i.boost=i.boost||{};return t=c.targetCtx,c.canvas||(c.canvas=d.createElement("canvas"),c.target=e.renderer.image("",0,0,o,l).addClass("highcharts-boost-canvas").add(s),t=c.targetCtx=c.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(e=>{b(t,e,h)}),c.copy=function(){c.target.attr({href:c.canvas.toDataURL("image/png")})},c.clear=function(){t.clearRect(0,0,c.canvas.width,c.canvas.height),i===c.target&&c.target.attr({href:r})},c.clipRect=e.renderer.clipRect(),c.target.clip(c.clipRect)),c.canvas.width!==o&&(c.canvas.width=o),c.canvas.height!==l&&(c.canvas.height=l),c.target.attr({x:0,y:0,width:o,height:l,style:"pointer-events: none",href:r}),c.clipRect&&c.clipRect.attr(n(e,i)),t}function M(){let t=this,n=t.options,a=t.chart,d=t.xAxis,b=t.yAxis,x=a.options.boost||{},A={timeRendering:x.timeRendering||!1,timeSeriesProcessing:x.timeSeriesProcessing||!1,timeSetup:x.timeSetup||!1},v=t.processedXData,y=t.processedYData,P=n.data,T=d.getExtremes(),E=T.min,S=T.max,M=b.getExtremes(),C=M.min,U=M.max,R={},k=!!t.sampling,D=n.marker&&n.marker.radius,w=t.cvsStrokeBatch||1e3,B=n.enableMouseTracking,L=n.threshold,N=f(L),_=b.getThreshold(L),z=t.fill,I=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),G=!!n.stacking,O=t.cropStart||0,X=a.options.loading,V=t.requireSorting,j=n.connectNulls,F=!v,Y=G?t.data:v||P,H=t.fillOpacity?i.parse(t.color).setOpacity(m(n.fillOpacity,.75)).get():t.color,W="x"===n.findNearestPointBy,K=this.boost||{},Z=t.cvsDrawPoint,q=n.lineWidth?t.cvsLineTo:void 0,Q=D&&D<=1?t.cvsMarkerSquare:t.cvsMarkerCircle;K.target&&K.target.attr({href:r}),(t.points||t.graph)&&l(t),t.plotGroup("group","series",t.visible?"visible":"hidden",n.zIndex,a.seriesGroup),t.markerGroup=t.group,u(t,"destroy",function(){t.markerGroup=null});let J=this.points=[],$=this.getContext();if(t.buildKDTree=c,K.clear&&K.clear(),!t.visible)return;P.length>99999&&(a.options.loading=p(X,{labelStyle:{backgroundColor:h("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),o.clearTimeout(s),a.showLoading("Drawing..."),a.options.loading=X),A.timeRendering&&console.time("canvas rendering");let tt=0,te,ti,ts=_,to,tr,tn,ta,tl,th,td=function(){z?($.fillStyle=H,$.fill()):($.strokeStyle=t.color,$.lineWidth=n.lineWidth,$.stroke())},tc=function(e,i,s,o){0===tt&&($.beginPath(),q&&($.lineJoin="round")),a.scroller&&"highcharts-navigator-series"===t.options.className?(i+=a.scroller.top,s&&(s+=a.scroller.top)):i+=a.plotTop,e+=a.plotLeft,to?$.moveTo(e,i):Z?Z($,e,i,s,ti):q?q($,e,i):Q&&Q.call(t,$,e,i,D,o),(tt+=1)===w&&(td(),tt=0),ti={clientX:e,plotY:i,yBottom:s}},tu=this.xData||this.options.xData||this.processedXData||!1,tg=function(t,e,i){th=W?t:t+","+e,B&&!R[th]&&(R[th]=!0,a.inverted&&(t=d.len-t,e=b.len-e),J.push({x:!!tu&&tu[O+i],clientX:t,plotX:t,plotY:e,i:O+i}))};e.eachAsync(Y,(e,i)=>{let s=void 0===a.index,o,r,n,l,h,c,u=!1,g=!1,f=NaN,p=NaN,m=!0;return!s&&(F?(o=e[0],r=e[1],Y[i+1]&&(f=Y[i+1][0]),Y[i-1]&&(p=Y[i-1][0])):(o=e,r=y[i],Y[i+1]&&(f=Y[i+1]),Y[i-1]&&(p=Y[i-1])),f&&f>=E&&f<=S&&(u=!0),p&&p>=E&&p<=S&&(g=!0),I?(F&&(r=e.slice(1,3)),c=r[0],r=r[1]):G&&(o=e.x,c=(r=e.stackY)-e.y),h=null===r,V||(m=r>=C&&r<=U),!h&&(o>=E&&o<=S&&m||u||g)&&(n=Math.round(d.toPixels(o,!0)),k?((void 0===ta||n===te)&&(I||(c=r),(void 0===tl||r>tn)&&(tn=r,tl=i),(void 0===ta||c<tr)&&(tr=c,ta=i)),n!==te&&(void 0!==ta&&(l=b.toPixels(tn,!0),ts=b.toPixels(tr,!0),tc(n,N?Math.min(l,_):l,N?Math.max(ts,_):ts,i),tg(n,l,tl),ts!==l&&tg(n,ts,ta)),ta=tl=void 0,te=n)):(tc(n,l=Math.round(b.toPixels(r,!0)),ts,i),tg(n,l,i))),to=h&&!j,i%5e4==0&&(t.boost&&t.boost.copy?t.boost.copy():t.chart.boost&&t.chart.boost.copy&&t.chart.boost.copy())),!s},function(){let e=a.loadingDiv,i=a.loadingShown;td(),t.canvasToSVG(),A.timeRendering&&console.timeEnd("canvas rendering"),g(t,"renderedCanvas"),i&&(e.style.transition="opacity 250ms",e.opacity=0,a.loadingShown=!1,s=setTimeout(function(){e.parentNode&&e.parentNode.removeChild(e),a.loadingDiv=a.loadingSpan=null},250)),delete t.buildKDTree,t.buildKDTree()},a.renderer.forExport?Number.MAX_VALUE:void 0)}function C(t,e,i,s){t.moveTo(e,i),t.arc(e,i,s,0,2*Math.PI,!1)}function U(t,e,i,s){t.rect(e-s,i-s,2*s,2*s)}function R(){let t=this.chart,e=this.getContext(),i=this.chart.inverted,s=this.xAxis,o=this.yAxis;e?(this.points.forEach(r=>{let n=r.plotY,a;if(void 0!==n&&!isNaN(n)&&null!==r.y&&e){let{x:n=0,y:l=0,width:h=0,height:d=0}=r.shapeArgs||{};a=t.styledMode?r.series.colorAttribs(r):r.series.pointAttribs(r),e.fillStyle=a.fill,i?e.fillRect(o.len-l+s.left,s.len-n+o.top,-d,-h):e.fillRect(n+s.left,l+o.top,h,d)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}t.compose=function(t,e,i){let s=e.prototype;if(!s.renderCanvas){let{area:e,bubble:o,column:r,heatmap:n,scatter:a}=i;if(t.prototype.callbacks.push(t=>{u(t,"predraw",P),u(t,"render",y)}),s.canvasToSVG=T,s.cvsLineTo=E,s.getContext=S,s.renderCanvas=M,e){let t=e.prototype;t.cvsDrawPoint=x,t.fill=!0,t.fillOpacity=!0,t.sampling=!0}if(o){let t=o.prototype;t.cvsMarkerCircle=A,t.cvsStrokeBatch=1}if(r){let t=r.prototype;t.cvsDrawPoint=v,t.fill=!0,t.sampling=!0}if(n&&b(n.prototype,"drawPoints",R),a){let t=a.prototype;t.cvsMarkerCircle=C,t.cvsMarkerSquare=U,t.fill=!0}}}}(r||(r={})),r}),i(e,"masters/modules/boost-canvas.src.js",[e["Core/Globals.js"],e["Extensions/BoostCanvas.js"]],function(t,e){return t.initCanvasBoost=function(){e.compose(t.Chart,t.Series,t.seriesTypes)},t})});