!/**
 * Highcharts JS v11.4.0 (2024-03-04)
 *
 * Highcharts
 *
 * (c) 2010-2024 Highsoft AS
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/data-tools",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function o(t,e,o,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}o(e,"Data/Modifiers/DataModifier.js",[e["Core/Utilities.js"]],function(t){var e,o=t.addEvent,r=t.fireEvent,n=t.merge,i=function(){function t(){}return t.prototype.benchmark=function(t,e){var o=[],r=this,i=function(){r.modifyTable(t),r.emit({type:"afterBenchmarkIteration"})},s=n({iterations:1},e).iterations;r.on("afterBenchmarkIteration",function(){if(o.length===s){r.emit({type:"afterBenchmark",results:o});return}i()});var a={startTime:0,endTime:0};return r.on("modify",function(){a.startTime=window.performance.now()}),r.on("afterModify",function(){a.endTime=window.performance.now(),o.push(a.endTime-a.startTime)}),i(),o},t.prototype.emit=function(t){r(this,t.type,t)},t.prototype.modify=function(t,e){var o=this;return new Promise(function(r,n){t.modified===t&&(t.modified=t.clone(!1,e));try{r(o.modifyTable(t,e))}catch(r){o.emit({type:"error",detail:e,table:t}),n(r)}})},t.prototype.modifyCell=function(t,e,o,r,n){return this.modifyTable(t)},t.prototype.modifyColumns=function(t,e,o,r){return this.modifyTable(t)},t.prototype.modifyRows=function(t,e,o,r){return this.modifyTable(t)},t.prototype.on=function(t,e){return o(this,t,e)},t}();return(e=i||(i={})).types={},e.registerType=function(t,o){return!!t&&!e.types[t]&&!!(e.types[t]=o)},i}),o(e,"Data/DataTable.js",[e["Core/Utilities.js"]],function(t){var e=t.addEvent,o=t.fireEvent,r=t.uniqueKey;return function(){function t(t){void 0===t&&(t={}),this.aliases=t.aliases?JSON.parse(JSON.stringify(t.aliases)):{},this.autoId=!t.id,this.columns={},this.id=t.id||r(),this.modified=this,this.rowCount=0,this.versionTag=r();for(var e=t.columns||{},o=Object.keys(e),n=this.columns,i=0,s=0,a=o.length,u=void 0,l=void 0;s<a;++s)u=e[l=o[s]].slice(),n[l]=u,i=Math.max(i,u.length);for(var s=0,a=o.length;s<a;++s)n[o[s]].length=i;this.rowCount=i;for(var c=t.aliases||{},f=Object.keys(c),p=this.aliases,s=0,a=f.length,h=void 0;s<a;++s)p[h=f[s]]=c[h]}return t.isNull=function(e){if(e===t.NULL)return!0;if(e instanceof Array){if(!e.length)return!1;for(var o=0,r=e.length;o<r;++o)if(null!==e[o])return!1}else{var n=Object.keys(e);if(!n.length)return!1;for(var o=0,r=n.length;o<r;++o)if(null!==e[n[o]])return!1}return!0},t.prototype.clone=function(e,o){var r={};this.emit({type:"cloneTable",detail:o}),e||(r.aliases=this.aliases,r.columns=this.columns),this.autoId||(r.id=this.id);var n=new t(r);return e||(n.versionTag=this.versionTag),this.emit({type:"afterCloneTable",detail:o,tableClone:n}),n},t.prototype.deleteColumnAlias=function(t){var e,o=this.aliases[t],r=this.modifier;return o&&(delete this.aliases[t],r&&r.modifyColumns(this,((e={})[o]=Array(this.rowCount),e),0)),o},t.prototype.deleteColumns=function(t,e){var o=this.columns,r={},n={},i=this.modifier,s=this.rowCount;if((t=t||Object.keys(o)).length){this.emit({type:"deleteColumns",columnNames:t,detail:e});for(var a=0,u=t.length,l=void 0,c=void 0;a<u;++a)(l=o[c=t[a]])&&(r[c]=l,n[c]=Array(s)),delete o[c];return Object.keys(o).length||(this.rowCount=0),i&&i.modifyColumns(this,n,0,e),this.emit({type:"afterDeleteColumns",columns:r,columnNames:t,detail:e}),r}},t.prototype.deleteRows=function(t,e,o){void 0===e&&(e=1);var r=[],n=[],i=this.modifier;if(this.emit({type:"deleteRows",detail:o,rowCount:e,rowIndex:t||0}),void 0===t&&(t=0,e=this.rowCount),e>0&&t<this.rowCount)for(var s=this.columns,a=Object.keys(s),u=0,l=a.length,c=void 0,f=void 0;u<l;++u){f=(c=s[a[u]]).splice(t,e),u||(this.rowCount=c.length);for(var p=0,h=f.length;p<h;++p)r[p]=r[p]||[],r[p][u]=f[p];n.push(Array(l))}return i&&i.modifyRows(this,n,t||0,o),this.emit({type:"afterDeleteRows",detail:o,rowCount:e,rowIndex:t||0,rows:r}),r},t.prototype.emit=function(t){switch(t.type){case"afterDeleteColumns":case"afterDeleteRows":case"afterSetCell":case"afterSetColumns":case"afterSetRows":this.versionTag=r()}o(this,t.type,t)},t.prototype.getCell=function(t,e){t=this.aliases[t]||t;var o=this.columns[t];if(o)return o[e]},t.prototype.getCellAsBoolean=function(t,e){t=this.aliases[t]||t;var o=this.columns[t];return!!(o&&o[e])},t.prototype.getCellAsNumber=function(t,e,o){t=this.aliases[t]||t;var r=this.columns[t],n=r&&r[e];switch(typeof n){case"boolean":return n?1:0;case"number":return isNaN(n)&&!o?null:n}return isNaN(n=parseFloat("".concat(n)))&&!o?null:n},t.prototype.getCellAsString=function(t,e){t=this.aliases[t]||t;var o=this.columns[t];return"".concat(o&&o[e])},t.prototype.getColumn=function(t,e){return this.getColumns([t],e)[t]},t.prototype.getColumnAsNumbers=function(t,e){var o=this.columns[t=this.aliases[t]||t],r=[];if(o){var n=o.length;if(e)for(var i=0;i<n;++i)r.push(this.getCellAsNumber(t,i,!0));else{for(var i=0,s=void 0;i<n;++i){if("number"==typeof(s=o[i]))return o.slice();if(null!=s)break}for(var i=0;i<n;++i)r.push(this.getCellAsNumber(t,i))}}return r},t.prototype.getColumnNames=function(){return Object.keys(this.columns)},t.prototype.getColumns=function(t,e){var o=this.aliases,r=this.columns,n={};t=t||Object.keys(r);for(var i=0,s=t.length,a=void 0,u=void 0;i<s;++i)(a=r[o[u=t[i]]||u])&&(n[u]=e?a:a.slice());return n},t.prototype.getModifier=function(){return this.modifier},t.prototype.getRow=function(t,e){return this.getRows(t,1,e)[0]},t.prototype.getRowCount=function(){return this.rowCount},t.prototype.getRowIndexBy=function(t,e,o){t=this.aliases[t]||t;var r=this.columns[t];if(r){var n=r.indexOf(e,o);if(-1!==n)return n}},t.prototype.getRowObject=function(t,e){return this.getRowObjects(t,1,e)[0]},t.prototype.getRowObjects=function(t,e,o){void 0===t&&(t=0),void 0===e&&(e=this.rowCount-t);var r=this.aliases,n=this.columns,i=Array(e);o=o||Object.keys(n);for(var s=t,a=0,u=Math.min(this.rowCount,t+e),l=void 0,c=void 0;s<u;++s,++a){c=i[a]={};for(var f=0,p=o;f<p.length;f++){var h=p[f];l=n[r[h]||h],c[h]=l?l[s]:void 0}}return i},t.prototype.getRows=function(t,e,o){void 0===t&&(t=0),void 0===e&&(e=this.rowCount-t);var r=this.aliases,n=this.columns,i=Array(e);o=o||Object.keys(n);for(var s=t,a=0,u=Math.min(this.rowCount,t+e),l=void 0,c=void 0;s<u;++s,++a){c=i[a]=[];for(var f=0,p=o;f<p.length;f++){var h=p[f];l=n[r[h]||h],c.push(l?l[s]:void 0)}}return i},t.prototype.getVersionTag=function(){return this.versionTag},t.prototype.hasColumns=function(t){for(var e=this.aliases,o=this.columns,r=0,n=t.length,i=void 0;r<n;++r)if(!o[i=t[r]]&&!e[i])return!1;return!0},t.prototype.hasRowWith=function(t,e){t=this.aliases[t]||t;var o=this.columns[t];return!!o&&-1!==o.indexOf(e)},t.prototype.on=function(t,o){return e(this,t,o)},t.prototype.renameColumn=function(t,e){var o=this.columns;if(o[t]){if(t!==e){var r=this.aliases;r[e]&&delete r[e],o[e]=o[t],delete o[t]}return!0}return!1},t.prototype.setCell=function(t,e,o,r){var n=this.columns,i=this.modifier,s=n[t=this.aliases[t]||t];s&&s[e]===o||(this.emit({type:"setCell",cellValue:o,columnName:t,detail:r,rowIndex:e}),s||(s=n[t]=Array(this.rowCount)),e>=this.rowCount&&(this.rowCount=e+1),s[e]=o,i&&i.modifyCell(this,t,e,o),this.emit({type:"afterSetCell",cellValue:o,columnName:t,detail:r,rowIndex:e}))},t.prototype.setColumn=function(t,e,o,r){var n;void 0===e&&(e=[]),void 0===o&&(o=0),this.setColumns(((n={})[t]=e,n),o,r)},t.prototype.setColumns=function(t,e,o){var r=this.columns,n=this.modifier,i=void 0===e,s=Object.keys(t);this.emit({type:"setColumns",columns:t,columnNames:s,detail:o,rowIndex:e});for(var a=0,u=s.length,l=void 0,c=void 0;a<u;++a)if(l=t[c=s[a]],c=this.aliases[c]||c,i)r[c]=l.slice(),this.rowCount=l.length;else{for(var f=r[c]?r[c]:r[c]=Array(this.rowCount),p=e||0,h=l.length;p<h;++p)f[p]=l[p];this.rowCount=Math.max(this.rowCount,f.length)}for(var m=Object.keys(r),a=0,u=m.length;a<u;++a)r[m[a]].length=this.rowCount;n&&n.modifyColumns(this,t,e||0),this.emit({type:"afterSetColumns",columns:t,columnNames:s,detail:o,rowIndex:e})},t.prototype.setModifier=function(t,e){var o=this;return o.emit({type:"setModifier",detail:e,modifier:t,modified:o.modified}),o.modified=o,o.modifier=t,(t?t.modify(o):Promise.resolve(o)).then(function(o){return o.emit({type:"afterSetModifier",detail:e,modifier:t,modified:o.modified}),o}).catch(function(e){throw o.emit({type:"setModifierError",error:e,modifier:t,modified:o.modified}),e})},t.prototype.setRow=function(t,e,o){this.setRows([t],e,o)},t.prototype.setRows=function(e,o,r){void 0===o&&(o=this.rowCount);var n=this.aliases,i=this.columns,s=Object.keys(i),a=this.modifier,u=e.length;this.emit({type:"setRows",detail:r,rowCount:u,rowIndex:o,rows:e});for(var l=0,c=o,f=void 0;l<u;++l,++c)if((f=e[l])===t.NULL)for(var p=0,h=s.length;p<h;++p)i[s[p]][c]=null;else if(f instanceof Array)for(var p=0,h=s.length;p<h;++p)i[s[p]][c]=f[p];else for(var m=Object.keys(f),p=0,h=m.length,d=void 0;p<h;++p)i[d=n[d=m[p]]||d]||(i[d]=Array(c+1)),i[d][c]=f[d];var g=o+u;if(g>this.rowCount){this.rowCount=g;for(var l=0,y=s.length;l<y;++l)i[s[l]].length=g}a&&a.modifyRows(this,e,o),this.emit({type:"afterSetRows",detail:r,rowCount:u,rowIndex:o,rows:e})},t.NULL={},t.version="1.0.0",t}()}),o(e,"Data/Connectors/DataConnector.js",[e["Data/Modifiers/DataModifier.js"],e["Data/DataTable.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=o.addEvent,i=o.fireEvent,s=o.merge,a=o.pick,u=function(){function o(t){void 0===t&&(t={}),this.table=new e(t.dataTable),this.metadata=t.metadata||{columns:{}}}return Object.defineProperty(o.prototype,"polling",{get:function(){return!!this.polling},enumerable:!1,configurable:!0}),o.prototype.describeColumn=function(t,e){var o=this.metadata.columns;o[t]=s(o[t]||{},e)},o.prototype.describeColumns=function(t){for(var e,o=Object.keys(t);"string"==typeof(e=o.pop());)this.describeColumn(e,t[e])},o.prototype.emit=function(t){i(this,t.type,t)},o.prototype.getColumnOrder=function(t){var e=this.metadata.columns,o=Object.keys(e||{});if(o.length)return o.sort(function(t,o){return a(e[t].index,0)-a(e[o].index,0)})},o.prototype.getSortedColumns=function(t){return this.table.getColumns(this.getColumnOrder(t))},o.prototype.load=function(){return i(this,"afterLoad",{table:this.table}),Promise.resolve(this)},o.prototype.on=function(t,e){return n(this,t,e)},o.prototype.save=function(){return i(this,"saveError",{table:this.table}),Promise.reject(Error("Not implemented"))},o.prototype.setColumnOrder=function(t){for(var e=0,o=t.length;e<o;++e)this.describeColumn(t[e],{index:e})},o.prototype.setModifierOptions=function(e){var o=this,r=e&&t.types[e.type];return this.table.setModifier(r?new r(e):void 0).then(function(){return o})},o.prototype.startPolling=function(t){void 0===t&&(t=1e3);var e=this;window.clearTimeout(e._polling),e._polling=window.setTimeout(function(){return e.load().catch(function(t){return e.emit({type:"loadError",error:t,table:e.table})}).then(function(){e._polling&&e.startPolling(t)})},t)},o.prototype.stopPolling=function(){window.clearTimeout(this._polling),delete this._polling},o.prototype.whatIs=function(t){return this.metadata.columns[t]},o}();return(r=u||(u={})).types={},r.registerType=function(t,e){return!!t&&!r.types[t]&&!!(r.types[t]=e)},u}),o(e,"Data/Converters/DataConverter.js",[e["Data/DataTable.js"],e["Core/Utilities.js"]],function(t,e){var o=e.addEvent,r=e.fireEvent,n=e.isNumber,i=e.merge,s=function(){function t(e){this.dateFormats={"YYYY/mm/dd":{regex:/^([0-9]{4})([\-\.\/])([0-9]{1,2})\2([0-9]{1,2})$/,parser:function(t){return t?Date.UTC(+t[1],t[3]-1,+t[4]):NaN}},"dd/mm/YYYY":{regex:/^([0-9]{1,2})([\-\.\/])([0-9]{1,2})\2([0-9]{4})$/,parser:function(t){return t?Date.UTC(+t[4],t[3]-1,+t[1]):NaN},alternative:"mm/dd/YYYY"},"mm/dd/YYYY":{regex:/^([0-9]{1,2})([\-\.\/])([0-9]{1,2})\2([0-9]{4})$/,parser:function(t){return t?Date.UTC(+t[4],t[1]-1,+t[3]):NaN}},"dd/mm/YY":{regex:/^([0-9]{1,2})([\-\.\/])([0-9]{1,2})\2([0-9]{2})$/,parser:function(t){var e=new Date;if(!t)return NaN;var o=+t[4];return o>e.getFullYear()-2e3?o+=1900:o+=2e3,Date.UTC(o,t[3]-1,+t[1])},alternative:"mm/dd/YY"},"mm/dd/YY":{regex:/^([0-9]{1,2})([\-\.\/])([0-9]{1,2})\2([0-9]{2})$/,parser:function(t){return t?Date.UTC(+t[4]+2e3,t[1]-1,+t[3]):NaN}}};var o=i(t.defaultOptions,e),r=o.decimalPoint;("."===r||","===r)&&(r="."===r?"\\.":",",this.decimalRegExp=RegExp("^(-?[0-9]+)"+r+"([0-9]+)$")),this.options=o}return t.prototype.asBoolean=function(t){return"boolean"==typeof t?t:"string"==typeof t?""!==t&&"0"!==t&&"false"!==t:!!this.asNumber(t)},t.prototype.asDate=function(t){var e;if("string"==typeof t)e=this.parseDate(t);else if("number"==typeof t)e=t;else{if(t instanceof Date)return t;e=this.parseDate(this.asString(t))}return new Date(e)},t.prototype.asGuessedType=function(t){return({number:this.asNumber,Date:this.asDate,string:this.asString})[this.guessType(t)].call(this,t)},t.prototype.asNumber=function(t){if("number"==typeof t)return t;if("boolean"==typeof t)return t?1:0;if("string"==typeof t){var e=this.decimalRegExp;if(t.indexOf(" ")>-1&&(t=t.replace(/\s+/g,"")),e){if(!e.test(t))return NaN;t=t.replace(e,"$1.$2")}return parseFloat(t)}return t instanceof Date?t.getDate():t?t.getRowCount():NaN},t.prototype.asString=function(t){return""+t},t.prototype.deduceDateFormat=function(t,e,o){var r,n,i,s=[],a=[],u="YYYY/mm/dd",l=[],c=0,f=!1;for((!e||e>t.length)&&(e=t.length);c<e;c++)if(void 0!==t[c]&&t[c]&&t[c].length)for(i=0,r=t[c].trim().replace(/[-\.\/]/g," ").split(" "),l=["","",""];i<r.length;i++)i<l.length&&(n=parseInt(r[i],10))&&(a[i]=!a[i]||a[i]<n?n:a[i],void 0!==s[i]?s[i]!==n&&(s[i]=!1):s[i]=n,n>31?n<100?l[i]="YY":l[i]="YYYY":n>12&&n<=31?(l[i]="dd",f=!0):l[i].length||(l[i]="mm"));if(f){for(i=0;i<s.length;i++)!1!==s[i]?a[i]>12&&"YY"!==l[i]&&"YYYY"!==l[i]&&(l[i]="YY"):a[i]>12&&"mm"===l[i]&&(l[i]="dd");3===l.length&&"dd"===l[1]&&"dd"===l[2]&&(l[2]="YY"),u=l.join("/")}return o&&(this.options.dateFormat=u),u},t.prototype.emit=function(t){r(this,t.type,t)},t.prototype.export=function(t,e){throw this.emit({type:"exportError",columns:[],headers:[]}),Error("Not implemented")},t.prototype.getTable=function(){throw Error("Not implemented")},t.prototype.guessType=function(t){var e="string";if("string"==typeof t){var o=this.trim("".concat(t)),r=this.decimalRegExp,i=this.trim(o,!0);r&&(i=r.test(i)?i.replace(r,"$1.$2"):"");var s=parseFloat(i);+i===s?t=s:e=n(this.parseDate(t))?"Date":"string"}return"number"==typeof t&&(e=t>31536e6?"Date":"number"),e},t.prototype.on=function(t,e){return o(this,t,e)},t.prototype.parse=function(t){throw this.emit({type:"parseError",columns:[],headers:[]}),Error("Not implemented")},t.prototype.parseDate=function(t,e){var o,r,i,s=this.options,a=e||s.dateFormat,u=NaN;if(s.parseDate)u=s.parseDate(t);else{if(a)(r=this.dateFormats[a])||(r=this.dateFormats["YYYY/mm/dd"]),(i=t.match(r.regex))&&(u=r.parser(i));else for(o in this.dateFormats)if(r=this.dateFormats[o],i=t.match(r.regex)){a=o,u=r.parser(i);break}!i&&("object"==typeof(i=Date.parse(t))&&null!==i&&i.getTime?u=i.getTime()-6e4*i.getTimezoneOffset():n(i)&&(u=i-6e4*new Date(i).getTimezoneOffset(),-1===t.indexOf("2001")&&2001===new Date(u).getFullYear()&&(u=NaN)))}return u},t.prototype.trim=function(t,e){return"string"==typeof t&&(t=t.replace(/^\s+|\s+$/g,""),e&&/^[0-9\s]+$/.test(t)&&(t=t.replace(/\s/g,""))),t},t.defaultOptions={dateFormat:"",alternativeFormat:"",startColumn:0,endColumn:Number.MAX_VALUE,startRow:0,endRow:Number.MAX_VALUE,firstRowAsNames:!0,switchRowsAndColumns:!1},t}();return(s||(s={})).getTableFromColumns=function(e,o){void 0===e&&(e=[]),void 0===o&&(o=[]);for(var r=new t,n=0,i=Math.max(o.length,e.length);n<i;++n)r.setColumn(o[n]||"".concat(n),e[n]);return r},s}),o(e,"Data/DataCursor.js",[],function(){var t=function(){function t(t){void 0===t&&(t={}),this.emittingRegister=[],this.listenerMap={},this.stateMap=t}return t.prototype.addListener=function(t,e,o){var r=this.listenerMap[t]=this.listenerMap[t]||{};return(r[e]=r[e]||[]).push(o),this},t.prototype.buildEmittingTag=function(t){return("position"===t.cursor.type?[t.table.id,t.cursor.column,t.cursor.row,t.cursor.state,t.cursor.type]:[t.table.id,t.cursor.columns,t.cursor.firstRow,t.cursor.lastRow,t.cursor.state,t.cursor.type]).join("\0")},t.prototype.emitCursor=function(e,o,r,n,i){var s="object"==typeof o?o:r,a="object"==typeof n?n:r,u="string"==typeof o?o:void 0,l=e.id,c=s.state,f=this.listenerMap[l]&&this.listenerMap[l][c];if(i=i||!0===n,f){var p=this.stateMap[l]=this.stateMap[l]||{},h=p[s.state]||[];i&&(h.length||(p[s.state]=h),-1===t.getIndex(s,h)&&h.push(s));var m={cursor:s,cursors:h,table:e};a&&(m.event=a),u&&(m.group=u);var d=this.emittingRegister,g=this.buildEmittingTag(m);if(d.indexOf(g)>=0)return this;try{this.emittingRegister.push(g);for(var y=0,v=f.length;y<v;++y)f[y].call(this,m)}finally{var b=this.emittingRegister.indexOf(g);b>=0&&this.emittingRegister.splice(b,1)}}return this},t.prototype.remitCursor=function(e,o){var r=this.stateMap[e]&&this.stateMap[e][o.state];if(r){var n=t.getIndex(o,r);n>=0&&r.splice(n,1)}return this},t.prototype.removeListener=function(t,e,o){var r=this.listenerMap[t]&&this.listenerMap[t][e];if(r){var n=r.indexOf(o);n&&r.splice(n,1)}return this},t.version="1.0.0",t}();return function(t){function e(t,e){if("range"===t.type)return t;var o,r,n,i,s={type:"range",firstRow:null!==(r=null!==(o=t.row)&&void 0!==o?o:e&&e.firstRow)&&void 0!==r?r:0,lastRow:null!==(i=null!==(n=t.row)&&void 0!==n?n:e&&e.lastRow)&&void 0!==i?i:Number.MAX_VALUE,state:t.state};return void 0!==t.column&&(s.columns=[t.column]),s}t.getIndex=function(t,e){if("position"===t.type){for(var o=void 0,r=0,n=e.length;r<n;++r)if("position"===(o=e[r]).type&&o.state===t.state&&o.column===t.column&&o.row===t.row)return r}else for(var i=JSON.stringify(t.columns),o=void 0,r=0,n=e.length;r<n;++r)if("range"===(o=e[r]).type&&o.state===t.state&&o.firstRow===t.firstRow&&o.lastRow===t.lastRow&&JSON.stringify(o.columns)===i)return r;return -1},t.isEqual=function(t,e){return"position"===t.type&&"position"===e.type?t.column===e.column&&t.row===e.row&&t.state===e.state:"range"===t.type&&"range"===e.type&&t.firstRow===e.firstRow&&t.lastRow===e.lastRow&&JSON.stringify(t.columns)===JSON.stringify(e.columns)},t.isInRange=function(t,o){"position"===o.type&&(o=e(o)),"position"===t.type&&(t=e(t,o));var r=t.columns,n=o.columns;return t.firstRow>=o.firstRow&&t.lastRow<=o.lastRow&&(!r||!n||r.every(function(t){return n.indexOf(t)>=0}))},t.toPositions=function(t){if("position"===t.type)return[t];for(var e=t.columns||[],o=[],r=t.state,n=t.firstRow,i=t.lastRow;n<i;++n){if(!e.length){o.push({type:"position",row:n,state:r});continue}for(var s=0,a=e.length;s<a;++s)o.push({type:"position",column:e[s],row:n,state:r})}return o},t.toRange=e}(t||(t={})),t}),o(e,"Data/DataPoolDefaults.js",[],function(){return{connectors:[]}}),o(e,"Data/DataPool.js",[e["Data/Connectors/DataConnector.js"],e["Data/DataPoolDefaults.js"],e["Core/Utilities.js"]],function(t,e,o){return function(){function r(t){void 0===t&&(t=e),t.connectors=t.connectors||[],this.connectors={},this.options=t,this.waiting={}}return r.prototype.emit=function(t){o.fireEvent(this,t.type,t)},r.prototype.getConnector=function(t){var e=this,o=this.connectors[t];if(o)return Promise.resolve(o);var r=this.waiting[t];if(!r){r=this.waiting[t]=[];var n=this.getConnectorOptions(t);if(!n)throw Error("Connector not found. (".concat(t,")"));this.loadConnector(n).then(function(o){delete e.waiting[t];for(var n=0,i=r.length;n<i;++n)r[n][0](o)}).catch(function(o){delete e.waiting[t];for(var n=0,i=r.length;n<i;++n)r[n][1](o)})}return new Promise(function(t,e){r.push([t,e])})},r.prototype.getConnectorIds=function(){for(var t=this.options.connectors,e=[],o=0,r=t.length;o<r;++o)e.push(t[o].id);return e},r.prototype.getConnectorOptions=function(t){for(var e=this.options.connectors,o=0,r=e.length;o<r;++o)if(e[o].id===t)return e[o]},r.prototype.getConnectorTable=function(t){return this.getConnector(t).then(function(t){return t.table})},r.prototype.isNewConnector=function(t){return!this.connectors[t]},r.prototype.loadConnector=function(e){var o=this;return new Promise(function(r,n){o.emit({type:"load",options:e});var i=t.types[e.type];if(!i)throw Error("Connector type not found. (".concat(e.type,")"));new i(e.options).load().then(function(t){o.connectors[e.id]=t,o.emit({type:"afterLoad",options:e}),r(t)}).catch(n)})},r.prototype.on=function(t,e){return o.addEvent(this,t,e)},r.prototype.setConnectorOptions=function(t){var e=this.options.connectors,o=this.connectors;this.emit({type:"setConnectorOptions",options:t});for(var r=0,n=e.length;r<n;++r)if(e[r].id===t.id){e.splice(r,1);break}o[t.id]&&(o[t.id].stopPolling(),delete o[t.id]),e.push(t),this.emit({type:"afterSetConnectorOptions",options:t})},r.version="1.0.0",r}()}),o(e,"Data/Formula/FormulaParser.js",[],function(){var t=/^(?:FALSE|TRUE)/,e=/^[+-]?\d+(?:\.\d+)?(?:e[+-]\d+)?/,o=/^[+-]?\d+(?:,\d+)?(?:e[+-]\d+)?/,r=/^([A-Z][A-Z\d\.]*)\(/,n=/^(?:[+\-*\/^<=>]|<=|=>)/,i=/^(\$?[A-Z]+)(\$?\d+)\:(\$?[A-Z]+)(\$?\d+)/,s=/^R(\d*|\[\d+\])C(\d*|\[\d+\])\:R(\d*|\[\d+\])C(\d*|\[\d+\])/,a=/^(\$?[A-Z]+)(\$?\d+)(?![\:C])/,u=/^R(\d*|\[\d+\])C(\d*|\[\d+\])(?!\:)/;function l(t){for(var e=0,o=0,r=t.length,n=void 0,i=1;o<r;++o){if("("===(n=t[o])){e||(i=o+1),++e;continue}if(")"===n&&!--e)return t.substring(i,o)}if(e>0){var s=Error("Incomplete parantheses.");throw s.name="FormulaParseError",s}return""}function c(t){for(var e=-1,o=0,r=t.length,n=void 0,i=!1;o<r;++o){if("\\"===(n=t[o])){i=!i;continue}if(i){i=!1;continue}if('"'===n){if(!(e<0))return t.substring(e+1,o);e=o}}var s=Error("Incomplete string.");throw s.name="FormulaParseError",s}function f(t,e){if(o=t.match(s)){var o,r=""===o[2]||"["===o[2][0],n=""===o[1]||"["===o[1][0],a=""===o[4]||"["===o[4][0],u=""===o[3]||"["===o[3][0],l={type:"range",beginColumn:r?parseInt(o[2].substring(1,-1)||"0",10):parseInt(o[2],10)-1,beginRow:n?parseInt(o[1].substring(1,-1)||"0",10):parseInt(o[1],10)-1,endColumn:a?parseInt(o[4].substring(1,-1)||"0",10):parseInt(o[4],10)-1,endRow:u?parseInt(o[3].substring(1,-1)||"0",10):parseInt(o[3],10)-1};return r&&(l.beginColumnRelative=!0),n&&(l.beginRowRelative=!0),a&&(l.endColumnRelative=!0),u&&(l.endRowRelative=!0),l}if(o=t.match(i)){var r="$"!==o[1][0],n="$"!==o[2][0],a="$"!==o[3][0],u="$"!==o[4][0],l={type:"range",beginColumn:h(r?o[1]:o[1].substring(1))-1,beginRow:parseInt(n?o[2]:o[2].substring(1),10)-1,endColumn:h(a?o[3]:o[3].substring(1))-1,endRow:parseInt(u?o[4]:o[4].substring(1),10)-1};return r&&(l.beginColumnRelative=!0),n&&(l.beginRowRelative=!0),a&&(l.endColumnRelative=!0),u&&(l.endRowRelative=!0),l}var c=p(t,e);return 1===c.length&&"string"!=typeof c[0]?c[0]:c}function p(i,s){for(var m,d=s?o:e,g=[],y=("="===i[0]?i.substring(1):i).trim();y;){if(m=y.match(u)){var v=""===m[2]||"["===m[2][0],b=""===m[1]||"["===m[1][0],C={type:"reference",column:v?parseInt(m[2].substring(1,-1)||"0",10):parseInt(m[2],10)-1,row:b?parseInt(m[1].substring(1,-1)||"0",10):parseInt(m[1],10)-1};v&&(C.columnRelative=!0),b&&(C.rowRelative=!0),g.push(C),y=y.substring(m[0].length).trim();continue}if(m=y.match(a)){var v="$"!==m[1][0],b="$"!==m[2][0],C={type:"reference",column:h(v?m[1]:m[1].substring(1))-1,row:parseInt(b?m[2]:m[2].substring(1),10)-1};v&&(C.columnRelative=!0),b&&(C.rowRelative=!0),g.push(C),y=y.substring(m[0].length).trim();continue}if(m=y.match(n)){g.push(m[0]),y=y.substring(m[0].length).trim();continue}if(m=y.match(t)){g.push("TRUE"===m[0]),y=y.substring(m[0].length).trim();continue}if(m=y.match(d)){g.push(parseFloat(m[0])),y=y.substring(m[0].length).trim();continue}if('"'===y[0]){var w=c(y);g.push(w.substring(1,-1)),y=y.substring(w.length+2).trim();continue}if(m=y.match(r)){var j=l(y=y.substring(m[1].length).trim());g.push({type:"function",name:m[1],args:function(t,e){for(var o=[],r=e?";":",",n=0,i="",s=0,a=t.length,u=void 0;s<a;++s)if((u=t[s])===r&&!n&&i)o.push(f(i,e)),i="";else if('"'!==u||n||i)" "!==u&&(i+=u,"("===u?++n:")"===u&&--n);else{var l=c(t.substring(s));o.push(l),s+=l.length+1}return!n&&i&&o.push(f(i,e)),o}(j,s)}),y=y.substring(j.length+2).trim();continue}if("("===y[0]){var D=l(y);if(D){g.push(p(D,s)),y=y.substring(D.length+2).trim();continue}}var O=i.length-y.length,N=Error("Unexpected character `"+i.substring(O,O+1)+"` at position "+(O+1)+". (`..."+i.substring(O-5,O+6)+"...`)");throw N.name="FormulaParseError",N}return g}function h(t){for(var e=0,o=0,r=t.length,n=void 0,i=t.length-1;o<r;++o)(n=t.charCodeAt(o))>=65&&n<=90&&(e+=(n-64)*Math.pow(26,i)),--i;return e}return{parseFormula:p}}),o(e,"Data/Formula/FormulaTypes.js",[],function(){var t=["+","-","*","/","^","=","<","<=",">",">="];return{isFormula:function(t){return t instanceof Array},isFunction:function(t){return"object"==typeof t&&!(t instanceof Array)&&"function"===t.type},isOperator:function(e){return"string"==typeof e&&t.indexOf(e)>=0},isRange:function(t){return"object"==typeof t&&!(t instanceof Array)&&"range"===t.type},isReference:function(t){return"object"==typeof t&&!(t instanceof Array)&&"reference"===t.type},isValue:function(t){return"boolean"==typeof t||"number"==typeof t||"string"==typeof t}}}),o(e,"Data/Formula/FormulaProcessor.js",[e["Data/Formula/FormulaTypes.js"]],function(t){var e=t.isFormula,o=t.isFunction,r=t.isOperator,n=t.isRange,i=t.isReference,s=t.isValue,a=/ */,u=Number.MAX_VALUE/1.000000000001,l=Number.MAX_VALUE/1.000000000002,c=Number.MAX_VALUE,f={"^":3,"*":2,"/":2,"+":1,"-":1,"=":0,"<":0,"<=":0,">":0,">=":0},p={},h=/^[A-Z][A-Z\.]*$/;function m(t){switch(typeof t){case"boolean":return t?c:u;case"string":return l;case"number":return t;default:return NaN}}function d(t){return"string"==typeof t?t.toLowerCase().replace(a,"\0"):t}function g(t){switch(typeof t){case"boolean":return t?1:0;case"string":return parseFloat(t.replace(",","."));case"number":return t;default:return NaN}}function y(t,e,o){var r;switch(t){case"=":return d(e)===d(o);case"<":if(typeof e==typeof o)return d(e)<d(o);return m(e)<m(o);case"<=":if(typeof e==typeof o)return d(e)<=d(o);return m(e)<=m(o);case">":if(typeof e==typeof o)return d(e)>d(o);return m(e)>m(o);case">=":if(typeof e==typeof o)return d(e)>=d(o);return m(e)>=m(o)}switch(e=g(e),o=g(o),t){case"+":r=e+o;break;case"-":r=e-o;break;case"*":r=e*o;break;case"/":r=e/o;break;case"^":r=Math.pow(e,o);break;default:return NaN}return r%1?Math.round(1e9*r)/1e9:r}function v(t,r){return s(t)?t:n(t)?r&&b(t,r)||[]:o(t)?j(t,r):w(e(t)?t:[t],r)}function b(t,e){for(var o=e.getColumnNames().slice(t.beginColumn,t.endColumn+1),r=[],n=0,i=o.length,a=void 0;n<i;++n)for(var u=e.getColumn(o[n],!0)||[],l=t.beginRow,c=t.endRow+1;l<c;++l)"string"==typeof(a=u[l])&&"="===a[0]&&e!==e.modified&&(a=e.modified.getCell(o[n],l)),r.push(s(a)?a:NaN);return r}function C(t,e){var o=e.getColumnNames()[t.column];if(o){var r=e.getCell(o,t.row);if("string"==typeof r&&"="===r[0]&&e!==e.modified){var n=e.modified.getCell(o,t.row);return s(n)?n:NaN}return s(r)?r:NaN}return NaN}function w(t,n){for(var a,u=0,l=t.length,c=void 0,p=void 0,h=void 0,m=void 0;u<l;++u){if(r(c=t[u])){p=c;continue}if(s(c)?m=c:e(c)?m=w(t,n):o(c)?m=s(h=j(c,n))?h:NaN:i(c)&&(m=n&&C(c,n)),void 0!==m){if(void 0===a)a=p?y(p,0,m):m;else{if(!p)return NaN;var d=t[u+1];r(d)&&f[d]>f[p]&&(m=y(d,m,w(t.slice(u+2))),u=l),a=y(p,a,m)}p=void 0,m=void 0}}return s(a)?a:NaN}function j(t,e,o){var r=p[t.name];if(r)try{return r(t.args,e)}catch(t){return NaN}var n=Error('Function "'.concat(t.name,'" not found.'));throw n.name="FormulaProcessError",n}return{asNumber:g,getArgumentValue:v,getArgumentsValues:function(t,e){for(var o=[],r=0,n=t.length;r<n;++r)o.push(v(t[r],e));return o},getRangeValues:b,getReferenceValue:C,processFormula:w,processorFunctions:p,registerProcessorFunction:function(t,e){return h.test(t)&&!p[t]&&!!(p[t]=e)},translateReferences:function t(e,r,s){void 0===r&&(r=0),void 0===s&&(s=0);for(var a=0,u=e.length,l=void 0;a<u;++a)(l=e[a])instanceof Array?t(l,r,s):o(l)?t(l.args,r,s):n(l)?(l.beginColumnRelative&&(l.beginColumn+=r),l.beginRowRelative&&(l.beginRow+=s),l.endColumnRelative&&(l.endColumn+=r),l.endRowRelative&&(l.endRow+=s)):i(l)&&(l.columnRelative&&(l.column+=r),l.rowRelative&&(l.row+=s));return e}}}),o(e,"Data/Formula/Functions/ABS.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,o){var r=e(t[0],o);switch(typeof r){case"number":return Math.abs(r);case"object":for(var n=[],i=0,s=r.length,a=void 0;i<s;++i){if("number"!=typeof(a=r[i]))return NaN;n.push(Math.abs(a))}return n;default:return NaN}}return t.registerProcessorFunction("ABS",o),o}),o(e,"Data/Formula/Functions/AND.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,r){for(var n=0,i=t.length,s=void 0;n<i;++n)if(!(s=e(t[n],r))||"object"==typeof s&&!o(s,r))return!1;return!0}return t.registerProcessorFunction("AND",o),o}),o(e,"Data/Formula/Functions/AVERAGE.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentsValues;function o(t,o){for(var r=e(t,o),n=0,i=0,s=0,a=r.length,u=void 0;s<a;++s)switch(typeof(u=r[s])){case"number":isNaN(u)||(++n,i+=u);break;case"object":for(var l=0,c=u.length,f=void 0;l<c;++l)"number"!=typeof(f=u[l])||isNaN(f)||(++n,i+=f)}return n?i/n:0}return t.registerProcessorFunction("AVERAGE",o),o}),o(e,"Data/Formula/Functions/AVERAGEA.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,o){for(var r=0,n=0,i=0,s=t.length,a=void 0;i<s;++i)switch(typeof(a=e(t[i],o))){case"boolean":++r,n+=a?1:0;continue;case"number":isNaN(a)||(++r,n+=a);continue;case"string":++r;continue;default:for(var u=0,l=a.length,c=void 0;u<l;++u)switch(typeof(c=a[u])){case"boolean":++r,n+=c?1:0;continue;case"number":isNaN(c)||(++r,n+=c);continue;case"string":++r;continue}continue}return r?n/r:0}return t.registerProcessorFunction("AVERAGEA",o),o}),o(e,"Data/Formula/Functions/COUNT.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){function e(o,r){for(var n=t.getArgumentsValues(o,r),i=0,s=0,a=n.length,u=void 0;s<a;++s)switch(typeof(u=n[s])){case"number":!isNaN(u)&&++i;break;case"object":i+=e(u,r)}return i}return t.registerProcessorFunction("COUNT",e),e}),o(e,"Data/Formula/Functions/COUNTA.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){function e(o,r){for(var n=t.getArgumentsValues(o,r),i=0,s=0,a=n.length,u=void 0;s<a;++s){switch(typeof(u=n[s])){case"number":if(isNaN(u))continue;break;case"object":i+=e(u,r);continue;case"string":if(!u)continue}++i}return i}return t.registerProcessorFunction("COUNTA",e),e}),o(e,"Data/Formula/Functions/IF.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,o){return e(t[0],o)?e(t[1],o):e(t[2],o)}return t.registerProcessorFunction("IF",o),o}),o(e,"Data/Formula/Functions/ISNA.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,o){var r=e(t[0],o);return"number"!=typeof r||isNaN(r)}return t.registerProcessorFunction("ISNA",o),o}),o(e,"Data/Formula/Functions/MAX.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentsValues;function o(t,r){for(var n=e(t,r),i=Number.NEGATIVE_INFINITY,s=0,a=n.length,u=void 0;s<a;++s)switch(typeof(u=n[s])){case"number":u>i&&(i=u);break;case"object":(u=o(u))>i&&(i=u)}return isFinite(i)?i:0}return t.registerProcessorFunction("MAX",o),o}),o(e,"Data/Formula/Functions/MEDIAN.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){function e(e,o){for(var r=[],n=t.getArgumentsValues(e,o),i=0,s=n.length,a=void 0;i<s;++i)switch(typeof(a=n[i])){case"number":isNaN(a)||r.push(a);break;case"object":for(var u=0,l=a.length,c=void 0;u<l;++u)"number"!=typeof(c=a[u])||isNaN(c)||r.push(c)}var f=r.length;if(!f)return NaN;var p=Math.floor(f/2);return f%2?r[p]:(r[p-1]+r[p])/2}return t.registerProcessorFunction("MEDIAN",e),e}),o(e,"Data/Formula/Functions/MIN.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentsValues;function o(t,r){for(var n=e(t,r),i=Number.POSITIVE_INFINITY,s=0,a=n.length,u=void 0;s<a;++s)switch(typeof(u=n[s])){case"number":u<i&&(i=u);break;case"object":(u=o(u))<i&&(i=u)}return isFinite(i)?i:0}return t.registerProcessorFunction("MIN",o),o}),o(e,"Data/Formula/Functions/MOD.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,o){var r=e(t[0],o),n=e(t[1],o);return("object"==typeof r&&(r=r[0]),"object"==typeof n&&(n=n[0]),"number"!=typeof r||"number"!=typeof n||0===n)?NaN:r%n}return t.registerProcessorFunction("MOD",o),o}),o(e,"Data/Formula/Functions/MODE.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){function e(e,o){for(var r={},n=t.getArgumentsValues(e,o),i=0,s=n.length,a=void 0;i<s;++i)switch(typeof(a=n[i])){case"number":isNaN(a)||(r[a]=(r[a]||0)+1);break;case"object":for(var u=0,l=a.length,c=void 0;u<l;++u)"number"!=typeof(c=a[u])||isNaN(c)||(r[c]=(r[c]||0)+1)}return r}function o(t,o){var r=e(t,o),n=Object.keys(r);if(!n.length)return NaN;for(var i=[parseFloat(n[0])],s=r[n[0]],a=1,u=n.length,l=void 0,c=void 0;a<u;++a)s<(c=r[l=n[a]])?(i=[parseFloat(l)],s=c):s===c&&i.push(parseFloat(l));return s>1?i:NaN}function r(t,o){var r=e(t,o),n=Object.keys(r);if(!n.length)return NaN;for(var i=parseFloat(n[0]),s=r[n[0]],a=1,u=n.length,l=void 0,c=void 0,f=void 0;a<u;++a)s<(f=r[l=n[a]])?(i=parseFloat(l),s=f):s===f&&i>(c=parseFloat(l))&&(i=c,s=f);return s>1?i:NaN}return t.registerProcessorFunction("MODE",r),t.registerProcessorFunction("MODE.MULT",o),t.registerProcessorFunction("MODE.SNGL",r),{MULT:o,SNGL:r}}),o(e,"Data/Formula/Functions/NOT.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,o){var r=e(t[0],o);switch("object"==typeof r&&(r=r[0]),typeof r){case"boolean":case"number":return!r}return NaN}return t.registerProcessorFunction("NOT",o),o}),o(e,"Data/Formula/Functions/OR.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,r){for(var n=0,i=t.length,s=void 0;n<i;++n)if("object"==typeof(s=e(t[n],r))){if(o(s,r))return!0}else if(s)return!0;return!1}return t.registerProcessorFunction("OR",o),o}),o(e,"Data/Formula/Functions/PRODUCT.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentsValues;function o(t,r){for(var n=e(t,r),i=1,s=!1,a=0,u=n.length,l=void 0;a<u;++a)switch(typeof(l=n[a])){case"number":isNaN(l)||(s=!0,i*=l);break;case"object":s=!0,i*=o(l,r)}return s?i:0}return t.registerProcessorFunction("PRODUCT",o),o}),o(e,"Data/Formula/Functions/SUM.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){function e(o,r){for(var n=t.getArgumentsValues(o,r),i=0,s=0,a=n.length,u=void 0;s<a;++s)switch(typeof(u=n[s])){case"number":isNaN(u)||(i+=u);break;case"object":i+=e(u,r)}return i}return t.registerProcessorFunction("SUM",e),e}),o(e,"Data/Formula/Functions/XOR.js",[e["Data/Formula/FormulaProcessor.js"]],function(t){var e=t.getArgumentValue;function o(t,o){for(var r=0,n=t.length,i=void 0,s=void 0;r<n;++r)switch(typeof(s=e(t[r],o))){case"boolean":case"number":if(void 0===i)i=!!s;else if(!!s!==i)return!0;break;case"object":for(var a=0,u=s.length,l=void 0;a<u;++a)switch(typeof(l=s[a])){case"boolean":case"number":if(void 0===i)i=!!l;else if(!!l!==i)return!0}}return!1}return t.registerProcessorFunction("XOR",o),o}),o(e,"Data/Formula/Formula.js",[e["Data/Formula/FormulaParser.js"],e["Data/Formula/FormulaProcessor.js"],e["Data/Formula/FormulaTypes.js"]],function(t,e,o){var r=this&&this.__assign||function(){return(r=Object.assign||function(t){for(var e,o=1,r=arguments.length;o<r;o++)for(var n in e=arguments[o])Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t}).apply(this,arguments)};return r(r(r({},t),e),o)}),o(e,"Data/Converters/CSVConverter.js",[e["Data/Converters/DataConverter.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=this&&this.__assign||function(){return(n=Object.assign||function(t){for(var e,o=1,r=arguments.length;o<r;o++)for(var n in e=arguments[o])Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t}).apply(this,arguments)},i=e.merge;return function(e){function o(t){var r=this,n=i(o.defaultOptions,t);return(r=e.call(this,n)||this).columns=[],r.headers=[],r.dataTypes=[],r.options=n,r}return r(o,e),o.prototype.export=function(t,e){void 0===e&&(e=this.options);var o=e.useLocalDecimalPoint,r=e.lineDelimiter,n=!1!==this.options.firstRowAsNames,i=e.decimalPoint,s=e.itemDelimiter;i||(i=","!==s&&o?1.1.toLocaleString()[1]:"."),s||(s=","===i?";":",");var a=t.getSortedColumns(e.usePresentationOrder),u=Object.keys(a),l=[],c=u.length,f=[];n&&l.push(u.map(function(t){return'"'.concat(t,'"')}).join(s));for(var p=0;p<c;p++){var h=u[p],m=a[h],d=m.length,g=t.whatIs(h),y=void 0;g&&(y=g.dataType);for(var v=0;v<d;v++){var b=m[v];if(f[v]||(f[v]=[]),"string"===y?b='"'+b+'"':"number"==typeof b?b=String(b).replace(".",i):"string"==typeof b&&(b='"'.concat(b,'"')),f[v][p]=b,p===c-1){for(var C=p;f[v].length>2&&void 0===f[v][C];)f[v].pop(),C--;l.push(f[v].join(s))}}}return l.join(r)},o.prototype.parse=function(t,e){var o,r,n=this.dataTypes,s=i(this.options,t),a=s.beforeParse,u=s.lineDelimiter,l=s.firstRowAsNames,c=s.itemDelimiter,f=0,p=s.csv,h=s.startRow,m=s.endRow;if(this.columns=[],this.emit({type:"parse",columns:this.columns,detail:e,headers:this.headers}),p&&a&&(p=a(p)),p){if(o=p.replace(/\r\n|\r/g,"\n").split(u||"\n"),(!h||h<0)&&(h=0),(!m||m>=o.length)&&(m=o.length-1),c||(this.guessedItemDelimiter=this.guessDelimiter(o)),l){for(var d=o[0].split(c||this.guessedItemDelimiter||","),g=0;g<d.length;g++)d[g]=d[g].trim().replace(/^["']|["']$/g,"");this.headers=d,h++}var y=0;for(f=h;f<=m;f++)"#"===o[f][0]?y++:this.parseCSVRow(o[f],f-h-y);n.length&&n[0].length&&"date"===n[0][1]&&!this.options.dateFormat&&this.deduceDateFormat(this.columns[0],null,!0);for(var g=0,v=this.columns.length;g<v;++g){r=this.columns[g];for(var b=0,C=r.length;b<C;++b)if(r[b]&&"string"==typeof r[b]){var w=this.asGuessedType(r[b]);w instanceof Date&&(w=w.getTime()),this.columns[g][b]=w}}}this.emit({type:"afterParse",columns:this.columns,detail:e,headers:this.headers})},o.prototype.parseCSVRow=function(t,e){var o=this,r=o.columns||[],n=o.dataTypes,i=o.options,s=i.startColumn,a=i.endColumn,u=o.options.itemDelimiter||o.guessedItemDelimiter,l=o.options.decimalPoint;l&&l!==u||(l=o.guessedDecimalPoint||".");var c=0,f="",p="",h=0,m=0,d=function(e){f=t[e]},g=function(t){n.length<m+1&&n.push([t]),n[m][n[m].length-1]!==t&&n[m].push(t)},y=function(){if(s>h||h>a){++h,p="";return}if("string"==typeof p?!isNaN(parseFloat(p))&&isFinite(p)?(p=parseFloat(p),g("number")):isNaN(Date.parse(p))?g("string"):(p=p.replace(/\//g,"-"),g("date")):g("number"),r.length<m+1&&r.push([]),"number"!=typeof p&&"number"!==o.guessType(p)&&l){var t=p;p=p.replace(l,"."),"number"!==o.guessType(p)&&(p=t)}r[m][e]=p,p="",++m,++h};if(t.trim().length&&"#"!==t.trim()[0]){for(;c<t.length;c++){if(d(c),"#"===f&&!/^#[0-F]{3,3}|[0-F]{6,6}/i.test(t.substring(c))){y();return}if('"'===f)for(d(++c);c<t.length&&'"'!==f;)p+=f,d(++c);else f===u?y():p+=f}y()}},o.prototype.guessDelimiter=function(t){for(var e,o=0,r=0,n={",":0,";":0,"	":0},i=t.length,s=0;s<i;s++){var a=!1,u=void 0,l=void 0,c=void 0,f="";if(s>13)break;for(var p=t[s],h=0;h<p.length&&(u=p[h],l=p[h+1],c=p[h-1],"#"!==u);h++){if('"'===u){if(a){if('"'!==c&&'"'!==l){for(;" "===l&&h<p.length;)l=p[++h];void 0!==n[l]&&n[l]++,a=!1}}else a=!0}else void 0!==n[u]?(isNaN(Date.parse(f=f.trim()))?(isNaN(Number(f))||!isFinite(Number(f)))&&n[u]++:n[u]++,f=""):f+=u;","===u&&r++,"."===u&&o++}}return n[";"]>n[","]?e=";":(n[","],n[";"],e=","),o>r?this.guessedDecimalPoint=".":this.guessedDecimalPoint=",",e},o.prototype.getTable=function(){return t.getTableFromColumns(this.columns,this.headers)},o.defaultOptions=n(n({},t.defaultOptions),{lineDelimiter:"\n"}),o}(t)}),o(e,"Data/Connectors/CSVConnector.js",[e["Data/Converters/CSVConverter.js"],e["Data/Connectors/DataConnector.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=o.merge,s=function(e){function o(r){var n=this,s=i(o.defaultOptions,r);return(n=e.call(this,s)||this).converter=new t(s),n.options=s,s.enablePolling&&n.startPolling(1e3*Math.max(s.dataRefreshRate||0,1)),n}return n(o,e),o.prototype.load=function(t){var e=this,o=e.converter,r=e.table,n=e.options,i=n.csv,s=n.csvURL,a=n.dataModifier;return e.emit({type:"load",csv:i,detail:t,table:r}),Promise.resolve(s?fetch(s).then(function(t){return t.text()}):i||"").then(function(t){return t&&(r.deleteColumns(),o.parse({csv:t}),r.setColumns(o.getTable().getColumns())),e.setModifierOptions(a).then(function(){return t})}).then(function(o){return e.emit({type:"afterLoad",csv:o,detail:t,table:r}),e}).catch(function(o){throw e.emit({type:"loadError",detail:t,error:o,table:r}),o})},o.defaultOptions={csv:"",csvURL:"",enablePolling:!1,dataRefreshRate:1,firstRowAsNames:!0},o}(e);return e.registerType("CSV",s),s}),o(e,"Data/Converters/JSONConverter.js",[e["Data/Converters/DataConverter.js"],e["Data/DataTable.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=this&&this.__assign||function(){return(i=Object.assign||function(t){for(var e,o=1,r=arguments.length;o<r;o++)for(var n in e=arguments[o])Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t}).apply(this,arguments)},s=o.error,a=o.isArray,u=o.merge,l=o.objectEach;return function(o){function r(t){var n=this,i=u(r.defaultOptions,t);return(n=o.call(this,i)||this).columns=[],n.headers=[],n.options=i,n.table=new e,n}return n(r,o),r.prototype.parse=function(t,e){var o=this,r=(t=u(o.options,t)).beforeParse,n=t.orientation,i=t.firstRowAsNames,c=t.columnNames,f=t.data;if(f){if(o.columns=[],o.emit({type:"parse",columns:o.columns,detail:e,headers:o.headers}),r&&(f=r(f)),f=f.slice(),"columns"===n)for(var p=0,h=f.length;p<h;p++){var m=f[p];if(!(m instanceof Array))return;o.headers instanceof Array?(i?o.headers.push("".concat(m.shift())):c&&c instanceof Array&&o.headers.push(c[p]),o.table.setColumn(o.headers[p]||p.toString(),m)):s("JSONConverter: Invalid `columnNames` option.",!1)}else if("rows"===n){i?o.headers=f.shift():c&&(o.headers=c);for(var d=this,g=0,h=f.length;g<h;g++)!function(t,e){var r=f[t];if(a(r))for(var n=0,i=r.length;n<i;n++)o.columns.length<n+1&&o.columns.push([]),o.columns[n].push(r[n]),o.headers instanceof Array?d.table.setColumn(o.headers[n]||n.toString(),o.columns[n]):s("JSONConverter: Invalid `columnNames` option.",!1);else{var u=o.headers;if(u&&!(u instanceof Array)){var c={};l(u,function(t,e){c[e]=t.reduce(function(t,e){return t[e]},r)}),r=c}d.table.setRows([r],t)}}(g,0)}o.emit({type:"afterParse",columns:o.columns,detail:e,headers:o.headers})}},r.prototype.getTable=function(){return this.table},r.defaultOptions=i(i({},t.defaultOptions),{data:[],orientation:"rows"}),r}(t)}),o(e,"Data/Connectors/JSONConnector.js",[e["Data/Connectors/DataConnector.js"],e["Core/Utilities.js"],e["Data/Converters/JSONConverter.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=e.merge,s=function(t){function e(r){var n=this,s=i(e.defaultOptions,r);return(n=t.call(this,s)||this).converter=new o(s),n.options=s,s.enablePolling&&n.startPolling(1e3*Math.max(s.dataRefreshRate||0,1)),n}return n(e,t),e.prototype.load=function(t){var e=this,o=e.converter,r=e.table,n=e.options,i=n.data,s=n.dataUrl,a=n.dataModifier;return e.emit({type:"load",data:i,detail:t,table:r}),Promise.resolve(s?fetch(s).then(function(t){return t.json()}):i||[]).then(function(t){return t&&(r.deleteColumns(),o.parse({data:t}),r.setColumns(o.getTable().getColumns())),e.setModifierOptions(a).then(function(){return t})}).then(function(o){return e.emit({type:"afterLoad",data:o,detail:t,table:r}),e}).catch(function(o){throw e.emit({type:"loadError",detail:t,error:o,table:r}),o})},e.defaultOptions={data:[],enablePolling:!1,dataRefreshRate:0,firstRowAsNames:!0,orientation:"rows"},e}(t);return t.registerType("JSON",s),s}),o(e,"Data/Converters/GoogleSheetsConverter.js",[e["Data/Converters/DataConverter.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=this&&this.__assign||function(){return(n=Object.assign||function(t){for(var e,o=1,r=arguments.length;o<r;o++)for(var n in e=arguments[o])Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t}).apply(this,arguments)},i=e.merge,s=e.uniqueKey;return function(e){function o(t){var r=this,n=i(o.defaultOptions,t);return(r=e.call(this,n)||this).columns=[],r.header=[],r.options=n,r}return r(o,e),o.prototype.parse=function(t,e){var o,r=i(this.options,t),n=(r.json&&r.json.values||[]).map(function(t){return t.slice()});if(0===n.length)return!1;this.header=[],this.columns=[],this.emit({type:"parse",columns:this.columns,detail:e,headers:this.header}),this.columns=n;for(var a=0,u=n.length;a<u;a++){o=n[a],this.header[a]=r.firstRowAsNames?"".concat(o.shift()):s();for(var l=0,c=o.length;l<c;++l)if(o[l]&&"string"==typeof o[l]){var f=this.asGuessedType(o[l]);f instanceof Date&&(f=f.getTime()),this.columns[a][l]=f}}this.emit({type:"afterParse",columns:this.columns,detail:e,headers:this.header})},o.prototype.getTable=function(){return t.getTableFromColumns(this.columns,this.header)},o.defaultOptions=n({},t.defaultOptions),o}(t)}),o(e,"Data/Connectors/GoogleSheetsConnector.js",[e["Data/Connectors/DataConnector.js"],e["Data/Converters/GoogleSheetsConverter.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=o.merge,s=o.pick,a=function(t){function o(r){var n=this,s=i(o.defaultOptions,r);return(n=t.call(this,s)||this).converter=new e(s),n.options=s,n}return n(o,t),o.prototype.load=function(t){var e=this,r=e.converter,n=e.table,i=e.options,s=i.dataModifier,a=i.dataRefreshRate,u=i.enablePolling,l=i.firstRowAsNames,c=i.googleAPIKey,f=i.googleSpreadsheetKey,p=o.buildFetchURL(c,f,e.options);return e.emit({type:"load",detail:t,table:n,url:p}),fetch(p).then(function(t){return t.json()}).then(function(t){if("object"==typeof t&&t&&"object"==typeof t.error&&t.error&&"number"==typeof t.error.code&&"string"==typeof t.error.message&&"string"==typeof t.error.status)throw Error(t.error.message);return r.parse({firstRowAsNames:l,json:t}),n.deleteColumns(),n.setColumns(r.getTable().getColumns()),e.setModifierOptions(s)}).then(function(){return e.emit({type:"afterLoad",detail:t,table:n,url:p}),u&&setTimeout(function(){return e.load()},1e3*Math.max(a||0,1)),e}).catch(function(o){throw e.emit({type:"loadError",detail:t,error:o,table:n}),o})},o.defaultOptions={googleAPIKey:"",googleSpreadsheetKey:"",worksheet:1,enablePolling:!1,dataRefreshRate:2,firstRowAsNames:!0},o}(t);return function(t){var e="ABCDEFGHIJKLMNOPQRSTUVWXYZ";function o(t){void 0===t&&(t={});var o=t.endColumn,r=t.endRow,n=t.googleSpreadsheetRange,i=t.startColumn,a=t.startRow;return n||(e[i||0]||"A")+(Math.max(a||0,0)+1)+":"+(e[s(o,25)]||"Z")+(r?Math.max(r,0):"Z")}t.buildFetchURL=function(t,e,r){return void 0===r&&(r={}),"https://sheets.googleapis.com/v4/spreadsheets/".concat(e,"/values/")+(r.onlyColumnNames?"A1:Z1":o(r))+"?alt=json"+(r.onlyColumnNames?"":"&dateTimeRenderOption=FORMATTED_STRING&majorDimension=COLUMNS&valueRenderOption=UNFORMATTED_VALUE")+"&prettyPrint=false"+"&key=".concat(t)},t.buildQueryRange=o}(a||(a={})),t.registerType("GoogleSheets",a),a}),o(e,"Data/Converters/HTMLTableConverter.js",[e["Data/Converters/DataConverter.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=this&&this.__assign||function(){return(n=Object.assign||function(t){for(var e,o=1,r=arguments.length;o<r;o++)for(var n in e=arguments[o])Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t}).apply(this,arguments)},i=e.merge;return function(e){function o(t){var r=this,n=i(o.defaultOptions,t);return(r=e.call(this,n)||this).columns=[],r.headers=[],r.options=n,n.tableElement&&(r.tableElement=n.tableElement,r.tableElementID=n.tableElement.id),r}return r(o,e),o.prototype.export=function(t,e){void 0===e&&(e=this.options);var o=!1!==e.firstRowAsNames,r=e.useMultiLevelHeaders,n=t.getSortedColumns(e.usePresentationOrder),i=Object.keys(n),s=[],a=i.length,u=[],l="";if(o){var c=[];if(r){for(var f=0;f<i.length;f++){var p=(n[i[f]].shift()||"").toString();c.push(p)}l=this.getTableHeaderHTML(i,c,e)}else l=this.getTableHeaderHTML(void 0,i,e)}for(var h=0;h<a;h++)for(var m=n[i[h]],d=m.length,g=0;g<d;g++){var y=m[g];u[g]||(u[g]=[]),"string"==typeof y||"number"==typeof y||void 0===y||(y=(y||"").toString()),u[g][h]=this.getCellHTMLFromValue(h?"td":"th",null,h?"":'scope="row"',y),h===a-1&&s.push("<tr>"+u[g].join("")+"</tr>")}var v="";return e.tableCaption&&(v='<caption class="highcharts-table-caption">'+e.tableCaption+"</caption>"),"<table>"+v+l+"<tbody>"+s.join("")+"</tbody></table>"},o.prototype.getCellHTMLFromValue=function(t,e,o,r,n){var i=r,s="text"+(e?" "+e:"");return"number"==typeof i?(i=i.toString(),","===n&&(i=i.replace(".",n)),s="number"):r||(i="",s="empty"),"<"+t+(o?" "+o:"")+' class="'+s+'">'+i+"</"+t+">"},o.prototype.getTableHeaderHTML=function(t,e,o){void 0===t&&(t=[]),void 0===e&&(e=[]),void 0===o&&(o=this.options);var r,n,i=o.useMultiLevelHeaders,s=o.useRowspanHeaders,a="<thead>",u=0,l=e&&e.length,c=0;if(i&&t&&e&&!function(t,e){var o=t.length;if(e.length!==o)return!1;for(;--o;)if(t[o]!==e[o])return!1;return!0}(t,e)){for(a+="<tr>";u<l;++u)(r=t[u])===t[u+1]?++c:c?(a+=this.getCellHTMLFromValue("th","highcharts-table-topheading",'scope="col" colspan="'+(c+1)+'"',r),c=0):(r===e[u]?s?(n=2,delete e[u]):(n=1,e[u]=""):n=1,a+=this.getCellHTMLFromValue("th","highcharts-table-topheading",'scope="col"'+(n>1?' valign="top" rowspan="'+n+'"':""),r));a+="</tr>"}if(e){for(a+="<tr>",u=0,l=e.length;u<l;++u)void 0!==e[u]&&(a+=this.getCellHTMLFromValue("th",null,'scope="col"',e[u]));a+="</tr>"}return a+"</thead>"},o.prototype.parse=function(t,e){var o=[],r=[],n=i(this.options,t),s=n.endRow,a=n.startColumn,u=n.endColumn,l=n.firstRowAsNames,c=n.tableElement||this.tableElement;if(!(c instanceof HTMLElement)){this.emit({type:"parseError",columns:o,detail:e,headers:r,error:"Not a valid HTML Table"});return}this.tableElement=c,this.tableElementID=c.id,this.emit({type:"parse",columns:this.columns,detail:e,headers:this.headers});var f,p=c.getElementsByTagName("tr"),h=p.length,m=0,d=n.startRow;if(l&&h){for(var g=p[0].children,y=g.length,v=a;v<y&&!(v>u);v++)("TD"===(f=g[v]).tagName||"TH"===f.tagName)&&r.push(f.innerHTML);d++}for(;m<h;){if(m>=d&&m<=s)for(var b=p[m].children,C=b.length,w=0;w<C;){var j=w-a,D=o[j];if(("TD"===(f=b[w]).tagName||"TH"===f.tagName)&&w>=a&&w<=u){o[j]||(o[j]=[]);var O=this.asGuessedType(f.innerHTML);O instanceof Date&&(O=O.getTime()),o[j][m-d]=O;for(var v=1;m-d>=v&&void 0===D[m-d-v];)D[m-d-v]=null,v++}w++}m++}this.columns=o,this.headers=r,this.emit({type:"afterParse",columns:o,detail:e,headers:r})},o.prototype.getTable=function(){return t.getTableFromColumns(this.columns,this.headers)},o.defaultOptions=n(n({},t.defaultOptions),{useRowspanHeaders:!0,useMultiLevelHeaders:!0}),o}(t)}),o(e,"Data/Connectors/HTMLTableConnector.js",[e["Data/Connectors/DataConnector.js"],e["Core/Globals.js"],e["Data/Converters/HTMLTableConverter.js"],e["Core/Utilities.js"]],function(t,e,o,r){var n,i=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),s=e.win,a=r.merge,u=function(t){function e(r){var n=this,i=a(e.defaultOptions,r);return(n=t.call(this,i)||this).converter=new o(i),n.options=i,n}return i(e,t),e.prototype.load=function(t){var e,o=this,r=o.converter,n=o.table,i=o.options,u=i.dataModifier,l=i.table;if(o.emit({type:"load",detail:t,table:n,tableElement:o.tableElement}),"string"==typeof l?(o.tableID=l,e=s.document.getElementById(l)):(e=l,o.tableID=e.id),o.tableElement=e||void 0,!o.tableElement){var c="HTML table not provided, or element with ID not found";return o.emit({type:"loadError",detail:t,error:c,table:n}),Promise.reject(Error(c))}return r.parse(a({tableElement:o.tableElement},o.options),t),n.deleteColumns(),n.setColumns(r.getTable().getColumns()),o.setModifierOptions(u).then(function(){return o.emit({type:"afterLoad",detail:t,table:n,tableElement:o.tableElement}),o})},e.defaultOptions={table:""},e}(t);return t.registerType("HTMLTable",u),u}),o(e,"Data/Modifiers/ChainModifier.js",[e["Data/Modifiers/DataModifier.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=e.merge,i=function(e){function o(r){for(var i=[],s=1;s<arguments.length;s++)i[s-1]=arguments[s];var a=e.call(this)||this;a.chain=i,a.options=n(o.defaultOptions,r);for(var u=a.options.chain||[],l=0,c=u.length,f=void 0,p=void 0;l<c;++l)(f=u[l]).type&&(p=t.types[f.type])&&i.push(new p(f));return a}return r(o,e),o.prototype.add=function(t,e){this.emit({type:"addModifier",detail:e,modifier:t}),this.chain.push(t),this.emit({type:"addModifier",detail:e,modifier:t})},o.prototype.clear=function(t){this.emit({type:"clearChain",detail:t}),this.chain.length=0,this.emit({type:"afterClearChain",detail:t})},o.prototype.modify=function(t,e){var o=this,r=this.options.reverse?this.chain.slice().reverse():this.chain.slice();t.modified===t&&(t.modified=t.clone(!1,e));for(var n=Promise.resolve(t),i=0,s=r.length;i<s;++i)!function(t,o){var i=r[t];n=n.then(function(t){return i.modify(t.modified,e)})}(i,0);return n=(n=n.then(function(e){return t.modified.deleteColumns(),t.modified.setColumns(e.modified.getColumns()),t})).catch(function(r){throw o.emit({type:"error",detail:e,table:t}),r})},o.prototype.modifyCell=function(t,e,o,r,n){var i=this.options.reverse?this.chain.reverse():this.chain;if(i.length){for(var s=t.clone(),a=0,u=i.length;a<u;++a)i[a].modifyCell(s,e,o,r,n),s=s.modified;t.modified=s}return t},o.prototype.modifyColumns=function(t,e,o,r){var n=this.options.reverse?this.chain.reverse():this.chain.slice();if(n.length){for(var i=t.clone(),s=0,a=n.length;s<a;++s)n[s].modifyColumns(i,e,o,r),i=i.modified;t.modified=i}return t},o.prototype.modifyRows=function(t,e,o,r){var n=this.options.reverse?this.chain.reverse():this.chain.slice();if(n.length){for(var i=t.clone(),s=0,a=n.length;s<a;++s)n[s].modifyRows(i,e,o,r),i=i.modified;t.modified=i}return t},o.prototype.modifyTable=function(t,e){this.emit({type:"modify",detail:e,table:t});for(var o=this.options.reverse?this.chain.reverse():this.chain.slice(),r=t.modified,n=0,i=o.length;n<i;++n)r=(0,o[n]).modifyTable(r,e).modified;return t.modified=r,this.emit({type:"afterModify",detail:e,table:t}),t},o.prototype.remove=function(t,e){var o=this.chain;this.emit({type:"removeModifier",detail:e,modifier:t}),o.splice(o.indexOf(t),1),this.emit({type:"afterRemoveModifier",detail:e,modifier:t})},o.defaultOptions={type:"Chain"},o}(t);return t.registerType("Chain",i),i}),o(e,"Data/Modifiers/InvertModifier.js",[e["Data/Modifiers/DataModifier.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=e.merge,i=function(t){function e(o){var r=t.call(this)||this;return r.options=n(e.defaultOptions,o),r}return r(e,t),e.prototype.modifyCell=function(t,e,o,r,n){var i=t.modified,s=i.getRowIndexBy("columnNames",e);return void 0===s?i.setColumns(this.modifyTable(t.clone()).getColumns(),void 0,n):i.setCell("".concat(o),s,r,n),t},e.prototype.modifyColumns=function(t,e,o,r){var n=t.modified,i=n.getColumn("columnNames")||[],s=t.getColumnNames(),a=t.getRowCount()!==i.length;if(!a){for(var u=0,l=s.length;u<l;++u)if(s[u]!==i[u]){a=!0;break}}if(a)return this.modifyTable(t,r);s=Object.keys(e);for(var u=0,l=s.length,c=void 0,f=void 0,p=void 0;u<l;++u){c=e[f=s[u]],p=n.getRowIndexBy("columnNames",f)||n.getRowCount();for(var h=0,m=o,d=c.length;h<d;++h,++m)n.setCell("".concat(m),p,c[h],r)}return t},e.prototype.modifyRows=function(t,e,o,r){var n=t.getColumnNames(),i=t.modified,s=i.getColumn("columnNames")||[],a=t.getRowCount()!==s.length;if(!a){for(var u=0,l=n.length;u<l;++u)if(n[u]!==s[u]){a=!0;break}}if(a)return this.modifyTable(t,r);for(var u=0,c=o,l=e.length,f=void 0;u<l;++u,++c)if((f=e[u])instanceof Array)i.setColumn("".concat(c),f);else for(var p=0,h=n.length;p<h;++p)i.setCell("".concat(c),p,f[n[p]],r);return t},e.prototype.modifyTable=function(t,e){this.emit({type:"modify",detail:e,table:t});var o=t.modified;if(t.hasColumns(["columnNames"])){for(var r=((t.deleteColumns(["columnNames"])||{}).columnNames||[]).map(function(t){return"".concat(t)}),n={},i=0,s=t.getRowCount(),a=void 0;i<s;++i)(a=t.getRow(i))&&(n[r[i]]=a);o.deleteColumns(),o.setColumns(n)}else{for(var n={},i=0,s=t.getRowCount(),a=void 0;i<s;++i)(a=t.getRow(i))&&(n["".concat(i)]=a);n.columnNames=t.getColumnNames(),o.deleteColumns(),o.setColumns(n)}return this.emit({type:"afterModify",detail:e,table:t}),t},e.defaultOptions={type:"Invert"},e}(t);return t.registerType("Invert",i),i}),o(e,"Data/Modifiers/MathModifier.js",[e["Data/Modifiers/DataModifier.js"],e["Data/Formula/FormulaParser.js"],e["Data/Formula/FormulaProcessor.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=this&&this.__assign||function(){return(i=Object.assign||function(t){for(var e,o=1,r=arguments.length;o<r;o++)for(var n in e=arguments[o])Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t}).apply(this,arguments)},s=function(t){function r(e){var o=t.call(this)||this;return o.options=i(i({},r.defaultOptions),e),o}return n(r,t),r.prototype.modifyTable=function(t,o){this.emit({type:"modify",detail:o,table:t});for(var r=this.options.alternativeSeparators,n=this.options.formulaColumns||t.getColumnNames(),i=t.modified,s=0,a=n.length,u=void 0;s<a;++s)u=n[s],n.indexOf(u)>=0&&i.setColumn(u,this.processColumn(t,u));for(var l=this.options.columnFormulas||[],s=0,a=l.length,c=void 0,f=void 0;s<a;++s)c=l[s],f=e.parseFormula(c.formula,r),i.setColumn(c.column,this.processColumnFormula(f,t,c.rowStart,c.rowEnd));return this.emit({type:"afterModify",detail:o,table:t}),t},r.prototype.processColumn=function(t,r,n){void 0===n&&(n=0);for(var i=this.options.alternativeSeparators,s=(t.getColumn(r,!0)||[]).slice(n>0?n:0),a=0,u=s.length,l=[],c=void 0;a<u;++a)if("string"==typeof(c=s[a])&&"="===c[0])try{l=""===c?l:e.parseFormula(c.substring(1),i),s[a]=o.processFormula(l,t)}catch(t){s[a]=NaN}return s},r.prototype.processColumnFormula=function(t,e,r,n){void 0===r&&(r=0),void 0===n&&(n=e.getRowCount()),r=r>=0?r:0,n=n>=0?n:e.getRowCount()+n;for(var i=[],s=e.modified,a=0,u=n-r;a<u;++a)try{i[a]=o.processFormula(t,s)}catch(t){i[a]=NaN}finally{t=o.translateReferences(t,0,1)}return i},r.defaultOptions={type:"Math",alternativeSeparators:!1},r}(t);return t.registerType("Math",s),s}),o(e,"Data/Modifiers/RangeModifier.js",[e["Data/Modifiers/DataModifier.js"],e["Core/Utilities.js"]],function(t,e){var o,r=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),n=e.merge,i=function(t){function e(o){var r=t.call(this)||this;return r.options=n(e.defaultOptions,o),r}return r(e,t),e.prototype.modifyTable=function(t,e){this.emit({type:"modify",detail:e,table:t});var o=this.options,r=o.additive,n=o.ranges,i=o.strict;if(n.length){for(var s=t.modified,a=t.getColumns(),u=[],l=0,c=n.length,f=void 0,p=void 0;l<c;++l)if(f=n[l],!i||typeof f.minValue==typeof f.maxValue){l>0&&!r&&(s.deleteRows(),s.setRows(u),a=s.getColumns(),u=[]),p=a[f.column]||[];for(var h=0,m=p.length,d=void 0,g=void 0;h<m;++h){switch(typeof(d=p[h])){default:continue;case"boolean":case"number":case"string":}(!i||typeof d==typeof f.minValue)&&d>=f.minValue&&d<=f.maxValue&&(g=r?t.getRow(h):s.getRow(h))&&u.push(g)}}s.deleteRows(),s.setRows(u)}return this.emit({type:"afterModify",detail:e,table:t}),t},e.defaultOptions={type:"Range",ranges:[]},e}(t);return t.registerType("Range",i),i}),o(e,"Data/Modifiers/SortModifier.js",[e["Data/Modifiers/DataModifier.js"],e["Data/DataTable.js"],e["Core/Utilities.js"]],function(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=o.merge,s=function(t){function o(e){var r=t.call(this)||this;return r.options=i(o.defaultOptions,e),r}return n(o,t),o.ascending=function(t,e){return(t||0)<(e||0)?-1:(t||0)>(e||0)?1:0},o.descending=function(t,e){return(e||0)<(t||0)?-1:(e||0)>(t||0)?1:0},o.prototype.getRowReferences=function(t){for(var e=t.getRows(),o=[],r=0,n=e.length;r<n;++r)o.push({index:r,row:e[r]});return o},o.prototype.modifyCell=function(t,o,r,n,i){var s=this.options,a=s.orderByColumn,u=s.orderInColumn;return o===a&&(u?(t.modified.setCell(o,r,n),t.modified.setColumn(u,this.modifyTable(new e({columns:t.getColumns([a,u])})).modified.getColumn(u))):this.modifyTable(t,i)),t},o.prototype.modifyColumns=function(t,o,r,n){var i=this.options,s=i.orderByColumn,a=i.orderInColumn,u=Object.keys(o);return u.indexOf(s)>-1&&(a&&o[u[0]].length?(t.modified.setColumns(o,r),t.modified.setColumn(a,this.modifyTable(new e({columns:t.getColumns([s,a])})).modified.getColumn(a))):this.modifyTable(t,n)),t},o.prototype.modifyRows=function(t,o,r,n){var i=this.options,s=i.orderByColumn,a=i.orderInColumn;return a&&o.length?(t.modified.setRows(o,r),t.modified.setColumn(a,this.modifyTable(new e({columns:t.getColumns([s,a])})).modified.getColumn(a))):this.modifyTable(t,n),t},o.prototype.modifyTable=function(t,e){this.emit({type:"modify",detail:e,table:t});var r,n=t.getColumnNames(),i=t.getRowCount(),s=this.getRowReferences(t),a=this.options,u=a.direction,l=a.orderByColumn,c=a.orderInColumn,f="asc"===u?o.ascending:o.descending,p=n.indexOf(l),h=t.modified;if(-1!==p&&s.sort(function(t,e){return f(t.row[p],e.row[p])}),c){for(var m=[],d=0;d<i;++d)m[s[d].index]=d;h.setColumns(((r={})[c]=m,r))}else{for(var g=[],d=0;d<i;++d)g.push(s[d].row);h.setRows(g,0)}return this.emit({type:"afterModify",detail:e,table:t}),t},o.defaultOptions={type:"Sort",direction:"desc",orderByColumn:"y"},o}(t);return t.registerType("Sort",s),s}),o(e,"masters/modules/data-tools.src.js",[e["Core/Globals.js"],e["Data/Connectors/DataConnector.js"],e["Data/Converters/DataConverter.js"],e["Data/DataCursor.js"],e["Data/Modifiers/DataModifier.js"],e["Data/DataPool.js"],e["Data/DataTable.js"],e["Data/Formula/Formula.js"]],function(t,e,o,r,n,i,s,a){return t.DataConnector=t.DataConnector||e,t.DataConverter=t.DataConverter||o,t.DataCursor=t.DataCursor||r,t.DataModifier=t.DataModifier||n,t.DataPool=t.DataPool||i,t.DataTable=t.DataTable||s,t.Formula=t.Formula||a,t})});