<?php

namespace Modules\data\Database\Migrations;

use CodeIgniter\Database\Migration;

class AmbulanceStaff extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ambulanceId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'typeStaffId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'membre' => [
                'type' => 'VARCHAR',
                'constraint' => '250',
                'default'    => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('dt_ambulance_staffs');
    }

    public function down()
    {
        $this->forge->dropTable('dt_ambulance_staffs');
    }
}
