!/**
 * Highstock JS v11.4.0 (2024-03-04)
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2024 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(t,i,e,o){t.hasOwnProperty(i)||(t[i]=o.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}e(i,"Series/DataModifyComposition.js",[i["Core/Axis/Axis.js"],i["Core/Series/Point.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=i.prototype.tooltipFormatter,n=o.addEvent,a=o.arrayMax,l=o.arrayMin,h=o.correctFloat,p=o.defined,d=o.isArray,u=o.isNumber,c=o.isString,f=o.pick;return function(t){function i(t,i,e){!this.isXAxis&&(this.series.forEach(function(e){"compare"===t&&"boolean"!=typeof i?e.setCompare(i,!1):"cumulative"!==t||c(i)||e.setCumulative(i,!1)}),f(e,!0)&&this.chart.redraw())}function e(t){var i=this,e=i.series.chart.numberFormatter,o=function(o){t=t.replace("{point."+o+"}",(i[o]>0&&"change"===o?"+":"")+e(i[o],f(i.series.tooltipOptions.changeDecimals,2)))};return p(i.change)&&o("change"),p(i.cumulativeSum)&&o("cumulativeSum"),s.apply(this,[t])}function o(){var t,i=this.options.compare;("percent"===i||"value"===i||this.options.cumulative)&&(t=new b(this),"percent"===i||"value"===i?t.initCompare(i):t.initCumulative()),this.dataModify=t}function r(t){var i=t.dataExtremes,e=i.activeYData;if(this.dataModify&&i){var o=void 0;this.options.compare?o=[this.dataModify.modifyValue(i.dataMin),this.dataModify.modifyValue(i.dataMax)]:this.options.cumulative&&d(e)&&e.length>=2&&(o=b.getCumulativeExtremes(e)),o&&(i.dataMin=l(o),i.dataMax=a(o))}}function g(t,i){this.options.compare=this.userOptions.compare=t,this.update({},f(i,!0)),this.dataModify&&("value"===t||"percent"===t)?this.dataModify.initCompare(t):this.points.forEach(function(t){delete t.change})}function v(){if(this.xAxis&&this.processedYData&&this.dataModify){var t=this.processedXData,i=this.processedYData,e=i.length,o=!0===this.options.compareStart?0:1,r=-1,s=void 0;for(this.pointArrayMap&&(r=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y")),s=0;s<e-o;s++){var n=i[s]&&r>-1?i[s][r]:i[s];if(u(n)&&0!==n&&t[s+o]>=(this.xAxis.min||0)){this.dataModify.compareValue=n;break}}}}function x(t,i){this.setModifier("compare",t,i)}function m(t,i){t=f(t,!1),this.options.cumulative=this.userOptions.cumulative=t,this.update({},f(i,!0)),this.dataModify?this.dataModify.initCumulative():this.points.forEach(function(t){delete t.cumulativeSum})}function y(t,i){this.setModifier("cumulative",t,i)}t.compose=function(t,s,a){var l=s.prototype,h=a.prototype,p=t.prototype;return p.setCompare||(p.setCompare=g,p.setCumulative=m,n(t,"afterInit",o),n(t,"afterGetExtremes",r),n(t,"afterProcessData",v)),l.setCompare||(l.setCompare=x,l.setModifier=i,l.setCumulative=y,h.tooltipFormatter=e),t};var b=function(){function t(t){this.series=t}return t.prototype.modifyValue=function(){return 0},t.getCumulativeExtremes=function(t){var i=1/0,e=-1/0;return t.reduce(function(t,o){var r=t+o;return i=Math.min(i,r,t),e=Math.max(e,r,t),r}),[i,e]},t.prototype.initCompare=function(t){this.modifyValue=function(i,e){null===i&&(i=0);var o=this.compareValue;if(void 0!==i&&void 0!==o){if("value"===t?i-=o:i=i/o*100-(100===this.series.options.compareBase?0:100),void 0!==e){var r=this.series.points[e];r&&(r.change=i)}return i}return 0}},t.prototype.initCumulative=function(){this.modifyValue=function(t,i){if(null===t&&(t=0),void 0!==t&&void 0!==i){var e=i>0?this.series.points[i-1]:null;e&&e.cumulativeSum&&(t=h(e.cumulativeSum+t));var o=this.series.points[i];return o&&(o.cumulativeSum=t),t}return 0}},t}();t.Additions=b}(r||(r={})),r}),e(i,"Stock/Navigator/ChartNavigatorComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,o=t.isTouchDevice,r=i.addEvent,s=i.merge,n=i.pick,a=[];function l(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function h(){var t,i,e,o,r=this.legend,s=this.navigator;if(s){i=r&&r.options,e=s.xAxis,o=s.yAxis;var a=s.scrollbarHeight,l=s.scrollButtonSize;this.inverted?(s.left=s.opposite?this.chartWidth-a-s.height:this.spacing[3]+a,s.top=this.plotTop+l):(s.left=n(e.left,this.plotLeft+l),s.top=s.navigatorOptions.top||this.chartHeight-s.height-a-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(i&&"bottom"===i.verticalAlign&&"proximate"!==i.layout&&i.enabled&&!i.floating?r.legendHeight+n(i.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&o&&(this.inverted?e.options.left=o.options.left=s.left:e.options.top=o.options.top=s.top,e.setAxisSize(),o.setAxisSize())}}function p(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this),n(t.redraw,!0)&&this.redraw(t.animation))}function d(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this))}function u(){var t=this.options,i=t.navigator,e=t.rangeSelector;if((i&&i.enabled||e&&e.enabled)&&(!o&&"x"===this.zooming.type||o&&"x"===this.zooming.pinchType))return!1}function c(t){var i=t.navigator;if(i&&t.xAxis[0]){var e=t.xAxis[0].getExtremes();i.render(e.min,e.max)}}function f(t){var i=t.options.navigator||{},e=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(i.enabled||e.enabled)&&(s(!0,this.options.navigator,i),s(!0,this.options.scrollbar,e),delete t.options.navigator,delete t.options.scrollbar)}return{compose:function(t,o){if(i.pushUnique(a,t)){var s=t.prototype;e=o,s.callbacks.push(c),r(t,"afterAddSeries",l),r(t,"afterSetChartSize",h),r(t,"afterUpdate",p),r(t,"beforeRender",d),r(t,"beforeShowResetZoom",u),r(t,"update",f)}}}}),e(i,"Core/Axis/NavigatorAxisComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.isTouchDevice,o=i.addEvent,r=i.correctFloat,s=i.defined,n=i.isNumber,a=i.pick;function l(){this.navigatorAxis||(this.navigatorAxis=new p(this))}function h(t){var i,o=this.chart,r=o.options,n=r.navigator,a=this.navigatorAxis,l=o.zooming.pinchType,h=r.rangeSelector,p=o.zooming.type;if(this.isXAxis&&((null==n?void 0:n.enabled)||(null==h?void 0:h.enabled))){if("y"===p&&"zoom"===t.trigger)i=!1;else if(("zoom"===t.trigger&&"xy"===p||e&&"xy"===l)&&this.options.range){var d=a.previousZoom;s(t.min)?a.previousZoom=[this.min,this.max]:d&&(t.min=d[0],t.max=d[1],a.previousZoom=void 0)}}void 0!==i&&t.preventDefault()}var p=function(){function t(t){this.axis=t}return t.compose=function(t){t.keepProps.includes("navigatorAxis")||(t.keepProps.push("navigatorAxis"),o(t,"init",l),o(t,"setExtremes",h))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,i,e,o){var l,h=this.axis,p=h.chart,d=a(null===(l=h.ordinal)||void 0===l?void 0:l.convertOverscroll(h.options.overscroll),0),u=a(e,h.translate(t,!0,!h.horiz)),c=a(o,h.translate(i,!0,!h.horiz)),f=p&&p.fixedRange,g=(h.pointRange||0)/2;if(s(e)||(u=r(u+g)),s(o)||(c=r(c-g)),f&&h.dataMin&&h.dataMax){var v=h.dataMax+d;c>=v&&(u=r(v-f),c=r(v)),u<=h.dataMin&&(c=r(h.dataMin+f))}return n(u)&&n(c)||(u=c=void 0),{min:u,max:c}},t}();return p}),e(i,"Stock/Navigator/NavigatorDefaults.js",[i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"]],function(t,i){var e=t.parse,o=i.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===o.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),e(i,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,i,e,o,r){void 0===r&&(r={});var s=r.width?r.width/2:e,n=Math.round(s/3)+.5;return[["M",-s-1,.5],["L",s,.5],["L",s,(o=r.height||o)+.5],["L",-s-1,o+.5],["L",-s-1,.5],["M",-n,4],["L",-n,o-3],["M",n-1,4],["L",n-1,o-3]]}}}),e(i,"Stock/Utilities/StockUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined;return{setFixedRange:function(t){var e=this.xAxis[0];i(e.dataMax)&&i(e.dataMin)&&t?this.fixedRange=Math.min(t,e.dataMax-e.dataMin):this.fixedRange=t}}}),e(i,"Stock/Navigator/NavigatorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/Navigator/NavigatorSymbols.js"],i["Core/Renderer/RendererRegistry.js"],i["Stock/Utilities/StockUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a){var l=t.setOptions,h=i.composed,p=s.getRendererType,d=n.setFixedRange,u=a.addEvent,c=a.extend,f=a.pushUnique;function g(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,i,s){e.compose(i),f(h,"Navigator")&&(t.prototype.setFixedRange=d,c(p().prototype.symbols,r),u(s,"afterUpdate",g),l({navigator:o}))}}}),e(i,"Core/Axis/ScrollbarAxis.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,o=t.composed,r=i.addEvent,s=i.defined,n=i.pick,a=i.pushUnique;return function(t){var i;function e(t){var i=n(t.options&&t.options.min,t.min),e=n(t.options&&t.options.max,t.max);return{axisMin:i,axisMax:e,scrollMin:s(t.dataMin)?Math.min(i,t.min,t.dataMin,n(t.threshold,1/0)):i,scrollMax:s(t.dataMax)?Math.max(e,t.max,t.dataMax,n(t.threshold,-1/0)):e}}function l(){var t=this.scrollbar,i=t&&!t.options.opposite,e=this.horiz?2:i?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[e]+=t.size+(t.options.margin||0))}function h(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new i(t.chart.renderer,t.options.scrollbar,t.chart),r(t.scrollbar,"changed",function(i){var o,r,n=e(t),a=n.axisMin,l=n.axisMax,h=n.scrollMin,p=n.scrollMax-h;if(s(a)&&s(l)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(o=h+p*this.to,r=h+p*this.from):(o=h+p*(1-this.from),r=h+p*(1-this.to)),this.shouldUpdateExtremes(i.DOMType)){var d="mousemove"!==i.DOMType&&"touchmove"!==i.DOMType&&void 0;t.setExtremes(r,o,!0,d,i)}else this.setRange(this.from,this.to)}}))}function p(){var t,i,o,r=e(this),n=r.scrollMin,a=r.scrollMax,l=this.scrollbar,h=this.axisTitleMargin+(this.titleOffset||0),p=this.chart.scrollbarsOffsets,d=this.options.margin||0;if(l&&p){if(this.horiz)this.opposite||(p[1]+=h),l.position(this.left,this.top+this.height+2+p[1]-(this.opposite?d:0),this.width,this.height),this.opposite||(p[1]+=d),t=1;else{this.opposite&&(p[0]+=h);var u=void 0;u=l.options.opposite?this.left+this.width+2+p[0]-(this.opposite?0:d):this.opposite?0:d,l.position(u,this.top,this.width,this.height),this.opposite&&(p[0]+=d),t=0}p[t]+=l.size+(l.options.margin||0),isNaN(n)||isNaN(a)||!s(this.min)||!s(this.max)||this.min===this.max?l.setRange(0,1):(i=(this.min-n)/(a-n),o=(this.max-n)/(a-n),this.horiz&&!this.reversed||!this.horiz&&this.reversed?l.setRange(i,o):l.setRange(1-o,1-i))}}t.compose=function(t,e){a(o,"Axis.Scrollbar")&&(i=e,r(t,"afterGetOffset",l),r(t,"afterInit",h),r(t,"afterRender",p))}}(e||(e={})),e}),e(i,"Stock/Scrollbar/ScrollbarDefaults.js",[],function(){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),e(i,"Stock/Scrollbar/Scrollbar.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/ScrollbarAxis.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var s=t.defaultOptions,n=r.addEvent,a=r.correctFloat,l=r.defined,h=r.destroyObjectProperties,p=r.fireEvent,d=r.merge,u=r.pick,c=r.removeEvent,f=function(){function t(t,i,e){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,i,e)}return t.compose=function(i){e.compose(i,t)},t.swapXY=function(t,i){return i&&t.forEach(function(t){for(var i,e=t.length,o=0;o<e;o+=2)"number"==typeof(i=t[o+1])&&(t[o+1]=t[o+2],t[o+2]=i)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],i=this.scrollbarButtons,e=this.scrollbarGroup.element,o=this.track.element,r=this.mouseDownHandler.bind(this),s=this.mouseMoveHandler.bind(this),a=this.mouseUpHandler.bind(this),l=[[i[t[0]].element,"click",this.buttonToMinClick.bind(this)],[i[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[o,"click",this.trackClick.bind(this)],[e,"mousedown",r],[e.ownerDocument,"mousemove",s],[e.ownerDocument,"mouseup",a],[e,"touchstart",r],[e.ownerDocument,"touchmove",s],[e.ownerDocument,"touchend",a]];l.forEach(function(t){n.apply(null,t)}),this._events=l},t.prototype.buttonToMaxClick=function(t){var i=(this.to-this.from)*u(this.options.step,.2);this.updatePosition(this.from+i,this.to+i),p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var i=a(this.to-this.from)*u(this.options.step,.2);this.updatePosition(a(this.from-i),a(this.to-i)),p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var i=this.options,e=i.minWidth>this.calculatedWidth?i.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-e),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-e)}},t.prototype.destroy=function(){var t=this,i=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(i){t[i]&&t[i].destroy&&(t[i]=t[i].destroy())}),i&&t===i.scrollbar&&(i.scrollbar=null,h(i.scrollbarButtons))},t.prototype.drawScrollbarButton=function(i){var e=this.renderer,o=this.scrollbarButtons,r=this.options,s=this.size,n=e.g().add(this.group);if(o.push(n),r.buttonsEnabled){var a=e.rect().addClass("highcharts-scrollbar-button").add(n);this.chart.styledMode||a.attr({stroke:r.buttonBorderColor,"stroke-width":r.buttonBorderWidth,fill:r.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:s+1,height:s+1,r:r.buttonBorderRadius},a.strokeWidth()));var l=e.path(t.swapXY([["M",s/2+(i?-1:1),s/2-3],["L",s/2+(i?-1:1),s/2+3],["L",s/2+(i?2:-2),s/2]],r.vertical)).addClass("highcharts-scrollbar-arrow").add(o[i]);this.chart.styledMode||l.attr({fill:r.buttonArrowColor})}},t.prototype.init=function(t,i,e){this.scrollbarButtons=[],this.renderer=t,this.userOptions=i,this.options=d(o,s.scrollbar,i),this.options.margin=u(this.options.margin,10),this.chart=e,this.size=u(this.options.size,this.options.height),i.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.cursorToScrollbarPosition(e);this.chartX=o.chartX,this.chartY=o.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var i,e,o=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,r=this.options.vertical?"chartY":"chartX",s=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][r])&&(e=this.cursorToScrollbarPosition(o)[r]-this[r],this.hasDragged=!0,this.updatePosition(s[0]+e,s[1]+e),this.hasDragged&&p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,i,e,o){var r=this.options,s=r.buttonsEnabled,n=r.margin,a=void 0===n?0:n,l=r.vertical,h=this.rendered?"animate":"attr",p=o,d=0;this.group.show(),this.x=t,this.y=i+this.trackBorderWidth,this.width=e,this.height=o,this.xOffset=p,this.yOffset=d,l?(this.width=this.yOffset=e=d=this.size,this.xOffset=p=0,this.yOffset=d=s?this.size:0,this.barWidth=o-(s?2*e:0),this.x=t+=a):(this.height=o=this.size,this.xOffset=p=s?this.size:0,this.barWidth=e-(s?2*o:0),this.y=this.y+a),this.group[h]({translateX:t,translateY:this.y}),this.track[h]({width:e,height:o}),this.scrollbarButtons[1][h]({translateX:l?0:e-p,translateY:l?o-d:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){c.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var i=this.renderer,e=this.options,o=this.size,r=this.chart.styledMode,s=i.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=s,this.track=i.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:o,width:o}).add(s),r||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var n=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-n%2/2,y:-n%2/2}),this.scrollbarGroup=i.g().add(s),this.scrollbar=i.rect().addClass("highcharts-scrollbar-thumb").attr({height:o-n,width:o-n,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=i.path(t.swapXY([["M",-3,o/4],["L",-3,2*o/3],["M",0,o/4],["L",0,2*o/3],["M",3,o/4],["L",3,2*o/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),r||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,i){var e,o,r=this.options,s=r.vertical,n=r.minWidth,h=this.barWidth,p=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(l(h)){var d=h*Math.min(i,1);e=Math.ceil(h*(t=Math.max(t,0))),this.calculatedWidth=o=a(d-e),o<n&&(e=(h-n+o)*t,o=n);var u=Math.floor(e+this.xOffset+this.yOffset),c=o/2-.5;this.from=t,this.to=i,s?(this.scrollbarGroup[p]({translateY:u}),this.scrollbar[p]({height:o}),this.scrollbarRifles[p]({translateY:c}),this.scrollbarTop=u,this.scrollbarLeft=0):(this.scrollbarGroup[p]({translateX:u}),this.scrollbar[p]({width:o}),this.scrollbarRifles[p]({translateX:c}),this.scrollbarLeft=u,this.scrollbarTop=0),o<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===r.showFull&&(t<=0&&i>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return u(this.options.liveRedraw,i.svg&&!i.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!l(t)},t.prototype.trackClick=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.to-this.from,r=this.y+this.scrollbarTop,s=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>r||!this.options.vertical&&e.chartX>s?this.updatePosition(this.from+o,this.to+o):this.updatePosition(this.from-o,this.to-o),p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,d(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,i){i>1&&(t=a(1-a(i-t)),i=1),t<0&&(i=a(i-t),t=0),this.from=t,this.to=i},t.defaultOptions=o,t}();return s.scrollbar=d(!0,f.defaultOptions,s.scrollbar),f}),e(i,"Stock/Navigator/Navigator.js",[i["Core/Axis/Axis.js"],i["Stock/Navigator/ChartNavigatorComposition.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorComposition.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a){var l=e.defaultOptions,h=o.isTouchDevice,p=a.addEvent,d=a.clamp,u=a.correctFloat,c=a.defined,f=a.destroyObjectProperties,g=a.erase,v=a.extend,x=a.find,m=a.fireEvent,y=a.isArray,b=a.isNumber,M=a.merge,S=a.pick,A=a.removeEvent,k=a.splat;function C(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];var o=[].filter.call(i,b);if(o.length)return Math[t].apply(0,o)}return function(){function e(t){this.scrollbarHeight=0,this.init(t)}return e.compose=function(t,o,r){i.compose(t,e),s.compose(t,o,r)},e.prototype.drawHandle=function(t,i,e,o){var r=this.navigatorOptions.handles.height;this.handles[i][o](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-r)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-r/2-1)})},e.prototype.drawOutline=function(t,i,e,o){var r,s,n=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),l=a/2,h=a%2/2,p=this.scrollButtonSize,d=this.size,u=this.top,c=this.height,f=u-l,g=u+c,v=this.left;e?(r=u+i+h,i=u+t+h,s=[["M",v+c,u-p-h],["L",v+c,r],["L",v,r],["M",v,i],["L",v+c,i],["L",v+c,u+d+p]],n&&s.push(["M",v+c,r-l],["L",v+c,i+l])):(v-=p,t+=v+p-h,i+=v+p-h,s=[["M",v,f],["L",t,f],["L",t,g],["M",i,g],["L",i,f],["L",v+d+2*p,u+l]],n&&s.push(["M",t-l,f],["L",i+l,f])),this.outline[o]({d:s})},e.prototype.drawMasks=function(t,i,e,o){var r,s,n,a,l=this.left,h=this.top,p=this.height;e?(n=[l,l,l],a=[h,h+t,h+i],s=[p,p,p],r=[t,i-t,this.size-i]):(n=[l,l+t,l+i],a=[h,h,h],s=[t,i-t,this.size-i],r=[p,p,p]),this.shades.forEach(function(t,i){t[o]({x:n[i],y:a[i],width:s[i],height:r[i]})})},e.prototype.renderElements=function(){var t=this,i=t.navigatorOptions,e=i.maskInside,o=t.chart,r=o.inverted,s=o.renderer,n={cursor:r?"ns-resize":"ew-resize"},a=t.navigatorGroup=s.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!e,e,!e].forEach(function(e,r){var l=s.rect().addClass("highcharts-navigator-mask"+(1===r?"-inside":"-outside")).add(a);o.styledMode||(l.attr({fill:e?i.maskFill:"rgba(0,0,0,0)"}),1===r&&l.css(n)),t.shades[r]=l}),t.outline=s.path().addClass("highcharts-navigator-outline").add(a),o.styledMode||t.outline.attr({"stroke-width":i.outlineWidth,stroke:i.outlineColor}),i.handles&&i.handles.enabled){var l=i.handles,h=l.height,p=l.width;[0,1].forEach(function(i){t.handles[i]=s.symbol(l.symbols[i],-p/2-1,0,p,h,l),o.inverted&&t.handles[i].attr({rotation:90,rotationOriginX:Math.floor(-p/2),rotationOriginY:(h+p)/2}),t.handles[i].attr({zIndex:7-i}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][i]).add(a),o.styledMode||t.handles[i].attr({fill:l.backgroundColor,stroke:l.borderColor,"stroke-width":l.lineWidth}).css(n)})}},e.prototype.update=function(t){(this.series||[]).forEach(function(t){t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),M(!0,this.chart.options.navigator,t),this.init(this.chart)},e.prototype.render=function(t,i,e,o){var r,s,n,a,l,h=this.chart,p=this.xAxis,f=p.pointRange||0,g=p.navigatorAxis.fake?h.xAxis[0]:p,v=this.navigatorEnabled,x=this.rendered,y=h.inverted,M=h.xAxis[0].minRange,A=h.xAxis[0].options.maxRange,k=this.scrollButtonSize,C=this.scrollbarHeight;if(!this.hasDragged||c(e)){if(t=u(t-f/2),i=u(i+f/2),!b(t)||!b(i)){if(!x)return;e=0,o=S(p.width,g.width)}this.left=S(p.left,h.plotLeft+k+(y?h.plotWidth:0));var w=this.size=a=S(p.len,(y?h.plotHeight:h.plotWidth)-2*k);r=y?C:a+2*k,e=S(e,p.toPixels(t,!0)),o=S(o,p.toPixels(i,!0)),b(e)&&Math.abs(e)!==1/0||(e=0,o=r);var D=p.toValue(e,!0),O=p.toValue(o,!0),E=Math.abs(u(O-D));E<M?this.grabbedLeft?e=p.toPixels(O-M-f,!0):this.grabbedRight&&(o=p.toPixels(D+M+f,!0)):c(A)&&u(E-f)>A&&(this.grabbedLeft?e=p.toPixels(O-A-f,!0):this.grabbedRight&&(o=p.toPixels(D+A+f,!0))),this.zoomedMax=d(Math.max(e,o),0,w),this.zoomedMin=d(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,o),0,w),this.range=this.zoomedMax-this.zoomedMin,w=Math.round(this.zoomedMax);var B=Math.round(this.zoomedMin);v&&(this.navigatorGroup.attr({visibility:"inherit"}),l=x&&!this.hasDragged?"animate":"attr",this.drawMasks(B,w,y,l),this.drawOutline(B,w,y,l),this.navigatorOptions.handles.enabled&&(this.drawHandle(B,0,y,l),this.drawHandle(w,1,y,l))),this.scrollbar&&(y?(n=this.top-k,s=this.left-C+(v||!g.opposite?0:(g.titleOffset||0)+g.axisTitleMargin),C=a+2*k):(n=this.top+(v?this.height:-C),s=this.left-k),this.scrollbar.position(s,n,r,C),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1))),this.rendered=!0,m(this,"afterRender")}},e.prototype.addMouseEvents=function(){var t,i,e=this,o=e.chart,r=o.container,s=[];e.mouseMoveHandler=t=function(t){e.onMouseMove(t)},e.mouseUpHandler=i=function(t){e.onMouseUp(t)},(s=e.getPartsEvents("mousedown")).push(p(o.renderTo,"mousemove",t),p(r.ownerDocument,"mouseup",i),p(o.renderTo,"touchmove",t),p(r.ownerDocument,"touchend",i)),s.concat(e.getPartsEvents("touchstart")),e.eventsToUnbind=s,e.series&&e.series[0]&&s.push(p(e.series[0].xAxis,"foundExtremes",function(){o.navigator.modifyNavigatorAxisExtremes()}))},e.prototype.getPartsEvents=function(t){var i=this,e=[];return["shades","handles"].forEach(function(o){i[o].forEach(function(r,s){e.push(p(r.element,t,function(t){i[o+"Mousedown"](t,s)}))})}),e},e.prototype.shadesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,o,r,s,n,a=this.chart,l=this.xAxis,h=this.zoomedMin,p=this.size,d=this.range,u=this.left,f=t.chartX;a.inverted&&(f=t.chartY,u=this.top),1===i?(this.grabbedCenter=f,this.fixedWidth=d,this.dragOffset=f-h):(n=f-u-d/2,0===i?n=Math.max(0,n):2===i&&n+d>=p&&(n=p-d,this.reversedExtremes?(n-=d,r=this.getUnionExtremes().dataMin):o=this.getUnionExtremes().dataMax),n!==h&&(this.fixedWidth=d,c((s=l.navigatorAxis.toFixedRange(n,n+d,r,o)).min)&&m(this,"setRange",{min:Math.min(s.min,s.max),max:Math.max(s.min,s.max),redraw:!0,eventArguments:{trigger:"navigator"}})))},e.prototype.handlesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,o=this.chart,r=o.xAxis[0],s=this.reversedExtremes;0===i?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=s?r.min:r.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=s?r.max:r.min),o.setFixedRange(void 0)},e.prototype.onMouseMove=function(t){var i,e,o=this,r=o.chart,s=o.navigatorSize,n=o.range,a=o.dragOffset,l=r.inverted,p=o.left;(!t.touches||0!==t.touches[0].pageX)&&(e=(t=(null===(i=r.pointer)||void 0===i?void 0:i.normalize(t))||t).chartX,l&&(p=o.top,e=t.chartY),o.grabbedLeft?(o.hasDragged=!0,o.render(0,0,e-p,o.otherHandlePos)):o.grabbedRight?(o.hasDragged=!0,o.render(0,0,o.otherHandlePos,e-p)):o.grabbedCenter&&(o.hasDragged=!0,e<a?e=a:e>s+a-n&&(e=s+a-n),o.render(0,0,e-a,e-a+n)),o.hasDragged&&o.scrollbar&&S(o.scrollbar.options.liveRedraw,!h&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){o.onMouseUp(t)},0)))},e.prototype.onMouseUp=function(t){var i,e,o,r,s,n,a=this.chart,l=this.xAxis,h=this.scrollbar,p=t.DOMEvent||t,d=a.inverted,u=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===t.trigger)&&(o=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?r=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(s=this.fixedExtreme),this.zoomedMax===this.size&&(s=this.reversedExtremes?o.dataMin:o.dataMax),0===this.zoomedMin&&(r=this.reversedExtremes?o.dataMax:o.dataMin),c((n=l.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,r,s)).min)&&m(this,"setRange",{min:Math.min(n.min,n.max),max:Math.max(n.min,n.max),redraw:!0,animation:!this.hasDragged&&null,eventArguments:{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:p}})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&b(this.zoomedMin)&&b(this.zoomedMax)&&(e=Math.round(this.zoomedMin),i=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,i,d,u),this.outline&&this.drawOutline(e,i,d,u),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,d,u),this.drawHandle(i,1,d,u)))},e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},e.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){A(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&A(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},e.prototype.init=function(i){var e=i.options,o=e.navigator||{},s=o.enabled,a=e.scrollbar||{},l=a.enabled,h=s&&o.height||0,d=l&&a.height||0,u=a.buttonsEnabled&&d||0;this.handles=[],this.shades=[],this.chart=i,this.setBaseSeries(),this.height=h,this.scrollbarHeight=d,this.scrollButtonSize=u,this.scrollbarEnabled=l,this.navigatorEnabled=s,this.navigatorOptions=o,this.scrollbarOptions=a,this.opposite=S(o.opposite,!!(!s&&i.inverted));var c=this,f=c.baseSeries,g=i.xAxis.length,v=i.yAxis.length,x=f&&f[0]&&f[0].xAxis||i.xAxis[0]||{options:{}};if(i.isDirtyBox=!0,c.navigatorEnabled?(c.xAxis=new t(i,M({breaks:x.options.breaks,ordinal:x.options.ordinal,overscroll:x.options.overscroll},o.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},i.inverted?{offsets:[u,0,-u,0],width:h}:{offsets:[0,-u,0,u],height:h}),"xAxis"),c.yAxis=new t(i,M(o.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:v,isInternal:!0,reversed:S(o.yAxis&&o.yAxis.reversed,i.yAxis[0]&&i.yAxis[0].reversed,!1),zoomEnabled:!1},i.inverted?{width:h}:{height:h}),"yAxis"),f||o.series.data?c.updateNavigatorSeries(!1):0===i.series.length&&(c.unbindRedraw=p(i,"beforeRedraw",function(){i.series.length>0&&!c.series&&(c.setBaseSeries(),c.unbindRedraw())})),c.reversedExtremes=i.inverted&&!c.xAxis.reversed||!i.inverted&&c.xAxis.reversed,c.renderElements(),c.addMouseEvents()):(c.xAxis={chart:i,navigatorAxis:{fake:!0},translate:function(t,e){var o=i.xAxis[0],r=o.getExtremes(),s=o.len-2*u,n=C("min",o.options.min,r.dataMin),a=C("max",o.options.max,r.dataMax)-n;return e?t*a/s+n:s*(t-n)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},c.xAxis.navigatorAxis.axis=c.xAxis,c.xAxis.navigatorAxis.toFixedRange=r.prototype.toFixedRange.bind(c.xAxis.navigatorAxis)),i.options.scrollbar.enabled){var m=M(i.options.scrollbar,{vertical:i.inverted});!b(m.margin)&&c.navigatorEnabled&&(m.margin=i.inverted?-3:3),i.scrollbar=c.scrollbar=new n(i.renderer,m,i),p(c.scrollbar,"changed",function(t){var i=c.size,e=i*this.to,o=i*this.from;c.hasDragged=c.scrollbar.hasDragged,c.render(0,0,o,e),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){c.onMouseUp(t)})})}c.addBaseSeriesEvents(),c.addChartEvents()},e.prototype.getUnionExtremes=function(t){var i,e=this.chart.xAxis[0],o=this.xAxis,r=o.options,s=e.options;return t&&null===e.dataMin||(i={dataMin:S(r&&r.min,C("min",s.min,e.dataMin,o.dataMin,o.min)),dataMax:S(r&&r.max,C("max",s.max,e.dataMax,o.dataMax,o.max))}),i},e.prototype.setBaseSeries=function(t,i){var e=this.chart,o=this.baseSeries=[];t=t||e.options&&e.options.navigator.baseSeries||(e.series.length?x(e.series,function(t){return!t.options.isInternal}).index:0),(e.series||[]).forEach(function(i,e){!i.options.isInternal&&(i.options.showInNavigator||(e===t||i.options.id===t)&&!1!==i.options.showInNavigator)&&o.push(i)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,i)},e.prototype.updateNavigatorSeries=function(t,i){var e,o,r,s=this,n=s.chart,a=s.baseSeries,h={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},p=s.series=(s.series||[]).filter(function(t){var i=t.baseSeries;return!(0>a.indexOf(i))||(i&&(A(i,"updatedData",s.updatedDataHandler),delete i.navigatorSeries),t.chart&&t.destroy(),!1)}),d=s.navigatorOptions.series;a&&a.length&&a.forEach(function(t){var u=t.navigatorSeries,c=v({color:t.color,visible:t.visible},y(d)?l.navigator.series:d);if(!u||!1!==s.navigatorOptions.adaptToUpdatedData){h.name="Navigator "+a.length,r=(e=t.options||{}).navigatorOptions||{},c.dataLabels=k(c.dataLabels),(o=M(e,h,c,r)).pointRange=S(c.pointRange,r.pointRange,l.plotOptions[o.type||"line"].pointRange);var f=r.data||c.data;s.hasNavigatorData=s.hasNavigatorData||!!f,o.data=f||e.data&&e.data.slice(0),u&&u.options?u.update(o,i):(t.navigatorSeries=n.initSeries(o),n.setSortedData(),t.navigatorSeries.baseSeries=t,p.push(t.navigatorSeries))}}),(d.data&&!(a&&a.length)||y(d))&&(s.hasNavigatorData=!1,(d=k(d)).forEach(function(t,i){h.name="Navigator "+(p.length+1),(o=M(l.navigator.series,{color:n.series[i]&&!n.series[i].options.isInternal&&n.series[i].color||n.options.colors[i]||n.options.colors[0]},h,t)).data=t.data,o.data&&(s.hasNavigatorData=!0,p.push(n.initSeries(o)))})),t&&this.addBaseSeriesEvents()},e.prototype.addBaseSeriesEvents=function(){var t=this,i=this,e=i.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(p(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(e){e.eventsToUnbind.push(p(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(p(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(p(e,"updatedData",t.updatedDataHandler)),e.eventsToUnbind.push(p(e,"remove",function(){this.navigatorSeries&&(g(i.series,this.navigatorSeries),c(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},e.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,i){return Math.min(t,i.xData&&i.xData.length?i.xData[0]:t)},t)},e.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var i=this.getUnionExtremes(!0);i&&(i.dataMin!==t.min||i.dataMax!==t.max)&&(t.min=i.dataMin,t.max=i.dataMax)}},e.prototype.modifyBaseAxisExtremes=function(){var t,i,e,o=this.chart.navigator,r=this.getExtremes(),s=r.min,n=r.max,a=r.dataMin,l=r.dataMax,h=n-s,p=o.stickToMin,d=o.stickToMax,u=S(null===(t=this.ordinal)||void 0===t?void 0:t.convertOverscroll(this.options.overscroll),0),c=o.series&&o.series[0],f=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(p&&(i=(e=a)+h),d&&(i=l+u,p||(e=Math.max(a,i-h,o.getBaseSeriesMin(c&&c.xData?c.xData[0]:-Number.MAX_VALUE)))),f&&(p||d)&&b(e)&&(this.min=this.userMin=e,this.max=this.userMax=i)),o.stickToMin=o.stickToMax=null},e.prototype.updatedDataHandler=function(){var t=this.chart.navigator,i=this.navigatorSeries,e=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=S(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,e),t.stickToMin=t.shouldStickToMin(this,t),i&&!t.hasNavigatorData&&(i.options.pointStart=this.xData[0],i.setData(this.options.data,!1,null,!1))},e.prototype.shouldStickToMin=function(t,i){var e=i.getBaseSeriesMin(t.xData[0]),o=t.xAxis,r=o.max,s=o.min,n=o.options.range;return!!(b(r)&&b(s))&&(n&&r-e>0?r-e<n:s<=e)},e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(p(this.chart,"redraw",function(){var t=this.navigator,i=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);i&&t.render(i.min,i.max)}),p(this.chart,"getMargins",function(){var t=this.navigator,i=t.opposite?"plotTop":"marginBottom";this.inverted&&(i=t.opposite?"marginRight":"plotLeft"),this[i]=(this[i]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}),p(e,"setRange",function(t){this.chart.xAxis[0].setExtremes(t.min,t.max,t.redraw,t.animation,t.eventArguments)}))},e.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(g(this.chart.xAxis,this.xAxis),g(this.chart.axes,this.xAxis)),this.yAxis&&(g(this.chart.yAxis,this.yAxis),g(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(i){t[i]&&t[i].destroy&&t[i].destroy(),t[i]=null}),[this.handles].forEach(function(t){f(t)})},e}()}),e(i,"Core/Axis/OrdinalAxis.js",[i["Core/Axis/Axis.js"],i["Core/Globals.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=o.addEvent,n=o.correctFloat,a=o.css,l=o.defined,h=o.error,p=o.isNumber,d=o.pick,u=o.timeUnits,c=o.isString;return function(t){function o(t,i,e,o,r,s,n){void 0===r&&(r=[]),void 0===s&&(s=0);var a,p,d,c,f,g={},v=this.options.tickPixelInterval,x=this.chart.time,m=[],y=0,b=[],M=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!r||r.length<3||void 0===i)return x.getTimeTicks.apply(x,arguments);var S=r.length;for(a=0;a<S;a++){if(f=a&&r[a-1]>e,r[a]<i&&(y=a),a===S-1||r[a+1]-r[a]>5*s||f){if(r[a]>M){for(p=x.getTimeTicks(t,r[y],r[a],o);p.length&&p[0]<=M;)p.shift();p.length&&(M=p[p.length-1]),m.push(b.length),b=b.concat(p)}y=a+1}if(f)break}if(p){if(c=p.info,n&&c.unitRange<=u.hour){for(y=1,a=b.length-1;y<a;y++)x.dateFormat("%d",b[y])!==x.dateFormat("%d",b[y-1])&&(g[b[y]]="day",d=!0);d&&(g[b[0]]="day"),c.higherRanks=g}c.segmentStarts=m,b.info=c}else h(12,!1,this.chart);if(n&&l(v)){for(var A=b.length,k=[],C=[],w=void 0,D=void 0,O=void 0,E=void 0,B=void 0,P=A;P--;)D=this.translate(b[P]),O&&(C[P]=O-D),k[P]=O=D;for(C.sort(),(E=C[Math.floor(C.length/2)])<.6*v&&(E=null),P=b[A-1]>e?A-1:A,O=void 0;P--;)B=Math.abs(O-(D=k[P])),O&&B<.8*v&&(null===E||B<.8*E)?(g[b[P]]&&!g[b[P+1]]?(w=P+1,O=D):w=P,b.splice(w,1)):O=D}return b}function r(t){var i=this.ordinal.positions;if(!i)return t;var e,o=i.length-1;return(t<0?t=i[0]:t>o?t=i[o]:(o=Math.floor(t),e=t-o),void 0!==e&&void 0!==i[o])?i[o]+(e?e*(i[o+1]-i[o]):0):t}function f(t){var i=this.ordinal,e=this.old?this.old.min:this.min,o=this.old?this.old.transA:this.transA,r=i.getExtendedPositions();if(r&&r.length){var s=n((t-e)*o+this.minPixelPadding),a=n(i.getIndexOfPoint(s,r)),l=n(a%1);if(a>=0&&a<=r.length-1){var h=r[Math.floor(a)],p=r[Math.ceil(a)];return r[Math.floor(a)]+l*(p-h)}}return t}function g(i,e){var o=t.Additions.findIndexOf(i,e,!0);if(i[o]===e)return o;var r=(e-i[o])/(i[o+1]-i[o]);return o+r}function v(){this.ordinal||(this.ordinal=new t.Additions(this))}function x(){var t=this.eventArgs,i=this.options;if(this.isXAxis&&l(i.overscroll)&&0!==i.overscroll&&p(this.max)&&p(this.min)&&(this.options.ordinal&&!this.ordinal.originalOrdinalRange&&this.ordinal.getExtendedPositions(!1),this.max===this.dataMax&&((null==t?void 0:t.trigger)!=="pan"||this.isInternal)&&(null==t?void 0:t.trigger)!=="navigator")){var e=this.ordinal.convertOverscroll(i.overscroll);this.max+=e,!this.isInternal&&l(this.userMin)&&(null==t?void 0:t.trigger)!=="mousewheel"&&(this.min+=e)}}function m(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function y(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function b(t){var i=this.xAxis[0],e=i.ordinal.convertOverscroll(i.options.overscroll),o=t.originalEvent.chartX,r=this.options.chart.panning,s=!1;if(r&&"y"!==r.type&&i.options.ordinal&&i.series.length){var n=this.mouseDownX,l=i.getExtremes(),h=l.dataMax,p=l.min,d=l.max,u=this.hoverPoints,c=i.closestPointRange||i.ordinal&&i.ordinal.overscrollPointsRange,f=Math.round((n-o)/(i.translationSlope*(i.ordinal.slope||c))),g=i.ordinal.getExtendedPositions(),v={ordinal:{positions:g,extendedOrdinalPositions:g}},x=i.index2val,m=i.val2lin,y=void 0,b=void 0;v.ordinal.positions?Math.abs(f)>1&&(u&&u.forEach(function(t){t.setState()}),h>(b=v.ordinal.positions)[b.length-1]&&b.push(h),this.setFixedRange(d-p),(y=i.navigatorAxis.toFixedRange(void 0,void 0,x.apply(v,[m.apply(v,[p,!0])+f]),x.apply(v,[m.apply(v,[d,!0])+f]))).min>=Math.min(l.dataMin,p)&&y.max<=Math.max(h,d)+e&&i.setExtremes(y.min,y.max,!0,!1,{trigger:"pan"}),this.mouseDownX=o,a(this.container,{cursor:"move"})):s=!0}else s=!0;s||r&&/y/.test(r.type)?e&&(i.max=i.dataMax+e):t.preventDefault()}function M(){var t=this.xAxis;t&&t.options.ordinal&&(delete t.ordinal.index,delete t.ordinal.originalOrdinalRange)}function S(t,i){var e,o,r=this.ordinal,s=r.positions,n=r.slope;if(!s)return t;var a=s.length;if(s[0]<=t&&s[a-1]>=t)e=g(s,t);else{if(!((o=r.getExtendedPositions&&r.getExtendedPositions())&&o.length))return t;var l=o.length;n||(n=(o[l-1]-o[0])/l);var h=g(o,s[0]);if(t>=o[0]&&t<=o[l-1])e=g(o,t)-h;else{if(!i)return t;if(t<o[0]){var p=o[0]-t,d=p/n;e=-h-d}else{var p=t-o[l-1],d=p/n;e=d+l-h}}}return i?e:n*(e||0)+r.offset}t.compose=function(t,i,e){var n=t.prototype;return n.ordinal2lin||(n.getTimeTicks=o,n.index2val=r,n.lin2val=f,n.val2lin=S,n.ordinal2lin=n.val2lin,s(t,"afterInit",v),s(t,"foundExtremes",x),s(t,"afterSetScale",m),s(t,"initialAxisTranslation",y),s(e,"pan",b),s(i,"updatedData",M)),t};var A=function(){function t(t){this.index={},this.axis=t}return t.prototype.beforeSetTickPositions=function(){var t,i,e,o,r,s,n,a,l=this.axis,h=l.ordinal,p=l.getExtremes(),u=p.min,c=p.max,f=null===(t=l.brokenAxis)||void 0===t?void 0:t.hasBreaks,g=l.options.ordinal,v=[],x=Number.MAX_VALUE,m=!1,y=!1,b=!1;if(g||f){var M=0;if(l.series.forEach(function(t,o){if(e=[],o>0&&"highcharts-navigator-series"!==t.options.id&&t.processedXData.length>1&&(y=M!==t.processedXData[1]-t.processedXData[0]),M=t.processedXData[1]-t.processedXData[0],t.boosted&&(b=t.boosted),t.reserveSpace()&&(!1!==t.takeOrdinalPosition||f)&&(i=(v=v.concat(t.processedXData)).length,v.sort(function(t,i){return t-i}),x=Math.min(x,d(t.closestPointRange,x)),i)){for(o=0;o<i-1;)v[o]!==v[o+1]&&e.push(v[o+1]),o++;e[0]!==v[0]&&e.unshift(v[0]),v=e}}),l.ordinal.originalOrdinalRange||(l.ordinal.originalOrdinalRange=(v.length-1)*x),y&&b&&(v.pop(),v.shift()),(i=v.length)>2){for(o=v[1]-v[0],a=i-1;a--&&!m;)v[a+1]-v[a]!==o&&(m=!0);!l.options.keepOrdinalPadding&&(v[0]-u>o||c-v[v.length-1]>o)&&(m=!0)}else l.options.overscroll&&(2===i?x=v[1]-v[0]:1===i?(x=l.ordinal.convertOverscroll(l.options.overscroll),v=[v[0],v[0]+x]):x=h.overscrollPointsRange);m||l.forceOrdinal?(l.options.overscroll&&(h.overscrollPointsRange=x,v=v.concat(h.getOverscrollPositions())),h.positions=v,r=l.ordinal2lin(Math.max(u,v[0]),!0),s=Math.max(l.ordinal2lin(Math.min(c,v[v.length-1]),!0),1),h.slope=n=(c-u)/(s-r),h.offset=u-r*n):(h.overscrollPointsRange=d(l.closestPointRange,h.overscrollPointsRange),h.positions=l.ordinal.slope=h.offset=void 0)}l.isOrdinal=g&&m,h.groupIntervalFactor=null},t.findIndexOf=function(t,i,e){for(var o,r=0,s=t.length-1;r<s;)t[o=Math.ceil((r+s)/2)]<=i?r=o:s=o-1;return t[r]===i?r:e?r:-1},t.prototype.getExtendedPositions=function(t){void 0===t&&(t=!0);var o,r,s=this,n=s.axis,a=n.constructor.prototype,l=n.chart,h=null===(o=n.series[0])||void 0===o?void 0:o.currentDataGrouping,p=h?h.count+h.unitName:"raw",d=t?n.ordinal.convertOverscroll(n.options.overscroll):0,u=n.getExtremes(),c=void 0,f=s.index;return f||(f=s.index={}),f[p]||((r={series:[],chart:l,forceOrdinal:!1,getExtremes:function(){return{min:u.dataMin,max:u.dataMax+d}},applyGrouping:a.applyGrouping,getGroupPixelWidth:a.getGroupPixelWidth,getTimeTicks:a.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:a.ordinal2lin,getIndexOfPoint:a.getIndexOfPoint,val2lin:a.val2lin}).ordinal.axis=r,n.series.forEach(function(o){c={xAxis:r,xData:o.xData.slice(),chart:l,groupPixelWidth:o.groupPixelWidth,destroyGroupedData:i.noop,getProcessedData:e.prototype.getProcessedData,applyGrouping:e.prototype.applyGrouping,reserveSpace:e.prototype.reserveSpace,visible:o.visible},t&&(c.xData=c.xData.concat(s.getOverscrollPositions())),c.options={dataGrouping:h?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[h.unitName,[h.count]]]}:{enabled:!1}},r.series.push(c),o.processData.apply(c)}),r.applyGrouping({hasExtremesChanged:!0}),(null==c?void 0:c.closestPointRange)!==(null==c?void 0:c.basePointRange)&&c.currentDataGrouping&&(r.forceOrdinal=!0),n.ordinal.beforeSetTickPositions.apply({axis:r}),!n.ordinal.originalOrdinalRange&&r.ordinal.originalOrdinalRange&&(n.ordinal.originalOrdinalRange=r.ordinal.originalOrdinalRange),f[p]=r.ordinal.positions),f[p]},t.prototype.getGroupIntervalFactor=function(t,i,e){var o,r,s=e.processedXData,n=s.length,a=[],l=this.groupIntervalFactor;if(!l){for(r=0;r<n-1;r++)a[r]=s[r+1]-s[r];a.sort(function(t,i){return t-i}),o=a[Math.floor(n/2)],t=Math.max(t,s[0]),i=Math.min(i,s[n-1]),this.groupIntervalFactor=l=n*o/(i-t)}return l},t.prototype.getIndexOfPoint=function(i,e){var o,r=this.axis,s=0,a=function(t){var i=r.min,e=r.max;return!!(l(i)&&l(e))&&t.points.some(function(t){return t.x>=i&&t.x<=e})};r.series.forEach(function(t){var i,e=null===(i=t.points)||void 0===i?void 0:i[0];l(null==e?void 0:e.plotX)&&(e.plotX<o||!l(o))&&a(t)&&(o=e.plotX,s=e.x)}),null!=o||(o=r.minPixelPadding);var h=r.translationSlope*(this.slope||r.closestPointRange||this.overscrollPointsRange),p=n((i-o)/h);return t.findIndexOf(e,s,!0)+p},t.prototype.getOverscrollPositions=function(){var t=this.axis,i=this.convertOverscroll(t.options.overscroll),e=this.overscrollPointsRange,o=[],r=t.dataMax;if(l(e))for(;r<=t.dataMax+i;)o.push(r+=e);return o},t.prototype.postProcessTickInterval=function(t){var i=this.axis,e=this.slope;return e?i.options.breaks?i.closestPointRange||t:t/(e/i.closestPointRange):t},t.prototype.convertOverscroll=function(t){void 0===t&&(t=0);var i=this,e=i.axis,o=function(t){return d(i.originalOrdinalRange,l(e.dataMax)&&l(e.dataMin)?e.dataMax-e.dataMin:0)*t};if(c(t)){var r=parseInt(t,10);if(/%$/.test(t))return o(r/100);if(/px/.test(t)){var s=Math.min(r,.9*e.len)/e.len;return o(s/(1-s))}return 0}return t},t}();t.Additions=A}(r||(r={})),r}),e(i,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),e(i,"Stock/RangeSelector/RangeSelectorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=t.defaultOptions,n=i.composed,a=o.addEvent,l=o.defined,h=o.extend,p=o.find,d=o.isNumber,u=o.merge,c=o.pick,f=o.pushUnique,g=[];function v(){var t,i,e=this.range,o=e.type,r=this.max,s=this.chart.time,n=function(t,i){var e="year"===o?"FullYear":"Month",r=new s.Date(t),n=s.get(e,r);return s.set(e,r,n+i),n===s.get(e,r)&&s.set("Date",r,0),r.getTime()-t};d(e)?(t=r-e,i=e):e&&(t=r+n(r,-(e.count||1)),this.chart&&this.chart.setFixedRange(r-t));var a=c(this.dataMin,Number.MIN_VALUE);return d(t)||(t=a),t<=a&&(t=a,void 0===i&&(i=n(t,e.count)),this.newMax=Math.min(t+i,c(this.dataMax,Number.MAX_VALUE))),d(r)?!d(e)&&e&&e._offsetMin&&(t+=e._offsetMin):t=void 0,t}function x(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new r(this))}function m(){var t=this.axes,i=this.rangeSelector;if(i){d(i.deferredYTDClick)&&(i.clickButton(i.deferredYTDClick),delete i.deferredYTDClick),t.forEach(function(t){t.updateNames(),t.setScale()}),this.getAxisMargins(),i.render();var e=i.options.verticalAlign;i.options.floating||("bottom"===e?this.extraBottomMargin=!0:"middle"===e||(this.extraTopMargin=!0))}}function y(t){var i,e,o,r,s=t.rangeSelector,n=function(){s&&(i=t.xAxis[0].getExtremes(),e=t.legend,r=s&&s.options.verticalAlign,d(i.min)&&s.render(i.min,i.max),e.display&&"top"===r&&r===e.options.verticalAlign&&(o=u(t.spacingBox),"vertical"===e.options.layout?o.y=t.plotTop:o.y+=s.getHeight(),e.group.placed=!1,e.align(o)))};s&&(p(g,function(i){return i[0]===t})||g.push([t,[a(t.xAxis[0],"afterSetExtremes",function(t){s&&s.render(t.min,t.max)}),a(t,"redraw",n)]]),n())}function b(){for(var t=0,i=g.length;t<i;++t){var e=g[t];if(e[0]===this){e[1].forEach(function(t){return t()}),g.splice(t,1);return}}}function M(){var t=this.rangeSelector;if(t){var i=t.getHeight();this.extraTopMargin&&(this.plotTop+=i),this.extraBottomMargin&&(this.marginBottom+=i)}}function S(){var t=this.rangeSelector;if(t&&!t.options.floating){t.render();var i=t.options.verticalAlign;"bottom"===i?this.extraBottomMargin=!0:"middle"!==i&&(this.extraTopMargin=!0)}}function A(t){var i=t.options.rangeSelector,e=this.extraBottomMargin,o=this.extraTopMargin,s=this.rangeSelector;if(i&&i.enabled&&!l(s)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=s=new r(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,s){y(this);var n=i&&i.verticalAlign||s.options&&s.options.verticalAlign;s.options.floating||("bottom"===n?this.extraBottomMargin=!0:"middle"===n||(this.extraTopMargin=!0)),(this.extraBottomMargin!==e||this.extraTopMargin!==o)&&(this.isDirtyBox=!0)}}return{compose:function(t,i,o){if(r=o,f(n,"RangeSelector")){var l=i.prototype;t.prototype.minFromRange=v,a(i,"afterGetContainer",x),a(i,"beforeRender",m),a(i,"destroy",b),a(i,"getMargins",M),a(i,"render",S),a(i,"update",A),l.callbacks.push(y),h(s,{rangeSelector:e.rangeSelector}),h(s.lang,e.lang)}}}}),e(i,"Stock/RangeSelector/RangeSelector.js",[i["Core/Axis/Axis.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorComposition.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s){var n=i.defaultOptions,a=s.addEvent,l=s.createElement,h=s.css,p=s.defined,d=s.destroyObjectProperties,u=s.discardElement,c=s.extend,f=s.fireEvent,g=s.isNumber,v=s.merge,x=s.objectEach,m=s.pad,y=s.pick,b=s.pInt,M=s.splat,S=function(){function i(t){this.buttonOptions=i.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.chart=t,this.init(t)}return i.compose=function(t,e){o.compose(t,e,i)},i.prototype.clickButton=function(i,e){var o,r,s,n,l,h,d,u=this.chart,c=this.buttonOptions[i],v=u.xAxis[0],x=u.scroller&&u.scroller.getUnionExtremes()||v||{},m=c.type,b=c.dataGrouping,S=x.dataMin,A=x.dataMax,k=v&&Math.round(Math.min(v.max,y(A,v.max))),C=c._range,w=!0;if(null!==S&&null!==A){if(this.setSelected(i),b&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(v||{chart:this.chart},b,!1),this.frozenStates=c.preserveDataGrouping),"month"===m||"year"===m)v?(h={range:c,max:k,chart:u,dataMin:S,dataMax:A},o=v.minFromRange.call(h),g(h.newMax)&&(k=h.newMax),w=!1):C=c;else if(C)k=Math.min((o=Math.max(k-C,S))+C,A),w=!1;else if("ytd"===m){if(v)(void 0===A||void 0===S)&&(S=Number.MAX_VALUE,A=Number.MIN_VALUE,u.series.forEach(function(t){var i=t.xData;i&&(S=Math.min(i[0],S),A=Math.max(i[i.length-1],A))}),e=!1),o=s=(d=this.getYTDExtremes(A,S,u.time.useUTC)).min,k=d.max;else{this.deferredYTDClick=i;return}}else"all"===m&&v&&(u.navigator&&u.navigator.baseSeries[0]&&(u.navigator.baseSeries[0].xAxis.options.range=void 0),o=S,k=A);w&&c._offsetMin&&p(o)&&(o+=c._offsetMin),c._offsetMax&&p(k)&&(k+=c._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=i+1),v?(v.setExtremes(o,k,y(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:c}),u.setFixedRange(c._range)):(l=(r=M(u.options.xAxis)[0]).range,r.range=C,n=r.min,r.min=s,a(u,"load",function(){u.setFixedRange(c._range),r.range=l,r.min=n})),f(this,"afterBtnClick")}},i.prototype.setSelected=function(t){this.selected=this.options.selected=t},i.prototype.init=function(t){var i=this,e=t.options.rangeSelector,o=e.buttons||i.defaultButtons.slice(),r=e.selected,s=function(){var t=i.minInput,e=i.maxInput;t&&t.blur&&f(t,"blur"),e&&e.blur&&f(e,"blur")};i.chart=t,i.options=e,i.buttons=[],i.buttonOptions=o,this.eventsToUnbind=[],this.eventsToUnbind.push(a(t.container,"mousedown",s)),this.eventsToUnbind.push(a(t,"resize",s)),o.forEach(i.computeButtonRange),void 0!==r&&o[r]&&this.clickButton(r,!1),this.eventsToUnbind.push(a(t,"load",function(){t.xAxis&&t.xAxis[0]&&a(t.xAxis[0],"setExtremes",function(e){g(this.max)&&g(this.min)&&this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==e.trigger&&"updatedData"!==e.trigger&&i.forcedDataGrouping&&!i.frozenStates&&this.setDataGrouping(!1,!1)})}))},i.prototype.updateButtonStates=function(){var t=this,i=this.chart,e=this.dropdown,o=i.xAxis[0],r=Math.round(o.max-o.min),s=!o.hasVisibleSeries,n=24*36e5,a=i.scroller&&i.scroller.getUnionExtremes()||o,l=a.dataMin,h=a.dataMax,d=t.getYTDExtremes(h,l,i.time.useUTC),u=d.min,c=d.max,f=t.selected,v=t.options.allButtonsEnabled,x=t.buttons,m=g(f),y=!1;t.buttonOptions.forEach(function(i,a){var d,g=i._range,b=i.type,M=i.count||1,S=x[a],A=i._offsetMax-i._offsetMin,k=a===f,C=g>h-l,w=g<o.minRange,D=0,O=!1,E=!1,B=g===r;if(k&&C&&(y=!0),o.isOrdinal&&(null===(d=o.ordinal)||void 0===d?void 0:d.positions)&&g&&r<g){var P=o.ordinal.positions;P[P.length-1]-P[0]>g&&(B=!0)}else("month"===b||"year"===b)&&r+36e5>=({month:28,year:365})[b]*n*M-A&&r-36e5<=({month:31,year:366})[b]*n*M+A?B=!0:"ytd"===b?(B=c-u+A===r,O=!k):"all"===b&&(B=o.max-o.min>=h-l,E=!k&&m&&B);var T=!v&&!(y&&"all"===b)&&(C||w||E||s),j=y&&"all"===b||k&&B||B&&!m&&!O||k&&t.frozenStates;T?D=3:j&&(m=!0,D=2),S.state!==D&&(S.setState(D),e&&(e.options[a+1].disabled=T,2===D&&(e.selectedIndex=a+1)),0===D&&f===a?t.setSelected():(2===D&&!p(f)||y)&&t.setSelected(a))})},i.prototype.computeButtonRange=function(t){var i=t.type,e=t.count||1,o={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};o[i]?t._range=o[i]*e:("month"===i||"year"===i)&&(t._range=24*({month:30,year:365})[i]*36e5*e),t._offsetMin=y(t.offsetMin,0),t._offsetMax=y(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin},i.prototype.getInputValue=function(t){var i="min"===t?this.minInput:this.maxInput,e=this.chart.options.rangeSelector,o=this.chart.time;return i?("text"===i.type&&e.inputDateParser||this.defaultInputDateParser)(i.value,o.useUTC,o):0},i.prototype.setInputValue=function(t,i){var e=this.options,o=this.chart.time,r="min"===t?this.minInput:this.maxInput,s="min"===t?this.minDateBox:this.maxDateBox;if(r){var n=r.getAttribute("data-hc-time"),a=p(n)?Number(n):void 0;if(p(i)){var l=a;p(l)&&r.setAttribute("data-hc-time-previous",l),r.setAttribute("data-hc-time",i),a=i}r.value=o.dateFormat(this.inputTypeFormats[r.type]||e.inputEditDateFormat,a),s&&s.attr({text:o.dateFormat(e.inputDateFormat,a)})}},i.prototype.setInputExtremes=function(t,i,e){var o="min"===t?this.minInput:this.maxInput;if(o){var r=this.inputTypeFormats[o.type],s=this.chart.time;if(r){var n=s.dateFormat(r,i);o.min!==n&&(o.min=n);var a=s.dateFormat(r,e);o.max!==a&&(o.max=a)}}},i.prototype.showInput=function(t){var i="min"===t?this.minDateBox:this.maxDateBox,e="min"===t?this.minInput:this.maxInput;if(e&&i&&this.inputGroup){var o="text"===e.type,r=this.inputGroup,s=r.translateX,n=void 0===s?0:s,a=r.translateY,l=void 0===a?0:a,p=i.x,d=void 0===p?0:p,u=i.width,c=void 0===u?0:u,f=i.height,g=void 0===f?0:f,v=this.options.inputBoxWidth;h(e,{width:o?c+(v?-2:20)+"px":"auto",height:g-2+"px",border:"2px solid silver"}),o&&v?h(e,{left:n+d+"px",top:l+"px"}):h(e,{left:Math.min(Math.round(d+n-(e.offsetWidth-c)/2),this.chart.chartWidth-e.offsetWidth)+"px",top:l-(e.offsetHeight-g)/2+"px"})}},i.prototype.hideInput=function(t){var i="min"===t?this.minInput:this.maxInput;i&&h(i,{top:"-9999em",border:0,width:"1px",height:"1px"})},i.prototype.defaultInputDateParser=function(t,i,o){var r,s=t.split("/").join("-").split(" ").join("T");if(-1===s.indexOf("T")&&(s+="T00:00"),i)s+="Z";else if(e.isSafari&&!((r=s).length>6&&(r.lastIndexOf("-")===r.length-6||r.lastIndexOf("+")===r.length-6))){var n=new Date(s).getTimezoneOffset()/60;s+=n<=0?"+".concat(m(-n),":00"):"-".concat(m(n),":00")}var a=Date.parse(s);if(!g(a)){var l=t.split("-");a=Date.UTC(b(l[0]),b(l[1])-1,b(l[2]))}return o&&i&&g(a)&&(a+=o.getTimezoneOffset(a)),a},i.prototype.drawInput=function(t){var i=this.chart,o=this.div,r=this.inputGroup,s=this,a=i.renderer.style||{},p=i.renderer,d=i.options.rangeSelector,u=n.lang,f="min"===t;function x(){var e=s.maxInput,o=s.minInput,r=i.xAxis[0],n=i.scroller&&i.scroller.getUnionExtremes()||r,a=n.dataMin,l=n.dataMax,h=s.getInputValue(t);h!==Number(M.getAttribute("data-hc-time-previous"))&&g(h)&&(M.setAttribute("data-hc-time-previous",h),f&&e&&g(a)?h>Number(e.getAttribute("data-hc-time"))?h=void 0:h<a&&(h=a):o&&g(l)&&(h<Number(o.getAttribute("data-hc-time"))?h=void 0:h>l&&(h=l)),void 0!==h&&r.setExtremes(f?h:r.min,f?r.max:h,void 0,void 0,{trigger:"rangeSelectorInput"}))}var m=u[f?"rangeSelectorFrom":"rangeSelectorTo"]||"",y=p.label(m,0).addClass("highcharts-range-label").attr({padding:m?2:0,height:m?d.inputBoxHeight:0}).add(r),b=p.label("",0).addClass("highcharts-range-input").attr({padding:2,width:d.inputBoxWidth,height:d.inputBoxHeight,"text-align":"center"}).on("click",function(){s.showInput(t),s[t+"Input"].focus()});i.styledMode||b.attr({stroke:d.inputBoxBorderColor,"stroke-width":1}),b.add(r);var M=l("input",{name:t,className:"highcharts-range-selector"},void 0,o);M.setAttribute("type",function(t){if(-1!==t.indexOf("%L"))return"text";var i=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(i){return -1!==t.indexOf("%"+i)}),e=["H","k","I","l","M","S"].some(function(i){return -1!==t.indexOf("%"+i)});return i&&e?"datetime-local":i?"date":e?"time":"text"}(d.inputDateFormat||"%e %b %Y")),i.styledMode||(y.css(v(a,d.labelStyle)),b.css(v({color:"#333333"},a,d.inputStyle)),h(M,c({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:a.fontSize,fontFamily:a.fontFamily,top:"-9999em"},d.inputStyle))),M.onfocus=function(){s.showInput(t)},M.onblur=function(){M===e.doc.activeElement&&x(),s.hideInput(t),s.setInputValue(t),M.blur()};var S=!1;return M.onchange=function(){S||(x(),s.hideInput(t),M.blur())},M.onkeypress=function(t){13===t.keyCode&&x()},M.onkeydown=function(t){S=!0,(38===t.keyCode||40===t.keyCode)&&x()},M.onkeyup=function(){S=!1},{dateBox:b,input:M,label:y}},i.prototype.getPosition=function(){var t=this.chart,i=t.options.rangeSelector,e="top"===i.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:e+i.buttonPosition.y,inputTop:e+i.inputPosition.y-10}},i.prototype.getYTDExtremes=function(t,i,e){var o=this.chart.time,r=new o.Date(t),s=o.get("FullYear",r),n=e?o.Date.UTC(s,0,1):+new o.Date(s,0,1),a=r.getTime();return{max:Math.min(t||a,a),min:Math.max(i,n)}},i.prototype.render=function(t,i){var e=this.chart,o=e.renderer,r=e.container,s=e.options,n=s.rangeSelector,a=y(s.chart.style&&s.chart.style.zIndex,0)+1,h=n.inputEnabled,d=this.rendered;if(!1!==n.enabled){if(!d&&(this.group=o.g("range-selector-group").attr({zIndex:7}).add(),this.div=l("div",void 0,{position:"relative",height:0,zIndex:a}),this.buttonOptions.length&&this.renderButtons(),r.parentNode&&r.parentNode.insertBefore(this.div,r),h)){this.inputGroup=o.g("input-group").add(this.group);var u=this.drawInput("min");this.minDateBox=u.dateBox,this.minLabel=u.label,this.minInput=u.input;var c=this.drawInput("max");this.maxDateBox=c.dateBox,this.maxLabel=c.label,this.maxInput=c.input}if(h){this.setInputValue("min",t),this.setInputValue("max",i);var f=e.scroller&&e.scroller.getUnionExtremes()||e.xAxis[0]||{};if(p(f.dataMin)&&p(f.dataMax)){var g=e.xAxis[0].minRange||0;this.setInputExtremes("min",f.dataMin,Math.min(f.dataMax,this.getInputValue("max"))-g),this.setInputExtremes("max",Math.max(f.dataMin,this.getInputValue("min"))+g,f.dataMax)}if(this.inputGroup){var v=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(t){if(t){var i=t.getBBox().width;i&&(t.attr({x:v}),v+=i+n.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},i.prototype.renderButtons=function(){var t=this,i=this.buttons,o=this.chart,r=this.options,s=n.lang,h=o.renderer,p=v(r.buttonTheme),d=p&&p.states,u=p.width||28;delete p.width,delete p.states,this.buttonGroup=h.g("range-selector-buttons").add(this.group);var c=this.dropdown=l("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);a(c,"touchstart",function(){c.style.fontSize="16px"}),[[e.isMS?"mouseover":"mouseenter"],[e.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(e){var o=e[0],r=e[1];a(c,o,function(){var e=i[t.currentButtonIndex()];e&&f(e.element,r||o)})}),this.zoomText=h.label(s&&s.rangeSelectorZoom||"",0).attr({padding:r.buttonTheme.padding,height:r.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(r.labelStyle),p["stroke-width"]=y(p["stroke-width"],0)),l("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,c),this.buttonOptions.forEach(function(e,o){l("option",{textContent:e.title||e.text},void 0,c),i[o]=h.button(e.text,0,0,function(i){var r,s=e.events&&e.events.click;s&&(r=s.call(e,i)),!1!==r&&t.clickButton(o),t.isActive=!0},p,d&&d.hover,d&&d.select,d&&d.disabled).attr({"text-align":"center",width:u}).add(t.buttonGroup),e.title&&i[o].attr("title",e.title)})},i.prototype.alignElements=function(){var t=this,i=this.buttonGroup,e=this.buttons,o=this.chart,r=this.group,s=this.inputGroup,n=this.options,a=this.zoomText,l=o.options,h=l.exporting&&!1!==l.exporting.enabled&&l.navigation&&l.navigation.buttonOptions,p=n.buttonPosition,d=n.inputPosition,u=n.verticalAlign,c=function(i,e){return h&&t.titleCollision(o)&&"top"===u&&"right"===e.align&&e.y-i.getBBox().height-12<(h.y||0)+(h.height||0)+o.spacing[0]?-40:0},f=o.plotLeft;if(r&&p&&d){var g=p.x-o.spacing[3];if(i){if(this.positionButtons(),!this.initialButtonGroupWidth){var v=0;a&&(v+=a.getBBox().width+5),e.forEach(function(t,i){v+=t.width||0,i!==e.length-1&&(v+=n.buttonSpacing)}),this.initialButtonGroupWidth=v}f-=o.spacing[3],this.updateButtonStates();var x=c(i,p);this.alignButtonGroup(x),r.placed=i.placed=o.hasLoaded}var m=0;s&&(m=c(s,d),"left"===d.align?g=f:"right"===d.align&&(g=-Math.max(o.axisOffset[1],-m)),s.align({y:d.y,width:s.getBBox().width,align:d.align,x:d.x+g-2},!0,o.spacingBox),s.placed=o.hasLoaded),this.handleCollision(m),r.align({verticalAlign:u},!0,o.spacingBox);var b=r.alignAttr.translateY,M=r.getBBox().height+20,S=0;if("bottom"===u){var A=o.legend&&o.legend.options;S=b-(M=M+(A&&"bottom"===A.verticalAlign&&A.enabled&&!A.floating?o.legend.legendHeight+y(A.margin,10):0)-20)-(n.floating?0:n.y)-(o.titleOffset?o.titleOffset[2]:0)-10}"top"===u?(n.floating&&(S=0),o.titleOffset&&o.titleOffset[0]&&(S=o.titleOffset[0]),S+=o.margin[0]-o.spacing[0]||0):"middle"===u&&(d.y===p.y?S=b:(d.y||p.y)&&(d.y<0||p.y<0?S-=Math.min(d.y,p.y):S=b-M)),r.translate(n.x,n.y+Math.floor(S));var k=this.minInput,C=this.maxInput,w=this.dropdown;n.inputEnabled&&k&&C&&(k.style.marginTop=r.translateY+"px",C.style.marginTop=r.translateY+"px"),w&&(w.style.marginTop=r.translateY+"px")}},i.prototype.alignButtonGroup=function(t,i){var e=this.chart,o=this.options,r=this.buttonGroup,s=o.buttonPosition,n=e.plotLeft-e.spacing[3],a=s.x-e.spacing[3];"right"===s.align?a+=t-n:"center"===s.align&&(a-=n/2),r&&r.align({y:s.y,width:y(i,this.initialButtonGroupWidth),align:s.align,x:a},!0,e.spacingBox)},i.prototype.positionButtons=function(){var t=this.buttons,i=this.chart,e=this.options,o=this.zoomText,r=i.hasLoaded?"animate":"attr",s=e.buttonPosition,n=i.plotLeft,a=n;o&&"hidden"!==o.visibility&&(o[r]({x:y(n+s.x,n)}),a+=s.x+o.getBBox().width+5);for(var l=0,h=this.buttonOptions.length;l<h;++l)"hidden"!==t[l].visibility?(t[l][r]({x:a}),a+=(t[l].width||0)+e.buttonSpacing):t[l][r]({x:n})},i.prototype.handleCollision=function(t){var i=this,e=this.chart,o=this.buttonGroup,r=this.inputGroup,s=this.options,n=s.buttonPosition,a=s.dropdown,l=s.inputPosition,h=function(){var t=0;return i.buttons.forEach(function(i){var e=i.getBBox();e.width>t&&(t=e.width)}),t},p=function(i){if(r&&o){var e=r.alignAttr.translateX+r.alignOptions.x-t+r.getBBox().x+2,s=r.alignOptions.width,a=o.alignAttr.translateX+o.getBBox().x;return a+i>e&&e+s>a&&n.y<l.y+r.getBBox().height}return!1},d=function(){r&&o&&r.attr({translateX:r.alignAttr.translateX+(e.axisOffset[1]>=-t?0:-t),translateY:r.alignAttr.translateY+o.getBBox().height+10})};if(o){if("always"===a){this.collapseButtons(t),p(h())&&d();return}"never"===a&&this.expandButtons()}r&&o?l.align===n.align||p(this.initialButtonGroupWidth+20)?"responsive"===a?(this.collapseButtons(t),p(h())&&d()):d():"responsive"===a&&this.expandButtons():o&&"responsive"===a&&(this.initialButtonGroupWidth>e.plotWidth?this.collapseButtons(t):this.expandButtons())},i.prototype.collapseButtons=function(t){var i=this.buttons,e=this.buttonOptions,o=this.chart,r=this.dropdown,s=this.options,n=this.zoomText;if(!0!==this.isCollapsed){this.isCollapsed=!0;var a=o.userOptions.rangeSelector&&o.userOptions.rangeSelector.buttonTheme||{},l=function(t){return{text:t?"".concat(t," ▾"):"▾",width:"auto",paddingLeft:y(s.buttonTheme.paddingLeft,a.padding,8),paddingRight:y(s.buttonTheme.paddingRight,a.padding,8)}};n&&n.hide();var h=!1;e.forEach(function(t,e){var o=i[e];2!==o.state?o.hide():(o.show(),o.attr(l(t.text)),h=!0)}),h||(r&&(r.selectedIndex=0),i[0].show(),i[0].attr(l(this.zoomText&&this.zoomText.textStr)));var p=s.buttonPosition.align;this.positionButtons(),("right"===p||"center"===p)&&this.alignButtonGroup(t,i[this.currentButtonIndex()].getBBox().width),this.showDropdown()}},i.prototype.expandButtons=function(){var t=this.buttons,i=this.buttonOptions,e=this.options,o=this.zoomText;this.hideDropdown(),!1!==this.isCollapsed&&(this.isCollapsed=!1,o&&o.show(),i.forEach(function(i,o){var r=t[o];r.show(),r.attr({text:i.text,width:e.buttonTheme.width||28,paddingLeft:y(e.buttonTheme.paddingLeft,"unset"),paddingRight:y(e.buttonTheme.paddingRight,"unset")}),r.state<2&&r.setState(0)}),this.positionButtons())},i.prototype.currentButtonIndex=function(){var t=this.dropdown;return t&&t.selectedIndex>0?t.selectedIndex-1:0},i.prototype.showDropdown=function(){var t=this.buttonGroup,i=this.buttons,e=this.chart,o=this.dropdown;if(t&&o){var r=t.translateX,s=t.translateY,n=i[this.currentButtonIndex()].getBBox();h(o,{left:e.plotLeft+(void 0===r?0:r)+"px",top:(void 0===s?0:s)+.5+"px",width:n.width+"px",height:n.height+"px"}),this.hasVisibleDropdown=!0}},i.prototype.hideDropdown=function(){var t=this.dropdown;t&&(h(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},i.prototype.getHeight=function(){var t=this.options,i=this.group,e=t.inputPosition,o=t.buttonPosition,r=t.y,s=o.y,n=e.y,a=0;return t.height?t.height:(this.alignElements(),a=i?i.getBBox(!0).height+13+r:0,(n<0&&s<0||n>0&&s>0)&&(a+=Math.abs(Math.min(n,s))),a)},i.prototype.titleCollision=function(t){return!(t.options.title.text||t.options.subtitle.text)},i.prototype.update=function(t){var i=this.chart;v(!0,i.options.rangeSelector,t),this.destroy(),this.init(i),this.render()},i.prototype.destroy=function(){var t=this,e=t.minInput,o=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(function(t){return t()}),t.eventsToUnbind=void 0),d(t.buttons),e&&(e.onfocus=e.onblur=e.onchange=null),o&&(o.onfocus=o.onblur=o.onchange=null),x(t,function(e,o){e&&"chart"!==o&&(e instanceof r?e.destroy():e instanceof window.HTMLElement&&u(e)),e!==i.prototype[o]&&(t[o]=null)},this)},i}();return c(S.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),S}),e(i,"Core/Chart/StockChart.js",[i["Core/Chart/Chart.js"],i["Core/Templating.js"],i["Core/Defaults.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Stock/Utilities/StockUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a){var l,h=this&&this.__extends||(l=function(t,i){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}l(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),p=i.format,d=e.getOptions,u=n.setFixedRange,c=a.addEvent,f=a.clamp,g=a.defined,v=a.extend,x=a.find,m=a.isNumber,y=a.isString,b=a.merge,M=a.pick,S=a.splat;function A(t,i,e){var o,r,s,n;return"xAxis"===t?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0}:"yAxis"===t?{labels:{y:-2},opposite:null===(r=null!==(o=e.opposite)&&void 0!==o?o:i.opposite)||void 0===r||r,showLastLabel:!!(i.categories||"category"===i.type),title:{text:(null===(s=e.title)||void 0===s?void 0:s.text)!=="Values"?null===(n=e.title)||void 0===n?void 0:n.text:null}}:{}}function k(t,i){if("xAxis"===t){var e=M(i.navigator&&i.navigator.enabled,o.enabled,!0),r={type:"datetime",categories:void 0};return e&&(r.startOnTick=!1,r.endOnTick=!1),r}return{}}var C=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return h(i,t),i.prototype.init=function(i,e){var n=d(),a=i.xAxis,l=i.yAxis,h=M(i.navigator&&i.navigator.enabled,o.enabled,!0);i.xAxis=i.yAxis=void 0;var p=b({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x",mouseWheel:{type:"x"}}},navigator:{enabled:h},scrollbar:{enabled:M(s.enabled,!0)},rangeSelector:{enabled:M(r.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:M(n.tooltip&&n.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},i,{isStock:!0});i.xAxis=a,i.yAxis=l,p.xAxis=S(i.xAxis||{}).map(function(t){return b(A("xAxis",t,n.xAxis),t,k("xAxis",i))}),p.yAxis=S(i.yAxis||{}).map(function(t){return b(A("yAxis",t,n.yAxis),t)}),t.prototype.init.call(this,p,e)},i.prototype.createAxis=function(i,e){return e.axis=b(A(i,e.axis,d()[i]),e.axis,k(i,this.userOptions)),t.prototype.createAxis.call(this,i,e)},i}(t);return c(t,"update",function(t){var i=t.options;"scrollbar"in i&&this.navigator&&(b(!0,this.options.scrollbar,i.scrollbar),this.navigator.update({}),delete i.scrollbar)}),function(t){function i(t){if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&m(this.min)&&m(this.max)){var i,e,o,r=this.chart,s=this.logarithmic,n=this.crosshair.label,a=this.horiz,l=this.opposite,h=this.left,d=this.top,u=this.width,c="inside"===this.options.tickPosition,f=!1!==this.crosshair.snap,g=t.e||this.cross&&this.cross.e,x=t.point,y=this.crossLabel,b=n.format,S="",A=0,k=this.min,C=this.max;s&&(k=s.lin2log(this.min),C=s.lin2log(this.max));var w=a?"center":l?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";y||(y=this.crossLabel=r.renderer.label("",0,void 0,n.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(x&&x.series?x.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:n.align||w,padding:M(n.padding,8),r:M(n.borderRadius,3),zIndex:2}).add(this.labelGroup),r.styledMode||y.attr({fill:n.backgroundColor||x&&x.series&&x.series.color||"#666666",stroke:n.borderColor||"","stroke-width":n.borderWidth||0}).css(v({color:"#ffffff",fontWeight:"normal",fontSize:"0.7em",textAlign:"center"},n.style||{}))),a?(i=f?(x.plotX||0)+h:g.chartX,e=d+(l?0:this.height)):(i=h+this.offset+(l?u:0),e=f?(x.plotY||0)+d:g.chartY),b||n.formatter||(this.dateTime&&(S="%b %d, %Y"),b="{value"+(S?":"+S:"")+"}");var D=f?this.isXAxis?x.x:x.y:this.toValue(a?g.chartX:g.chartY),O=x&&x.series?x.series.isPointInside(x):m(D)&&D>k&&D<C,E="";b?E=p(b,{value:D},r):n.formatter&&m(D)&&(E=n.formatter.call(this,D)),y.attr({text:E,x:i,y:e,visibility:O?"inherit":"hidden"});var B=y.getBBox();!m(y.x)||a||l||(i=y.x-B.width/2),m(y.y)&&(a?(c&&!l||!c&&l)&&(e=y.y-B.height):e=y.y-B.height/2),o=a?{left:h-B.x,right:h+this.width-B.x}:{left:"left"===this.labelAlign?h:0,right:"right"===this.labelAlign?h+this.width:r.chartWidth};var P=y.translateX||0;P<o.left&&(A=o.left-P),P+B.width>=o.right&&(A=-(P+B.width-o.right)),y.attr({x:i+A,y:e,anchorX:a?i:this.opposite?0:r.chartWidth,anchorY:a?this.opposite?r.chartHeight:0:e+B.height/2})}}function e(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())}function o(t){var i=this.chart,e=this.options,o=i._labelPanes=i._labelPanes||{},r=e.labels;if(i.options.isStock&&"yAxis"===this.coll){var s=e.top+","+e.height;!o[s]&&r.enabled&&(15===r.distance&&1===this.side&&(r.distance=0),void 0===r.align&&(r.align="right"),o[s]=this,t.align="right",t.preventDefault())}}function r(){var t=this.chart,i=this.options&&this.options.top+","+this.options.height;i&&t._labelPanes&&t._labelPanes[i]===this&&delete t._labelPanes[i]}function s(t){var i,e,o,r,s,n,a,l=this.isLinked&&!this.series&&this.linkedParent?this.linkedParent.series:this.series,h=this.chart,p=h.renderer,d=this.left,u=this.top,c=[],v=t.translatedValue,b=t.value,S=t.force,A=[];if(h.options.isStock&&!1!==t.acrossPanes&&"xAxis"===this.coll||"yAxis"===this.coll){t.preventDefault(),k="xAxis"===this.coll?"yAxis":"xAxis",A=m(C=this.options[k])?[h[k][C]]:y(C)?[h.get(C)]:l.map(function(t){return t[k]}),s=this.isXAxis?h.yAxis:h.xAxis;for(var k,C,w=0;w<s.length;w++){var D=s[w];if(!g(D.options.id)||-1===D.options.id.indexOf("navigator")){var O=D.isXAxis?"yAxis":"xAxis";this===(g(D.options[O])?h[O][D.options[O]]:h[O][0])&&A.push(D)}}n=A.length?[]:[this.isXAxis?h.yAxis[0]:h.xAxis[0]];for(var E=function(t){-1!==n.indexOf(t)||x(n,function(i){return i.pos===t.pos&&i.len===t.len})||n.push(t)},B=0,P=A;B<P.length;B++){var T=P[B];E(T)}if(m(a=M(v,this.translate(b||0,void 0,void 0,t.old)))){if(this.horiz)for(var j=0;j<n.length;j++){var T=n[j],G=void 0;r=(e=T.pos)+T.len,i=o=Math.round(a+this.transB),"pass"!==S&&(i<d||i>d+this.width)&&(S?i=o=f(i,d,d+this.width):G=!0),G||c.push(["M",i,e],["L",o,r])}else for(var R=0;R<n.length;R++){var T=n[R],G=void 0;o=(i=T.pos)+T.len,e=r=Math.round(u+this.height-a),"pass"!==S&&(e<u||e>u+this.height)&&(S?e=r=f(e,u,u+this.height):G=!0),G||c.push(["M",i,e],["L",o,r])}}t.path=c.length>0?p.crispPolyLine(c,t.lineWidth||1):void 0}}function n(t){if(this.chart.options.isStock){var i=void 0;this.is("column")||this.is("columnrange")?i={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(i={marker:{enabled:!1,radius:2}}),i&&(t.plotOptions[this.type]=b(t.plotOptions[this.type],i))}}function a(){var t=this.chart,i=this.options.dataGrouping;return!1!==this.allowDG&&i&&M(i.enabled,t.options.isStock)}function l(t,i){for(var e=0;e<t.length;e+=2){var o=t[e],r=t[e+1];o[1]===r[1]&&(o[1]=r[1]=Math.round(o[1])-i%2/2),o[2]===r[2]&&(o[2]=r[2]=Math.round(o[2])+i%2/2)}return t}t.compose=function(t,h,p,d){var f=p.prototype;f.forceCropping||(c(h,"afterDrawCrosshair",i),c(h,"afterHideCrosshair",e),c(h,"autoLabelAlign",o),c(h,"destroy",r),c(h,"getPlotLinePath",s),t.prototype.setFixedRange=u,f.forceCropping=a,c(p,"setOptions",n),d.prototype.crispPolyLine=l)},t.stockChart=function(i,e,o){return new t(i,e,o)}}(C||(C={})),C}),e(i,"Series/HLC/HLCPoint.js",[i["Core/Series/SeriesRegistry.js"]],function(t){var i,e=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)});return function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return e(i,t),i}(t.seriesTypes.column.prototype.pointClass)}),e(i,"Series/HLC/HLCSeriesDefaults.js",[],function(){return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}}),e(i,"Series/HLC/HLCSeries.js",[i["Series/HLC/HLCPoint.js"],i["Series/HLC/HLCSeriesDefaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=this&&this.__extends||(r=function(t,i){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}r(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),n=e.seriesTypes.column,a=o.extend,l=o.merge,h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s(e,t),e.prototype.extendStem=function(t,i,e){var o=t[0],r=t[1];"number"==typeof o[2]&&(o[2]=Math.max(e+i,o[2])),"number"==typeof r[2]&&(r[2]=Math.min(e-i,r[2]))},e.prototype.getPointPath=function(t,i){var e=i.strokeWidth(),o=t.series,r=e%2/2,s=Math.round(t.plotX)-r,n=Math.round(t.shapeArgs.width/2),a=t.plotClose,l=[["M",s,Math.round(t.yBottom)],["L",s,Math.round(t.plotHigh)]];return null!==t.close&&(a=Math.round(t.plotClose)+r,l.push(["M",s,a],["L",s+n,a]),o.extendStem(l,e/2,a)),l},e.prototype.drawSinglePoint=function(t){var i,e=t.series,o=e.chart,r=t.graphic;void 0!==t.plotY&&(r||(t.graphic=r=o.renderer.path().add(e.group)),o.styledMode||r.attr(e.pointAttribs(t,t.selected&&"select")),i=e.getPointPath(t,r),r[r?"animate":"attr"]({d:i}).addClass(t.getClassName(),!0))},e.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)},e.prototype.init=function(){t.prototype.init.apply(this,arguments),this.options.stacking=void 0},e.prototype.pointAttribs=function(i,e){var o=t.prototype.pointAttribs.call(this,i,e);return delete o.fill,o},e.prototype.toYData=function(t){return[t.high,t.low,t.close]},e.prototype.translate=function(){var i=this,e=i.yAxis,o=this.pointArrayMap&&this.pointArrayMap.slice()||[],r=o.map(function(t){return"plot".concat(t.charAt(0).toUpperCase()+t.slice(1))});r.push("yBottom"),o.push("low"),t.prototype.translate.apply(i),i.points.forEach(function(t){o.forEach(function(o,s){var n=t[o];null!==n&&(i.dataModify&&(n=i.dataModify.modifyValue(n)),t[r[s]]=e.toPixels(n,!0))}),t.tooltipPos[1]=t.plotHigh+e.pos-i.chart.plotTop})},e.defaultOptions=l(n.defaultOptions,i),e}(n);return a(h.prototype,{pointClass:t,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"}),e.registerSeriesType("hlc",h),h}),e(i,"Series/OHLC/OHLCPoint.js",[i["Core/Series/SeriesRegistry.js"]],function(t){var i,e=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)});return function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return e(i,t),i.prototype.getClassName=function(){return t.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},i.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},i.prototype.resolveColor=function(){t.prototype.resolveColor.call(this),this.series.is("heikinashi")||this.resolveUpColor()},i.prototype.getZone=function(){var i=t.prototype.getZone.call(this);return this.resolveUpColor(),i},i.prototype.applyOptions=function(){return t.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},i}(t.seriesTypes.hlc.prototype.pointClass)}),e(i,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){return{tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}}),e(i,"Series/OHLC/OHLCSeries.js",[i["Core/Globals.js"],i["Series/OHLC/OHLCPoint.js"],i["Series/OHLC/OHLCSeriesDefaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var s,n=this&&this.__extends||(s=function(t,i){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}s(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),a=t.composed,l=o.seriesTypes.hlc,h=r.addEvent,p=r.extend,d=r.merge,u=r.pushUnique;function c(t){var i=t.options,e=i.dataGrouping;e&&i.useOhlcData&&"highcharts-navigator-series"!==i.id&&(e.approximation="ohlc")}function f(t){var i=t.options;i.useOhlcData&&"highcharts-navigator-series"!==i.id&&p(this,{pointValKey:g.prototype.pointValKey,pointArrayMap:g.prototype.pointArrayMap,toYData:g.prototype.toYData})}var g=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n(i,t),i.compose=function(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];u(a,"OHLCSeries")&&(h(t,"afterSetOptions",c),h(t,"init",f))},i.prototype.getPointPath=function(i,e){var o=t.prototype.getPointPath.call(this,i,e),r=e.strokeWidth(),s=r%2/2,n=Math.round(i.plotX)-s,a=Math.round(i.shapeArgs.width/2),l=i.plotOpen;return null!==i.open&&(l=Math.round(i.plotOpen)+s,o.push(["M",n,l],["L",n-a,l]),t.prototype.extendStem.call(this,o,r/2,l)),o},i.prototype.pointAttribs=function(i,e){var o=t.prototype.pointAttribs.call(this,i,e),r=this.options;return delete o.fill,!i.options.color&&r.upColor&&i.open<i.close&&(o.stroke=r.upColor),o},i.prototype.toYData=function(t){return[t.open,t.high,t.low,t.close]},i.defaultOptions=d(l.defaultOptions,e),i}(l);return p(g.prototype,{pointClass:i,pointArrayMap:["open","high","low","close"]}),o.registerSeriesType("ohlc",g),g}),e(i,"Series/Candlestick/CandlestickSeriesDefaults.js",[],function(){return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}}),e(i,"Series/Candlestick/CandlestickSeries.js",[i["Series/Candlestick/CandlestickSeriesDefaults.js"],i["Core/Defaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=this&&this.__extends||(r=function(t,i){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}r(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),n=i.defaultOptions,a=e.seriesTypes,l=a.column,h=a.ohlc,p=o.merge,d=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return s(e,i),e.prototype.pointAttribs=function(t,i){var e=l.prototype.pointAttribs.call(this,t,i),o=this.options,r=t.open<t.close,s=o.lineColor||this.color,n=t.color||this.color;if(e["stroke-width"]=o.lineWidth,e.fill=t.options.color||r&&o.upColor||n,e.stroke=t.options.lineColor||r&&o.upLineColor||s,i){var a=o.states[i];e.fill=a.color||e.fill,e.stroke=a.lineColor||e.stroke,e["stroke-width"]=a.lineWidth||e["stroke-width"]}return e},e.prototype.drawPoints=function(){for(var t=this.points,i=this.chart,e=this.yAxis.reversed,o=0;o<t.length;o++){var r=t[o],s=r.graphic,n=void 0,a=void 0,l=void 0,h=void 0,p=void 0,d=void 0,u=void 0,c=void 0,f=void 0,g=void 0,v=!s;void 0!==r.plotY&&(s||(r.graphic=s=i.renderer.path().add(this.group)),this.chart.styledMode||s.attr(this.pointAttribs(r,r.selected&&"select")).shadow(this.options.shadow),u=s.strokeWidth()%2/2,c=Math.round(r.plotX)-u,l=Math.min(n=r.plotOpen,a=r.plotClose),h=Math.max(n,a),g=Math.round(r.shapeArgs.width/2),p=e?h!==r.yBottom:Math.round(l)!==Math.round(r.plotHigh),d=e?Math.round(l)!==Math.round(r.plotHigh):h!==r.yBottom,l=Math.round(l)+u,h=Math.round(h)+u,(f=[]).push(["M",c-g,h],["L",c-g,l],["L",c+g,l],["L",c+g,h],["Z"],["M",c,l],["L",c,p?Math.round(e?r.yBottom:r.plotHigh):l],["M",c,h],["L",c,d?Math.round(e?r.plotHigh:r.yBottom):h]),s[v?"attr":"animate"]({d:f}).addClass(r.getClassName(),!0))}},e.defaultOptions=p(h.defaultOptions,n.plotOptions,{tooltip:h.defaultOptions.tooltip},t),e}(h);return e.registerSeriesType("candlestick",d),d}),e(i,"Series/Flags/FlagsPoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)}),r=t.seriesTypes.column.prototype.pointClass,s=i.isNumber;return function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.ttBelow=!1,i}return o(i,t),i.prototype.isValid=function(){return s(this.y)||void 0===this.y},i.prototype.hasNewShapeType=function(){var t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey},i}(r)}),e(i,"Series/Flags/FlagsSeriesDefaults.js",[],function(){return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd3ff"}},style:{fontSize:"0.7em",fontWeight:"bold"}}}),e(i,"Series/Flags/FlagsSymbols.js",[i["Core/Renderer/RendererRegistry.js"]],function(t){var i;return function(i){var e=[];function o(t,i,e,o,r){var s=r&&r.anchorX||t,n=r&&r.anchorY||i,a=this.circle(s-1,n-1,2,2);return a.push(["M",s,n],["L",t,i+o],["L",t,i],["L",t+e,i],["L",t+e,i+o],["L",t,i+o],["Z"]),a}function r(t,i){t[i+"pin"]=function(e,o,r,s,n){var a,l=n&&n.anchorX,h=n&&n.anchorY;if("circle"===i&&s>r&&(e-=Math.round((s-r)/2),r=s),a=t[i](e,o,r,s),l&&h){var p=l;if("circle"===i)p=e+r/2;else{var d=a[0],u=a[1];"M"===d[0]&&"L"===u[0]&&(p=(d[1]+u[1])/2)}var c=o>h?o:o+s;a.push(["M",p,c],["L",l,h]),a=a.concat(t.circle(l-1,h-1,2,2))}return a}}i.compose=function(i){if(-1===e.indexOf(i)){e.push(i);var s=i.prototype.symbols;s.flag=o,r(s,"circle"),r(s,"square")}var n=t.getRendererType();e.indexOf(n)&&e.push(n)}}(i||(i={})),i}),e(i,"Series/OnSeriesComposition.js",[i["Series/Column/ColumnSeries.js"],i["Core/Globals.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,s=i.composed,n=t.prototype,a=e.prototype,l=o.defined,h=o.pushUnique,p=o.stableSort;return function(t){function i(t){return a.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function e(){n.translate.apply(this);var t,i,e,o,r,s,a,h,d,u=this,c=u.options,f=u.chart,g=u.points,v=c.onSeries,x=v&&f.get(v),m=x&&x.options.step,y=x&&x.points,b=f.inverted,M=u.xAxis,S=u.yAxis,A=g.length-1,k=c.onKey||"y",C=y&&y.length,w=0;if(x&&x.visible&&C)for(w=(x.pointXOffset||0)+(x.barW||0)/2,h=x.currentDataGrouping,s=y[C-1].x+(h?h.totalRange:0),p(g,function(t,i){return t.x-i.x}),k="plot"+k[0].toUpperCase()+k.substr(1);C--&&g[A]&&"break"!==function(){if(r=y[C],(e=g[A]).y=r.y,r.x<=e.x&&void 0!==r[k]){if(e.x<=s&&(e.plotY=r[k],r.x<e.x&&!m&&(a=y[C+1])&&void 0!==a[k])){if(l(e.plotX)&&x.is("spline")){for(var o=[r.plotX||0,r.plotY||0],n=[a.plotX||0,a.plotY||0],h=(null===(t=r.controlPoints)||void 0===t?void 0:t.high)||o,p=(null===(i=a.controlPoints)||void 0===i?void 0:i.low)||n,u=function(t,i){return Math.pow(1-t,3)*o[i]+3*(1-t)*(1-t)*t*h[i]+3*(1-t)*t*t*p[i]+t*t*t*n[i]},c=0,f=1,v=void 0,b=0;b<100;b++){var M=(c+f)/2,w=u(M,0);if(null===w)break;if(.25>Math.abs(w-e.plotX)){v=M;break}w<e.plotX?c=M:f=M}l(v)&&(e.plotY=u(v,1),e.y=S.toValue(e.plotY,!0))}else d=(e.x-r.x)/(a.x-r.x),e.plotY+=d*(a[k]-r[k]),e.y+=d*(a.y-r.y)}if(A--,C++,A<0)return"break"}}(););g.forEach(function(t,i){var e;t.plotX+=w,(void 0===t.plotY||b)&&(t.plotX>=0&&t.plotX<=M.len?b?(t.plotY=M.translate(t.x,0,1,0,1),t.plotX=l(t.y)?S.translate(t.y,0,0,0,1):0):t.plotY=(M.opposite?0:u.yAxis.len)+M.offset:t.shapeArgs={}),(o=g[i-1])&&o.plotX===t.plotX&&(void 0===o.stackIndex&&(o.stackIndex=0),e=o.stackIndex+1),t.stackIndex=e}),this.onSeries=x}t.compose=function(t){if(h(s,"OnSeries")){var o=t.prototype;o.getPlotBox=i,o.translate=e}return t},t.getPlotBox=i,t.translate=e}(r||(r={})),r}),e(i,"Series/Flags/FlagsSeries.js",[i["Series/Flags/FlagsPoint.js"],i["Series/Flags/FlagsSeriesDefaults.js"],i["Series/Flags/FlagsSymbols.js"],i["Core/Globals.js"],i["Series/OnSeriesComposition.js"],i["Core/Renderer/RendererUtilities.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n,a,l){var h,p=this&&this.__extends||(h=function(t,i){return(h=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}h(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),d=o.noop,u=s.distribute,c=n.series,f=n.seriesTypes.column,g=l.addEvent,v=l.defined,x=l.extend,m=l.merge,y=l.objectEach,b=l.wrap,M=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return p(o,t),o.prototype.animate=function(t){t&&this.setClip()},o.prototype.drawPoints=function(){var t,i,e,o,r,s,n,l,h,p,d,c=this.points,f=this.chart,g=f.renderer,x=f.inverted,M=this.options,S=M.y,A=this.yAxis,k={},C=[];for(o=c.length;o--;)r=c[o],p=(x?r.plotY:r.plotX)>this.xAxis.len,t=r.plotX,n=r.stackIndex,e=r.options.shape||M.shape,void 0!==(i=r.plotY)&&(i=r.plotY+S-(void 0!==n&&n*M.stackDistance)),r.anchorX=n?void 0:r.plotX,l=n?void 0:r.plotY,d="flag"!==e,s=r.graphic,void 0!==i&&t>=0&&!p?(s&&r.hasNewShapeType()&&(s=s.destroy()),s||(s=r.graphic=g.label("",null,null,e,null,null,M.useHTML).addClass("highcharts-point").add(this.markerGroup),r.graphic.div&&(r.graphic.div.point=r),s.isNew=!0),s.attr({align:d?"center":"left",width:M.width,height:M.height,"text-align":M.textAlign}),f.styledMode||s.attr(this.pointAttribs(r)).css(m(M.style,r.style)).shadow(M.shadow),t>0&&(t-=s.strokeWidth()%2),h={y:i,anchorY:l},M.allowOverlapX&&(h.x=t,h.anchorX=r.anchorX),s.attr({text:r.options.title||M.title||"A"})[s.isNew?"attr":"animate"](h),M.allowOverlapX||(k[r.plotX]?k[r.plotX].size=Math.max(k[r.plotX].size,s.width||0):k[r.plotX]={align:d?.5:0,size:s.width||0,target:t,anchorX:t}),r.tooltipPos=[t,i+A.pos-f.plotTop]):s&&(r.graphic=s.destroy());if(!M.allowOverlapX){var w=100;y(k,function(t){t.plotX=t.anchorX,C.push(t),w=Math.max(t.size,w)}),u(C,x?A.len:this.xAxis.len,w);for(var D=0;D<c.length;D++){var O=c[D],E=O.plotX,B=O.graphic,P=B&&k[E];P&&B&&(v(P.pos)?B[B.isNew?"attr":"animate"]({x:P.pos+(P.align||0)*P.size,anchorX:O.anchorX}).show().isNew=!1:B.hide().isNew=!0)}}M.useHTML&&this.markerGroup&&b(this.markerGroup,"on",function(t){return a.prototype.on.apply(t.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},o.prototype.drawTracker=function(){var i=this.points;t.prototype.drawTracker.call(this);for(var e=function(t){var e=t.graphic;e&&(t.unbindMouseOver&&t.unbindMouseOver(),t.unbindMouseOver=g(e.element,"mouseover",function(){t.stackIndex>0&&!t.raised&&(t._y=e.y,e.attr({y:t._y-8}),t.raised=!0);for(var o=0;o<i.length;o++){var r=i[o];r!==t&&r.raised&&r.graphic&&(r.graphic.attr({y:r._y}),r.raised=!1)}}))},o=0;o<i.length;o++)e(i[o])},o.prototype.pointAttribs=function(t,i){var e=this.options,o=t&&t.color||this.color,r=e.lineColor,s=t&&t.lineWidth,n=t&&t.fillColor||e.fillColor;return i&&(n=e.states[i].fillColor,r=e.states[i].lineColor,s=e.states[i].lineWidth),{fill:n||o,stroke:r||o,"stroke-width":s||e.lineWidth||0}},o.prototype.setClip=function(){c.prototype.setClip.apply(this,arguments),!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},o.compose=e.compose,o.defaultOptions=m(f.defaultOptions,i),o}(f);return r.compose(M),x(M.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:t,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:d,init:c.prototype.init}),n.registerSeriesType("flags",M),M}),e(i,"Core/Axis/BrokenAxis.js",[i["Core/Axis/Stacking/StackItem.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,r=i.find,s=i.fireEvent,n=i.isArray,a=i.isNumber,l=i.pick;return function(i){function e(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function h(){var t;(null===(t=this.brokenAxis)||void 0===t?void 0:t.hasBreaks)&&(this.options.ordinal=!1)}function p(){var t=this.brokenAxis;if(null==t?void 0:t.hasBreaks){for(var i=this.tickPositions,e=this.tickPositions.info,o=[],r=0;r<i.length;r++)t.isInAnyBreak(i[r])||o.push(i[r]);this.tickPositions=o,this.tickPositions.info=e}}function d(){this.brokenAxis||(this.brokenAxis=new v(this))}function u(){var t,i,e=this.isDirty,o=this.options.connectNulls,r=this.points,s=this.xAxis,n=this.yAxis;if(e)for(var a=r.length;a--;){var l=r[a],h=!(null===l.y&&!1===o)&&((null===(t=null==s?void 0:s.brokenAxis)||void 0===t?void 0:t.isInAnyBreak(l.x,!0))||(null===(i=null==n?void 0:n.brokenAxis)||void 0===i?void 0:i.isInAnyBreak(l.y,!0)));l.visible=!h&&!1!==l.options.visible}}function c(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,l(this.pointArrayMap,["y"]))}function f(t,i){var e,o,r,n,h=this,p=h.points;if(null===(e=null==t?void 0:t.brokenAxis)||void 0===e?void 0:e.hasBreaks){var d=t.brokenAxis;i.forEach(function(i){o=(null==d?void 0:d.breakArray)||[],r=t.isXAxis?t.min:l(h.options.threshold,t.min);var e,u,c=null===(u=null===(e=null==t?void 0:t.options)||void 0===e?void 0:e.breaks)||void 0===u?void 0:u.filter(function(t){for(var i=!0,e=0;e<o.length;e++){var r=o[e];if(r.from===t.from&&r.to===t.to){i=!1;break}}return i});p.forEach(function(e){n=l(e["stack"+i.toUpperCase()],e[i]),o.forEach(function(i){if(a(r)&&a(n)){var o="";r<i.from&&n>i.to||r>i.from&&n<i.from?o="pointBreak":(r<i.from&&n>i.from&&n<i.to||r>i.from&&n>i.to&&n<i.from)&&(o="pointInBreak"),o&&s(t,o,{point:e,brk:i})}}),null==c||c.forEach(function(i){s(t,"pointOutsideOfBreak",{point:e,brk:i})})})})}}function g(){var i=this.currentDataGrouping,e=null==i?void 0:i.gapSize,o=this.points.slice(),r=this.yAxis,s=this.options.gapSize,n=o.length-1;if(s&&n>0){"value"!==this.options.gapUnit&&(s*=this.basePointRange),e&&e>s&&e>=this.basePointRange&&(s=e);for(var a=void 0,l=void 0;n--;)if(l&&!1!==l.visible||(l=o[n+1]),a=o[n],!1!==l.visible&&!1!==a.visible){if(l.x-a.x>s){var h=(a.x+l.x)/2;o.splice(n+1,0,{isNull:!0,x:h}),r.stacking&&this.options.stacking&&((r.stacking.stacks[this.stackKey][h]=new t(r,r.options.stackLabels,!1,h,this.stack)).total=0)}l=a}}return this.getGraphPath(o)}i.compose=function(t,i){if(!t.keepProps.includes("brokenAxis")){t.keepProps.push("brokenAxis"),o(t,"init",d),o(t,"afterInit",e),o(t,"afterSetTickPositions",p),o(t,"afterSetOptions",h);var r=i.prototype;r.drawBreaks=f,r.gappedPath=g,o(i,"afterGeneratePoints",u),o(i,"afterRender",c)}return t};var v=function(){function t(t){this.hasBreaks=!1,this.axis=t}return t.isInBreak=function(t,i){var e=t.repeat||1/0,o=t.from,r=t.to-t.from,s=i>=o?(i-o)%e:e-(o-i)%e;return t.inclusive?s<=r:s<r&&0!==s},t.lin2Val=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,s,n=i;for(s=0;s<o.length&&!((r=o[s]).from>=n);s++)r.to<n?n+=r.len:t.isInBreak(r,n)&&(n+=r.len);return n},t.val2Lin=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,s,n=i;for(s=0;s<o.length;s++)if((r=o[s]).to<=i)n-=r.len;else if(r.from>=i)break;else if(t.isInBreak(r,i)){n-=i-r.from;break}return n},t.prototype.findBreakAt=function(t,i){return r(i,function(i){return i.from<t&&t<i.to})},t.prototype.isInAnyBreak=function(i,e){var o,r,s,n=this.axis,h=n.options.breaks||[],p=h.length;if(p&&a(i)){for(;p--;)t.isInBreak(h[p],i)&&(o=!0,r||(r=l(h[p].showPoints,!n.isXAxis)));s=o&&e?o&&!r:o}return s},t.prototype.setBreaks=function(i,e){var o=this,r=o.axis,h=n(i)&&!!i.length&&!!Object.keys(i[0]).length;r.isDirty=o.hasBreaks!==h,o.hasBreaks=h,i!==r.options.breaks&&(r.options.breaks=r.userOptions.breaks=i),r.forceRedraw=!0,r.series.forEach(function(t){t.isDirty=!0}),h||r.val2lin!==t.val2Lin||(delete r.val2lin,delete r.lin2val),h&&(r.userOptions.ordinal=!1,r.lin2val=t.lin2Val,r.val2lin=t.val2Lin,r.setExtremes=function(t,i,e,s,n){if(o.hasBreaks){for(var a=this.options.breaks||[],l=void 0;l=o.findBreakAt(t,a);)t=l.to;for(;l=o.findBreakAt(i,a);)i=l.from;i<t&&(i=t)}r.constructor.prototype.setExtremes.call(this,t,i,e,s,n)},r.setAxisTranslation=function(){if(r.constructor.prototype.setAxisTranslation.call(this),o.unitLength=void 0,o.hasBreaks){var i,e,n,h,p=r.options.breaks||[],d=[],u=[],c=l(r.pointRangePadding,0),f=0,g=r.userMin||r.min,v=r.userMax||r.max;p.forEach(function(i){e=i.repeat||1/0,a(g)&&a(v)&&(t.isInBreak(i,g)&&(g+=i.to%e-g%e),t.isInBreak(i,v)&&(v-=v%e-i.from%e))}),p.forEach(function(t){if(n=t.from,e=t.repeat||1/0,a(g)&&a(v)){for(;n-e>g;)n-=e;for(;n<g;)n+=e;for(h=n;h<v;h+=e)d.push({value:h,move:"in"}),d.push({value:h+t.to-t.from,move:"out",size:t.breakSize})}}),d.sort(function(t,i){return t.value===i.value?("in"===t.move?0:1)-("in"===i.move?0:1):t.value-i.value}),i=0,n=g,d.forEach(function(t){1===(i+="in"===t.move?1:-1)&&"in"===t.move&&(n=t.value),0===i&&a(n)&&(u.push({from:n,to:t.value,len:t.value-n-(t.size||0)}),f+=t.value-n-(t.size||0))}),o.breakArray=u,a(g)&&a(v)&&a(r.min)&&(o.unitLength=v-g-f+c,s(r,"afterBreaks"),r.staticScale?r.transA=r.staticScale:o.unitLength&&(r.transA*=(v-r.min+c)/o.unitLength),c&&(r.minPixelPadding=r.transA*(r.minPointOffset||0)),r.min=g,r.max=v)}}),l(e,!0)&&r.chart.redraw()},t}();i.Additions=v}(e||(e={})),e}),e(i,"masters/modules/broken-axis.src.js",[i["Core/Globals.js"],i["Core/Axis/BrokenAxis.js"]],function(t,i){return t.BrokenAxis=t.BrokenAxis||i,t.BrokenAxis.compose(t.Axis,t.Series),t}),e(i,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),e(i,"Extensions/DataGrouping/ApproximationDefaults.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e=i.arrayMax,o=i.arrayMin,r=i.correctFloat,s=i.extend,n=i.isNumber;function a(t){var i=t.length,e=l(t);return n(e)&&i&&(e=r(e/i)),e}function l(t){var i,e=t.length;if(!e&&t.hasNulls)i=null;else if(e)for(i=0;e--;)i+=t[e];return i}var h={average:a,averages:function(){var t=[];return[].forEach.call(arguments,function(i){t.push(a(i))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?e(t):t.hasNulls?null:void 0},hlc:function(i,e,o){if(i=t.high(i),e=t.low(e),o=t.close(o),n(i)||n(e)||n(o))return[i,e,o]},low:function(t){return t.length?o(t):t.hasNulls?null:void 0},ohlc:function(i,e,o,r){if(i=t.open(i),e=t.high(e),o=t.low(o),r=t.close(r),n(i)||n(e)||n(o)||n(r))return[i,e,o,r]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(i,e){return(i=t.low(i),e=t.high(e),n(i)||n(e))?[i,e]:null===i&&null===e?null:void 0},sum:l};return s(t,h),h}),e(i,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),e(i,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,r=i.extend,s=i.merge,n=i.pick;function a(t){var i=this,e=i.series;e.forEach(function(t){t.groupPixelWidth=void 0}),e.forEach(function(e){e.groupPixelWidth=i.getGroupPixelWidth&&i.getGroupPixelWidth(),e.groupPixelWidth&&(e.hasProcessed=!0),e.applyGrouping(!!t.hasExtremesChanged)})}function l(){for(var i,e,o=this.series,r=o.length,s=0,a=!1;r--;)(e=o[r].options.dataGrouping)&&(s=Math.max(s,n(e.groupPixelWidth,t.common.groupPixelWidth)),i=(o[r].processedXData||o[r].data).length,(o[r].groupPixelWidth||i>this.chart.plotSizeX/s||i&&e.forced)&&(a=!0));return a?s:0}function h(){this.series.forEach(function(t){t.hasProcessed=!1})}function p(t,i){var o;if(i=n(i,!0),t||(t={forced:!1,units:null}),this instanceof e)for(o=this.series.length;o--;)this.series[o].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(i){i.dataGrouping="boolean"==typeof t?t:s(t,i.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),i&&this.chart.redraw()}return{compose:function(t){e=t;var i=t.prototype;i.applyGrouping||(o(t,"afterSetScale",h),o(t,"postProcessData",a),r(i,{applyGrouping:a,getGroupPixelWidth:l,setDataGrouping:p}))}}}),e(i,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Axis/DateTimeAxis.js"],i["Core/Defaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s){var n=r.series.prototype,a=s.addEvent,l=s.defined,h=s.error,p=s.extend,d=s.isNumber,u=s.merge,c=s.pick,f=n.generatePoints;function g(t){var o,r,s,a,p=this.chart,u=this.options.dataGrouping,f=!1!==this.allowDG&&u&&c(u.enabled,p.options.isStock),g=this.reserveSpace(),v=this.currentDataGrouping,x=!1;f&&!this.requireSorting&&(this.requireSorting=x=!0);var m=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!f;if(x&&(this.requireSorting=!1),!m){this.destroyGroupedData();var y=u.groupAll?this.xData:this.processedXData,b=u.groupAll?this.yData:this.processedYData,M=p.plotSizeX,S=this.xAxis,A=S.options.ordinal,k=this.groupPixelWidth;if(k&&y&&y.length&&M){r=!0,this.isDirty=!0,this.points=null;var C,w=S.getExtremes(),D=w.min,O=w.max,E=A&&S.ordinal&&S.ordinal.getGroupIntervalFactor(D,O,this)||1,B=k*(O-D)/M*E,P=S.getTimeTicks(e.Additions.prototype.normalizeTimeTickInterval(B,u.units||i.units),Math.min(D,y[0]),Math.max(O,y[y.length-1]),S.options.startOfWeek,y,this.closestPointRange),T=n.groupData.apply(this,[y,b,P,u.approximation]),j=T.groupedXData,G=T.groupedYData,R=0;for(u&&u.smoothed&&j.length&&(u.firstAnchor="firstPoint",u.anchor="middle",u.lastAnchor="lastPoint",h(32,!1,p,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),o=1;o<P.length;o++)P.info.segmentStarts&&-1!==P.info.segmentStarts.indexOf(o)||(R=Math.max(P[o]-P[o-1],R));(s=P.info).gapSize=R,this.closestPointRange=P.info.totalRange,this.groupMap=T.groupMap,this.currentDataGrouping=s,function(t,i,e){var o=t.options.dataGrouping,r=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(o&&t.xData&&r&&t.groupMap){var s=i.length-1,n=o.anchor,a=o.firstAnchor,l=o.lastAnchor,h=i.length-1,p=0;if(a&&t.xData[0]>=i[0]){p++;var u=t.groupMap[0].start,c=t.groupMap[0].length,f=void 0;d(u)&&d(c)&&(f=u+(c-1)),i[0]=({start:i[0],middle:i[0]+.5*r,end:i[0]+r,firstPoint:t.xData[0],lastPoint:f&&t.xData[f]})[a]}if(s>0&&l&&r&&i[s]>=e-r){h--;var g=t.groupMap[t.groupMap.length-1].start;i[s]=({start:i[s],middle:i[s]+.5*r,end:i[s]+r,firstPoint:g&&t.xData[g],lastPoint:t.xData[t.xData.length-1]})[l]}if(n&&"start"!==n)for(var v=r*({middle:.5,end:1})[n];h>=p;)i[h]+=v,h--}}(this,j,O),g&&(l((C=j)[0])&&d(S.min)&&d(S.dataMin)&&C[0]<S.min&&((!l(S.options.min)&&S.min<=S.dataMin||S.min===S.dataMin)&&(S.min=Math.min(C[0],S.min)),S.dataMin=Math.min(C[0],S.dataMin)),l(C[C.length-1])&&d(S.max)&&d(S.dataMax)&&C[C.length-1]>S.max&&((!l(S.options.max)&&d(S.dataMax)&&S.max>=S.dataMax||S.max===S.dataMax)&&(S.max=Math.max(C[C.length-1],S.max)),S.dataMax=Math.max(C[C.length-1],S.dataMax))),u.groupAll&&(this.allGroupedData=G,j=(a=this.cropData(j,G,S.min,S.max)).xData,G=a.yData,this.cropStart=a.start),this.processedXData=j,this.processedYData=G}else this.groupMap=null;this.hasGroupedData=r,this.preventGraphAnimation=(v&&v.totalRange)!==(s&&s.totalRange)}}function v(){this.groupedData&&(this.groupedData.forEach(function(t,i){t&&(this.groupedData[i]=t.destroy?t.destroy():null)},this),this.groupedData.length=0,delete this.allGroupedData)}function x(){f.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function m(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function y(i,e,o,r){var s,n,a,h=this,p=h.data,c=h.options&&h.options.data,f=[],g=[],v=[],x=i.length,m=!!e,y=[],b=h.pointArrayMap,M=b&&b.length,S=["x"].concat(b||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll,k=0,C=0,w="function"==typeof r?r:r&&t[r]?t[r]:t[h.getDGApproximation&&h.getDGApproximation()||"average"];if(M)for(var D=b.length;D--;)y.push([]);else y.push([]);for(var O=M||1,E=0;E<=x;E++)if(!(i[E]<o[0])){for(;void 0!==o[k+1]&&i[E]>=o[k+1]||E===x;){s=o[k],h.dataGroupInfo={start:A?C:h.cropStart+C,length:y[0].length,groupStart:s},a=w.apply(h,y),h.pointClass&&!l(h.dataGroupInfo.options)&&(h.dataGroupInfo.options=u(h.pointClass.prototype.optionsToObject.call({series:h},h.options.data[h.cropStart+C])),S.forEach(function(t){delete h.dataGroupInfo.options[t]})),void 0!==a&&(f.push(s),g.push(a),v.push(h.dataGroupInfo)),C=E;for(var B=0;B<O;B++)y[B].length=0,y[B].hasNulls=!1;if(k+=1,E===x)break}if(E===x)break;if(b)for(var P=h.options.dataGrouping&&h.options.dataGrouping.groupAll?E:h.cropStart+E,T=p&&p[P]||h.pointClass.prototype.applyOptions.apply({series:h},[c[P]]),j=void 0,B=0;B<M;B++)d(j=T[b[B]])?y[B].push(j):null===j&&(y[B].hasNulls=!0);else d(n=m?e[E]:null)?y[0].push(n):null===n&&(y[0].hasNulls=!0)}return{groupedXData:f,groupedYData:g,groupMap:v}}function b(t){var e=t.options,r=this.type,s=this.chart.options.plotOptions,n=this.useCommonDataGrouping&&i.common,a=i.seriesSpecific,l=o.defaultOptions.plotOptions[r].dataGrouping;if(s&&(a[r]||n)){var h=this.chart.rangeSelector;l||(l=u(i.common,a[r])),e.dataGrouping=u(n,l,s.series&&s.series.dataGrouping,s[r].dataGrouping,this.userOptions.dataGrouping,!e.isInternal&&h&&d(h.selected)&&h.buttonOptions[h.selected].dataGrouping)}}return{compose:function(t){var i=t.prototype;i.applyGrouping||(a(t.prototype.pointClass,"update",function(){if(this.dataGroup)return h(24,!1,this.series.chart),!1}),a(t,"afterSetOptions",b),a(t,"destroy",v),p(i,{applyGrouping:g,destroyGroupedData:v,generatePoints:x,getDGApproximation:m,groupData:y}))},groupData:y}}),e(i,"Extensions/DataGrouping/DataGrouping.js",[i["Extensions/DataGrouping/DataGroupingAxisComposition.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],i["Core/Templating.js"],i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s){var n=o.format,a=r.composed,l=s.addEvent,h=s.extend,p=s.isNumber,d=s.pick,u=s.pushUnique;function c(t){var e,o,r,s,a,l,u=this.chart,c=u.time,f=t.labelConfig,g=f.series,v=f.point,x=g.options,m=g.tooltipOptions,y=x.dataGrouping,b=g.xAxis,M=m.xDateFormat,S=m[t.isFooter?"footerFormat":"headerFormat"];if(b&&"datetime"===b.options.type&&y&&p(f.key)){r=g.currentDataGrouping,s=y.dateTimeLabelFormats||i.common.dateTimeLabelFormats,r?(a=s[r.unitName],1===r.count?M=a[0]:(M=a[1],o=a[2])):!M&&s&&b.dateTime&&(M=b.dateTime.getXDateFormat(f.x,m.dateTimeLabelFormats));var A=d(null===(e=g.groupMap)||void 0===e?void 0:e[v.index].groupStart,f.key),k=A+(null==r?void 0:r.totalRange)-1;l=c.dateFormat(M,A),o&&(l+=c.dateFormat(o,k)),g.chart.styledMode&&(S=this.styledModeFormat(S)),t.text=n(S,{point:h(f.point,{key:l}),series:g},u),t.preventDefault()}}return{compose:function(i,o,r){t.compose(i),e.compose(o),r&&u(a,"DataGrouping")&&l(r,"headerFormatter",c)},groupData:e.groupData}}),e(i,"masters/modules/datagrouping.src.js",[i["Core/Globals.js"],i["Extensions/DataGrouping/ApproximationDefaults.js"],i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGrouping.js"]],function(t,i,e,o){return t.dataGrouping=t.dataGrouping||{},t.dataGrouping.approximationDefaults=t.dataGrouping.approximationDefaults||i,t.dataGrouping.approximations=t.dataGrouping.approximations||e,o.compose(t.Axis,t.Series,t.Tooltip),t}),e(i,"Extensions/Annotations/NavigationBindingsUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined,e=t.isNumber,o=t.pick,r={backgroundColor:"string",borderColor:"string",borderRadius:"string",color:"string",fill:"string",fontSize:"string",labels:"string",name:"string",stroke:"string",title:"string"};return{annotationsFieldsTypes:r,getAssignedAxis:function(t){return t.filter(function(t){var i=t.axis.getExtremes(),r=i.min,s=i.max,n=o(t.axis.minPointOffset,0);return e(r)&&e(s)&&t.value>=r-n&&t.value<=s+n&&!t.axis.options.isInternal})[0]},getFieldType:function(t,e){var o=r[t],s=typeof e;return i(o)&&(s=o),({string:"text",number:"number",boolean:"checkbox"})[s]}}}),e(i,"Extensions/MouseWheelZoom/MouseWheelZoom.js",[i["Core/Utilities.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"]],function(t,i){var e,o=t.addEvent,r=t.isObject,s=t.pick,n=t.defined,a=t.merge,l=i.getAssignedAxis,h=[],p={enabled:!0,sensitivity:1.1},d=function(t,i,o,r,a,l,h){var p=s(h.type,t.zooming.type,""),d=[];"x"===p?d=o:"y"===p?d=r:"xy"===p&&(d=t.axes);var u=t.transform({axes:d,to:{x:a-5,y:l-5,width:10,height:10},from:{x:a-5*i,y:l-5*i,width:10*i,height:10*i},trigger:"mousewheel"});return u&&(n(e)&&clearTimeout(e),e=setTimeout(function(){var i;null===(i=t.pointer)||void 0===i||i.drop()},400)),u};function u(){var t,i=this,e=(r(t=this.zooming.mouseWheel)||(t={enabled:null==t||t}),a(p,t));e.enabled&&o(this.container,"wheel",function(t){t=(null===(o=i.pointer)||void 0===o?void 0:o.normalize(t))||t;var o,r,s=i.pointer,n=s&&!s.inClass(t.target,"highcharts-no-mousewheel");if(i.isInsidePlot(t.chartX-i.plotLeft,t.chartY-i.plotTop)&&n){var a=e.sensitivity||1.1,h=t.detail||(t.deltaY||0)/120,p=l(s.getCoordinates(t).xAxis),u=l(s.getCoordinates(t).yAxis);d(i,Math.pow(a,h),p?[p.axis]:i.xAxis,u?[u.axis]:i.yAxis,t.chartX,t.chartY,e)&&(null===(r=t.preventDefault)||void 0===r||r.call(t))}})}return{compose:function(t){-1===h.indexOf(t)&&(h.push(t),o(t,"afterGetContainer",u))}}}),e(i,"masters/modules/mouse-wheel-zoom.src.js",[i["Core/Globals.js"],i["Extensions/MouseWheelZoom/MouseWheelZoom.js"]],function(t,i){return t.MouseWheelZoom=t.MouseWheelZoom||i,t.MouseWheelZoom.compose(t.Chart),t}),e(i,"masters/modules/stock.src.js",[i["Core/Globals.js"],i["Series/DataModifyComposition.js"],i["Stock/Navigator/Navigator.js"],i["Core/Axis/OrdinalAxis.js"],i["Stock/RangeSelector/RangeSelector.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Chart/StockChart.js"],i["Series/OHLC/OHLCSeries.js"],i["Series/Flags/FlagsSeries.js"]],function(t,i,e,o,r,s,n,a,l){return t.Navigator=t.Navigator||e,t.OrdinalAxis=t.OrdinalAxis||o,t.RangeSelector=t.RangeSelector||r,t.Scrollbar=t.Scrollbar||s,t.stockChart=t.stockChart||n.stockChart,t.StockChart=t.StockChart||t.stockChart,t.extend(t.StockChart,n),i.compose(t.Series,t.Axis,t.Point),l.compose(t.Renderer),a.compose(t.Series),t.Navigator.compose(t.Chart,t.Axis,t.Series),t.OrdinalAxis.compose(t.Axis,t.Series,t.Chart),t.RangeSelector.compose(t.Axis,t.Chart),t.Scrollbar.compose(t.Axis),t.StockChart.compose(t.Chart,t.Axis,t.Series,t.SVGRenderer),t})});