!/**
 * Highcharts Gantt JS v11.4.0 (2024-03-04)
 *
 * Gantt series
 *
 * (c) 2016-2024 Lars A. V. Cabrera
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/gantt",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(t,i,e,o){t.hasOwnProperty(i)||(t[i]=o.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}e(i,"Extensions/ArrowSymbols.js",[],function(){function t(t,i,e,o){return[["M",t,i+o/2],["L",t+e,i],["L",t,i+o/2],["L",t+e,i+o]]}function i(i,e,o,r){return t(i,e,o/2,r)}function e(t,i,e,o){return[["M",t+e,i],["L",t,i+o/2],["L",t+e,i+o],["Z"]]}function o(t,i,o,r){return e(t,i,o/2,r)}return{compose:function(r){var n=r.prototype.symbols;n.arrow=t,n["arrow-filled"]=e,n["arrow-filled-half"]=o,n["arrow-half"]=i,n["triangle-left"]=e,n["triangle-left-half"]=o}}}),e(i,"Gantt/Connection.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=i.defined,o=i.error,r=i.merge,n=i.objectEach,s=t.deg2rad,a=Math.max,h=Math.min;return function(){function t(t,i,e){this.init(t,i,e)}return t.prototype.init=function(t,i,e){this.fromPoint=t,this.toPoint=i,this.options=e,this.chart=t.series.chart,this.pathfinder=this.chart.pathfinder},t.prototype.renderPath=function(t,i){var e=this.chart,o=e.styledMode,r=this.pathfinder,n={},s=this.graphics&&this.graphics.path;r.group||(r.group=e.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(e.seriesGroup)),r.group.translate(e.plotLeft,e.plotTop),s&&s.renderer||(s=e.renderer.path().add(r.group),o||s.attr({opacity:0})),s.attr(i),n.d=t,o||(n.opacity=1),s.animate(n),this.graphics=this.graphics||{},this.graphics.path=s},t.prototype.addMarker=function(t,i,e){var o,r,n,a,h,l,d,c,p=this.fromPoint.series.chart,u=p.pathfinder,f=p.renderer,g="start"===t?this.fromPoint:this.toPoint,x=g.getPathfinderAnchorPoint(i);i.enabled&&((c="start"===t?e[1]:e[e.length-2])&&"M"===c[0]||"L"===c[0])&&(d={x:c[1],y:c[2]},r=g.getRadiansToVector(d,x),o=g.getMarkerVector(r,i.radius,x),n=-r/s,i.width&&i.height?(h=i.width,l=i.height):h=l=2*i.radius,this.graphics=this.graphics||{},a={x:o.x-h/2,y:o.y-l/2,width:h,height:l,rotation:n,rotationOriginX:o.x,rotationOriginY:o.y},this.graphics[t]?this.graphics[t].animate(a):(this.graphics[t]=f.symbol(i.symbol).addClass("highcharts-point-connecting-path-"+t+"-marker highcharts-color-"+this.fromPoint.colorIndex).attr(a).add(u.group),f.styledMode||this.graphics[t].attr({fill:i.color||this.fromPoint.color,stroke:i.lineColor,"stroke-width":i.lineWidth,opacity:0}).animate({opacity:1},g.series.options.animation)))},t.prototype.getPath=function(t){var i=this.pathfinder,e=this.chart,n=i.algorithms[t.type],s=i.chartObstacles;return"function"!=typeof n?(o('"'+t.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]}):(n.requiresObstacles&&!s&&(s=i.chartObstacles=i.getChartObstacles(t),e.options.connectors.algorithmMargin=t.algorithmMargin,i.chartObstacleMetrics=i.getObstacleMetrics(s)),n(this.fromPoint.getPathfinderAnchorPoint(t.startMarker),this.toPoint.getPathfinderAnchorPoint(t.endMarker),r({chartObstacles:s,lineObstacles:i.lineObstacles||[],obstacleMetrics:i.chartObstacleMetrics,hardBounds:{xMin:0,xMax:e.plotWidth,yMin:0,yMax:e.plotHeight},obstacleOptions:{margin:t.algorithmMargin},startDirectionX:i.getAlgorithmStartDirection(t.startMarker)},t)))},t.prototype.render=function(){var t=this.fromPoint,i=t.series,o=i.chart,n=o.pathfinder,s={},l=r(o.options.connectors,i.options.connectors,t.options.connectors,this.options);!o.styledMode&&(s.stroke=l.lineColor||t.color,s["stroke-width"]=l.lineWidth,l.dashStyle&&(s.dashstyle=l.dashStyle)),s.class="highcharts-point-connecting-path highcharts-color-"+t.colorIndex,e((l=r(s,l)).marker.radius)||(l.marker.radius=h(a(Math.ceil((l.algorithmMargin||8)/2)-1,1),5));var d=this.getPath(l),c=d.path;d.obstacles&&(n.lineObstacles=n.lineObstacles||[],n.lineObstacles=n.lineObstacles.concat(d.obstacles)),this.renderPath(c,s),this.addMarker("start",r(l.marker,l.startMarker),c),this.addMarker("end",r(l.marker,l.endMarker),c)},t.prototype.destroy=function(){this.graphics&&(n(this.graphics,function(t){t.destroy()}),delete this.graphics)},t}()}),e(i,"Extensions/CurrentDateIndication.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.composed,o=i.addEvent,r=i.merge,n=i.pushUnique,s=i.wrap,a={color:"#ccd3ff",width:2,label:{format:"%a, %b %d %Y, %H:%M",formatter:function(t,i){return this.axis.chart.time.dateFormat(i||"",t)},rotation:0,style:{fontSize:"0.7em"}}};function h(){var t=this.options,i=t.currentDateIndicator;if(i){var e="object"==typeof i?r(a,i):r(a);e.value=Date.now(),e.className="highcharts-current-date-indicator",t.plotLines||(t.plotLines=[]),t.plotLines.push(e)}}function l(){this.label&&this.label.attr({text:this.getLabelText(this.options.label)})}function d(t,i){var e=this.options;return e&&e.className&&-1!==e.className.indexOf("highcharts-current-date-indicator")&&e.label&&"function"==typeof e.label.formatter?(e.value=Date.now(),e.label.formatter.call(this,e.value,e.label.format)):t.call(this,i)}return{compose:function(t,i){n(e,"CurrentDateIndication")&&(o(t,"afterSetOptions",h),o(i,"render",l),s(i.prototype,"getLabelText",d))}}}),e(i,"Core/Chart/GanttChart.js",[i["Core/Chart/Chart.js"],i["Core/Defaults.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r,n=this&&this.__extends||(o=function(t,i){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}o(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),s=i.defaultOptions,a=e.isArray,h=e.merge,l=e.splat,d=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n(i,t),i.prototype.init=function(i,e){var o,r=i.xAxis,n=i.yAxis;i.xAxis=i.yAxis=void 0;var d=h(!0,{chart:{type:"gantt"},title:{text:""},legend:{enabled:!1},navigator:{series:{type:"gantt"},yAxis:{type:"category"}}},i,{isGantt:!0});i.xAxis=r,i.yAxis=n,d.xAxis=(a(i.xAxis)?i.xAxis:[i.xAxis||{},{}]).map(function(t,i){var e,r,n;return 1===i&&(o=0),h({grid:{borderColor:"#cccccc",enabled:!0},opposite:null===(n=null!==(r=null===(e=s.xAxis)||void 0===e?void 0:e.opposite)&&void 0!==r?r:t.opposite)||void 0===n||n,linkedTo:o},t,{type:"datetime"})}),d.yAxis=l(i.yAxis||{}).map(function(t){return h({grid:{borderColor:"#cccccc",enabled:!0},staticScale:50,reversed:!0,type:t.categories?t.type:"treegrid"},t)}),t.prototype.init.call(this,d,e)},i}(t);return(r=d||(d={})).ganttChart=function(t,i,e){return new r(t,i,e)},d}),e(i,"Stock/Navigator/ChartNavigatorComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,o=t.isTouchDevice,r=i.addEvent,n=i.merge,s=i.pick,a=[];function h(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function l(){var t,i,e,o,r=this.legend,n=this.navigator;if(n){i=r&&r.options,e=n.xAxis,o=n.yAxis;var a=n.scrollbarHeight,h=n.scrollButtonSize;this.inverted?(n.left=n.opposite?this.chartWidth-a-n.height:this.spacing[3]+a,n.top=this.plotTop+h):(n.left=s(e.left,this.plotLeft+h),n.top=n.navigatorOptions.top||this.chartHeight-n.height-a-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(i&&"bottom"===i.verticalAlign&&"proximate"!==i.layout&&i.enabled&&!i.floating?r.legendHeight+s(i.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&o&&(this.inverted?e.options.left=o.options.left=n.left:e.options.top=o.options.top=n.top,e.setAxisSize(),o.setAxisSize())}}function d(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this),s(t.redraw,!0)&&this.redraw(t.animation))}function c(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this))}function p(){var t=this.options,i=t.navigator,e=t.rangeSelector;if((i&&i.enabled||e&&e.enabled)&&(!o&&"x"===this.zooming.type||o&&"x"===this.zooming.pinchType))return!1}function u(t){var i=t.navigator;if(i&&t.xAxis[0]){var e=t.xAxis[0].getExtremes();i.render(e.min,e.max)}}function f(t){var i=t.options.navigator||{},e=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(i.enabled||e.enabled)&&(n(!0,this.options.navigator,i),n(!0,this.options.scrollbar,e),delete t.options.navigator,delete t.options.scrollbar)}return{compose:function(t,o){if(i.pushUnique(a,t)){var n=t.prototype;e=o,n.callbacks.push(u),r(t,"afterAddSeries",h),r(t,"afterSetChartSize",l),r(t,"afterUpdate",d),r(t,"beforeRender",c),r(t,"beforeShowResetZoom",p),r(t,"update",f)}}}}),e(i,"Core/Axis/NavigatorAxisComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.isTouchDevice,o=i.addEvent,r=i.correctFloat,n=i.defined,s=i.isNumber,a=i.pick;function h(){this.navigatorAxis||(this.navigatorAxis=new d(this))}function l(t){var i,o=this.chart,r=o.options,s=r.navigator,a=this.navigatorAxis,h=o.zooming.pinchType,l=r.rangeSelector,d=o.zooming.type;if(this.isXAxis&&((null==s?void 0:s.enabled)||(null==l?void 0:l.enabled))){if("y"===d&&"zoom"===t.trigger)i=!1;else if(("zoom"===t.trigger&&"xy"===d||e&&"xy"===h)&&this.options.range){var c=a.previousZoom;n(t.min)?a.previousZoom=[this.min,this.max]:c&&(t.min=c[0],t.max=c[1],a.previousZoom=void 0)}}void 0!==i&&t.preventDefault()}var d=function(){function t(t){this.axis=t}return t.compose=function(t){t.keepProps.includes("navigatorAxis")||(t.keepProps.push("navigatorAxis"),o(t,"init",h),o(t,"setExtremes",l))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,i,e,o){var h,l=this.axis,d=l.chart,c=a(null===(h=l.ordinal)||void 0===h?void 0:h.convertOverscroll(l.options.overscroll),0),p=a(e,l.translate(t,!0,!l.horiz)),u=a(o,l.translate(i,!0,!l.horiz)),f=d&&d.fixedRange,g=(l.pointRange||0)/2;if(n(e)||(p=r(p+g)),n(o)||(u=r(u-g)),f&&l.dataMin&&l.dataMax){var x=l.dataMax+c;u>=x&&(p=r(x-f),u=r(x)),p<=l.dataMin&&(u=r(l.dataMin+f))}return s(p)&&s(u)||(p=u=void 0),{min:p,max:u}},t}();return d}),e(i,"Stock/Navigator/NavigatorDefaults.js",[i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"]],function(t,i){var e=t.parse,o=i.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===o.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),e(i,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,i,e,o,r){void 0===r&&(r={});var n=r.width?r.width/2:e,s=Math.round(n/3)+.5;return[["M",-n-1,.5],["L",n,.5],["L",n,(o=r.height||o)+.5],["L",-n-1,o+.5],["L",-n-1,.5],["M",-s,4],["L",-s,o-3],["M",s-1,4],["L",s-1,o-3]]}}}),e(i,"Stock/Utilities/StockUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined;return{setFixedRange:function(t){var e=this.xAxis[0];i(e.dataMax)&&i(e.dataMin)&&t?this.fixedRange=Math.min(t,e.dataMax-e.dataMin):this.fixedRange=t}}}),e(i,"Stock/Navigator/NavigatorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/Navigator/NavigatorSymbols.js"],i["Core/Renderer/RendererRegistry.js"],i["Stock/Utilities/StockUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,n,s,a){var h=t.setOptions,l=i.composed,d=n.getRendererType,c=s.setFixedRange,p=a.addEvent,u=a.extend,f=a.pushUnique;function g(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,i,n){e.compose(i),f(l,"Navigator")&&(t.prototype.setFixedRange=c,u(d().prototype.symbols,r),p(n,"afterUpdate",g),h({navigator:o}))}}}),e(i,"Core/Axis/ScrollbarAxis.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,o=t.composed,r=i.addEvent,n=i.defined,s=i.pick,a=i.pushUnique;return function(t){var i;function e(t){var i=s(t.options&&t.options.min,t.min),e=s(t.options&&t.options.max,t.max);return{axisMin:i,axisMax:e,scrollMin:n(t.dataMin)?Math.min(i,t.min,t.dataMin,s(t.threshold,1/0)):i,scrollMax:n(t.dataMax)?Math.max(e,t.max,t.dataMax,s(t.threshold,-1/0)):e}}function h(){var t=this.scrollbar,i=t&&!t.options.opposite,e=this.horiz?2:i?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[e]+=t.size+(t.options.margin||0))}function l(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new i(t.chart.renderer,t.options.scrollbar,t.chart),r(t.scrollbar,"changed",function(i){var o,r,s=e(t),a=s.axisMin,h=s.axisMax,l=s.scrollMin,d=s.scrollMax-l;if(n(a)&&n(h)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(o=l+d*this.to,r=l+d*this.from):(o=l+d*(1-this.from),r=l+d*(1-this.to)),this.shouldUpdateExtremes(i.DOMType)){var c="mousemove"!==i.DOMType&&"touchmove"!==i.DOMType&&void 0;t.setExtremes(r,o,!0,c,i)}else this.setRange(this.from,this.to)}}))}function d(){var t,i,o,r=e(this),s=r.scrollMin,a=r.scrollMax,h=this.scrollbar,l=this.axisTitleMargin+(this.titleOffset||0),d=this.chart.scrollbarsOffsets,c=this.options.margin||0;if(h&&d){if(this.horiz)this.opposite||(d[1]+=l),h.position(this.left,this.top+this.height+2+d[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(d[1]+=c),t=1;else{this.opposite&&(d[0]+=l);var p=void 0;p=h.options.opposite?this.left+this.width+2+d[0]-(this.opposite?0:c):this.opposite?0:c,h.position(p,this.top,this.width,this.height),this.opposite&&(d[0]+=c),t=0}d[t]+=h.size+(h.options.margin||0),isNaN(s)||isNaN(a)||!n(this.min)||!n(this.max)||this.min===this.max?h.setRange(0,1):(i=(this.min-s)/(a-s),o=(this.max-s)/(a-s),this.horiz&&!this.reversed||!this.horiz&&this.reversed?h.setRange(i,o):h.setRange(1-o,1-i))}}t.compose=function(t,e){a(o,"Axis.Scrollbar")&&(i=e,r(t,"afterGetOffset",h),r(t,"afterInit",l),r(t,"afterRender",d))}}(e||(e={})),e}),e(i,"Stock/Scrollbar/ScrollbarDefaults.js",[],function(){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),e(i,"Stock/Scrollbar/Scrollbar.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/ScrollbarAxis.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var n=t.defaultOptions,s=r.addEvent,a=r.correctFloat,h=r.defined,l=r.destroyObjectProperties,d=r.fireEvent,c=r.merge,p=r.pick,u=r.removeEvent,f=function(){function t(t,i,e){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,i,e)}return t.compose=function(i){e.compose(i,t)},t.swapXY=function(t,i){return i&&t.forEach(function(t){for(var i,e=t.length,o=0;o<e;o+=2)"number"==typeof(i=t[o+1])&&(t[o+1]=t[o+2],t[o+2]=i)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],i=this.scrollbarButtons,e=this.scrollbarGroup.element,o=this.track.element,r=this.mouseDownHandler.bind(this),n=this.mouseMoveHandler.bind(this),a=this.mouseUpHandler.bind(this),h=[[i[t[0]].element,"click",this.buttonToMinClick.bind(this)],[i[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[o,"click",this.trackClick.bind(this)],[e,"mousedown",r],[e.ownerDocument,"mousemove",n],[e.ownerDocument,"mouseup",a],[e,"touchstart",r],[e.ownerDocument,"touchmove",n],[e.ownerDocument,"touchend",a]];h.forEach(function(t){s.apply(null,t)}),this._events=h},t.prototype.buttonToMaxClick=function(t){var i=(this.to-this.from)*p(this.options.step,.2);this.updatePosition(this.from+i,this.to+i),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var i=a(this.to-this.from)*p(this.options.step,.2);this.updatePosition(a(this.from-i),a(this.to-i)),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var i=this.options,e=i.minWidth>this.calculatedWidth?i.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-e),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-e)}},t.prototype.destroy=function(){var t=this,i=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(i){t[i]&&t[i].destroy&&(t[i]=t[i].destroy())}),i&&t===i.scrollbar&&(i.scrollbar=null,l(i.scrollbarButtons))},t.prototype.drawScrollbarButton=function(i){var e=this.renderer,o=this.scrollbarButtons,r=this.options,n=this.size,s=e.g().add(this.group);if(o.push(s),r.buttonsEnabled){var a=e.rect().addClass("highcharts-scrollbar-button").add(s);this.chart.styledMode||a.attr({stroke:r.buttonBorderColor,"stroke-width":r.buttonBorderWidth,fill:r.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:n+1,height:n+1,r:r.buttonBorderRadius},a.strokeWidth()));var h=e.path(t.swapXY([["M",n/2+(i?-1:1),n/2-3],["L",n/2+(i?-1:1),n/2+3],["L",n/2+(i?2:-2),n/2]],r.vertical)).addClass("highcharts-scrollbar-arrow").add(o[i]);this.chart.styledMode||h.attr({fill:r.buttonArrowColor})}},t.prototype.init=function(t,i,e){this.scrollbarButtons=[],this.renderer=t,this.userOptions=i,this.options=c(o,n.scrollbar,i),this.options.margin=p(this.options.margin,10),this.chart=e,this.size=p(this.options.size,this.options.height),i.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.cursorToScrollbarPosition(e);this.chartX=o.chartX,this.chartY=o.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var i,e,o=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,r=this.options.vertical?"chartY":"chartX",n=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][r])&&(e=this.cursorToScrollbarPosition(o)[r]-this[r],this.hasDragged=!0,this.updatePosition(n[0]+e,n[1]+e),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,i,e,o){var r=this.options,n=r.buttonsEnabled,s=r.margin,a=void 0===s?0:s,h=r.vertical,l=this.rendered?"animate":"attr",d=o,c=0;this.group.show(),this.x=t,this.y=i+this.trackBorderWidth,this.width=e,this.height=o,this.xOffset=d,this.yOffset=c,h?(this.width=this.yOffset=e=c=this.size,this.xOffset=d=0,this.yOffset=c=n?this.size:0,this.barWidth=o-(n?2*e:0),this.x=t+=a):(this.height=o=this.size,this.xOffset=d=n?this.size:0,this.barWidth=e-(n?2*o:0),this.y=this.y+a),this.group[l]({translateX:t,translateY:this.y}),this.track[l]({width:e,height:o}),this.scrollbarButtons[1][l]({translateX:h?0:e-d,translateY:h?o-c:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){u.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var i=this.renderer,e=this.options,o=this.size,r=this.chart.styledMode,n=i.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=n,this.track=i.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:o,width:o}).add(n),r||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var s=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-s%2/2,y:-s%2/2}),this.scrollbarGroup=i.g().add(n),this.scrollbar=i.rect().addClass("highcharts-scrollbar-thumb").attr({height:o-s,width:o-s,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=i.path(t.swapXY([["M",-3,o/4],["L",-3,2*o/3],["M",0,o/4],["L",0,2*o/3],["M",3,o/4],["L",3,2*o/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),r||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,i){var e,o,r=this.options,n=r.vertical,s=r.minWidth,l=this.barWidth,d=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(h(l)){var c=l*Math.min(i,1);e=Math.ceil(l*(t=Math.max(t,0))),this.calculatedWidth=o=a(c-e),o<s&&(e=(l-s+o)*t,o=s);var p=Math.floor(e+this.xOffset+this.yOffset),u=o/2-.5;this.from=t,this.to=i,n?(this.scrollbarGroup[d]({translateY:p}),this.scrollbar[d]({height:o}),this.scrollbarRifles[d]({translateY:u}),this.scrollbarTop=p,this.scrollbarLeft=0):(this.scrollbarGroup[d]({translateX:p}),this.scrollbar[d]({width:o}),this.scrollbarRifles[d]({translateX:u}),this.scrollbarLeft=p,this.scrollbarTop=0),o<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===r.showFull&&(t<=0&&i>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return p(this.options.liveRedraw,i.svg&&!i.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!h(t)},t.prototype.trackClick=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.to-this.from,r=this.y+this.scrollbarTop,n=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>r||!this.options.vertical&&e.chartX>n?this.updatePosition(this.from+o,this.to+o):this.updatePosition(this.from-o,this.to-o),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,c(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,i){i>1&&(t=a(1-a(i-t)),i=1),t<0&&(i=a(i-t),t=0),this.from=t,this.to=i},t.defaultOptions=o,t}();return n.scrollbar=c(!0,f.defaultOptions,n.scrollbar),f}),e(i,"Stock/Navigator/Navigator.js",[i["Core/Axis/Axis.js"],i["Stock/Navigator/ChartNavigatorComposition.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorComposition.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,n,s,a){var h=e.defaultOptions,l=o.isTouchDevice,d=a.addEvent,c=a.clamp,p=a.correctFloat,u=a.defined,f=a.destroyObjectProperties,g=a.erase,x=a.extend,v=a.find,m=a.fireEvent,y=a.isArray,b=a.isNumber,M=a.merge,k=a.pick,A=a.removeEvent,S=a.splat;function w(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];var o=[].filter.call(i,b);if(o.length)return Math[t].apply(0,o)}return function(){function e(t){this.scrollbarHeight=0,this.init(t)}return e.compose=function(t,o,r){i.compose(t,e),n.compose(t,o,r)},e.prototype.drawHandle=function(t,i,e,o){var r=this.navigatorOptions.handles.height;this.handles[i][o](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-r)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-r/2-1)})},e.prototype.drawOutline=function(t,i,e,o){var r,n,s=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),h=a/2,l=a%2/2,d=this.scrollButtonSize,c=this.size,p=this.top,u=this.height,f=p-h,g=p+u,x=this.left;e?(r=p+i+l,i=p+t+l,n=[["M",x+u,p-d-l],["L",x+u,r],["L",x,r],["M",x,i],["L",x+u,i],["L",x+u,p+c+d]],s&&n.push(["M",x+u,r-h],["L",x+u,i+h])):(x-=d,t+=x+d-l,i+=x+d-l,n=[["M",x,f],["L",t,f],["L",t,g],["M",i,g],["L",i,f],["L",x+c+2*d,p+h]],s&&n.push(["M",t-h,f],["L",i+h,f])),this.outline[o]({d:n})},e.prototype.drawMasks=function(t,i,e,o){var r,n,s,a,h=this.left,l=this.top,d=this.height;e?(s=[h,h,h],a=[l,l+t,l+i],n=[d,d,d],r=[t,i-t,this.size-i]):(s=[h,h+t,h+i],a=[l,l,l],n=[t,i-t,this.size-i],r=[d,d,d]),this.shades.forEach(function(t,i){t[o]({x:s[i],y:a[i],width:n[i],height:r[i]})})},e.prototype.renderElements=function(){var t=this,i=t.navigatorOptions,e=i.maskInside,o=t.chart,r=o.inverted,n=o.renderer,s={cursor:r?"ns-resize":"ew-resize"},a=t.navigatorGroup=n.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!e,e,!e].forEach(function(e,r){var h=n.rect().addClass("highcharts-navigator-mask"+(1===r?"-inside":"-outside")).add(a);o.styledMode||(h.attr({fill:e?i.maskFill:"rgba(0,0,0,0)"}),1===r&&h.css(s)),t.shades[r]=h}),t.outline=n.path().addClass("highcharts-navigator-outline").add(a),o.styledMode||t.outline.attr({"stroke-width":i.outlineWidth,stroke:i.outlineColor}),i.handles&&i.handles.enabled){var h=i.handles,l=h.height,d=h.width;[0,1].forEach(function(i){t.handles[i]=n.symbol(h.symbols[i],-d/2-1,0,d,l,h),o.inverted&&t.handles[i].attr({rotation:90,rotationOriginX:Math.floor(-d/2),rotationOriginY:(l+d)/2}),t.handles[i].attr({zIndex:7-i}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][i]).add(a),o.styledMode||t.handles[i].attr({fill:h.backgroundColor,stroke:h.borderColor,"stroke-width":h.lineWidth}).css(s)})}},e.prototype.update=function(t){(this.series||[]).forEach(function(t){t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),M(!0,this.chart.options.navigator,t),this.init(this.chart)},e.prototype.render=function(t,i,e,o){var r,n,s,a,h,l=this.chart,d=this.xAxis,f=d.pointRange||0,g=d.navigatorAxis.fake?l.xAxis[0]:d,x=this.navigatorEnabled,v=this.rendered,y=l.inverted,M=l.xAxis[0].minRange,A=l.xAxis[0].options.maxRange,S=this.scrollButtonSize,w=this.scrollbarHeight;if(!this.hasDragged||u(e)){if(t=p(t-f/2),i=p(i+f/2),!b(t)||!b(i)){if(!v)return;e=0,o=k(d.width,g.width)}this.left=k(d.left,l.plotLeft+S+(y?l.plotWidth:0));var C=this.size=a=k(d.len,(y?l.plotHeight:l.plotWidth)-2*S);r=y?w:a+2*S,e=k(e,d.toPixels(t,!0)),o=k(o,d.toPixels(i,!0)),b(e)&&Math.abs(e)!==1/0||(e=0,o=r);var O=d.toValue(e,!0),P=d.toValue(o,!0),B=Math.abs(p(P-O));B<M?this.grabbedLeft?e=d.toPixels(P-M-f,!0):this.grabbedRight&&(o=d.toPixels(O+M+f,!0)):u(A)&&p(B-f)>A&&(this.grabbedLeft?e=d.toPixels(P-A-f,!0):this.grabbedRight&&(o=d.toPixels(O+A+f,!0))),this.zoomedMax=c(Math.max(e,o),0,C),this.zoomedMin=c(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,o),0,C),this.range=this.zoomedMax-this.zoomedMin,C=Math.round(this.zoomedMax);var E=Math.round(this.zoomedMin);x&&(this.navigatorGroup.attr({visibility:"inherit"}),h=v&&!this.hasDragged?"animate":"attr",this.drawMasks(E,C,y,h),this.drawOutline(E,C,y,h),this.navigatorOptions.handles.enabled&&(this.drawHandle(E,0,y,h),this.drawHandle(C,1,y,h))),this.scrollbar&&(y?(s=this.top-S,n=this.left-w+(x||!g.opposite?0:(g.titleOffset||0)+g.axisTitleMargin),w=a+2*S):(s=this.top+(x?this.height:-w),n=this.left-S),this.scrollbar.position(n,s,r,w),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1))),this.rendered=!0,m(this,"afterRender")}},e.prototype.addMouseEvents=function(){var t,i,e=this,o=e.chart,r=o.container,n=[];e.mouseMoveHandler=t=function(t){e.onMouseMove(t)},e.mouseUpHandler=i=function(t){e.onMouseUp(t)},(n=e.getPartsEvents("mousedown")).push(d(o.renderTo,"mousemove",t),d(r.ownerDocument,"mouseup",i),d(o.renderTo,"touchmove",t),d(r.ownerDocument,"touchend",i)),n.concat(e.getPartsEvents("touchstart")),e.eventsToUnbind=n,e.series&&e.series[0]&&n.push(d(e.series[0].xAxis,"foundExtremes",function(){o.navigator.modifyNavigatorAxisExtremes()}))},e.prototype.getPartsEvents=function(t){var i=this,e=[];return["shades","handles"].forEach(function(o){i[o].forEach(function(r,n){e.push(d(r.element,t,function(t){i[o+"Mousedown"](t,n)}))})}),e},e.prototype.shadesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,o,r,n,s,a=this.chart,h=this.xAxis,l=this.zoomedMin,d=this.size,c=this.range,p=this.left,f=t.chartX;a.inverted&&(f=t.chartY,p=this.top),1===i?(this.grabbedCenter=f,this.fixedWidth=c,this.dragOffset=f-l):(s=f-p-c/2,0===i?s=Math.max(0,s):2===i&&s+c>=d&&(s=d-c,this.reversedExtremes?(s-=c,r=this.getUnionExtremes().dataMin):o=this.getUnionExtremes().dataMax),s!==l&&(this.fixedWidth=c,u((n=h.navigatorAxis.toFixedRange(s,s+c,r,o)).min)&&m(this,"setRange",{min:Math.min(n.min,n.max),max:Math.max(n.min,n.max),redraw:!0,eventArguments:{trigger:"navigator"}})))},e.prototype.handlesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,o=this.chart,r=o.xAxis[0],n=this.reversedExtremes;0===i?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=n?r.min:r.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=n?r.max:r.min),o.setFixedRange(void 0)},e.prototype.onMouseMove=function(t){var i,e,o=this,r=o.chart,n=o.navigatorSize,s=o.range,a=o.dragOffset,h=r.inverted,d=o.left;(!t.touches||0!==t.touches[0].pageX)&&(e=(t=(null===(i=r.pointer)||void 0===i?void 0:i.normalize(t))||t).chartX,h&&(d=o.top,e=t.chartY),o.grabbedLeft?(o.hasDragged=!0,o.render(0,0,e-d,o.otherHandlePos)):o.grabbedRight?(o.hasDragged=!0,o.render(0,0,o.otherHandlePos,e-d)):o.grabbedCenter&&(o.hasDragged=!0,e<a?e=a:e>n+a-s&&(e=n+a-s),o.render(0,0,e-a,e-a+s)),o.hasDragged&&o.scrollbar&&k(o.scrollbar.options.liveRedraw,!l&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){o.onMouseUp(t)},0)))},e.prototype.onMouseUp=function(t){var i,e,o,r,n,s,a=this.chart,h=this.xAxis,l=this.scrollbar,d=t.DOMEvent||t,c=a.inverted,p=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!l||!l.hasDragged)||"scrollbar"===t.trigger)&&(o=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?r=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(n=this.fixedExtreme),this.zoomedMax===this.size&&(n=this.reversedExtremes?o.dataMin:o.dataMax),0===this.zoomedMin&&(r=this.reversedExtremes?o.dataMax:o.dataMin),u((s=h.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,r,n)).min)&&m(this,"setRange",{min:Math.min(s.min,s.max),max:Math.max(s.min,s.max),redraw:!0,animation:!this.hasDragged&&null,eventArguments:{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:d}})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&b(this.zoomedMin)&&b(this.zoomedMax)&&(e=Math.round(this.zoomedMin),i=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,i,c,p),this.outline&&this.drawOutline(e,i,c,p),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,c,p),this.drawHandle(i,1,c,p)))},e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},e.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){A(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&A(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},e.prototype.init=function(i){var e=i.options,o=e.navigator||{},n=o.enabled,a=e.scrollbar||{},h=a.enabled,l=n&&o.height||0,c=h&&a.height||0,p=a.buttonsEnabled&&c||0;this.handles=[],this.shades=[],this.chart=i,this.setBaseSeries(),this.height=l,this.scrollbarHeight=c,this.scrollButtonSize=p,this.scrollbarEnabled=h,this.navigatorEnabled=n,this.navigatorOptions=o,this.scrollbarOptions=a,this.opposite=k(o.opposite,!!(!n&&i.inverted));var u=this,f=u.baseSeries,g=i.xAxis.length,x=i.yAxis.length,v=f&&f[0]&&f[0].xAxis||i.xAxis[0]||{options:{}};if(i.isDirtyBox=!0,u.navigatorEnabled?(u.xAxis=new t(i,M({breaks:v.options.breaks,ordinal:v.options.ordinal,overscroll:v.options.overscroll},o.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},i.inverted?{offsets:[p,0,-p,0],width:l}:{offsets:[0,-p,0,p],height:l}),"xAxis"),u.yAxis=new t(i,M(o.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:x,isInternal:!0,reversed:k(o.yAxis&&o.yAxis.reversed,i.yAxis[0]&&i.yAxis[0].reversed,!1),zoomEnabled:!1},i.inverted?{width:l}:{height:l}),"yAxis"),f||o.series.data?u.updateNavigatorSeries(!1):0===i.series.length&&(u.unbindRedraw=d(i,"beforeRedraw",function(){i.series.length>0&&!u.series&&(u.setBaseSeries(),u.unbindRedraw())})),u.reversedExtremes=i.inverted&&!u.xAxis.reversed||!i.inverted&&u.xAxis.reversed,u.renderElements(),u.addMouseEvents()):(u.xAxis={chart:i,navigatorAxis:{fake:!0},translate:function(t,e){var o=i.xAxis[0],r=o.getExtremes(),n=o.len-2*p,s=w("min",o.options.min,r.dataMin),a=w("max",o.options.max,r.dataMax)-s;return e?t*a/n+s:n*(t-s)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},u.xAxis.navigatorAxis.axis=u.xAxis,u.xAxis.navigatorAxis.toFixedRange=r.prototype.toFixedRange.bind(u.xAxis.navigatorAxis)),i.options.scrollbar.enabled){var m=M(i.options.scrollbar,{vertical:i.inverted});!b(m.margin)&&u.navigatorEnabled&&(m.margin=i.inverted?-3:3),i.scrollbar=u.scrollbar=new s(i.renderer,m,i),d(u.scrollbar,"changed",function(t){var i=u.size,e=i*this.to,o=i*this.from;u.hasDragged=u.scrollbar.hasDragged,u.render(0,0,o,e),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){u.onMouseUp(t)})})}u.addBaseSeriesEvents(),u.addChartEvents()},e.prototype.getUnionExtremes=function(t){var i,e=this.chart.xAxis[0],o=this.xAxis,r=o.options,n=e.options;return t&&null===e.dataMin||(i={dataMin:k(r&&r.min,w("min",n.min,e.dataMin,o.dataMin,o.min)),dataMax:k(r&&r.max,w("max",n.max,e.dataMax,o.dataMax,o.max))}),i},e.prototype.setBaseSeries=function(t,i){var e=this.chart,o=this.baseSeries=[];t=t||e.options&&e.options.navigator.baseSeries||(e.series.length?v(e.series,function(t){return!t.options.isInternal}).index:0),(e.series||[]).forEach(function(i,e){!i.options.isInternal&&(i.options.showInNavigator||(e===t||i.options.id===t)&&!1!==i.options.showInNavigator)&&o.push(i)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,i)},e.prototype.updateNavigatorSeries=function(t,i){var e,o,r,n=this,s=n.chart,a=n.baseSeries,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},d=n.series=(n.series||[]).filter(function(t){var i=t.baseSeries;return!(0>a.indexOf(i))||(i&&(A(i,"updatedData",n.updatedDataHandler),delete i.navigatorSeries),t.chart&&t.destroy(),!1)}),c=n.navigatorOptions.series;a&&a.length&&a.forEach(function(t){var p=t.navigatorSeries,u=x({color:t.color,visible:t.visible},y(c)?h.navigator.series:c);if(!p||!1!==n.navigatorOptions.adaptToUpdatedData){l.name="Navigator "+a.length,r=(e=t.options||{}).navigatorOptions||{},u.dataLabels=S(u.dataLabels),(o=M(e,l,u,r)).pointRange=k(u.pointRange,r.pointRange,h.plotOptions[o.type||"line"].pointRange);var f=r.data||u.data;n.hasNavigatorData=n.hasNavigatorData||!!f,o.data=f||e.data&&e.data.slice(0),p&&p.options?p.update(o,i):(t.navigatorSeries=s.initSeries(o),s.setSortedData(),t.navigatorSeries.baseSeries=t,d.push(t.navigatorSeries))}}),(c.data&&!(a&&a.length)||y(c))&&(n.hasNavigatorData=!1,(c=S(c)).forEach(function(t,i){l.name="Navigator "+(d.length+1),(o=M(h.navigator.series,{color:s.series[i]&&!s.series[i].options.isInternal&&s.series[i].color||s.options.colors[i]||s.options.colors[0]},l,t)).data=t.data,o.data&&(n.hasNavigatorData=!0,d.push(s.initSeries(o)))})),t&&this.addBaseSeriesEvents()},e.prototype.addBaseSeriesEvents=function(){var t=this,i=this,e=i.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(d(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(e){e.eventsToUnbind.push(d(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(d(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(d(e,"updatedData",t.updatedDataHandler)),e.eventsToUnbind.push(d(e,"remove",function(){this.navigatorSeries&&(g(i.series,this.navigatorSeries),u(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},e.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,i){return Math.min(t,i.xData&&i.xData.length?i.xData[0]:t)},t)},e.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var i=this.getUnionExtremes(!0);i&&(i.dataMin!==t.min||i.dataMax!==t.max)&&(t.min=i.dataMin,t.max=i.dataMax)}},e.prototype.modifyBaseAxisExtremes=function(){var t,i,e,o=this.chart.navigator,r=this.getExtremes(),n=r.min,s=r.max,a=r.dataMin,h=r.dataMax,l=s-n,d=o.stickToMin,c=o.stickToMax,p=k(null===(t=this.ordinal)||void 0===t?void 0:t.convertOverscroll(this.options.overscroll),0),u=o.series&&o.series[0],f=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(d&&(i=(e=a)+l),c&&(i=h+p,d||(e=Math.max(a,i-l,o.getBaseSeriesMin(u&&u.xData?u.xData[0]:-Number.MAX_VALUE)))),f&&(d||c)&&b(e)&&(this.min=this.userMin=e,this.max=this.userMax=i)),o.stickToMin=o.stickToMax=null},e.prototype.updatedDataHandler=function(){var t=this.chart.navigator,i=this.navigatorSeries,e=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=k(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,e),t.stickToMin=t.shouldStickToMin(this,t),i&&!t.hasNavigatorData&&(i.options.pointStart=this.xData[0],i.setData(this.options.data,!1,null,!1))},e.prototype.shouldStickToMin=function(t,i){var e=i.getBaseSeriesMin(t.xData[0]),o=t.xAxis,r=o.max,n=o.min,s=o.options.range;return!!(b(r)&&b(n))&&(s&&r-e>0?r-e<s:n<=e)},e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(d(this.chart,"redraw",function(){var t=this.navigator,i=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);i&&t.render(i.min,i.max)}),d(this.chart,"getMargins",function(){var t=this.navigator,i=t.opposite?"plotTop":"marginBottom";this.inverted&&(i=t.opposite?"marginRight":"plotLeft"),this[i]=(this[i]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}),d(e,"setRange",function(t){this.chart.xAxis[0].setExtremes(t.min,t.max,t.redraw,t.animation,t.eventArguments)}))},e.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(g(this.chart.xAxis,this.xAxis),g(this.chart.axes,this.xAxis)),this.yAxis&&(g(this.chart.yAxis,this.yAxis),g(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(i){t[i]&&t[i].destroy&&t[i].destroy(),t[i]=null}),[this.handles].forEach(function(t){f(t)})},e}()}),e(i,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),e(i,"Stock/RangeSelector/RangeSelectorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o){var r,n=t.defaultOptions,s=i.composed,a=o.addEvent,h=o.defined,l=o.extend,d=o.find,c=o.isNumber,p=o.merge,u=o.pick,f=o.pushUnique,g=[];function x(){var t,i,e=this.range,o=e.type,r=this.max,n=this.chart.time,s=function(t,i){var e="year"===o?"FullYear":"Month",r=new n.Date(t),s=n.get(e,r);return n.set(e,r,s+i),s===n.get(e,r)&&n.set("Date",r,0),r.getTime()-t};c(e)?(t=r-e,i=e):e&&(t=r+s(r,-(e.count||1)),this.chart&&this.chart.setFixedRange(r-t));var a=u(this.dataMin,Number.MIN_VALUE);return c(t)||(t=a),t<=a&&(t=a,void 0===i&&(i=s(t,e.count)),this.newMax=Math.min(t+i,u(this.dataMax,Number.MAX_VALUE))),c(r)?!c(e)&&e&&e._offsetMin&&(t+=e._offsetMin):t=void 0,t}function v(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new r(this))}function m(){var t=this.axes,i=this.rangeSelector;if(i){c(i.deferredYTDClick)&&(i.clickButton(i.deferredYTDClick),delete i.deferredYTDClick),t.forEach(function(t){t.updateNames(),t.setScale()}),this.getAxisMargins(),i.render();var e=i.options.verticalAlign;i.options.floating||("bottom"===e?this.extraBottomMargin=!0:"middle"===e||(this.extraTopMargin=!0))}}function y(t){var i,e,o,r,n=t.rangeSelector,s=function(){n&&(i=t.xAxis[0].getExtremes(),e=t.legend,r=n&&n.options.verticalAlign,c(i.min)&&n.render(i.min,i.max),e.display&&"top"===r&&r===e.options.verticalAlign&&(o=p(t.spacingBox),"vertical"===e.options.layout?o.y=t.plotTop:o.y+=n.getHeight(),e.group.placed=!1,e.align(o)))};n&&(d(g,function(i){return i[0]===t})||g.push([t,[a(t.xAxis[0],"afterSetExtremes",function(t){n&&n.render(t.min,t.max)}),a(t,"redraw",s)]]),s())}function b(){for(var t=0,i=g.length;t<i;++t){var e=g[t];if(e[0]===this){e[1].forEach(function(t){return t()}),g.splice(t,1);return}}}function M(){var t=this.rangeSelector;if(t){var i=t.getHeight();this.extraTopMargin&&(this.plotTop+=i),this.extraBottomMargin&&(this.marginBottom+=i)}}function k(){var t=this.rangeSelector;if(t&&!t.options.floating){t.render();var i=t.options.verticalAlign;"bottom"===i?this.extraBottomMargin=!0:"middle"!==i&&(this.extraTopMargin=!0)}}function A(t){var i=t.options.rangeSelector,e=this.extraBottomMargin,o=this.extraTopMargin,n=this.rangeSelector;if(i&&i.enabled&&!h(n)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=n=new r(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,n){y(this);var s=i&&i.verticalAlign||n.options&&n.options.verticalAlign;n.options.floating||("bottom"===s?this.extraBottomMargin=!0:"middle"===s||(this.extraTopMargin=!0)),(this.extraBottomMargin!==e||this.extraTopMargin!==o)&&(this.isDirtyBox=!0)}}return{compose:function(t,i,o){if(r=o,f(s,"RangeSelector")){var h=i.prototype;t.prototype.minFromRange=x,a(i,"afterGetContainer",v),a(i,"beforeRender",m),a(i,"destroy",b),a(i,"getMargins",M),a(i,"render",k),a(i,"update",A),h.callbacks.push(y),l(n,{rangeSelector:e.rangeSelector}),l(n.lang,e.lang)}}}}),e(i,"Stock/RangeSelector/RangeSelector.js",[i["Core/Axis/Axis.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorComposition.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,n){var s=i.defaultOptions,a=n.addEvent,h=n.createElement,l=n.css,d=n.defined,c=n.destroyObjectProperties,p=n.discardElement,u=n.extend,f=n.fireEvent,g=n.isNumber,x=n.merge,v=n.objectEach,m=n.pad,y=n.pick,b=n.pInt,M=n.splat,k=function(){function i(t){this.buttonOptions=i.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.chart=t,this.init(t)}return i.compose=function(t,e){o.compose(t,e,i)},i.prototype.clickButton=function(i,e){var o,r,n,s,h,l,c,p=this.chart,u=this.buttonOptions[i],x=p.xAxis[0],v=p.scroller&&p.scroller.getUnionExtremes()||x||{},m=u.type,b=u.dataGrouping,k=v.dataMin,A=v.dataMax,S=x&&Math.round(Math.min(x.max,y(A,x.max))),w=u._range,C=!0;if(null!==k&&null!==A){if(this.setSelected(i),b&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(x||{chart:this.chart},b,!1),this.frozenStates=u.preserveDataGrouping),"month"===m||"year"===m)x?(l={range:u,max:S,chart:p,dataMin:k,dataMax:A},o=x.minFromRange.call(l),g(l.newMax)&&(S=l.newMax),C=!1):w=u;else if(w)S=Math.min((o=Math.max(S-w,k))+w,A),C=!1;else if("ytd"===m){if(x)(void 0===A||void 0===k)&&(k=Number.MAX_VALUE,A=Number.MIN_VALUE,p.series.forEach(function(t){var i=t.xData;i&&(k=Math.min(i[0],k),A=Math.max(i[i.length-1],A))}),e=!1),o=n=(c=this.getYTDExtremes(A,k,p.time.useUTC)).min,S=c.max;else{this.deferredYTDClick=i;return}}else"all"===m&&x&&(p.navigator&&p.navigator.baseSeries[0]&&(p.navigator.baseSeries[0].xAxis.options.range=void 0),o=k,S=A);C&&u._offsetMin&&d(o)&&(o+=u._offsetMin),u._offsetMax&&d(S)&&(S+=u._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=i+1),x?(x.setExtremes(o,S,y(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:u}),p.setFixedRange(u._range)):(h=(r=M(p.options.xAxis)[0]).range,r.range=w,s=r.min,r.min=n,a(p,"load",function(){p.setFixedRange(u._range),r.range=h,r.min=s})),f(this,"afterBtnClick")}},i.prototype.setSelected=function(t){this.selected=this.options.selected=t},i.prototype.init=function(t){var i=this,e=t.options.rangeSelector,o=e.buttons||i.defaultButtons.slice(),r=e.selected,n=function(){var t=i.minInput,e=i.maxInput;t&&t.blur&&f(t,"blur"),e&&e.blur&&f(e,"blur")};i.chart=t,i.options=e,i.buttons=[],i.buttonOptions=o,this.eventsToUnbind=[],this.eventsToUnbind.push(a(t.container,"mousedown",n)),this.eventsToUnbind.push(a(t,"resize",n)),o.forEach(i.computeButtonRange),void 0!==r&&o[r]&&this.clickButton(r,!1),this.eventsToUnbind.push(a(t,"load",function(){t.xAxis&&t.xAxis[0]&&a(t.xAxis[0],"setExtremes",function(e){g(this.max)&&g(this.min)&&this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==e.trigger&&"updatedData"!==e.trigger&&i.forcedDataGrouping&&!i.frozenStates&&this.setDataGrouping(!1,!1)})}))},i.prototype.updateButtonStates=function(){var t=this,i=this.chart,e=this.dropdown,o=i.xAxis[0],r=Math.round(o.max-o.min),n=!o.hasVisibleSeries,s=24*36e5,a=i.scroller&&i.scroller.getUnionExtremes()||o,h=a.dataMin,l=a.dataMax,c=t.getYTDExtremes(l,h,i.time.useUTC),p=c.min,u=c.max,f=t.selected,x=t.options.allButtonsEnabled,v=t.buttons,m=g(f),y=!1;t.buttonOptions.forEach(function(i,a){var c,g=i._range,b=i.type,M=i.count||1,k=v[a],A=i._offsetMax-i._offsetMin,S=a===f,w=g>l-h,C=g<o.minRange,O=0,P=!1,B=!1,E=g===r;if(S&&w&&(y=!0),o.isOrdinal&&(null===(c=o.ordinal)||void 0===c?void 0:c.positions)&&g&&r<g){var T=o.ordinal.positions;T[T.length-1]-T[0]>g&&(E=!0)}else("month"===b||"year"===b)&&r+36e5>=({month:28,year:365})[b]*s*M-A&&r-36e5<=({month:31,year:366})[b]*s*M+A?E=!0:"ytd"===b?(E=u-p+A===r,P=!S):"all"===b&&(E=o.max-o.min>=l-h,B=!S&&m&&E);var j=!x&&!(y&&"all"===b)&&(w||C||B||n),D=y&&"all"===b||S&&E||E&&!m&&!P||S&&t.frozenStates;j?O=3:D&&(m=!0,O=2),k.state!==O&&(k.setState(O),e&&(e.options[a+1].disabled=j,2===O&&(e.selectedIndex=a+1)),0===O&&f===a?t.setSelected():(2===O&&!d(f)||y)&&t.setSelected(a))})},i.prototype.computeButtonRange=function(t){var i=t.type,e=t.count||1,o={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};o[i]?t._range=o[i]*e:("month"===i||"year"===i)&&(t._range=24*({month:30,year:365})[i]*36e5*e),t._offsetMin=y(t.offsetMin,0),t._offsetMax=y(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin},i.prototype.getInputValue=function(t){var i="min"===t?this.minInput:this.maxInput,e=this.chart.options.rangeSelector,o=this.chart.time;return i?("text"===i.type&&e.inputDateParser||this.defaultInputDateParser)(i.value,o.useUTC,o):0},i.prototype.setInputValue=function(t,i){var e=this.options,o=this.chart.time,r="min"===t?this.minInput:this.maxInput,n="min"===t?this.minDateBox:this.maxDateBox;if(r){var s=r.getAttribute("data-hc-time"),a=d(s)?Number(s):void 0;if(d(i)){var h=a;d(h)&&r.setAttribute("data-hc-time-previous",h),r.setAttribute("data-hc-time",i),a=i}r.value=o.dateFormat(this.inputTypeFormats[r.type]||e.inputEditDateFormat,a),n&&n.attr({text:o.dateFormat(e.inputDateFormat,a)})}},i.prototype.setInputExtremes=function(t,i,e){var o="min"===t?this.minInput:this.maxInput;if(o){var r=this.inputTypeFormats[o.type],n=this.chart.time;if(r){var s=n.dateFormat(r,i);o.min!==s&&(o.min=s);var a=n.dateFormat(r,e);o.max!==a&&(o.max=a)}}},i.prototype.showInput=function(t){var i="min"===t?this.minDateBox:this.maxDateBox,e="min"===t?this.minInput:this.maxInput;if(e&&i&&this.inputGroup){var o="text"===e.type,r=this.inputGroup,n=r.translateX,s=void 0===n?0:n,a=r.translateY,h=void 0===a?0:a,d=i.x,c=void 0===d?0:d,p=i.width,u=void 0===p?0:p,f=i.height,g=void 0===f?0:f,x=this.options.inputBoxWidth;l(e,{width:o?u+(x?-2:20)+"px":"auto",height:g-2+"px",border:"2px solid silver"}),o&&x?l(e,{left:s+c+"px",top:h+"px"}):l(e,{left:Math.min(Math.round(c+s-(e.offsetWidth-u)/2),this.chart.chartWidth-e.offsetWidth)+"px",top:h-(e.offsetHeight-g)/2+"px"})}},i.prototype.hideInput=function(t){var i="min"===t?this.minInput:this.maxInput;i&&l(i,{top:"-9999em",border:0,width:"1px",height:"1px"})},i.prototype.defaultInputDateParser=function(t,i,o){var r,n=t.split("/").join("-").split(" ").join("T");if(-1===n.indexOf("T")&&(n+="T00:00"),i)n+="Z";else if(e.isSafari&&!((r=n).length>6&&(r.lastIndexOf("-")===r.length-6||r.lastIndexOf("+")===r.length-6))){var s=new Date(n).getTimezoneOffset()/60;n+=s<=0?"+".concat(m(-s),":00"):"-".concat(m(s),":00")}var a=Date.parse(n);if(!g(a)){var h=t.split("-");a=Date.UTC(b(h[0]),b(h[1])-1,b(h[2]))}return o&&i&&g(a)&&(a+=o.getTimezoneOffset(a)),a},i.prototype.drawInput=function(t){var i=this.chart,o=this.div,r=this.inputGroup,n=this,a=i.renderer.style||{},d=i.renderer,c=i.options.rangeSelector,p=s.lang,f="min"===t;function v(){var e=n.maxInput,o=n.minInput,r=i.xAxis[0],s=i.scroller&&i.scroller.getUnionExtremes()||r,a=s.dataMin,h=s.dataMax,l=n.getInputValue(t);l!==Number(M.getAttribute("data-hc-time-previous"))&&g(l)&&(M.setAttribute("data-hc-time-previous",l),f&&e&&g(a)?l>Number(e.getAttribute("data-hc-time"))?l=void 0:l<a&&(l=a):o&&g(h)&&(l<Number(o.getAttribute("data-hc-time"))?l=void 0:l>h&&(l=h)),void 0!==l&&r.setExtremes(f?l:r.min,f?r.max:l,void 0,void 0,{trigger:"rangeSelectorInput"}))}var m=p[f?"rangeSelectorFrom":"rangeSelectorTo"]||"",y=d.label(m,0).addClass("highcharts-range-label").attr({padding:m?2:0,height:m?c.inputBoxHeight:0}).add(r),b=d.label("",0).addClass("highcharts-range-input").attr({padding:2,width:c.inputBoxWidth,height:c.inputBoxHeight,"text-align":"center"}).on("click",function(){n.showInput(t),n[t+"Input"].focus()});i.styledMode||b.attr({stroke:c.inputBoxBorderColor,"stroke-width":1}),b.add(r);var M=h("input",{name:t,className:"highcharts-range-selector"},void 0,o);M.setAttribute("type",function(t){if(-1!==t.indexOf("%L"))return"text";var i=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(i){return -1!==t.indexOf("%"+i)}),e=["H","k","I","l","M","S"].some(function(i){return -1!==t.indexOf("%"+i)});return i&&e?"datetime-local":i?"date":e?"time":"text"}(c.inputDateFormat||"%e %b %Y")),i.styledMode||(y.css(x(a,c.labelStyle)),b.css(x({color:"#333333"},a,c.inputStyle)),l(M,u({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:a.fontSize,fontFamily:a.fontFamily,top:"-9999em"},c.inputStyle))),M.onfocus=function(){n.showInput(t)},M.onblur=function(){M===e.doc.activeElement&&v(),n.hideInput(t),n.setInputValue(t),M.blur()};var k=!1;return M.onchange=function(){k||(v(),n.hideInput(t),M.blur())},M.onkeypress=function(t){13===t.keyCode&&v()},M.onkeydown=function(t){k=!0,(38===t.keyCode||40===t.keyCode)&&v()},M.onkeyup=function(){k=!1},{dateBox:b,input:M,label:y}},i.prototype.getPosition=function(){var t=this.chart,i=t.options.rangeSelector,e="top"===i.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:e+i.buttonPosition.y,inputTop:e+i.inputPosition.y-10}},i.prototype.getYTDExtremes=function(t,i,e){var o=this.chart.time,r=new o.Date(t),n=o.get("FullYear",r),s=e?o.Date.UTC(n,0,1):+new o.Date(n,0,1),a=r.getTime();return{max:Math.min(t||a,a),min:Math.max(i,s)}},i.prototype.render=function(t,i){var e=this.chart,o=e.renderer,r=e.container,n=e.options,s=n.rangeSelector,a=y(n.chart.style&&n.chart.style.zIndex,0)+1,l=s.inputEnabled,c=this.rendered;if(!1!==s.enabled){if(!c&&(this.group=o.g("range-selector-group").attr({zIndex:7}).add(),this.div=h("div",void 0,{position:"relative",height:0,zIndex:a}),this.buttonOptions.length&&this.renderButtons(),r.parentNode&&r.parentNode.insertBefore(this.div,r),l)){this.inputGroup=o.g("input-group").add(this.group);var p=this.drawInput("min");this.minDateBox=p.dateBox,this.minLabel=p.label,this.minInput=p.input;var u=this.drawInput("max");this.maxDateBox=u.dateBox,this.maxLabel=u.label,this.maxInput=u.input}if(l){this.setInputValue("min",t),this.setInputValue("max",i);var f=e.scroller&&e.scroller.getUnionExtremes()||e.xAxis[0]||{};if(d(f.dataMin)&&d(f.dataMax)){var g=e.xAxis[0].minRange||0;this.setInputExtremes("min",f.dataMin,Math.min(f.dataMax,this.getInputValue("max"))-g),this.setInputExtremes("max",Math.max(f.dataMin,this.getInputValue("min"))+g,f.dataMax)}if(this.inputGroup){var x=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(t){if(t){var i=t.getBBox().width;i&&(t.attr({x:x}),x+=i+s.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},i.prototype.renderButtons=function(){var t=this,i=this.buttons,o=this.chart,r=this.options,n=s.lang,l=o.renderer,d=x(r.buttonTheme),c=d&&d.states,p=d.width||28;delete d.width,delete d.states,this.buttonGroup=l.g("range-selector-buttons").add(this.group);var u=this.dropdown=h("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);a(u,"touchstart",function(){u.style.fontSize="16px"}),[[e.isMS?"mouseover":"mouseenter"],[e.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(e){var o=e[0],r=e[1];a(u,o,function(){var e=i[t.currentButtonIndex()];e&&f(e.element,r||o)})}),this.zoomText=l.label(n&&n.rangeSelectorZoom||"",0).attr({padding:r.buttonTheme.padding,height:r.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(r.labelStyle),d["stroke-width"]=y(d["stroke-width"],0)),h("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,u),this.buttonOptions.forEach(function(e,o){h("option",{textContent:e.title||e.text},void 0,u),i[o]=l.button(e.text,0,0,function(i){var r,n=e.events&&e.events.click;n&&(r=n.call(e,i)),!1!==r&&t.clickButton(o),t.isActive=!0},d,c&&c.hover,c&&c.select,c&&c.disabled).attr({"text-align":"center",width:p}).add(t.buttonGroup),e.title&&i[o].attr("title",e.title)})},i.prototype.alignElements=function(){var t=this,i=this.buttonGroup,e=this.buttons,o=this.chart,r=this.group,n=this.inputGroup,s=this.options,a=this.zoomText,h=o.options,l=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions,d=s.buttonPosition,c=s.inputPosition,p=s.verticalAlign,u=function(i,e){return l&&t.titleCollision(o)&&"top"===p&&"right"===e.align&&e.y-i.getBBox().height-12<(l.y||0)+(l.height||0)+o.spacing[0]?-40:0},f=o.plotLeft;if(r&&d&&c){var g=d.x-o.spacing[3];if(i){if(this.positionButtons(),!this.initialButtonGroupWidth){var x=0;a&&(x+=a.getBBox().width+5),e.forEach(function(t,i){x+=t.width||0,i!==e.length-1&&(x+=s.buttonSpacing)}),this.initialButtonGroupWidth=x}f-=o.spacing[3],this.updateButtonStates();var v=u(i,d);this.alignButtonGroup(v),r.placed=i.placed=o.hasLoaded}var m=0;n&&(m=u(n,c),"left"===c.align?g=f:"right"===c.align&&(g=-Math.max(o.axisOffset[1],-m)),n.align({y:c.y,width:n.getBBox().width,align:c.align,x:c.x+g-2},!0,o.spacingBox),n.placed=o.hasLoaded),this.handleCollision(m),r.align({verticalAlign:p},!0,o.spacingBox);var b=r.alignAttr.translateY,M=r.getBBox().height+20,k=0;if("bottom"===p){var A=o.legend&&o.legend.options;k=b-(M=M+(A&&"bottom"===A.verticalAlign&&A.enabled&&!A.floating?o.legend.legendHeight+y(A.margin,10):0)-20)-(s.floating?0:s.y)-(o.titleOffset?o.titleOffset[2]:0)-10}"top"===p?(s.floating&&(k=0),o.titleOffset&&o.titleOffset[0]&&(k=o.titleOffset[0]),k+=o.margin[0]-o.spacing[0]||0):"middle"===p&&(c.y===d.y?k=b:(c.y||d.y)&&(c.y<0||d.y<0?k-=Math.min(c.y,d.y):k=b-M)),r.translate(s.x,s.y+Math.floor(k));var S=this.minInput,w=this.maxInput,C=this.dropdown;s.inputEnabled&&S&&w&&(S.style.marginTop=r.translateY+"px",w.style.marginTop=r.translateY+"px"),C&&(C.style.marginTop=r.translateY+"px")}},i.prototype.alignButtonGroup=function(t,i){var e=this.chart,o=this.options,r=this.buttonGroup,n=o.buttonPosition,s=e.plotLeft-e.spacing[3],a=n.x-e.spacing[3];"right"===n.align?a+=t-s:"center"===n.align&&(a-=s/2),r&&r.align({y:n.y,width:y(i,this.initialButtonGroupWidth),align:n.align,x:a},!0,e.spacingBox)},i.prototype.positionButtons=function(){var t=this.buttons,i=this.chart,e=this.options,o=this.zoomText,r=i.hasLoaded?"animate":"attr",n=e.buttonPosition,s=i.plotLeft,a=s;o&&"hidden"!==o.visibility&&(o[r]({x:y(s+n.x,s)}),a+=n.x+o.getBBox().width+5);for(var h=0,l=this.buttonOptions.length;h<l;++h)"hidden"!==t[h].visibility?(t[h][r]({x:a}),a+=(t[h].width||0)+e.buttonSpacing):t[h][r]({x:s})},i.prototype.handleCollision=function(t){var i=this,e=this.chart,o=this.buttonGroup,r=this.inputGroup,n=this.options,s=n.buttonPosition,a=n.dropdown,h=n.inputPosition,l=function(){var t=0;return i.buttons.forEach(function(i){var e=i.getBBox();e.width>t&&(t=e.width)}),t},d=function(i){if(r&&o){var e=r.alignAttr.translateX+r.alignOptions.x-t+r.getBBox().x+2,n=r.alignOptions.width,a=o.alignAttr.translateX+o.getBBox().x;return a+i>e&&e+n>a&&s.y<h.y+r.getBBox().height}return!1},c=function(){r&&o&&r.attr({translateX:r.alignAttr.translateX+(e.axisOffset[1]>=-t?0:-t),translateY:r.alignAttr.translateY+o.getBBox().height+10})};if(o){if("always"===a){this.collapseButtons(t),d(l())&&c();return}"never"===a&&this.expandButtons()}r&&o?h.align===s.align||d(this.initialButtonGroupWidth+20)?"responsive"===a?(this.collapseButtons(t),d(l())&&c()):c():"responsive"===a&&this.expandButtons():o&&"responsive"===a&&(this.initialButtonGroupWidth>e.plotWidth?this.collapseButtons(t):this.expandButtons())},i.prototype.collapseButtons=function(t){var i=this.buttons,e=this.buttonOptions,o=this.chart,r=this.dropdown,n=this.options,s=this.zoomText;if(!0!==this.isCollapsed){this.isCollapsed=!0;var a=o.userOptions.rangeSelector&&o.userOptions.rangeSelector.buttonTheme||{},h=function(t){return{text:t?"".concat(t," ▾"):"▾",width:"auto",paddingLeft:y(n.buttonTheme.paddingLeft,a.padding,8),paddingRight:y(n.buttonTheme.paddingRight,a.padding,8)}};s&&s.hide();var l=!1;e.forEach(function(t,e){var o=i[e];2!==o.state?o.hide():(o.show(),o.attr(h(t.text)),l=!0)}),l||(r&&(r.selectedIndex=0),i[0].show(),i[0].attr(h(this.zoomText&&this.zoomText.textStr)));var d=n.buttonPosition.align;this.positionButtons(),("right"===d||"center"===d)&&this.alignButtonGroup(t,i[this.currentButtonIndex()].getBBox().width),this.showDropdown()}},i.prototype.expandButtons=function(){var t=this.buttons,i=this.buttonOptions,e=this.options,o=this.zoomText;this.hideDropdown(),!1!==this.isCollapsed&&(this.isCollapsed=!1,o&&o.show(),i.forEach(function(i,o){var r=t[o];r.show(),r.attr({text:i.text,width:e.buttonTheme.width||28,paddingLeft:y(e.buttonTheme.paddingLeft,"unset"),paddingRight:y(e.buttonTheme.paddingRight,"unset")}),r.state<2&&r.setState(0)}),this.positionButtons())},i.prototype.currentButtonIndex=function(){var t=this.dropdown;return t&&t.selectedIndex>0?t.selectedIndex-1:0},i.prototype.showDropdown=function(){var t=this.buttonGroup,i=this.buttons,e=this.chart,o=this.dropdown;if(t&&o){var r=t.translateX,n=t.translateY,s=i[this.currentButtonIndex()].getBBox();l(o,{left:e.plotLeft+(void 0===r?0:r)+"px",top:(void 0===n?0:n)+.5+"px",width:s.width+"px",height:s.height+"px"}),this.hasVisibleDropdown=!0}},i.prototype.hideDropdown=function(){var t=this.dropdown;t&&(l(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},i.prototype.getHeight=function(){var t=this.options,i=this.group,e=t.inputPosition,o=t.buttonPosition,r=t.y,n=o.y,s=e.y,a=0;return t.height?t.height:(this.alignElements(),a=i?i.getBBox(!0).height+13+r:0,(s<0&&n<0||s>0&&n>0)&&(a+=Math.abs(Math.min(s,n))),a)},i.prototype.titleCollision=function(t){return!(t.options.title.text||t.options.subtitle.text)},i.prototype.update=function(t){var i=this.chart;x(!0,i.options.rangeSelector,t),this.destroy(),this.init(i),this.render()},i.prototype.destroy=function(){var t=this,e=t.minInput,o=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(function(t){return t()}),t.eventsToUnbind=void 0),c(t.buttons),e&&(e.onfocus=e.onblur=e.onchange=null),o&&(o.onfocus=o.onblur=o.onchange=null),v(t,function(e,o){e&&"chart"!==o&&(e instanceof r?e.destroy():e instanceof window.HTMLElement&&p(e)),e!==i.prototype[o]&&(t[o]=null)},this)},i}();return u(k.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),k}),e(i,"Series/PathUtilities.js",[],function(){function t(t,i){for(var e=[],o=0;o<t.length;o++){var r=t[o][1],n=t[o][2];if("number"==typeof r&&"number"==typeof n){if(0===o)e.push(["M",r,n]);else if(o===t.length-1)e.push(["L",r,n]);else if(i){var s=t[o-1],a=t[o+1];if(s&&a){var h=s[1],l=s[2],d=a[1],c=a[2];if("number"==typeof h&&"number"==typeof d&&"number"==typeof l&&"number"==typeof c&&h!==d&&l!==c){var p=h<d?1:-1,u=l<c?1:-1;e.push(["L",r-p*Math.min(Math.abs(r-h),i),n-u*Math.min(Math.abs(n-l),i)],["C",r,n,r,n,r+p*Math.min(Math.abs(r-d),i),n+u*Math.min(Math.abs(n-c),i)])}}}else e.push(["L",r,n])}}return e}return{applyRadius:t,getLinkPath:{default:function(i){var e=i.x1,o=i.y1,r=i.x2,n=i.y2,s=i.width,a=void 0===s?0:s,h=i.inverted,l=void 0!==h&&h,d=i.radius,c=i.parentVisible,p=[["M",e,o],["L",e,o],["C",e,o,e,n,e,n],["L",e,n],["C",e,o,e,n,e,n],["L",e,n]];return c?t([["M",e,o],["L",e+a*(l?-.5:.5),o],["L",e+a*(l?-.5:.5),n],["L",r,n]],d):p},straight:function(t){var i=t.x1,e=t.y1,o=t.x2,r=t.y2,n=t.width,s=t.inverted;return t.parentVisible?[["M",i,e],["L",i+(void 0===n?0:n)*(void 0!==s&&s?-1:1),r],["L",o,r]]:[["M",i,e],["L",i,r],["L",i,r]]},curved:function(t){var i=t.x1,e=t.y1,o=t.x2,r=t.y2,n=t.offset,s=void 0===n?0:n,a=t.width,h=void 0===a?0:a,l=t.inverted,d=void 0!==l&&l;return t.parentVisible?[["M",i,e],["C",i+s,e,i-s+h*(d?-1:1),r,i+h*(d?-1:1),r],["L",o,r]]:[["M",i,e],["C",i,e,i,r,i,r],["L",o,r]]}}}}),e(i,"Gantt/PathfinderAlgorithms.js",[i["Series/PathUtilities.js"],i["Core/Utilities.js"]],function(t,i){var e=i.pick,o=Math.min,r=Math.max,n=Math.abs;function s(t,i,e){for(var o,r,n=i-1e-7,s=e||0,a=t.length-1;s<=a;)if((r=n-t[o=a+s>>1].xMin)>0)s=o+1;else{if(!(r<0))return o;a=o-1}return s>0?s-1:0}function a(t,i){for(var e,o=s(t,i.x+1)+1;o--;)if(t[o].xMax>=i.x&&(e=t[o],i.x<=e.xMax&&i.x>=e.xMin&&i.y<=e.yMax&&i.y>=e.yMin))return o;return -1}function h(t){var i=[];if(t.length){i.push(["M",t[0].start.x,t[0].start.y]);for(var e=0;e<t.length;++e)i.push(["L",t[e].end.x,t[e].end.y])}return i}function l(t,i){t.yMin=r(t.yMin,i.yMin),t.yMax=o(t.yMax,i.yMax),t.xMin=r(t.xMin,i.xMin),t.xMax=o(t.xMax,i.xMax)}var d=function(i,o,r){var s,l,d,c,p,u=[],f=r.chartObstacles,g=a(f,i),x=a(f,o),v=e(r.startDirectionX,n(o.x-i.x)>n(o.y-i.y))?"x":"y";function m(t,i,e,o,r){var n={x:t.x,y:t.y};return n[i]=e[o||i]+(r||0),n}function y(t,i,e){var o=n(i[e]-t[e+"Min"])>n(i[e]-t[e+"Max"]);return m(i,e,t,e+(o?"Max":"Min"),o?1:-1)}x>-1?(s={start:d=y(f[x],o,v),end:o},p=d):p=o,g>-1&&(d=y(l=f[g],i,v),u.push({start:i,end:d}),d[v]>=i[v]==d[v]>=p[v]&&(c=i[v="y"===v?"x":"y"]<o[v],u.push({start:d,end:m(d,v,l,v+(c?"Max":"Min"),c?1:-1)}),v="y"===v?"x":"y"));var b=u.length?u[u.length-1].end:i;d=m(b,v,p),u.push({start:b,end:d});var M=m(d,v="y"===v?"x":"y",p);return u.push({start:d,end:M}),u.push(s),{path:t.applyRadius(h(u),r.radius),obstacles:u}};function c(t,i,d){var c,p,u,f,g,x,v,m=e(d.startDirectionX,n(i.x-t.x)>n(i.y-t.y)),y=m?"x":"y",b=[],M=d.obstacleMetrics,k=o(t.x,i.x)-M.maxWidth-10,A=r(t.x,i.x)+M.maxWidth+10,S=o(t.y,i.y)-M.maxHeight-10,w=r(t.y,i.y)+M.maxHeight+10,C=!1,O=d.chartObstacles,P=s(O,A),B=s(O,k);function E(t,i,e){var r,n,a,h,l=t.x<i.x?1:-1;t.x<i.x?(r=t,n=i):(r=i,n=t),t.y<i.y?(h=t,a=i):(h=i,a=t);for(var d=l<0?o(s(O,n.x),O.length-1):0;O[d]&&(l>0&&O[d].xMin<=n.x||l<0&&O[d].xMax>=r.x);){if(O[d].xMin<=n.x&&O[d].xMax>=r.x&&O[d].yMin<=a.y&&O[d].yMax>=h.y){if(e)return{y:t.y,x:t.x<i.x?O[d].xMin-1:O[d].xMax+1,obstacle:O[d]};return{x:t.x,y:t.y<i.y?O[d].yMin-1:O[d].yMax+1,obstacle:O[d]}}d+=l}return i}function T(t,i,e,o,r){var s=r.soft,a=r.hard,h=o?"x":"y",l={x:i.x,y:i.y},d={x:i.x,y:i.y},c=t[h+"Max"]>=s[h+"Max"],p=t[h+"Min"]<=s[h+"Min"],u=t[h+"Max"]>=a[h+"Max"],f=t[h+"Min"]<=a[h+"Min"],g=n(t[h+"Min"]-i[h]),x=n(t[h+"Max"]-i[h]),v=10>n(g-x)?i[h]<e[h]:x<g;d[h]=t[h+"Min"],l[h]=t[h+"Max"];var m=E(i,d,o)[h]!==d[h],y=E(i,l,o)[h]!==l[h];return v=m?!y||v:!y&&v,v=p?!c||v:!c&&v,v=f?!u||v:!u&&v}for((P=a(O=O.slice(B,P+1),i))>-1&&(c=O[P],p=i,u=o(c.xMax-p.x,p.x-c.xMin)<o(c.yMax-p.y,p.y-c.yMin),f=T(c,p,t,u,{soft:d.hardBounds,hard:d.hardBounds}),b.push({end:i,start:v=u?{y:p.y,x:c[f?"xMax":"xMin"]+(f?1:-1)}:{x:p.x,y:c[f?"yMax":"yMin"]+(f?1:-1)}}),i=v);(P=a(O,i))>-1;)x=i[y]-t[y]<0,(v={x:i.x,y:i.y})[y]=O[P][x?y+"Max":y+"Min"]+(x?1:-1),b.push({end:i,start:v}),i=v;return{path:h(g=(g=function t(i,e,n){if(i.x===e.x&&i.y===e.y)return[];var s,h,c,p,u,f,g,x=n?"x":"y",v=d.obstacleOptions.margin,m={soft:{xMin:k,xMax:A,yMin:S,yMax:w},hard:d.hardBounds};return(u=a(O,i))>-1?(p=T(u=O[u],i,e,n,m),l(u,d.hardBounds),g=n?{y:i.y,x:u[p?"xMax":"xMin"]+(p?1:-1)}:{x:i.x,y:u[p?"yMax":"yMin"]+(p?1:-1)},(f=a(O,g))>-1&&(l(f=O[f],d.hardBounds),g[x]=p?r(u[x+"Max"]-v+1,(f[x+"Min"]+u[x+"Max"])/2):o(u[x+"Min"]+v-1,(f[x+"Max"]+u[x+"Min"])/2),i.x===g.x&&i.y===g.y?(C&&(g[x]=p?r(u[x+"Max"],f[x+"Max"])+1:o(u[x+"Min"],f[x+"Min"])-1),C=!C):C=!1),h=[{start:i,end:g}]):(s=E(i,{x:n?e.x:i.x,y:n?i.y:e.y},n),h=[{start:i,end:{x:s.x,y:s.y}}],s[n?"x":"y"]!==e[n?"x":"y"]&&(p=T(s.obstacle,s,e,!n,m),l(s.obstacle,d.hardBounds),c={x:n?s.x:s.obstacle[p?"xMax":"xMin"]+(p?1:-1),y:n?s.obstacle[p?"yMax":"yMin"]+(p?1:-1):s.y},n=!n,h=h.concat(t({x:s.x,y:s.y},c,n)))),h=h.concat(t(h[h.length-1].end,e,!n))}(t,i,m)).concat(b.reverse())),obstacles:g}}return d.requiresObstacles=!0,c.requiresObstacles=!0,{fastAvoid:c,straight:function(t,i){return{path:[["M",t.x,t.y],["L",i.x,i.y]],obstacles:[{start:t,end:i}]}},simpleConnect:d}}),e(i,"Gantt/ConnectorsDefaults.js",[],function(){return{connectors:{type:"straight",radius:0,lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}}}),e(i,"Gantt/PathfinderComposition.js",[i["Gantt/ConnectorsDefaults.js"],i["Core/Defaults.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r=i.setOptions,n=e.defined,s=e.error,a=e.merge;function h(t){var i=t.shapeArgs;if(i)return{xMin:i.x||0,xMax:(i.x||0)+(i.width||0),yMin:i.y||0,yMax:(i.y||0)+(i.height||0)};var e=t.graphic&&t.graphic.getBBox();return e?{xMin:t.plotX-e.width/2,xMax:t.plotX+e.width/2,yMin:t.plotY-e.height/2,yMax:t.plotY+e.height/2}:null}return function(i){function e(t){var i,e,o=h(this);switch(t.align){case"right":i="xMax";break;case"left":i="xMin"}switch(t.verticalAlign){case"top":e="yMin";break;case"bottom":e="yMax"}return{x:i?o[i]:(o.xMin+o.xMax)/2,y:e?o[e]:(o.yMin+o.yMax)/2}}function o(t,i){var e;return!n(i)&&(e=h(this))&&(i={x:(e.xMin+e.xMax)/2,y:(e.yMin+e.yMax)/2}),Math.atan2(i.y-t.y,t.x-i.x)}function l(t,i,e){for(var o=2*Math.PI,r=h(this),n=r.xMax-r.xMin,s=r.yMax-r.yMin,a=Math.atan2(s,n),l=n/2,d=s/2,c=r.xMin+l,p=r.yMin+d,u={x:c,y:p},f=t,g=1,x=!1,v=1,m=1;f<-Math.PI;)f+=o;for(;f>Math.PI;)f-=o;return g=Math.tan(f),f>-a&&f<=a?(m=-1,x=!0):f>a&&f<=Math.PI-a?m=-1:f>Math.PI-a||f<=-(Math.PI-a)?(v=-1,x=!0):v=-1,x?(u.x+=v*l,u.y+=m*l*g):(u.x+=s/(2*g)*v,u.y+=m*d),e.x!==c&&(u.x=e.x),e.y!==p&&(u.y=e.y),{x:u.x+i*Math.cos(f),y:u.y-i*Math.sin(f)}}i.compose=function(i,n,h){var d=h.prototype;d.getPathfinderAnchorPoint||(i.prototype.callbacks.push(function(t){!1!==t.options.connectors.enabled&&((t.options.pathfinder||t.series.reduce(function(t,i){return i.options&&a(!0,i.options.connectors=i.options.connectors||{},i.options.pathfinder),t||i.options&&i.options.pathfinder},!1))&&(a(!0,t.options.connectors=t.options.connectors||{},t.options.pathfinder),s('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')),this.pathfinder=new n(this),this.pathfinder.update(!0))}),d.getMarkerVector=l,d.getPathfinderAnchorPoint=e,d.getRadiansToVector=o,r(t))}}(o||(o={})),o}),e(i,"Gantt/Pathfinder.js",[i["Gantt/Connection.js"],i["Gantt/PathfinderAlgorithms.js"],i["Gantt/PathfinderComposition.js"],i["Core/Series/Point.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var n=r.addEvent,s=r.defined,a=r.pick,h=r.splat,l=Math.max,d=Math.min,c=function(){function i(t){this.init(t)}return i.compose=function(t,o){e.compose(t,i,o)},i.prototype.init=function(t){this.chart=t,this.connections=[],n(t,"redraw",function(){this.pathfinder.update()})},i.prototype.update=function(i){var e=this.chart,r=this,n=r.connections;r.connections=[],e.series.forEach(function(i){i.visible&&!i.options.isInternal&&i.points.forEach(function(i){var n,s,a=i.options;a&&a.dependency&&(a.connect=a.dependency);var l=(null===(n=i.options)||void 0===n?void 0:n.connect)&&h(i.options.connect);i.visible&&!1!==i.isInside&&l&&l.forEach(function(n){(s=e.get("string"==typeof n?n:n.to))instanceof o&&s.series.visible&&s.visible&&!1!==s.isInside&&r.connections.push(new t(i,s,"string"==typeof n?{}:n))})})});for(var s=0,a=void 0,l=void 0,d=n.length,c=r.connections.length;s<d;++s){l=!1;var p=n[s];for(a=0;a<c;++a){var u=r.connections[a];if((p.options&&p.options.type)===(u.options&&u.options.type)&&p.fromPoint===u.fromPoint&&p.toPoint===u.toPoint){u.graphics=p.graphics,l=!0;break}}l||p.destroy()}delete this.chartObstacles,delete this.lineObstacles,r.renderConnections(i)},i.prototype.renderConnections=function(t){t?this.chart.series.forEach(function(t){var i=function(){var i=t.chart.pathfinder;(i&&i.connections||[]).forEach(function(i){i.fromPoint&&i.fromPoint.series===t&&i.render()}),t.pathfinderRemoveRenderEvent&&(t.pathfinderRemoveRenderEvent(),delete t.pathfinderRemoveRenderEvent)};!1===t.options.animation?i():t.pathfinderRemoveRenderEvent=n(t,"afterAnimate",i)}):this.connections.forEach(function(t){t.render()})},i.prototype.getChartObstacles=function(t){for(var i,e=this.chart.series,o=a(t.algorithmMargin,0),r=[],n=0,h=e.length;n<h;++n)if(e[n].visible&&!e[n].options.isInternal)for(var c=0,p=e[n].points.length,u=void 0,f=void 0;c<p;++c)(f=e[n].points[c]).visible&&(u=function(t){var i=t.shapeArgs;if(i)return{xMin:i.x||0,xMax:(i.x||0)+(i.width||0),yMin:i.y||0,yMax:(i.y||0)+(i.height||0)};var e=t.graphic&&t.graphic.getBBox();return e?{xMin:t.plotX-e.width/2,xMax:t.plotX+e.width/2,yMin:t.plotY-e.height/2,yMax:t.plotY+e.height/2}:null}(f))&&r.push({xMin:u.xMin-o,xMax:u.xMax+o,yMin:u.yMin-o,yMax:u.yMax+o});return r=r.sort(function(t,i){return t.xMin-i.xMin}),s(t.algorithmMargin)||(i=t.algorithmMargin=function(t){for(var i,e=t.length,o=[],r=0;r<e;++r)for(var n=r+1;n<e;++n)(i=function t(i,e,o){var r=a(o,10),n=i.yMax+r>e.yMin-r&&i.yMin-r<e.yMax+r,s=i.xMax+r>e.xMin-r&&i.xMin-r<e.xMax+r,h=n?i.xMin>e.xMax?i.xMin-e.xMax:e.xMin-i.xMax:1/0,l=s?i.yMin>e.yMax?i.yMin-e.yMax:e.yMin-i.yMax:1/0;return s&&n?r?t(i,e,Math.floor(r/2)):1/0:d(h,l)}(t[r],t[n]))<80&&o.push(i);return o.push(80),l(Math.floor(o.sort(function(t,i){return t-i})[Math.floor(o.length/10)]/2-1),1)}(r),r.forEach(function(t){t.xMin-=i,t.xMax+=i,t.yMin-=i,t.yMax+=i})),r},i.prototype.getObstacleMetrics=function(t){for(var i,e,o=0,r=0,n=t.length;n--;)i=t[n].xMax-t[n].xMin,e=t[n].yMax-t[n].yMin,o<i&&(o=i),r<e&&(r=e);return{maxHeight:r,maxWidth:o}},i.prototype.getAlgorithmStartDirection=function(t){var i="left"!==t.align&&"right"!==t.align,e="top"!==t.verticalAlign&&"bottom"!==t.verticalAlign;return i?!!e&&void 0:!!e||void 0},i}();return c.prototype.algorithms=i,c}),e(i,"masters/modules/pathfinder.src.js",[i["Core/Globals.js"],i["Gantt/Pathfinder.js"],i["Extensions/ArrowSymbols.js"]],function(t,i,e){return t.Pathfinder=t.Pathfinder||i,e.compose(t.SVGRenderer),t.Pathfinder.compose(t.Chart,t.Point),t}),e(i,"Extensions/StaticScale.js",[i["Core/Utilities.js"]],function(t){var i=t.addEvent,e=t.defined,o=t.isNumber,r=t.pick;function n(){var t=this.chart.options.chart;!this.horiz&&o(this.options.staticScale)&&(!t.height||t.scrollablePlotArea&&t.scrollablePlotArea.minHeight)&&(this.staticScale=this.options.staticScale)}function s(){if("adjustHeight"!==this.redrawTrigger){for(var t=0,i=this.axes||[];t<i.length;t++)!function(t){var i=t.chart,o=!!i.initiatedScale&&i.options.animation,n=t.options.staticScale;if(t.staticScale&&e(t.min)){var s=r(t.brokenAxis&&t.brokenAxis.unitLength,t.max+t.tickInterval-t.min)*n,a=(s=Math.max(s,n))-i.plotHeight;!i.scrollablePixelsY&&Math.abs(a)>=1&&(i.plotHeight=s,i.redrawTrigger="adjustHeight",i.setSize(void 0,i.chartHeight+a,o)),t.series.forEach(function(t){var e=t.sharedClipKey&&i.sharedClips[t.sharedClipKey];e&&e.attr(i.inverted?{width:i.plotHeight}:{height:i.plotHeight})})}}(i[t]);this.initiatedScale=!0}this.redrawTrigger=null}return{compose:function(t,e){var o=e.prototype;o.adjustHeight||(i(t,"afterSetOptions",n),o.adjustHeight=s,i(e,"render",o.adjustHeight))}}}),e(i,"masters/modules/static-scale.src.js",[i["Core/Globals.js"],i["Extensions/StaticScale.js"]],function(t,i){return i.compose(t.Axis,t.Chart),t}),e(i,"Series/XRange/XRangeSeriesDefaults.js",[i["Core/Utilities.js"]],function(t){var i=t.correctFloat,e=t.isNumber,o=t.isObject;return{colorByPoint:!0,dataLabels:{formatter:function(){var t=this.point.partialFill;if(o(t)&&(t=t.amount),e(t)&&t>0)return i(100*t)+"%"},inside:!0,verticalAlign:"middle",style:{whiteSpace:"nowrap"}},tooltip:{headerFormat:'<span style="font-size: 0.8em">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0}}),e(i,"Series/XRange/XRangePoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)}),r=t.seriesTypes.column.prototype.pointClass,n=i.extend,s=function(t){function i(i,e){var o=t.call(this,i,e)||this;return o.y||(o.y=0),o}return o(i,t),i.getColorByCategory=function(t,i){var e=t.options.colors||t.chart.options.colors,o=e?e.length:t.chart.options.chart.colorCount,r=i.y%o,n=e&&e[r];return{colorIndex:r,color:n}},i.prototype.resolveColor=function(){var t=this.series;if(t.options.colorByPoint&&!this.options.color){var e=i.getColorByCategory(t,this);t.chart.styledMode||(this.color=e.color),this.options.colorIndex||(this.colorIndex=e.colorIndex)}else this.color=this.options.color||t.color},i.prototype.setState=function(){t.prototype.setState.apply(this,arguments),this.series.drawPoint(this,this.series.getAnimationVerb())},i.prototype.getLabelConfig=function(){var i=t.prototype.getLabelConfig.call(this),e=this.series.yAxis.categories;return i.x2=this.x2,i.yCategory=this.yCategory=e&&e[this.y],i.key=this.category||this.name,i},i.prototype.isValid=function(){return"number"==typeof this.x&&"number"==typeof this.x2},i}(r);return n(s.prototype,{ttBelow:!1,tooltipDateKeys:["x","x2"]}),s}),e(i,"Series/XRange/XRangeSeries.js",[i["Core/Globals.js"],i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"],i["Series/XRange/XRangeSeriesDefaults.js"],i["Series/XRange/XRangePoint.js"]],function(t,i,e,o,r,n){var s,a=this&&this.__extends||(s=function(t,i){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}s(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),h=t.composed,l=t.noop,d=i.parse,c=e.seriesTypes.column,p=o.addEvent,u=o.clamp,f=o.defined,g=o.extend,x=o.find,v=o.isNumber,m=o.isObject,y=o.merge,b=o.pick,M=o.pushUnique,k=o.relativeLength;function A(){var t,i;if(this.isXAxis){t=b(this.dataMax,-Number.MAX_VALUE);for(var e=0,o=this.series;e<o.length;e++){var r=o[e];if(r.x2Data)for(var n=0,s=r.x2Data;n<s.length;n++){var a=s[n];a&&a>t&&(t=a,i=!0)}}i&&(this.dataMax=t)}}var S=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return a(i,t),i.compose=function(t){M(h,"Series.XRange")&&p(t,"afterGetSeriesExtremes",A)},i.prototype.init=function(){t.prototype.init.apply(this,arguments),this.options.stacking=void 0},i.prototype.getColumnMetrics=function(){var i=this,e=function(){for(var t=0,e=i.chart.series;t<e.length;t++){var o=e[t],r=o.xAxis;o.xAxis=o.yAxis,o.yAxis=r}};e();var o=t.prototype.getColumnMetrics.call(this);return e(),o},i.prototype.cropData=function(i,e,o,r){var n=t.prototype.cropData.call(this,this.x2Data,e,o,r);return n.xData=i.slice(n.start,n.end),n},i.prototype.findPointIndex=function(t){var i,e=this.cropStart,o=this.points,r=t.id;if(r){var n=x(o,function(t){return t.id===r});i=n?n.index:void 0}if(void 0===i){var n=x(o,function(i){return i.x===t.x&&i.x2===t.x2&&!i.touched});i=n?n.index:void 0}return this.cropped&&v(i)&&v(e)&&i>=e&&(i-=e),i},i.prototype.alignDataLabel=function(i){var e,o=i.plotX;i.plotX=b(i.dlBox&&i.dlBox.centerX,i.plotX),i.dataLabel&&(null===(e=i.shapeArgs)||void 0===e?void 0:e.width)&&i.dataLabel.css({width:"".concat(i.shapeArgs.width,"px")}),t.prototype.alignDataLabel.apply(this,arguments),i.plotX=o},i.prototype.translatePoint=function(t){var i,e,o,r,n,s,a=this.xAxis,h=this.yAxis,l=this.columnMetrics,d=this.options,c=d.minPointLength||0,p=(t.shapeArgs&&t.shapeArgs.width||0)/2,g=this.pointXOffset=l.offset,x=b(t.x2,t.x+(t.len||0)),M=d.borderRadius,A=this.chart.plotTop,S=this.chart.plotLeft,w=t.plotX,C=a.translate(x,0,0,0,1),O=Math.abs(C-w),P=this.chart.inverted,B=b(d.borderWidth,1)%2/2,E=l.offset,T=Math.round(l.width);c&&((i=c-O)<0&&(i=0),w-=i/2,C+=i/2),w=Math.max(w,-10),C=u(C,-10,a.len+10),f(t.options.pointWidth)&&(E-=(Math.ceil(t.options.pointWidth)-T)/2,T=Math.ceil(t.options.pointWidth)),d.pointPlacement&&v(t.plotY)&&h.categories&&(t.plotY=h.translate(t.y,0,1,0,1,d.pointPlacement));var j=Math.floor(Math.min(w,C))+B,D=Math.floor(Math.max(w,C))+B-j,G=Math.min(k("object"==typeof M?M.radius:M||0,T),Math.min(D,T)/2),I={x:j,y:Math.floor(t.plotY+E)+B,width:D,height:T,r:G};t.shapeArgs=I,P?t.tooltipPos[1]+=g+p:t.tooltipPos[0]-=p+g-I.width/2,r=(o=I.x)+I.width,o<0||r>a.len?(o=u(o,0,a.len),n=(r=u(r,0,a.len))-o,t.dlBox=y(I,{x:o,width:r-o,centerX:n?n/2:null})):t.dlBox=null;var L=t.tooltipPos,R=P?1:0,N=P?0:1,z=this.columnMetrics?this.columnMetrics.offset:-l.width/2;P?L[R]+=I.width/2:L[R]=u(L[R]+(a.reversed?-1:0)*I.width,a.left-S,a.left+a.len-S-1),L[N]=u(L[N]+(P?-1:1)*z,h.top-A,h.top+h.len-A-1),(e=t.partialFill)&&(m(e)&&(e=e.amount),v(e)||(e=0),t.partShapeArgs=y(I),s=Math.max(Math.round(O*e+t.plotX-w),0),t.clipRectArgs={x:a.reversed?I.x+O-s:I.x,y:I.y,width:s,height:I.height})},i.prototype.translate=function(){t.prototype.translate.apply(this,arguments);for(var i=0,e=this.points;i<e.length;i++){var o=e[i];this.translatePoint(o)}},i.prototype.drawPoint=function(t,i){var e=this.options,o=this.chart.renderer,r=t.shapeType,n=t.shapeArgs,s=t.partShapeArgs,a=t.clipRectArgs,h=t.state,l=e.states[h||"normal"]||{},c=void 0===h?"attr":i,p=this.pointAttribs(t,h),u=b(this.chart.options.chart.animation,l.animation),f=t.graphic,g=t.partialFill;if(t.isNull||!1===t.visible)f&&(t.graphic=f.destroy());else if(f?f.rect[i](n):(t.graphic=f=o.g("point").addClass(t.getClassName()).add(t.group||this.group),f.rect=o[r](y(n)).addClass(t.getClassName()).addClass("highcharts-partfill-original").add(f)),s&&(f.partRect?(f.partRect[i](y(s)),f.partialClipRect[i](y(a))):(f.partialClipRect=o.clipRect(a.x,a.y,a.width,a.height),f.partRect=o[r](s).addClass("highcharts-partfill-overlay").add(f).clip(f.partialClipRect))),!this.chart.styledMode&&(f.rect[i](p,u).shadow(e.shadow),s)){m(g)||(g={}),m(e.partialFill)&&(g=y(e.partialFill,g));var x=g.fill||d(p.fill).brighten(-.3).get()||d(t.color||this.color).brighten(-.3).get();p.fill=x,f.partRect[c](p,u).shadow(e.shadow)}},i.prototype.drawPoints=function(){for(var t=this.getAnimationVerb(),i=0,e=this.points;i<e.length;i++){var o=e[i];this.drawPoint(o,t)}},i.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"},i.prototype.isPointInside=function(i){var e=i.shapeArgs,o=i.plotX,r=i.plotY;return e?void 0!==o&&void 0!==r&&r>=0&&r<=this.yAxis.len&&(e.x||0)+(e.width||0)>=0&&o<=this.xAxis.len:t.prototype.isPointInside.apply(this,arguments)},i.defaultOptions=y(c.defaultOptions,r),i}(c);return g(S.prototype,{pointClass:n,pointArrayMap:["x2","y"],getExtremesFromAll:!0,parallelArrays:["x","x2","y"],requireSorting:!1,type:"xrange",animate:e.series.prototype.animate,autoIncrement:l,buildKDTree:l}),e.registerSeriesType("xrange",S),S}),e(i,"masters/modules/xrange.src.js",[i["Core/Globals.js"],i["Series/XRange/XRangeSeries.js"]],function(t,i){return i.compose(t.Axis),t}),e(i,"Series/Gantt/GanttPoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)}),r=t.seriesTypes.xrange.prototype.pointClass,n=i.pick;return function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return o(i,t),i.setGanttPointAliases=function(t){function i(i,e){void 0!==e&&(t[i]=e)}i("x",n(t.start,t.x)),i("x2",n(t.end,t.x2)),i("partialFill",n(t.completed,t.partialFill))},i.prototype.applyOptions=function(e,o){var r=t.prototype.applyOptions.call(this,e,o);return i.setGanttPointAliases(r),r},i.prototype.isValid=function(){return("number"==typeof this.start||"number"==typeof this.x)&&("number"==typeof this.end||"number"==typeof this.x2||this.milestone)},i}(r)}),e(i,"Series/Gantt/GanttSeriesDefaults.js",[i["Core/Utilities.js"]],function(t){var i=t.isNumber;return{grouping:!1,dataLabels:{enabled:!0},tooltip:{headerFormat:'<span style="font-size: 0.8em">{series.name}</span><br/>',pointFormat:null,pointFormatter:function(){var t=this.series,e=t.xAxis,o=t.tooltipOptions.dateTimeLabelFormats,r=e.options.startOfWeek,n=t.tooltipOptions,s=this.options.milestone,a=n.xDateFormat,h="<b>"+(this.name||this.yCategory)+"</b>";if(n.pointFormat)return this.tooltipFormatter(n.pointFormat);!a&&i(this.start)&&(a=t.chart.time.getDateFormat(e.closestPointRange,this.start,r,o||{}));var l=t.chart.time.dateFormat(a,this.start),d=t.chart.time.dateFormat(a,this.end);return h+="<br/>",s?h+=l+"<br/>":h+="Start: "+l+"<br/>End: "+d+"<br/>",h}},connectors:{type:"simpleConnect",animation:{reversed:!0},radius:0,startMarker:{enabled:!0,symbol:"arrow-filled",radius:4,fill:"#fa0",align:"left"},endMarker:{enabled:!1,align:"right"}}}}),e(i,"Core/Axis/BrokenAxis.js",[i["Core/Axis/Stacking/StackItem.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,r=i.find,n=i.fireEvent,s=i.isArray,a=i.isNumber,h=i.pick;return function(i){function e(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function l(){var t;(null===(t=this.brokenAxis)||void 0===t?void 0:t.hasBreaks)&&(this.options.ordinal=!1)}function d(){var t=this.brokenAxis;if(null==t?void 0:t.hasBreaks){for(var i=this.tickPositions,e=this.tickPositions.info,o=[],r=0;r<i.length;r++)t.isInAnyBreak(i[r])||o.push(i[r]);this.tickPositions=o,this.tickPositions.info=e}}function c(){this.brokenAxis||(this.brokenAxis=new x(this))}function p(){var t,i,e=this.isDirty,o=this.options.connectNulls,r=this.points,n=this.xAxis,s=this.yAxis;if(e)for(var a=r.length;a--;){var h=r[a],l=!(null===h.y&&!1===o)&&((null===(t=null==n?void 0:n.brokenAxis)||void 0===t?void 0:t.isInAnyBreak(h.x,!0))||(null===(i=null==s?void 0:s.brokenAxis)||void 0===i?void 0:i.isInAnyBreak(h.y,!0)));h.visible=!l&&!1!==h.options.visible}}function u(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,h(this.pointArrayMap,["y"]))}function f(t,i){var e,o,r,s,l=this,d=l.points;if(null===(e=null==t?void 0:t.brokenAxis)||void 0===e?void 0:e.hasBreaks){var c=t.brokenAxis;i.forEach(function(i){o=(null==c?void 0:c.breakArray)||[],r=t.isXAxis?t.min:h(l.options.threshold,t.min);var e,p,u=null===(p=null===(e=null==t?void 0:t.options)||void 0===e?void 0:e.breaks)||void 0===p?void 0:p.filter(function(t){for(var i=!0,e=0;e<o.length;e++){var r=o[e];if(r.from===t.from&&r.to===t.to){i=!1;break}}return i});d.forEach(function(e){s=h(e["stack"+i.toUpperCase()],e[i]),o.forEach(function(i){if(a(r)&&a(s)){var o="";r<i.from&&s>i.to||r>i.from&&s<i.from?o="pointBreak":(r<i.from&&s>i.from&&s<i.to||r>i.from&&s>i.to&&s<i.from)&&(o="pointInBreak"),o&&n(t,o,{point:e,brk:i})}}),null==u||u.forEach(function(i){n(t,"pointOutsideOfBreak",{point:e,brk:i})})})})}}function g(){var i=this.currentDataGrouping,e=null==i?void 0:i.gapSize,o=this.points.slice(),r=this.yAxis,n=this.options.gapSize,s=o.length-1;if(n&&s>0){"value"!==this.options.gapUnit&&(n*=this.basePointRange),e&&e>n&&e>=this.basePointRange&&(n=e);for(var a=void 0,h=void 0;s--;)if(h&&!1!==h.visible||(h=o[s+1]),a=o[s],!1!==h.visible&&!1!==a.visible){if(h.x-a.x>n){var l=(a.x+h.x)/2;o.splice(s+1,0,{isNull:!0,x:l}),r.stacking&&this.options.stacking&&((r.stacking.stacks[this.stackKey][l]=new t(r,r.options.stackLabels,!1,l,this.stack)).total=0)}h=a}}return this.getGraphPath(o)}i.compose=function(t,i){if(!t.keepProps.includes("brokenAxis")){t.keepProps.push("brokenAxis"),o(t,"init",c),o(t,"afterInit",e),o(t,"afterSetTickPositions",d),o(t,"afterSetOptions",l);var r=i.prototype;r.drawBreaks=f,r.gappedPath=g,o(i,"afterGeneratePoints",p),o(i,"afterRender",u)}return t};var x=function(){function t(t){this.hasBreaks=!1,this.axis=t}return t.isInBreak=function(t,i){var e=t.repeat||1/0,o=t.from,r=t.to-t.from,n=i>=o?(i-o)%e:e-(o-i)%e;return t.inclusive?n<=r:n<r&&0!==n},t.lin2Val=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,n,s=i;for(n=0;n<o.length&&!((r=o[n]).from>=s);n++)r.to<s?s+=r.len:t.isInBreak(r,s)&&(s+=r.len);return s},t.val2Lin=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,n,s=i;for(n=0;n<o.length;n++)if((r=o[n]).to<=i)s-=r.len;else if(r.from>=i)break;else if(t.isInBreak(r,i)){s-=i-r.from;break}return s},t.prototype.findBreakAt=function(t,i){return r(i,function(i){return i.from<t&&t<i.to})},t.prototype.isInAnyBreak=function(i,e){var o,r,n,s=this.axis,l=s.options.breaks||[],d=l.length;if(d&&a(i)){for(;d--;)t.isInBreak(l[d],i)&&(o=!0,r||(r=h(l[d].showPoints,!s.isXAxis)));n=o&&e?o&&!r:o}return n},t.prototype.setBreaks=function(i,e){var o=this,r=o.axis,l=s(i)&&!!i.length&&!!Object.keys(i[0]).length;r.isDirty=o.hasBreaks!==l,o.hasBreaks=l,i!==r.options.breaks&&(r.options.breaks=r.userOptions.breaks=i),r.forceRedraw=!0,r.series.forEach(function(t){t.isDirty=!0}),l||r.val2lin!==t.val2Lin||(delete r.val2lin,delete r.lin2val),l&&(r.userOptions.ordinal=!1,r.lin2val=t.lin2Val,r.val2lin=t.val2Lin,r.setExtremes=function(t,i,e,n,s){if(o.hasBreaks){for(var a=this.options.breaks||[],h=void 0;h=o.findBreakAt(t,a);)t=h.to;for(;h=o.findBreakAt(i,a);)i=h.from;i<t&&(i=t)}r.constructor.prototype.setExtremes.call(this,t,i,e,n,s)},r.setAxisTranslation=function(){if(r.constructor.prototype.setAxisTranslation.call(this),o.unitLength=void 0,o.hasBreaks){var i,e,s,l,d=r.options.breaks||[],c=[],p=[],u=h(r.pointRangePadding,0),f=0,g=r.userMin||r.min,x=r.userMax||r.max;d.forEach(function(i){e=i.repeat||1/0,a(g)&&a(x)&&(t.isInBreak(i,g)&&(g+=i.to%e-g%e),t.isInBreak(i,x)&&(x-=x%e-i.from%e))}),d.forEach(function(t){if(s=t.from,e=t.repeat||1/0,a(g)&&a(x)){for(;s-e>g;)s-=e;for(;s<g;)s+=e;for(l=s;l<x;l+=e)c.push({value:l,move:"in"}),c.push({value:l+t.to-t.from,move:"out",size:t.breakSize})}}),c.sort(function(t,i){return t.value===i.value?("in"===t.move?0:1)-("in"===i.move?0:1):t.value-i.value}),i=0,s=g,c.forEach(function(t){1===(i+="in"===t.move?1:-1)&&"in"===t.move&&(s=t.value),0===i&&a(s)&&(p.push({from:s,to:t.value,len:t.value-s-(t.size||0)}),f+=t.value-s-(t.size||0))}),o.breakArray=p,a(g)&&a(x)&&a(r.min)&&(o.unitLength=x-g-f+u,n(r,"afterBreaks"),r.staticScale?r.transA=r.staticScale:o.unitLength&&(r.transA*=(x-r.min+u)/o.unitLength),u&&(r.minPixelPadding=r.transA*(r.minPointOffset||0)),r.min=g,r.max=x)}}),h(e,!0)&&r.chart.redraw()},t}();i.Additions=x}(e||(e={})),e}),e(i,"Core/Axis/GridAxis.js",[i["Core/Axis/Axis.js"],i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r,n=i.dateFormats,s=e.addEvent,a=e.defined,h=e.erase,l=e.find,d=e.isArray,c=e.isNumber,p=e.merge,u=e.pick,f=e.timeUnits,g=e.wrap;function x(t){return e.isObject(t,!0)}function v(t,i){var e={width:0,height:0};if(i.forEach(function(i){var o,r=t[i],n=0,s=0;x(r)&&(n=(o=x(r.label)?r.label:{}).getBBox?o.getBBox().height:0,o.textStr&&!c(o.textPxLength)&&(o.textPxLength=o.getBBox().width),s=c(o.textPxLength)?Math.round(o.textPxLength):0,o.textStr&&(s=Math.round(o.getBBox().width)),e.height=Math.max(n,e.height),e.width=Math.max(s,e.width))}),"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode){var o=this.treeGrid.mapOfPosToGridNode[-1].height||0;e.width+=this.options.labels.indentation*(o-1)}return e}function m(t){var i=this.grid,e=3===this.side;if(e||t.apply(this),!(null==i?void 0:i.isColumn)){var o=(null==i?void 0:i.columns)||[];e&&(o=o.slice().reverse()),o.forEach(function(t){t.getOffset()})}e&&t.apply(this)}function y(t){if(!0===(this.options.grid||{}).enabled){var i=this.axisTitle,e=this.height,o=this.horiz,n=this.left,s=this.offset,a=this.opposite,h=this.options,l=this.top,d=this.width,c=this.tickSize(),p=i&&i.getBBox().width,f=h.title.x,g=h.title.y,x=u(h.title.margin,o?5:10),v=i?this.chart.renderer.fontMetrics(i).f:0,m=(o?l+e:n)+(o?1:-1)*(a?-1:1)*(c?c[0]/2:0)+(this.side===r.bottom?v:0);t.titlePosition.x=o?n-(p||0)/2-x+f:m+(a?d:0)+s+f,t.titlePosition.y=o?m-(a?e:0)+(a?v:-v)/2+s+g:l-x+g}}function b(){var i,e=this.chart,o=this.options.grid,r=void 0===o?{}:o,n=this.userOptions;if(r.enabled&&((i=this.options).labels.align=u(i.labels.align,"center"),this.categories||(i.showLastLabel=!1),this.labelRotation=0,i.labels.rotation=0,i.minTickInterval=1),r.columns)for(var s=this.grid.columns=[],a=this.grid.columnIndex=0;++a<r.columns.length;){var l=p(n,r.columns[a],{isInternal:!0,linkedTo:0,scrollbar:{enabled:!1}},{grid:{columns:void 0}}),d=new t(this.chart,l,"yAxis");d.grid.isColumn=!0,d.grid.columnIndex=a,h(e.axes,d),h(e[this.coll]||[],d),s.push(d)}}function M(){var t=this.axisTitle,i=this.grid,e=this.options;if(!0===(e.grid||{}).enabled){var o=this.min||0,n=this.max||0,s=this.ticks[this.tickPositions[0]];if(t&&!this.chart.styledMode&&(null==s?void 0:s.slotWidth)&&!this.options.title.style.width&&t.css({width:"".concat(s.slotWidth,"px")}),this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions),this.rightWall&&this.rightWall.destroy(),this.grid&&this.grid.isOuterAxis()&&this.axisLine){var a=e.lineWidth;if(a){var h=this.getLinePath(a),l=h[0],d=h[1],c=((this.tickSize("tick")||[1])[0]-1)*(this.side===r.top||this.side===r.left?-1:1);if("M"===l[0]&&"L"===d[0]&&(this.horiz?(l[2]+=c,d[2]+=c):(l[1]+=c,d[1]+=c)),!this.horiz&&this.chart.marginRight){var p=["L",this.left,l[2]||0],u=[l,p],f=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(n+this.tickmarkOffset)],g=[["M",d[1]||0,this.toPixels(n+this.tickmarkOffset)],f];this.grid.upperBorder||o%1==0||(this.grid.upperBorder=this.grid.renderBorder(u)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:e.lineColor,"stroke-width":e.lineWidth}),this.grid.upperBorder.animate({d:u})),this.grid.lowerBorder||n%1==0||(this.grid.lowerBorder=this.grid.renderBorder(g)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:e.lineColor,"stroke-width":e.lineWidth}),this.grid.lowerBorder.animate({d:g}))}this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:e.lineColor,"stroke-width":e.lineWidth}),this.grid.axisLineExtra.animate({d:h})):this.grid.axisLineExtra=this.grid.renderBorder(h),this.axisLine[this.showAxis?"show":"hide"]()}}if((i&&i.columns||[]).forEach(function(t){return t.render()}),!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)&&this.tickPositions.length){for(var x=this.tickmarkOffset,v=this.tickPositions[this.tickPositions.length-1],m=this.tickPositions[0],y=void 0,b=void 0;(y=this.hiddenLabels.pop())&&y.element;)y.show();for(;(b=this.hiddenMarks.pop())&&b.element;)b.show();(y=this.ticks[m].label)&&(o-m>x?this.hiddenLabels.push(y.hide()):y.show()),(y=this.ticks[v].label)&&(v-n>x?this.hiddenLabels.push(y.hide()):y.show());var M=this.ticks[v].mark;M&&v-n<x&&v-n>0&&this.ticks[v].isLast&&this.hiddenMarks.push(M.hide())}}}function k(){var t=this.tickPositions&&this.tickPositions.info,i=this.options,e=i.grid||{},o=this.userOptions.labels||{};e.enabled&&(this.horiz?(this.series.forEach(function(t){t.options.pointRange=0}),t&&i.dateTimeLabelFormats&&i.labels&&!a(o.align)&&(!1===i.dateTimeLabelFormats[t.unitName].range||t.count>1)&&(i.labels.align="left",a(o.x)||(i.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function A(t){var i,e=this.options,o=t.userOptions,r=e&&x(e.grid)?e.grid:{};!0===r.enabled&&(i=p(!0,{className:"highcharts-grid-axis "+(o.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0,style:{textOverflow:"ellipsis"}},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},o),"xAxis"!==this.coll||(a(o.linkedTo)&&!a(o.tickPixelInterval)&&(i.tickPixelInterval=350),!(!a(o.tickPixelInterval)&&a(o.linkedTo))||a(o.tickPositioner)||a(o.tickInterval)||a(o.units)||(i.tickPositioner=function(t,e){var o=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(o){for(var r=i.units||[],n=void 0,s=1,a="year",h=0;h<r.length;h++){var l=r[h];if(l&&l[0]===o.unitName){n=h;break}}var d=c(n)&&r[n+1];if(d){a=d[0]||"year";var p=d[1];s=p&&p[0]||1}else"year"===o.unitName&&(s=10*o.count);var u=f[a];return this.tickInterval=u*s,this.chart.time.getTimeTicks({unitRange:u,count:s,unitName:a},t,e,this.options.startOfWeek)}})),p(!0,this.options,i),this.horiz&&(e.minPadding=u(o.minPadding,0),e.maxPadding=u(o.maxPadding,0)),c(e.grid.borderWidth)&&(e.tickWidth=e.lineWidth=r.borderWidth))}function S(t){var i=t.userOptions,e=i&&i.grid||{},o=e.columns;e.enabled&&o&&p(!0,this.options,o[0])}function w(){(this.grid.columns||[]).forEach(function(t){return t.setScale()})}function C(t){var i=this.horiz,e=this.maxLabelDimensions,o=this.options.grid,r=void 0===o?{}:o;if(r.enabled&&e){var n=2*this.options.labels.distance,s=i?r.cellHeight||n+e.height:n+e.width;d(t.tickSize)?t.tickSize[0]=s:t.tickSize=[s,0]}}function O(){this.axes.forEach(function(t){(t.grid&&t.grid.columns||[]).forEach(function(t){t.setAxisSize(),t.setAxisTranslation()})})}function P(t){var i=this.grid;(i.columns||[]).forEach(function(i){return i.destroy(t.keepEvents)}),i.columns=void 0}function B(t){var i=t.userOptions||{},e=i.grid||{};e.enabled&&a(e.borderColor)&&(i.tickColor=i.lineColor=e.borderColor),this.grid||(this.grid=new G(this)),this.hiddenLabels=[],this.hiddenMarks=[]}function E(t){var i=this.label,e=this.axis,o=e.reversed,n=e.chart,s=e.options.grid||{},a=e.options.labels,h=a.align,l=r[e.side],d=t.tickmarkOffset,p=e.tickPositions,u=this.pos-d,f=c(p[t.index+1])?p[t.index+1]-d:(e.max||0)+d,g=e.tickSize("tick"),x=g?g[0]:0,v=g?g[1]/2:0;if(!0===s.enabled){var m,y=void 0,b=void 0,M=void 0;if("top"===l?m=(y=e.top+e.offset)-x:"bottom"===l?y=(m=n.chartHeight-e.bottom+e.offset)+x:(y=e.top+e.len-(e.translate(o?f:u)||0),m=e.top+e.len-(e.translate(o?u:f)||0)),"right"===l?M=(b=n.chartWidth-e.right+e.offset)+x:"left"===l?b=(M=e.left+e.offset)-x:(b=Math.round(e.left+(e.translate(o?f:u)||0))-v,M=Math.min(Math.round(e.left+(e.translate(o?u:f)||0))-v,e.left+e.len)),this.slotWidth=M-b,t.pos.x="left"===h?b:"right"===h?M:b+(M-b)/2,t.pos.y=m+(y-m)/2,i){var k=n.renderer.fontMetrics(i),A=i.getBBox().height;if(a.useHTML)t.pos.y+=k.b+-(A/2);else{var S=Math.round(A/k.h);t.pos.y+=(k.b-(k.h-k.f))/2+-((S-1)*k.h/2)}}t.pos.x+=e.horiz&&a.x||0}}function T(t){var e=t.axis,o=t.value;if(e.options.grid&&e.options.grid.enabled){var r=e.tickPositions,n=(e.linkedParent||e).series[0],s=o===r[0],a=o===r[r.length-1],h=n&&l(n.options.data,function(t){return t[e.isXAxis?"x":"y"]===o}),d=void 0;h&&n.is("gantt")&&(d=p(h),i.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(d)),t.isFirst=s,t.isLast=a,t.point=d}}function j(){var t=this.options,i=t.grid||{},e=this.categories,o=this.tickPositions,r=o[0],n=o[1],s=o[o.length-1],a=o[o.length-2],h=this.linkedParent&&this.linkedParent.min,l=this.linkedParent&&this.linkedParent.max,d=h||this.min,p=l||this.max,u=this.tickInterval,f=c(d)&&d>=r+u&&d<n,g=c(d)&&r<d&&r+u>d,x=c(p)&&s>p&&s-u<p,v=c(p)&&p<=s-u&&p>a;!0===i.enabled&&!e&&(this.isXAxis||this.isLinked)&&((g||f)&&!t.startOnTick&&(o[0]=d),(x||v)&&!t.endOnTick&&(o[o.length-1]=p))}function D(t){var i,e=this.options.grid;return!0===(void 0===e?{}:e).enabled&&this.categories?this.tickInterval:t.apply(this,(i=arguments,Array.prototype.slice.call(i,1)))}(o=r||(r={}))[o.top=0]="top",o[o.right=1]="right",o[o.bottom=2]="bottom",o[o.left=3]="left";var G=function(){function t(t){this.axis=t}return t.prototype.isOuterAxis=function(){var t,i=this.axis,e=i.chart,o=i.grid.columnIndex,r=(null===(t=i.linkedParent)||void 0===t?void 0:t.grid.columns)||i.grid.columns||[],n=o?i.linkedParent:i,s=-1,a=0;return 3===i.side&&!e.inverted&&r.length?!i.linkedParent:((e[i.coll]||[]).forEach(function(t,e){t.side!==i.side||t.options.isInternal||(a=e,t!==n||(s=e))}),a===s&&(!c(o)||r.length===o))},t.prototype.renderBorder=function(t){var i=this.axis,e=i.chart.renderer,o=i.options,r=e.path(t).addClass("highcharts-axis-line").add(i.axisGroup);return e.styledMode||r.attr({stroke:o.lineColor,"stroke-width":o.lineWidth,zIndex:7}),r},t}();return n.E=function(t){return this.dateFormat("%a",t,!0).charAt(0)},n.W=function(t){var i=this,e=new this.Date(t);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(t){i.set(t,e,0)});var o=(this.get("Day",e)+6)%7,r=new this.Date(e.valueOf());this.set("Date",r,this.get("Date",e)-o+3);var n=new this.Date(this.get("FullYear",r),0,1);return 4!==this.get("Day",n)&&(this.set("Month",e,0),this.set("Date",e,1+(11-this.get("Day",n))%7)),(1+Math.floor((r.valueOf()-n.valueOf())/6048e5)).toString()},{compose:function(t,i,e){return t.keepProps.includes("grid")||(t.keepProps.push("grid"),t.prototype.getMaxLabelDimensions=v,g(t.prototype,"unsquish",D),g(t.prototype,"getOffset",m),s(t,"init",B),s(t,"afterGetTitlePosition",y),s(t,"afterInit",b),s(t,"afterRender",M),s(t,"afterSetAxisTranslation",k),s(t,"afterSetOptions",A),s(t,"afterSetOptions",S),s(t,"afterSetScale",w),s(t,"afterTickSize",C),s(t,"trimTicks",j),s(t,"destroy",P),s(i,"afterSetChartSize",O),s(e,"afterGetLabelPosition",E),s(e,"labelFormat",T)),t}}}),e(i,"Gantt/Tree.js",[i["Core/Utilities.js"]],function(t){var i=this&&this.__rest||function(t,i){var e={};for(var o in t)Object.prototype.hasOwnProperty.call(t,o)&&0>i.indexOf(o)&&(e[o]=t[o]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols)for(var r=0,o=Object.getOwnPropertySymbols(t);r<o.length;r++)0>i.indexOf(o[r])&&Object.prototype.propertyIsEnumerable.call(t,o[r])&&(e[o[r]]=t[o[r]]);return e},e=t.extend,o=t.isNumber,r=t.pick;function n(t,i,s,a,h,l){var d,c,p=l&&l.after,u=l&&l.before,f={data:a,depth:s-1,id:t,level:s,parent:i||""},g=0,x=0;"function"==typeof u&&u(f,l);var v=(h[t]||[]).map(function(i){var e=n(i.id,t,s+1,i,h,l),r=i.start||NaN,a=!0===i.milestone?r:i.end||NaN;return d=!o(d)||r<d?r:d,c=!o(c)||a>c?a:c,g=g+1+e.descendants,x=Math.max(e.height+1,x),e});return a&&(a.start=r(a.start,d),a.end=r(a.end,c)),e(f,{children:v,descendants:g,height:x}),"function"==typeof p&&p(f,l),f}return{getNode:n,getTree:function(t,e){var o,r;return n("",null,1,null,(o=[],Object.keys(r=t.reduce(function(t,i){var e=i.parent,r=void 0===e?"":e,n=i.id;return void 0===t[r]&&(t[r]=[]),t[r].push(i),n&&o.push(n),t},{})).forEach(function(t){var e;if(""!==t&&-1===o.indexOf(t)){var n=r[t].map(function(t){return i(t,[])});(e=r[""]).push.apply(e,n),delete r[t]}}),r),e)}}}),e(i,"Core/Axis/TreeGrid/TreeGridTick.js",[i["Core/Utilities.js"]],function(t){var i=t.addEvent,e=t.removeEvent,o=t.isObject,r=t.isNumber,n=t.pick,s=t.wrap;function a(){this.treeGrid||(this.treeGrid=new d(this))}function h(t,i,e,s,a,h,l,d,c){var p,u,f,g=n(this.options&&this.options.labels,h),x=this.pos,v=this.axis,m="treegrid"===v.options.type,y=t.apply(this,[i,e,s,a,g,l,d,c]);if(m){var b=g&&o(g.symbol,!0)?g.symbol:{},M=b.width,k=b.padding,A=void 0===k?v.linkedParent?0:5:k,S=g&&r(g.indentation)?g.indentation:0;f=(u=(p=v.treeGrid.mapOfPosToGridNode)&&p[x])&&u.depth||1,y.x+=(void 0===M?0:M)+2*A+(f-1)*S}return y}function l(t){var s,a,h,l,d,c,p,u,f,g,x,v,m,y,b,M,k,A=this.pos,S=this.axis,w=this.label,C=this.treeGrid,O=this.options,P=null==C?void 0:C.labelIcon,B=null==w?void 0:w.element,E=S.treeGrid,T=S.options,j=S.chart,D=S.tickPositions,G=E.mapOfPosToGridNode,I=n(null==O?void 0:O.labels,null==T?void 0:T.labels),L=I&&o(I.symbol,!0)?I.symbol:{},R=G&&G[A],N=R||{},z=N.descendants,W=N.depth,U=R&&z&&z>0,_="treegrid"===T.type&&B,H=D.indexOf(A)>-1,X="highcharts-treegrid-node-",F=X+"level-",Y=j.styledMode;(_&&R&&w.removeClass(RegExp(F+".*")).addClass(F+W),t.apply(this,Array.prototype.slice.call(arguments,1)),_&&U)?(b=E.isCollapsed(R),s={color:!Y&&w.styles.color||"",collapsed:b,group:w.parentGroup,options:L,renderer:w.renderer,show:H,xy:w.xy},l=!(h=this.treeGrid).labelIcon,d=s.renderer,c=s.xy,u=(p=s.options).width||0,f=p.height||0,g=(null!==(a=p.padding)&&void 0!==a?a:this.axis.linkedParent)?0:5,x={x:c.x-u/2-g,y:c.y-f/2},v=s.collapsed?90:180,m=s.show&&r(x.y),(y=h.labelIcon)||(h.labelIcon=y=d.path(d.symbols[p.type](p.x||0,p.y||0,u,f)).addClass("highcharts-label-icon").add(s.group)),y[m?"show":"hide"](),d.styledMode||y.attr({cursor:"pointer",fill:n(s.color,"#666666"),"stroke-width":1,stroke:p.lineColor,strokeWidth:p.lineWidth||0}),y[l?"attr":"animate"]({translateX:x.x,translateY:x.y,rotation:v}),M=X+(b?"collapsed":"expanded"),k=X+(b?"expanded":"collapsed"),w.addClass(M).removeClass(k),Y||w.css({cursor:"pointer"}),[w,P].forEach(function(t){t&&!t.attachedTreeGridEvents&&(i(t.element,"mouseover",function(){w.addClass("highcharts-treegrid-node-active"),w.renderer.styledMode||w.css({textDecoration:"underline"})}),i(t.element,"mouseout",function(){var t;t=o(I.style)?I.style:{},w.removeClass("highcharts-treegrid-node-active"),w.renderer.styledMode||w.css({textDecoration:t.textDecoration||"none"})}),i(t.element,"click",function(){C.toggleCollapse()}),t.attachedTreeGridEvents=!0)})):P&&(e(B),null==w||w.css({cursor:"default"}),P.destroy())}var d=function(){function t(t){this.tick=t}return t.compose=function(t){var e=t.prototype;e.toggleCollapse||(i(t,"init",a),s(e,"getLabelPosition",h),s(e,"renderLabel",l),e.collapse=function(t){this.treeGrid.collapse(t)},e.expand=function(t){this.treeGrid.expand(t)},e.toggleCollapse=function(t){this.treeGrid.toggleCollapse(t)})},t.prototype.collapse=function(t){var i=this.tick,e=i.axis,o=e.brokenAxis;if(o&&e.treeGrid.mapOfPosToGridNode){var r=i.pos,s=e.treeGrid.mapOfPosToGridNode[r],a=e.treeGrid.collapse(s);o.setBreaks(a,n(t,!0))}},t.prototype.destroy=function(){this.labelIcon&&this.labelIcon.destroy()},t.prototype.expand=function(t){var i=this.tick,e=i.pos,o=i.axis,r=o.treeGrid,s=o.brokenAxis,a=r.mapOfPosToGridNode;if(s&&a){var h=a[e],l=r.expand(h);s.setBreaks(l,n(t,!0))}},t.prototype.toggleCollapse=function(t){var i=this.tick,e=i.axis,o=e.brokenAxis;if(o&&e.treeGrid.mapOfPosToGridNode){var r=i.pos,s=e.treeGrid.mapOfPosToGridNode[r],a=e.treeGrid.toggleCollapse(s);o.setBreaks(a,n(t,!0))}},t}();return d}),e(i,"Series/TreeUtilities.js",[i["Core/Color/Color.js"],i["Core/Utilities.js"]],function(t,i){var e=i.extend,o=i.isArray,r=i.isNumber,n=i.isObject,s=i.merge,a=i.pick,h=i.relativeLength;return{getColor:function(i,e){var o,r,n,s,h,l,d,c=e.index,p=e.mapOptionsToLevel,u=e.parentColor,f=e.parentColorIndex,g=e.series,x=e.colors,v=e.siblings,m=g.points,y=g.chart.options.chart;return i&&(r=m[i.i],n=p[i.level]||{},r&&n.colorByPoint&&(h=r.index%(x?x.length:y.colorCount),s=x&&x[h]),g.chart.styledMode||(l=a(r&&r.options.color,n&&n.color,s,u&&((o=n&&n.colorVariation)&&"brightness"===o.key&&c&&v?t.parse(u).brighten(o.to*(c/v)).get():u),g.color)),d=a(r&&r.options.colorIndex,n&&n.colorIndex,h,f,e.colorIndex)),{color:l,colorIndex:d}},getLevelOptions:function(t){var i,e,h,l,d,c,p={};if(n(t))for(l=r(t.from)?t.from:1,c=t.levels,e={},i=n(t.defaults)?t.defaults:{},o(c)&&(e=c.reduce(function(t,e){var o,h,d;return n(e)&&r(e.level)&&(h=a((d=s({},e)).levelIsConstant,i.levelIsConstant),delete d.levelIsConstant,delete d.level,n(t[o=e.level+(h?0:l-1)])?s(!0,t[o],d):t[o]=d),t},{})),d=r(t.to)?t.to:1,h=0;h<=d;h++)p[h]=s({},i,n(e[h])?e[h]:{});return p},getNodeWidth:function(t,i){var e=t.chart,o=t.options,r=o.nodeDistance,n=void 0===r?0:r,s=o.nodeWidth,a=void 0===s?0:s,l=e.plotSizeX,d=void 0===l?1:l;if("auto"===a){if("string"==typeof n&&/%$/.test(n))return d/(i+parseFloat(n)/100*(i-1));var c=Number(n);return(d+c)/(i||1)-c}return h(a,d)},setTreeValues:function t(i,o){var r=o.before,n=o.idRoot,s=o.mapIdToNode[n],h=!1!==o.levelIsConstant,l=o.points[i.i],d=l&&l.options||{},c=[],p=0;i.levelDynamic=i.level-(h?0:s.level),i.name=a(l&&l.name,""),i.visible=n===i.id||!0===o.visible,"function"==typeof r&&(i=r(i,o)),i.children.forEach(function(r,n){var s=e({},o);e(s,{index:n,siblings:i.children.length,visible:i.visible}),r=t(r,s),c.push(r),r.visible&&(p+=r.val)});var u=a(d.value,p);return i.visible=u>=0&&(p>0||i.visible),i.children=c,i.childrenTotal=p,i.isLeaf=i.visible&&!p,i.val=u,i},updateRootId:function(t){var i,e;return n(t)&&(e=n(t.options)?t.options:{},i=a(t.rootNode,e.rootId,""),n(t.userOptions)&&(t.userOptions.rootId=i),t.rootNode=i),i}}}),e(i,"Core/Axis/TreeGrid/TreeGridAxis.js",[i["Core/Axis/BrokenAxis.js"],i["Core/Axis/GridAxis.js"],i["Gantt/Tree.js"],i["Core/Axis/TreeGrid/TreeGridTick.js"],i["Series/TreeUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,n){var s,a=r.getLevelOptions,h=n.addEvent,l=n.find,d=n.fireEvent,c=n.isArray,p=n.isObject,u=n.isString,f=n.merge,g=n.pick,x=n.removeEvent,v=n.wrap;function m(t,i){var e=t.collapseEnd||0,o=t.collapseStart||0;return e>=i&&(o-=.5),{from:o,to:e,showPoints:!1}}function y(t,i,o){var r,n,s=[],a=[],h={},d="boolean"==typeof i&&i,c={},f=-1,g=e.getTree(t,{after:function(t){var i=c[t.pos],e=0,o=0;i.children.forEach(function(t){o+=(t.descendants||0)+1,e=Math.max((t.height||0)+1,e)}),i.descendants=o,i.height=e,i.collapsed&&a.push(i)},before:function(t){var i,e,o=p(t.data,!0)?t.data:{},r=u(o.name)?o.name:"",n=h[t.parent],a=p(n,!0)?c[n.pos]:null;d&&p(a,!0)&&(i=l(a.children,function(t){return t.name===r}))?(e=i.pos,i.nodes.push(t)):e=f++,!c[e]&&(c[e]=i={depth:a?a.depth+1:0,name:r,id:o.id,nodes:[t],children:[],pos:e},-1!==e&&s.push(r),p(a,!0)&&a.children.push(i)),u(t.id)&&(h[t.id]=t),i&&!0===o.collapsed&&(i.collapsed=!0),t.pos=e}});return r=c,{categories:s,mapOfIdToNode:h,mapOfPosToGridNode:c=(n=function(t,i,e){var r=t.nodes,s=i+(-1===i?0:o-1),a=(s-i)/2,h=i+a;return r.forEach(function(t){var e=t.data;p(e,!0)&&(e.y=i+(e.seriesIndex||0),delete e.seriesIndex),t.pos=h}),e[h]=t,t.pos=h,t.tickmarkOffset=a+.5,t.collapseStart=s+.5,t.children.forEach(function(t){n(t,s+1,e),s=(t.collapseEnd||0)-.5}),t.collapseEnd=s+.5,e})(r["-1"],-1,{}),collapsedNodes:a,tree:g}}function b(t){t.target.axes.filter(function(t){return"treegrid"===t.options.type}).forEach(function(i){var e,o,r=i.options||{},n=r.labels,s=r.uniqueNames,h=r.max,l=!i.treeGrid.mapOfPosToGridNode||i.series.some(function(t){return!t.hasRendered||t.isDirtyData||t.isDirty}),d=0;if(l){if(e=i.series.reduce(function(t,i){return i.visible&&((i.options.data||[]).forEach(function(e){i.options.keys&&i.options.keys.length&&(e=i.pointClass.prototype.optionsToObject.call({series:i},e),i.pointClass.setGanttPointAliases(e)),p(e,!0)&&(e.seriesIndex=d,t.push(e))}),!0===s&&d++),t},[]),h&&e.length<h)for(var u=e.length;u<=h;u++)e.push({name:u+"​"});o=y(e,s||!1,!0===s?d:1),i.categories=o.categories,i.treeGrid.mapOfPosToGridNode=o.mapOfPosToGridNode,i.hasNames=!0,i.treeGrid.tree=o.tree,i.series.forEach(function(t){var i=(t.options.data||[]).map(function(i){return c(i)&&t.options.keys&&t.options.keys.length&&e.forEach(function(t){i.indexOf(t.x)>=0&&i.indexOf(t.x2)>=0&&(i=t)}),p(i,!0)?f(i):i});t.visible&&t.setData(i,!1)}),i.treeGrid.mapOptionsToLevel=a({defaults:n,from:1,levels:n&&n.levels,to:i.treeGrid.tree&&i.treeGrid.tree.height}),"beforeRender"===t.type&&(i.treeGrid.collapsedNodes=o.collapsedNodes)}})}function M(t,i){var e,o,r,n=this.treeGrid.mapOptionsToLevel||{},a="treegrid"===this.options.type,h=this.ticks,l=h[i];a&&this.treeGrid.mapOfPosToGridNode?((e=n[(r=this.treeGrid.mapOfPosToGridNode[i]).depth])&&(o={labels:e}),!l&&s?h[i]=l=new s(this,i,void 0,void 0,{category:r.name,tickmarkOffset:r.tickmarkOffset,options:o}):(l.parameters.category=r.name,l.options=o,l.addLabel())):t.apply(this,Array.prototype.slice.call(arguments,1))}function k(t,i,e,o){var r=this,n="treegrid"===e.type;r.treeGrid||(r.treeGrid=new w(r)),n&&(h(i,"beforeRender",b),h(i,"beforeRedraw",b),h(i,"addSeries",function(t){if(t.options.data){var i=y(t.options.data,e.uniqueNames||!1,1);r.treeGrid.collapsedNodes=(r.treeGrid.collapsedNodes||[]).concat(i.collapsedNodes)}}),h(r,"foundExtremes",function(){r.treeGrid.collapsedNodes&&r.treeGrid.collapsedNodes.forEach(function(t){var i=r.treeGrid.collapse(t);r.brokenAxis&&(r.brokenAxis.setBreaks(i,!1),r.treeGrid.collapsedNodes&&(r.treeGrid.collapsedNodes=r.treeGrid.collapsedNodes.filter(function(i){return t.collapseStart!==i.collapseStart||t.collapseEnd!==i.collapseEnd})))})}),h(r,"afterBreaks",function(){"yAxis"===r.coll&&!r.staticScale&&r.chart.options.chart.height&&(r.isDirty=!0)}),e=f({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10}},uniqueNames:!1},e,{reversed:!0})),t.apply(r,[i,e,o]),n&&(r.hasNames=!0,r.options.showLastLabel=!0)}function A(t){var i,e=this.options,o="number"==typeof e.linkedTo?null===(i=this.chart[this.coll])||void 0===i?void 0:i[e.linkedTo]:void 0;if("treegrid"===e.type){if(this.min=g(this.userMin,e.min,this.dataMin),this.max=g(this.userMax,e.max,this.dataMax),d(this,"foundExtremes"),this.setAxisTranslation(),this.tickInterval=1,this.tickmarkOffset=.5,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[],o){var r=o.getExtremes();this.min=g(r.min,r.dataMin),this.max=g(r.max,r.dataMax),this.tickPositions=o.tickPositions}this.linkedParent=o}else t.apply(this,Array.prototype.slice.call(arguments,1))}function S(t){var i=this;"treegrid"===i.options.type&&i.visible&&i.tickPositions.forEach(function(t){var e=i.ticks[t];e.label&&e.label.attachedTreeGridEvents&&(x(e.label.element),e.label.attachedTreeGridEvents=!1)}),t.apply(i,Array.prototype.slice.call(arguments,1))}var w=function(){function r(t){this.axis=t}return r.compose=function(r,n,a,h){if(!r.keepProps.includes("treeGrid")){var l=r.prototype;r.keepProps.push("treeGrid"),v(l,"generateTick",M),v(l,"init",k),v(l,"setTickInterval",A),v(l,"redraw",S),l.utils={getNode:e.getNode},s||(s=h)}return i.compose(r,n,h),t.compose(r,a),o.compose(h),r},r.prototype.setCollapsedStatus=function(t){var i=this.axis,e=i.chart;i.series.forEach(function(i){var o=i.options.data;if(t.id&&o){var r=e.get(t.id),n=o[i.data.indexOf(r)];r&&n&&(r.collapsed=t.collapsed,n.collapsed=t.collapsed)}})},r.prototype.collapse=function(t){var i=this.axis,e=i.options.breaks||[],o=m(t,i.max);return e.push(o),t.collapsed=!0,i.treeGrid.setCollapsedStatus(t),e},r.prototype.expand=function(t){var i=this.axis,e=i.options.breaks||[],o=m(t,i.max);return t.collapsed=!1,i.treeGrid.setCollapsedStatus(t),e.reduce(function(t,i){return(i.to!==o.to||i.from!==o.from)&&t.push(i),t},[])},r.prototype.getTickPositions=function(){var t=this.axis,i=Math.floor(t.min/t.tickInterval)*t.tickInterval,e=Math.ceil(t.max/t.tickInterval)*t.tickInterval;return Object.keys(t.treeGrid.mapOfPosToGridNode||{}).reduce(function(o,r){var n=+r;return n>=i&&n<=e&&!(t.brokenAxis&&t.brokenAxis.isInAnyBreak(n))&&o.push(n),o},[])},r.prototype.isCollapsed=function(t){var i=this.axis,e=i.options.breaks||[],o=m(t,i.max);return e.some(function(t){return t.from===o.from&&t.to===o.to})},r.prototype.toggleCollapse=function(t){return this.isCollapsed(t)?this.expand(t):this.collapse(t)},r}();return w}),e(i,"Series/Gantt/GanttSeries.js",[i["Series/Gantt/GanttPoint.js"],i["Series/Gantt/GanttSeriesDefaults.js"],i["Gantt/Pathfinder.js"],i["Core/Series/SeriesRegistry.js"],i["Extensions/StaticScale.js"],i["Core/Axis/TreeGrid/TreeGridAxis.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,n,s){var a,h=this&&this.__extends||(a=function(t,i){return(a=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}a(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),l=o.series,d=o.seriesTypes.xrange,c=s.extend,p=s.isNumber,u=s.merge,f=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return h(o,t),o.compose=function(t,i,o,s){d.compose(t),i&&(r.compose(t,i),o)&&(e.compose(i,o.prototype.pointClass),s&&n.compose(t,i,o,s))},o.prototype.drawPoint=function(i,e){var o,r=this.options,n=this.chart.renderer,s=i.shapeArgs,a=i.plotY,h=i.selected&&"select",l=r.stacking&&!r.borderRadius,d=i.graphic;i.options.milestone?p(a)&&null!==i.y&&!1!==i.visible?(o=n.symbols.diamond(s.x||0,s.y||0,s.width||0,s.height||0),d?d[e]({d:o}):i.graphic=d=n.path(o).addClass(i.getClassName(),!0).add(i.group||this.group),this.chart.styledMode||i.graphic.attr(this.pointAttribs(i,h)).shadow(r.shadow,null,l)):d&&(i.graphic=d.destroy()):t.prototype.drawPoint.call(this,i,e)},o.prototype.translatePoint=function(i){var e,o;t.prototype.translatePoint.call(this,i),i.options.milestone&&(o=(e=i.shapeArgs).height||0,i.shapeArgs={x:(e.x||0)-o/2,y:e.y,width:o,height:o})},o.defaultOptions=u(d.defaultOptions,i),o}(d);return c(f.prototype,{pointArrayMap:["start","end","y"],pointClass:t,setData:l.prototype.setData}),o.registerSeriesType("gantt",f),f}),e(i,"masters/modules/gantt.src.js",[i["Core/Globals.js"],i["Extensions/ArrowSymbols.js"],i["Gantt/Connection.js"],i["Extensions/CurrentDateIndication.js"],i["Core/Chart/GanttChart.js"],i["Stock/Navigator/Navigator.js"],i["Stock/RangeSelector/RangeSelector.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Series/Gantt/GanttSeries.js"]],function(t,i,e,o,r,n,s,a,h){return t.Connection=t.Connection||e,t.GanttChart=t.GanttChart||r,t.Navigator=t.Navigator||n,t.RangeSelector=t.RangeSelector||s,t.Scrollbar=t.Scrollbar||a,t.ganttChart=t.GanttChart.ganttChart,i.compose(t.SVGRenderer),o.compose(t.Axis,t.PlotLineOrBand),h.compose(t.Axis,t.Chart,t.Series,t.Tick),t.Navigator.compose(t.Chart,t.Axis,t.Series),t.RangeSelector.compose(t.Axis,t.Chart),t.Scrollbar.compose(t.Axis),t})});