<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="row" style="margin-top:10px">
            <div class="col-md-4">
                <h2 class="text-bold"><?= \auth()->user()->nom . ", " . \auth()->user()->prenom ?></h2>
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message') . "</div>";
                } ?>

                <?php echo form_open_multipart($locale . "/volontaire/language/save"); ?>
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Langue <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('langueId', $langues, set_value('langueId'), "class = 'form-control' id='langueId'");
                                ?>
                                <?= !empty(validation_show_error('langueId')) ? "<p class='text-danger'>" . validation_show_error('langueId') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Parler <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('niveauOral', $niveaux, set_value('niveauOral'), "class = 'form-control' id='niveauOral'");
                                ?>
                                <?= !empty(validation_show_error('niveauOral')) ? "<p class='text-danger'>" . validation_show_error('niveauOral') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Ecrire <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('niveauEcrit', $niveaux, set_value('niveauEcrit'), "class = 'form-control' id='niveauEcrit'");
                                ?>
                                <?= !empty(validation_show_error('niveauEcrit')) ? "<p class='text-danger'>" . validation_show_error('niveauEcrit') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Lire <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('niveauLire', $niveaux, set_value('niveauLire'), "class = 'form-control' id='niveauLire'");
                                ?>
                                <?= !empty(validation_show_error('niveauLire')) ? "<p class='text-danger'>" . validation_show_error('niveauLire') . "</p>" : "" ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer", "class='btn btn-primary btn-sm mt-2'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>

            <div class="col-md-8">
                <h2 class="text-bold">Compétences linguistiques</h2>

                <?php

                if (!empty($languages)) {
                    foreach ($languages as $language) {

                ?>
                        <?php echo form_open_multipart($locale . "/volontaire/language/edit", NULL, ['id' => $language->id]); ?>
                        <div class="card card-default">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <?= form_label("Langue <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('langueId', $langues, set_value('langueId', $language->langueId), "class = 'form-control' id='langueId'");
                                        ?>
                                        <?= !empty(validation_show_error('langueId')) ? "<p class='text-danger'>" . validation_show_error('langueId') . "</p>" : "" ?>

                                    </div>

                                    <div class="col-md-6">
                                        <?= form_label("Parler <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('niveauOral', $niveaux, set_value('niveauOral', $language->niveauOral), "class = 'form-control' id='niveauOral'");
                                        ?>
                                        <?= !empty(validation_show_error('niveauOral')) ? "<p class='text-danger'>" . validation_show_error('niveauOral') . "</p>" : "" ?>
                                    </div>

                                    <div class="col-md-6">
                                        <?= form_label("Ecrire <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('niveauEcrit', $niveaux, set_value('niveauEcrit', $language->niveauEcrit), "class = 'form-control' id='niveauEcrit'");
                                        ?>
                                        <?= !empty(validation_show_error('niveauEcrit')) ? "<p class='text-danger'>" . validation_show_error('niveauEcrit') . "</p>" : "" ?>
                                    </div>

                                    <div class="col-md-6">
                                        <?= form_label("Lire <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('niveauLire', $niveaux, set_value('niveauLire', $language->niveauLire), "class = 'form-control' id='niveauLire'");
                                        ?>
                                        <?= !empty(validation_show_error('niveauLire')) ? "<p class='text-danger'>" . validation_show_error('niveauLire') . "</p>" : "" ?>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <?php
                                echo form_submit("mysubmit", "Modifier", "class='btn btn-primary btn-sm mt-2'");
                                echo anchor($locale . "/volontaire/language/delete/" . $language->id, 'Supprimer', "class='btn btn-danger btn-sm mt-2'");
                                ?>
                            </div>
                        </div>
                        <?php echo form_close(); ?>

                <?php }
                } ?>
            </div>
        </div>

    </section>
</div>

<?= $this->endSection(); ?>