<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->nom . ", " . \auth()->user()->prenom ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message') . "</div>";
                } ?>

                <?php echo form_open_multipart($locale . "/volontaire/etude/save",); ?>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">
                            Études faites
                        </h3>
                        <p class='text-bold float-right'>
                            <font color='red'>*</font> Champ est obligatoire
                        </p>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Type d'éducation <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('typeId', $types, set_value('typeId'), "class = 'form-control' id='typeId'");
                                ?>
                                <?= !empty(validation_show_error('typeId')) ? "<p class='text-danger'>" . validation_show_error('typeId') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Nom du diplôme/qualification <font color='red'>*</font>"); ?>
                                <?php
                                $desc = [
                                    'type'  => 'text',
                                    'name'  => 'descriptionQualification',
                                    'id'    => 'descriptionQualification',
                                    'value' => set_value('descriptionQualification'),
                                    'placeholder' => "Nom du diplôme/qualification",
                                    'class' => 'form-control',
                                ];

                                echo form_input($desc);
                                ?>
                                <?= !empty(validation_show_error('descriptionQualification')) ? "<p class='text-danger'>" . validation_show_error('descriptionQualification') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Accent sur le degré <font color='red'>*</font>"); ?>
                                <?php
                                $accent = [
                                    'type'  => 'text',
                                    'name'  => 'domaineEtude',
                                    'id'    => 'domaineEtude',
                                    'value' => set_value('domaineEtude'),
                                    'placeholder' => "Accent sur le degré",
                                    'class' => 'form-control',
                                ];

                                echo form_input($accent);
                                ?>
                                <?= !empty(validation_show_error('domaineEtude')) ? "<p class='text-danger'>" . validation_show_error('domaineEtude') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Institution <font color='red'>*</font>"); ?>
                                <?php
                                $institution = [
                                    'type'  => 'text',
                                    'name'  => 'institution',
                                    'id'    => 'institution',
                                    'value' => set_value('institution'),
                                    'placeholder' => "Institution",
                                    'class' => 'form-control',
                                ];

                                echo form_input($institution);
                                ?>
                                <?= !empty(validation_show_error('institution')) ? "<p class='text-danger'>" . validation_show_error('institution') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Ville / pays <font color='red'>*</font>"); ?>
                                <?php
                                $ville = [
                                    'type'  => 'text',
                                    'name'  => 'villeEtPays',
                                    'id'    => 'villeEtPays',
                                    'value' => set_value('villeEtPays'),
                                    'placeholder' => "Ville et pays",
                                    'class' => 'form-control',
                                ];

                                echo form_input($ville);
                                ?>
                                <?= !empty(validation_show_error('villeEtPays')) ? "<p class='text-danger'>" . validation_show_error('villeEtPays') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de début <font color='red'>*</font>"); ?>
                                <?php $date = set_value('dateDebut') ?>
                                <div class="input-group date" id="dateDebut" data-target-input="nearest">
                                    <?= form_input('dateDebut', $date, "class='form-control datetimepicker-input', id='dateDebut' placeholder='Date de début'") ?>
                                    <div class="input-group-append" data-target="#dateDebut" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('dateDebut')) ? "<p class='text-danger'>" . validation_show_error('dateDebut') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de fin"); ?>
                                <?php $date = set_value('dateFin') ?>
                                <div class="input-group date" id="dateFin" data-target-input="nearest">
                                    <?= form_input('dateFin', $date, "class='form-control datetimepicker-input', id='dateFin' placeholder='Date de fin'") ?>
                                    <div class="input-group-append" data-target="#dateFin" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('dateFin')) ? "<p class='text-danger'>" . validation_show_error('dateFin') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Informations complémentaires"); ?>
                                <?php
                                $ville = [
                                    'type'  => 'text',
                                    'name'  => 'informationsComplementaire',
                                    'id'    => 'informationsComplementaire',
                                    'value' => set_value('informationsComplementaire'),
                                    'placeholder' => "Informations complémentaires",
                                    'class' => 'form-control',
                                ];

                                echo form_input($ville);
                                ?>
                                <?= !empty(validation_show_error('informationsComplementaire')) ? "<p class='text-danger'>" . validation_show_error('informationsComplementaire') . "</p>" : "" ?>

                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer", "class='btn btn-primary btn-sm'");

                        echo anchor($locale.'/volontaire/etudes', 'Retour', 'class="btn btn-default btn-sm"');
                        ?>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>