<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/activite", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    // print_r(validation_list_errors());

                    // echo "<pre>";
                    // print_r($activite);
                    // echo "</pre>";
                    ?>
                </div>

                <?php echo form_open_multipart($locale . $route, NULL, ['id' => (string)$activite->id]); ?>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <?= form_label("Nom de l'activite", 'nomActivite'); ?>
                        <?php
                        $nomActivite = [
                            'type'  => 'text',
                            'name'  => 'nomActivite',
                            'id'    => 'nomActivite',
                            'value' => set_value('nomActivite', $activite->nomActivite),
                            'placeholder' => "Nom de l'activite",
                            'class' => 'form-control',
                        ];

                        echo form_input($nomActivite);
                        ?>
                        <?= !empty(validation_show_error('nomActivite')) ? "<p class='text-danger'>" . validation_show_error('nomActivite') . "</p>" : "" ?>
                    </div>

                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $activite->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $activite->communeId,
                    ];

                    echo form_input($cm);

                    $zn = [
                        'type'  => 'hidden',
                        'name'  => 'zone_id_load',
                        'id'    => 'zone_id_load',
                        'value' => $activite->zoneId,
                    ];

                    echo form_input($zn);

                    $cl = [
                        'type'  => 'hidden',
                        'name'  => 'colline_id_load',
                        'id'    => 'colline_id_load',
                        'value' => $activite->collineId,
                    ];

                    echo form_input($cl);
                    ?>

                    <div class="col-md-4">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $activite->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Commune"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $activite->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Zone"); ?>
                        <?php
                        echo form_dropdown('zoneId', [], set_value('zoneId', $activite->zoneId), "class = 'form-control' id='zoneId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Colline"); ?>
                        <?php
                        echo form_dropdown('collineId', [], set_value('collineId', $activite->collineId), "class = 'form-control' id='collineId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Domaine de l'activite"); ?>
                        <?php
                        echo form_dropdown('domaineActiviteId', $domaines, set_value('domaineActiviteId', $activite->domaineActiviteId), "class = 'form-control' id='domaineActiviteId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Participant (H)"); ?>

                        <?php
                        $nbParticipantHomme = [
                            'type'  => 'text',
                            'name'  => 'nbParticipantHomme',
                            'id'    => 'nbParticipantHomme',
                            'value' => set_value('nbParticipantHomme', $activite->nbParticipantHomme),
                            'placeholder' => "Participant (H)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbParticipantHomme);
                        ?>
                        <?= !empty(validation_show_error('nbParticipantHomme')) ? "<p class='text-danger'>" . validation_show_error('nbParticipantHomme') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Participant (F)"); ?>

                        <?php
                        $nbParticipantFemme = [
                            'type'  => 'text',
                            'name'  => 'nbParticipantFemme',
                            'id'    => 'nbParticipantFemme',
                            'value' => set_value('nbParticipantFemme', $activite->nbParticipantFemme),
                            'placeholder' => "Participant (F)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbParticipantFemme);
                        ?>
                        <?= !empty(validation_show_error('nbParticipantFemme')) ? "<p class='text-danger'>" . validation_show_error('nbParticipantFemme') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Participant (Jeune)"); ?>

                        <?php
                        $nbParticipantJeune = [
                            'type'  => 'text',
                            'name'  => 'nbParticipantJeune',
                            'id'    => 'nbParticipantJeune',
                            'value' => set_value('nbParticipantJeune', $activite->nbParticipantJeune),
                            'placeholder' => "Participant (Jeune)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbParticipantJeune);
                        ?>
                        <?= !empty(validation_show_error('nbParticipantJeune')) ? "<p class='text-danger'>" . validation_show_error('nbParticipantJeune') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Lieu d'activite"); ?>

                        <?php
                        $lieuActivite = [
                            'type'  => 'text',
                            'name'  => 'lieuActivite',
                            'id'    => 'lieuActivite',
                            'value' => set_value('lieuActivite', $activite->lieuActivite),
                            'placeholder' => "Lieu d'activite",
                            'class' => 'form-control',
                        ];

                        echo form_input($lieuActivite);
                        ?>
                        <?= !empty(validation_show_error('lieuActivite')) ? "<p class='text-danger'>" . validation_show_error('lieuActivite') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Beneficiaire (H)"); ?>

                        <?php
                        $nbBeneficiaireHomme = [
                            'type'  => 'text',
                            'name'  => 'nbBeneficiaireHomme',
                            'id'    => 'nbBeneficiaireHomme',
                            'value' => set_value('nbBeneficiaireHomme', $activite->nbBeneficiaireHomme),
                            'placeholder' => "Beneficiaire (H)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBeneficiaireHomme);
                        ?>
                        <?= !empty(validation_show_error('nbBeneficiaireHomme')) ? "<p class='text-danger'>" . validation_show_error('nbBeneficiaireHomme') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Beneficiaire (F)"); ?>

                        <?php
                        $nbBeneficiaireFemme = [
                            'type'  => 'text',
                            'name'  => 'nbBeneficiaireFemme',
                            'id'    => 'nbBeneficiaireFemme',
                            'value' => set_value('nbBeneficiaireFemme', $activite->nbBeneficiaireFemme),
                            'placeholder' => "Beneficiaire (F)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBeneficiaireFemme);
                        ?>
                        <?= !empty(validation_show_error('nbBeneficiaireFemme')) ? "<p class='text-danger'>" . validation_show_error('nbBeneficiaireFemme') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Est finance ?"); ?>
                        <?php
                        echo form_dropdown('finance', $finances, set_value('finance', $activite->finance), "class = 'form-control' id='finance'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Recette"); ?>

                        <?php
                        $recette = [
                            'type'  => 'text',
                            'name'  => 'recette',
                            'id'    => 'recette',
                            'value' => set_value('recette', $activite->recette),
                            'placeholder' => "Recette",
                            'class' => 'form-control',
                        ];

                        echo form_input($recette);
                        ?>
                        <?= !empty(validation_show_error('recette')) ? "<p class='text-danger'>" . validation_show_error('recette') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Cout estime"); ?>

                        <?php
                        $coutEstime = [
                            'type'  => 'text',
                            'name'  => 'coutEstime',
                            'id'    => 'coutEstime',
                            'value' => set_value('coutEstime', $activite->coutEstime),
                            'placeholder' => "Cout estime",
                            'class' => 'form-control',
                        ];

                        echo form_input($coutEstime);
                        ?>
                        <?= !empty(validation_show_error('coutEstime')) ? "<p class='text-danger'>" . validation_show_error('coutEstime') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Date de debut <font color='red'>*</font>"); ?>
                        <?php $date = $activite->dateActivite ? $activite->dateActivite : set_value('dateActivite') ?>
                        <div class="input-group date" id="dateActivite" data-target-input="nearest">
                            <?= form_input('dateActivite', $date, "class='form-control datetimepicker-input', id='dateActivite' placeholder='Date debut'") ?>
                            <div class="input-group-append" data-target="#dateActivite" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateActivite')) ? "<p class='text-danger'>" . validation_show_error('dateActivite') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-4">
                        <?= form_label("Heure de debut"); ?>

                        <?php
                        $heureDebut = [
                            'type'  => 'text',
                            'name'  => 'heureDebut',
                            'id'    => 'heureDebut',
                            'value' => set_value('heureDebut', $activite->heureDebut),
                            'placeholder' => "Heure de debut",
                            'class' => 'form-control',
                        ];

                        echo form_input($heureDebut);
                        ?>
                        <?= !empty(validation_show_error('heureDebut')) ? "<p class='text-danger'>" . validation_show_error('heureDebut') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Duree (Heure)"); ?>

                        <?php
                        $dureeheure = [
                            'type'  => 'text',
                            'name'  => 'dureeheure',
                            'id'    => 'dureeheure',
                            'value' => set_value('dureeheure', $activite->dureeheure),
                            'placeholder' => "Duree (Heure)",
                            'class' => 'form-control',
                        ];

                        echo form_input($dureeheure);
                        ?>
                        <?= !empty(validation_show_error('dureeheure')) ? "<p class='text-danger'>" . validation_show_error('dureeheure') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4 mb-3">
                        <?= form_label("Fichier"); ?>
                        <?php

                        $pathFile = [
                            'type'  => 'file',
                            'name'  => 'pathFile',
                            'id'    => 'pathFile',
                            'class' => 'form-control',
                        ];

                        echo form_upload($pathFile);
                        if(!empty($activite->pathFile)){
                           echo anchor(base_url()."files/activite/".$activite->pathFile, $activite->pathFile, "target='_blank'");
                        }
                        ?>                        
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>