<?php

namespace App\Traits;

use App\Models\Pays as ModelsPays;

class PaysTrait
{

    public static function ArrayFormat($id = NULL): array|string
    {
        $myPays = [];
        $myPays[] = "Choix";
        $myPays[1000] = "Indéfini";

        foreach ((new ModelsPays())->findAll() as $pay) {
            $myPays[$pay->id] = $pay->description;
        }
        return $id > 0 ? $myPays[$id] : $myPays;
    }

    public static function HTMLFormat($id)
    {
        $pays = (new ModelsPays())->findAll();

        $myPays = "";
        $myPays .= "<option >" . lang("Params.choice") . "</option>";

        foreach ($pays as $pay) {
            $select = $pay->id == $id ? "selected" : "";
            $myPays .= "<option $select value='" . $pay->id . "'>" . $pay->description . "</option>";
        }

        return $myPays;
    }
}
