<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Language extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'langueId' => [
                'type'       => 'INT',
                'constraint' => '10',
            ],
            'niveauEcrit' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ], 
            'niveauLire' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ],
            'niveauOral' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ],
            'userId' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_languages');
    }

    public function down()
    {
        $this->forge->dropTable('vt_languages');
    }
}
