<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Models\Etude;
use Modules\Volontaire\Models\Language;
use Modules\Volontaire\Models\Volontaire;

use App\Traits\LanguageTrait;

class Dashboard extends BaseController
{
    public function index()
    {
        $uri = current_url(true);
        $volontaireId = $uri->getSegment(4);

        $id = \auth()->user()->id;
        $id = $volontaireId > 0 ? $volontaireId : $id;

        $session = session();

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $volontaire = (new Volontaire())->where('userId', $id)->first();

        if($id == \auth()->user()->id)
            $session->set('passportImage', $volontaire->passportImagePath);

        $this->viewData['volontaire'] = $volontaire;
        $this->viewData['etudes'] = (new Etude())->where('userId', $id)->get()->getResult();
        $this->viewData['mesLangues'] = (new Language())->where('userId', $id)->get()->getResult();
        $this->viewData['langues'] = LanguageTrait ::langues();

        return view('volonatire/dash/index', $this->viewData);
    }
}
