<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\VulnerabiliteModel;
use Psr\Log\LoggerInterface;
use stdClass;

class VulnerabiliteController extends BaseController
{
    public VulnerabiliteModel $vulnerabiliteModel;

    function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->vulnerabiliteModel = new VulnerabiliteModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/vulnerabilite/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/vulnerabilite/save";
        $this->viewData['vulnerabilite'] =  $this->initVulnerabilite($id);

        return view('params/vulnerabilite/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/vulnerabilite/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/vulnerabilite/save";
            $this->viewData['vulnerabilite'] =  $this->initVulnerabilite($id);

            return view('params/vulnerabilite/add', $this->viewData);
        } else {

            $unVulnerabilite = $this->unVulnerabilite();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Une vulnerabilite <b>" . $unVulnerabilite['description'] . "</b> a été modifié</div>");
                $stmt = $this->vulnerabiliteModel->update($id, $unVulnerabilite);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Une vulnerabilite <b>" . $unVulnerabilite['description'] . "</b> a été bien enregistré</div>");
                $stmt = $this->vulnerabiliteModel->save($unVulnerabilite);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/vulnerabilite'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->vulnerabiliteModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Une vulnerabilite a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/vulnerabilite'));
        }
    }

    private function unVulnerabilite()
    {
        $typeFormation = [];
        $typeFormation['description'] = $this->request->getPost('description');

        return $typeFormation;
    }

    private function initVulnerabilite($id = NULL)
    {
        $typeFormation = NULL;
        if ($id) {
            $typeFormation = $this->vulnerabiliteModel->find($id);
        } else {
            $typeFormation = new stdClass();
            $typeFormation->id = 0;
            $typeFormation->description = "";
        }

        return $typeFormation;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->vulnerabiliteModel, $search_column, $order_column);
        $output = $this->formatVulnerabilite($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatVulnerabilite($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/params/vulnerabilite/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/params/vulnerabilite/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
