<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\CollineModel;
use Modules\Params\Models\ZoneModel;
use Psr\Log\LoggerInterface;
use stdClass;

class CollineController extends BaseController
{
    protected CollineModel $collineModel;
    protected ZoneModel $zoneModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->collineModel = new CollineModel();
        $this->zoneModel = new ZoneModel();
    }
    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $colline =  $this->initColline($id);

        $this->viewData['url_list'] = "/params/colline/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/colline/save";
        $this->viewData['colline'] =  $colline;
        $this->viewData['zones'] = CommonTrait::formatData($this->zoneModel);

        return view('params/colline/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {
            $colline =  $this->initColline($id);

            $this->viewData['url_list'] = "/params/colline/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/colline/save";
            $this->viewData['colline'] =  $colline;
            $this->viewData['zones'] = CommonTrait::formatData($this->zoneModel);

            return view('params/colline/add', $this->viewData);
        } else {

            $uneColline = $this->uneColline();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La colline <b>" . $uneColline['description'] . "</b> a été modifiée</div>");
                $stmt = $this->collineModel->update($id, $uneColline);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La colline <b>" . $uneColline['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->collineModel->save($uneColline);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/colline'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->zoneModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La colline a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/colline'));
        }
        
    }
    function collines() {
        $uri = current_url(true);

        $zoneId = $uri->getSegment(4); 
        $collineId = $uri->getSegment(5);

        $output = ['collines' => $this->formatStringcollines($this->collineModel->where("zoneId", $zoneId)->get()->getResult(), $collineId)];
        return $this->response->setJSON($output);
    }

    private static function formatStringcollines($collines, $collineId){
        $options = "<option value='0'>Choix (colline)</option>";

        foreach ($collines as $colline) {
            # code...
            $selected = $colline->id == $collineId?"selected":"";
            $options .= "<option $selected value='".$colline->id."'>".$colline->description."</option>";
        }

        return $options;
    }

    private function uneColline()
    {
        $colline = [];
        $colline['description'] = $this->request->getPost('description');
        $colline['zoneId'] = $this->request->getPost('zoneId');
        $colline['longitude'] = $this->request->getPost('longitude');
        $colline['latitude'] = $this->request->getPost('latitude');

        return $colline;
    }

    private function initColline($id = NULL)
    {
        $colline = NULL;
        if ($id) {
            $colline = $this->collineModel->find($id);
        } else {
            $colline = new stdClass();
            $colline->id = 0;
            $colline->zoneId = "";
            $colline->description = "";
            $colline->longitude = "-1.0";
            $colline->latitude = "-1.0";
        }

        return $colline;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['zoneId'] = ['rules'  => 'required|is_natural_no_zero'];
        $rules['longitude'] = ['rules'  => 'permit_empty|decimal'];
        $rules['latitude'] = ['rules'  => 'permit_empty|decimal'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description', 'latitude', 'longitude'];
        $order_column = ['id', 'description', 'latitude', 'longitude'];

        $fetch_data = DatatableQuery::build_query($this->collineModel, $search_column, $order_column);
        $output = $this->formatZones($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatZones($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $sub_array[] =  CommonTrait::formatData($this->zoneModel,$data->zoneId);
                $sub_array[] =  $data->latitude;
                $sub_array[] =  $data->longitude;
                $option = "-";
                // if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/colline/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/colline/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                //}
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
