<?php

namespace Modules\PS\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\PS\Models\MaterielModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

use function PHPUnit\Framework\fileExists;

class MaterielController extends BaseController
{
    protected MaterielModel $materielModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->materielModel = new MaterielModel();
    }
    public function index()
    {
        $this->viewData['url_list'] = "/ps/materiel/data";
        $this->viewData['js'] = "Common.js";
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['title'] = "Liste des materiels";

        return view('ps/materiel/index', $this->viewData);
    }
    public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['route'] = "/ps/materiel/save";
        $this->viewData['materiel'] =  $this->initMateriel($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['exTrouseSecours'] = CommonTrait::ouiNon();

        if ($id > 0)
            $title = "Editer un materiel";
        else
            $title = "Nouveau materiel";

        $this->viewData['title'] = $title;

        return view('ps/materiel/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "Volontaire.js";
            $this->viewData['route'] = "/ps/materiel/save";
            $this->viewData['materiel'] =  $this->initMateriel($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['exTrouseSecours'] = CommonTrait::ouiNon();

            if ($id > 0)
                $title = "Editer un materiel";
            else
                $title = "Nouveau materiel";

            $this->viewData['title'] = $title;


            return view('ps/materiel/add', $this->viewData);
        } else {

            $uneMateriel = $this->uneMateriel();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Les materiels de premier secour ont été modifiés</div>");
                $stmt = $this->materielModel->update($id, $uneMateriel);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Les materiels de premier secour ont été bien enregistrés</div>");
                $stmt = $this->materielModel->save($uneMateriel);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/ps/materiel'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(6);

        $stmnt = $this->materielModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Les materiels premier secour ont été suprimés</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/materiel'));
        }
    }

    private function uneMateriel()
    {
        $materiel = [];
        $materiel['brancheId'] = $this->request->getPost('brancheId');
        $materiel['communeId'] = $this->request->getPost('communeId');
        $materiel['nbManuelPSEnfant'] = $this->request->getPost('nbManuelPSEnfant');
        $materiel['nbBrancards'] = $this->request->getPost('nbBrancards');
        $materiel['nbManequinEnfant'] = $this->request->getPost('nbManequinEnfant');
        $materiel['nbManequinEnAdulte'] = $this->request->getPost('nbManequinEnAdulte');
        $materiel['dateEnregistrement'] = $this->request->getPost('dateEnregistrement');
        $materiel['nbAttele'] = $this->request->getPost('nbAttele');
        $materiel['nbBoiteImage'] = $this->request->getPost('nbBoiteImage');
        $materiel['nbCouverture'] = $this->request->getPost('nbCouverture');
        $materiel['nbManuelPSBlessureRoute'] = $this->request->getPost('nbManuelPSBlessureRoute');
        $materiel['nbManuelPSBlessurePRepondant'] = $this->request->getPost('nbManuelPSBlessurePRepondant');
        $materiel['nbManequinBebe'] = $this->request->getPost('nbManequinBebe');
        $materiel['nbKitPS'] = $this->request->getPost('nbKitPS');
        $materiel['nbBallonInsuflatteurOxygene'] = $this->request->getPost('nbBallonInsuflatteurOxygene');
        $materiel['nbDefibrillateurAutoExtern'] = $this->request->getPost('nbDefibrillateurAutoExtern');
        $materiel['masquePoche'] = $this->request->getPost('masquePoche');
        $materiel['existeTrousseSecour'] = $this->request->getPost('existeTrousseSecour');
        $materiel['nbTrousseSecour'] = $this->request->getPost('nbTrousseSecour');
        $materiel['nbGrantProprePaire'] = $this->request->getPost('nbGrantProprePaire');
        $materiel['nbBetadineFlacon'] = $this->request->getPost('nbBetadineFlacon');
        $materiel['nbBettolFlacon'] = $this->request->getPost('nbBettolFlacon');
        $materiel['nbAntalgiquePommadeTube'] = $this->request->getPost('nbAntalgiquePommadeTube');
        $materiel['nbAntalgiqueSprayTube'] = $this->request->getPost('nbAntalgiqueSprayTube');
        $materiel['nbAntalgiqueComprimeCP'] = $this->request->getPost('nbAntalgiqueComprimeCP');
        $materiel['nbPaireCiseauPiece'] = $this->request->getPost('nbPaireCiseauPiece');
        $materiel['nbPinceKocherPiece'] = $this->request->getPost('nbPinceKocherPiece');
        $materiel['nbMasqueFacialPiece'] = $this->request->getPost('nbMasqueFacialPiece');
        $materiel['nbServietteEssuiMain'] = $this->request->getPost('nbServietteEssuiMain');
        $materiel['ouateRouleau'] = $this->request->getPost('ouateRouleau');
        $materiel['nbCompresseSterilePiece'] = $this->request->getPost('nbCompresseSterilePiece');
        $materiel['echarpeDrapTriangulaire'] = $this->request->getPost('echarpeDrapTriangulaire');
        $materiel['sparadrapPerforeRouleau'] = $this->request->getPost('sparadrapPerforeRouleau');
        $materiel['sparadrapEtanchePiece'] = $this->request->getPost('sparadrapEtanchePiece');
        $materiel['bandeElastiquePiece'] = $this->request->getPost('bandeElastiquePiece');
        $materiel['ambuBuccalEnfantPiece'] = $this->request->getPost('ambuBuccalEnfantPiece');
        $materiel['ambuBuccalAdultePiece'] = $this->request->getPost('ambuBuccalAdultePiece');
        $materiel['ambuBuccalNourrissonPiece'] = $this->request->getPost('ambuBuccalNourrissonPiece');
        $materiel['nbSavonPiece'] = $this->request->getPost('nbSavonPiece');
        $materiel['nbThermometrePiece'] = $this->request->getPost('nbThermometrePiece');
        $materiel['nbThermosPiece'] = $this->request->getPost('nbThermosPiece');
        $materiel['nbSROPiece'] = $this->request->getPost('nbSROPiece');
        $materiel['picettePiece'] = $this->request->getPost('picettePiece');
        $materiel['lameRasoirPiece'] = $this->request->getPost('lameRasoirPiece');
        $materiel['sacPoubellePiece'] = $this->request->getPost('sacPoubellePiece');
        $materiel['carnetTroussePiece'] = $this->request->getPost('carnetTroussePiece');
        $materiel['styloPiece'] = $this->request->getPost('styloPiece');
        $materiel['userId'] = \auth()->user()->id;

        return $materiel;
    }

    private function initMateriel($id = NULL)
    {
        $materiel = NULL;
        if ($id) {
            $materiel = $this->materielModel->find($id);
        } else {
            $materiel = new stdClass();
            $materiel->id = 0;
            $materiel->brancheId = NULL;
            $materiel->communeId = NULL;
            $materiel->dateEnregistrement = NULL;
            $materiel->nbManuelPSEnfant = 0;
            $materiel->nbBrancards = 0;
            $materiel->nbManequinEnfant = 0;
            $materiel->nbManequinEnAdulte = 0;
            $materiel->nbAttele = 0;
            $materiel->nbBoiteImage = 0;
            $materiel->nbCouverture = 0;
            $materiel->nbManuelPSBlessureRoute = 0;
            $materiel->nbManuelPSBlessurePRepondant = 0;
            $materiel->nbManequinBebe = 0;
            $materiel->nbKitPS = 0;
            $materiel->nbBallonInsuflatteurOxygene = 0;
            $materiel->nbDefibrillateurAutoExtern = 0;
            $materiel->masquePoche = 0;
            $materiel->existeTrousseSecour = "NON";
            $materiel->nbTrousseSecour = 0;
            $materiel->nbGrantProprePaire = 0;
            $materiel->nbBetadineFlacon = 0;
            $materiel->nbBettolFlacon = 0;
            $materiel->nbAntalgiquePommadeTube = 0;
            $materiel->nbAntalgiqueSprayTube = 0;
            $materiel->nbAntalgiqueComprimeCP = 0;
            $materiel->nbPaireCiseauPiece = 0;
            $materiel->nbPinceKocherPiece = 0;
            $materiel->nbMasqueFacialPiece = 0;
            $materiel->nbServietteEssuiMain = 0;
            $materiel->ouateRouleau = 0;
            $materiel->nbCompresseSterilePiece = 0;
            $materiel->echarpeDrapTriangulaire = 0;
            $materiel->sparadrapPerforeRouleau = 0;
            $materiel->sparadrapEtanchePiece = 0;
            $materiel->bandeElastiquePiece = 0;
            $materiel->ambuBuccalEnfantPiece = 0;
            $materiel->ambuBuccalAdultePiece = 0;
            $materiel->ambuBuccalNourrissonPiece = 0;
            $materiel->nbSavonPiece = 0;
            $materiel->nbThermometrePiece = 0;
            $materiel->nbThermosPiece = 0;
            $materiel->nbSROPiece = 0;
            $materiel->picettePiece = 0;
            $materiel->lameRasoirPiece = 0;
            $materiel->sacPoubellePiece = 0;
            $materiel->carnetTroussePiece = 0;
            $materiel->styloPiece = 0;
        }

        return $materiel;
    }

    private function _rules()
    {
        $rules = [];
        $rules['brancheId'] = ['rules'  => 'required'];
        $rules['communeId'] = ['rules'  => 'required'];
        $rules['dateEnregistrement'] = ['rules'  => 'required'];
        $rules['nbManuelPSEnfant'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbBrancards'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbManequinEnfant'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbManequinEnAdulte'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbAttele'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbBoiteImage'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbCouverture'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbManuelPSBlessureRoute'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbManuelPSBlessurePRepondant'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbManequinBebe'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbKitPS'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbBallonInsuflatteurOxygene'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbDefibrillateurAutoExtern'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['masquePoche'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['existeTrousseSecour'] = ['rules'  => 'permit_empty'];
        $rules['nbTrousseSecour'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbGrantProprePaire'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbBetadineFlacon'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbAntalgiquePommadeTube'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbAntalgiqueSprayTube'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbAntalgiqueComprimeCP'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbPaireCiseauPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbPinceKocherPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbMasqueFacialPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbServietteEssuiMain'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['ouateRouleau'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbCompresseSterilePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['echarpeDrapTriangulaire'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['sparadrapPerforeRouleau'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['sparadrapEtanchePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['bandeElastiquePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['ambuBuccalEnfantPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['ambuBuccalAdultePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['ambuBuccalNourrissonPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbSavonPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbThermometrePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbThermosPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['nbSROPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['picettePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['lameRasoirPiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['sacPoubellePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['carnetTroussePiece'] = ['rules'  => 'permit_empty|is_natural'];
        $rules['styloPiece'] = ['rules'  => 'permit_empty|is_natural'];

        return $rules;
    }

    function fecth()
    {
        $search_column = ['id', 'brancheId', 'communeId', 'nbManuelPSEnfant', 'nbBrancards', 'nbManequinEnfant', 'nbManequinEnAdulte', 'nbAttele', 'nbBoiteImage', 'nbCouverture', 'nbManuelPSBlessureRoute', 'nbManuelPSBlessurePRepondant', 'nbManequinBebe', 'nbKitPS', 'nbBallonInsuflatteurOxygene', 'nbDefibrillateurAutoExtern', 'masquePoche', 'existeTrousseSecour'];
        $order_column = ['id', 'brancheId', 'communeId', 'nbManuelPSEnfant', 'nbBrancards', 'nbManequinEnfant', 'nbManequinEnAdulte', 'nbAttele', 'nbBoiteImage', 'nbCouverture', 'nbManuelPSBlessureRoute', 'nbManuelPSBlessurePRepondant', 'nbManequinBebe', 'nbKitPS', 'nbBallonInsuflatteurOxygene', 'nbDefibrillateurAutoExtern', 'masquePoche', 'existeTrousseSecour'];

        $materielMdl = $this->materielModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $materielMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $materielMdl->where('communeId', \auth()->user()->communeId);
        }

        if ($this->request->getPost('brancheId') > 0) {
            $materielMdl->where('brancheId', $this->request->getPost('brancheId'));
        }

        $fetch_data = DatatableQuery::build_query($materielMdl, $search_column, $order_column);
        $output = $this->formatMateriel($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatMateriel($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  $data->nbManuelPSEnfant;
                $sub_array[] =  $data->nbBrancards;
                $sub_array[] =  $data->nbManequinEnfant;
                $sub_array[] =  $data->nbManequinEnAdulte;
                $sub_array[] =  $data->nbAttele;
                $sub_array[] =  $data->nbBoiteImage;
                // $sub_array[] =  $data->nbCouverture;
                // $sub_array[] =  $data->nbManuelPSBlessureRoute;
                // $sub_array[] =  $data->nbManuelPSBlessurePRepondant;
                // $sub_array[] =  $data->nbManequinBebe;
                // $sub_array[] =  $data->nbKitPS;
                // $sub_array[] =  $data->nbBallonInsuflatteurOxygene;
                // $sub_array[] =  $data->nbDefibrillateurAutoExtern;
                // $sub_array[] =  $data->masquePoche;
                $sub_array[] =  $data->existeTrousseSecour;
                $sub_array[] =  $data->dateEnregistrement;

                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/ps/materiel/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/ps/materiel/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }

    function export(){
        $uri = current_url(true);
        $brancheId = $uri->getSegment(5);

        if ($brancheId > 0) {
            $branche = CommonTrait::formatData(new BrancheModel(), $brancheId);
        } else {
            $branche = "Toutes les branches";
        }

        $fileName = str_replace(' ', '', $branche);        
        $csv_file_name = "rapportExport/materiel/materiel_" . $fileName . ".csv";
        $file = fopen($csv_file_name, 'w');

        $arrays = [];
        $arrays[0] = ['', $this->formatText("Premiers Secours - Materiels")];
        $arrays[1] = ['', $this->formatText($branche)];
        $arrays[2] = [];
        $arrays[3] = [
            '#',  
            $this->formatText('Branche'),  
            $this->formatText('Commune'), 
            $this->formatText("Date d'enregistrement"),  
            $this->formatText("Nombre de manuels en Premiers Secours pour enfants - pièce"), 
            $this->formatText("Brancards - Pièce"), 
            $this->formatText("Nombre de Mannequins enfants - Pièce"), 
            $this->formatText("Nombre de Mannequins Adultes - Pièce"), 
            $this->formatText("Nombre d'Attèles - pièce"), 
            $this->formatText("Boîte à image - pièce"), 
            $this->formatText("Nombre de Couvertures"), 
            $this->formatText("Nbre de manuels PS pour blessures de route"), 
            $this->formatText("Nbre de manuels PS pour les premiers répondants"), 
            $this->formatText("Nbre de mannequins bébé"), 
            $this->formatText("Nbre de kits PS"), 
            $this->formatText("Nbre de ballons  insuflatteurs d'oxygène manuel"), 
            $this->formatText("Défibrilateur automatique externes"), 
            $this->formatText("Masques de poche"), 
            $this->formatText("Existe -il Trousse de secours ?"), 
            $this->formatText("Si oui, nombre de trousses de secours"), 
            $this->formatText("si oui, Gant propre ( à usage unique) - Paire"), 
            $this->formatText("si oui, bétadine - Flacon"), 
            $this->formatText("si oui, béttol - Flacon"), 
            $this->formatText("si oui, Antalgique Pommade - tube"), 
            $this->formatText("si oui, Antalgique Spray- tube"), 
            $this->formatText("si oui, Antalgique comprimé - CP"), 
            $this->formatText("si oui,Nombre de paires de ciseaux - pièce"), 
            $this->formatText("si oui, Pinces Kocher - pièce"), 
            $this->formatText("si  oui, Masque facial - pièce"), 
            $this->formatText("si oui, Nombre de Serviette et essui-mains"), 
            $this->formatText("si oui, Ouate - rouleau"), 
            $this->formatText("si oui, Compresse stérile - pièces"), 
            $this->formatText("si oui, Echarpe/Drap triangulaire - pièce"), 
            $this->formatText("si oui, Sparadrap perforé (Bande adhésive) - Rouleau"), 
            $this->formatText("si oui, Sparadrap étanche - Pièce"), 
            $this->formatText("si oui, Bande Elastique (Velpeau) - Pièce"), 
            $this->formatText("si oui, Ambu buccal enfant - Pièce"), 
            $this->formatText("si oui, Ambu buccal adulte - Pièce"), 
            $this->formatText("si oui, Ambu buccal nourrisson - Pièce"), 
            $this->formatText("si oui, Nombre - Savons ( pièce)"), 
            $this->formatText("si oui, Thermomètre - pièce"), 
            $this->formatText("si oui, Thermos - Pièce"), 
            $this->formatText("si oui, SRO ( Sel de Réhydratation Orale) - Pièce"), 
            $this->formatText("si oui, Picette ( Solution de Dettol) - Pièce"), 
            $this->formatText("si oui, Lame de Rasoir - Pièce"), 
            $this->formatText("si oui, Sac poubelle - Pièce"), 
            $this->formatText("si oui, Carnet ( Fiche de gestion de la trousse) - Pièce"), 
            $this->formatText("si oui, Stylo - Pièce")
        ];      

        if ($brancheId > 0) {
            $materiels = $this->materielModel->where('brancheId', $brancheId)->findAll();
        } else {
            $materiels = $this->materielModel->findAll();
        }

        $i = 1;
        foreach ($materiels as $materiel) {
            $sub_array = [];
            $sub_array[] = $i;
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new BrancheModel(), $materiel->brancheId));
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new CommuneModel(), $materiel->communeId));
            $sub_array[] =  $materiel->dateEnregistrement;
            $sub_array[] =  $materiel->nbManuelPSEnfant;
            $sub_array[] =  $materiel->nbBrancards; 
            $sub_array[] =  $materiel->nbManequinEnfant;
            $sub_array[] =  $materiel->nbManequinEnAdulte;
            $sub_array[] =  $materiel->nbAttele;
            $sub_array[] =  $materiel->nbBoiteImage;
            $sub_array[] =  $materiel->nbCouverture;
            $sub_array[] =  $materiel->nbManuelPSBlessureRoute;
            $sub_array[] =  $materiel->nbManuelPSBlessurePRepondant;
            $sub_array[] =  $materiel->nbManequinBebe;
            $sub_array[] =  $materiel->nbKitPS;
            $sub_array[] =  $materiel->nbBallonInsuflatteurOxygene;
            $sub_array[] =  $materiel->nbDefibrillateurAutoExtern;
            $sub_array[] =  $materiel->masquePoche;
            $sub_array[] =  $materiel->existeTrousseSecour;
            $sub_array[] =  $materiel->nbTrousseSecour;
            $sub_array[] =  $materiel->nbGrantProprePaire;
            $sub_array[] =  $materiel->nbBetadineFlacon;
            $sub_array[] =  $materiel->nbBettolFlacon;
            $sub_array[] =  $materiel->nbAntalgiquePommadeTube;
            $sub_array[] =  $materiel->nbAntalgiqueSprayTube;
            $sub_array[] =  $materiel->nbAntalgiqueComprimeCP;
            $sub_array[] =  $materiel->nbPaireCiseauPiece;
            $sub_array[] =  $materiel->nbPinceKocherPiece;
            $sub_array[] =  $materiel->nbMasqueFacialPiece;
            $sub_array[] =  $materiel->nbServietteEssuiMain;
            $sub_array[] =  $materiel->ouateRouleau;
            $sub_array[] =  $materiel->nbCompresseSterilePiece;
            $sub_array[] =  $materiel->echarpeDrapTriangulaire;
            $sub_array[] =  $materiel->sparadrapPerforeRouleau;
            $sub_array[] =  $materiel->sparadrapEtanchePiece;
            $sub_array[] =  $materiel->bandeElastiquePiece;
            $sub_array[] =  $materiel->ambuBuccalEnfantPiece;
            $sub_array[] =  $materiel->ambuBuccalAdultePiece;
            $sub_array[] =  $materiel->ambuBuccalNourrissonPiece;
            $sub_array[] =  $materiel->nbSavonPiece;
            $sub_array[] =  $materiel->nbThermometrePiece;
            $sub_array[] =  $materiel->nbThermosPiece;
            $sub_array[] =  $materiel->nbSROPiece;
            $sub_array[] =  $materiel->picettePiece;
            $sub_array[] =  $materiel->lameRasoirPiece;
            $sub_array[] =  $materiel->sacPoubellePiece;
            $sub_array[] =  $materiel->carnetTroussePiece;
            $sub_array[] =  $materiel->styloPiece;

            $arrays[] = $sub_array;
            $i++;
        }


        foreach ($arrays as $array) {
            fputcsv($file, $array);
        }
        fclose($file);
        $btn = anchor($csv_file_name, "Exporter un <i class='fa fa-file-csv'></i>", ['class' => 'text-success', 'target' => '_blank']);

        $status = 0;
        if (fileExists($csv_file_name)) {
            $status = 1;
        }

        return $this->response->setJSON(['status' => $status, 'btnExport' => $btn]);
    }

    function formatText($string = "")
    {
        return UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
    }
}
