<?php

namespace Modules\Formation\Database\Migrations;

use CodeIgniter\Database\Migration;

class FormationMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],

            'intituleFormation' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'zoneId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'collineId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'lieuFormation' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],

            'typeFormationId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbParticipantHomme' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbParticipantFemme' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'certifiant' => [
                'type'       => 'ENUM',
                'constraint' => ['OUI', 'NON'],
                'default'    => 'NON',
            ],
            'dateDebut' => [
                'type' => 'DATE',
                'default'    => NULL
            ],
            'dateFin' => [
                'type' => 'DATE',
                'default'    => NULL,
            ],
            'nbHeureDuree' => [
                'type' => 'DOUBLE',
                'default'    => NULL,
            ],
            'commentaire' => [
                'type' => 'TEXT',
                'default'    => NULL,
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'pathFile' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('fr_formation');
    }

    public function down()
    {
        $this->forge->dropTable('fr_formation');
    }
}
