<?php

namespace Modules\Activite\Database\Migrations;

use CodeIgniter\Database\Migration;

class ActiviteMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],

            'nomActivite' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'zoneId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'collineId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'domaineActiviteId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],

            'nbParticipantHomme' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbParticipantFemme' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbParticipantJeune' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'lieuActivite' => [
                'type' => 'VARCHAR',
                'constraint' => '11',
                'default'    => NULL,
            ],
            'nbBeneficiaireHomme' => [
                'type' => 'VARCHAR',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBeneficiaireFemme' => [
                'type' => 'VARCHAR',
                'constraint' => '11',
                'default'    => 0,
            ],
            'finance' => [
                'type'       => 'ENUM',
                'constraint' => ['OUI','NON'],
                'default'    => 'NON',
            ],
            'recette' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0
            ],
            'coutEstime' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0
            ],
            'dateActivite' => [
                'type' => 'DATE',
                'default'    => NULL
            ],
            'heureDebut' => [
                'type' => 'VARCHAR',
                'constraint' => '11',
                'default'    => 0
            ],
            'heureDebut' => [
                'type' => 'VARCHAR',
                'constraint' => '11',
                'default'    => 0
            ],
            'dureeheure' => [
                'type' => 'DOUBLE',
                'default'    => 0
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'pathFile'=>[
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => ""
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('at_activite');
    }

    public function down()
    {
        $this->forge->dropTable('at_activite');
    }
}
