!/**
 * Highcharts JS v11.4.0 (2024-03-04)
 *
 * Accessibility module
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Oystein Moseng
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,n){t.hasOwnProperty(e)||(t[e]=n.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Accessibility/Utils/HTMLUtilities.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.doc,n=t.win,o=e.css,r=n.EventTarget&&new n.EventTarget||"none";function s(t){if("function"==typeof n.MouseEvent)return new n.MouseEvent(t.type,t);if(i.createEvent){var e=i.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(t.type,t.bubbles,t.cancelable,t.view||n,t.detail,t.screenX,t.screenY,t.clientX,t.clientY,t.ctrlKey,t.altKey,t.shiftKey,t.metaKey,t.button,t.relatedTarget),e}return a(t.type)}function a(t,e,o){var s=e||{x:0,y:0};if("function"==typeof n.MouseEvent)return new n.MouseEvent(t,{bubbles:!0,cancelable:!0,composed:!0,button:0,buttons:1,relatedTarget:o||r,view:n,detail:"click"===t?1:0,screenX:s.x,screenY:s.y,clientX:s.x,clientY:s.y});if(i.createEvent){var a=i.createEvent("MouseEvent");if(a.initMouseEvent)return a.initMouseEvent(t,!0,!0,n,"click"===t?1:0,s.x,s.y,s.x,s.y,!1,!1,!1,!1,0,null),a}return{type:t}}return{addClass:function(t,e){t.classList?t.classList.add(e):0>t.className.indexOf(e)&&(t.className+=" "+e)},cloneMouseEvent:s,cloneTouchEvent:function(t){var e=function(t){for(var e=[],i=0;i<t.length;++i){var n=t.item(i);n&&e.push(n)}return e};if("function"==typeof n.TouchEvent){var i=new n.TouchEvent(t.type,{touches:e(t.touches),targetTouches:e(t.targetTouches),changedTouches:e(t.changedTouches),ctrlKey:t.ctrlKey,shiftKey:t.shiftKey,altKey:t.altKey,metaKey:t.metaKey,bubbles:t.bubbles,cancelable:t.cancelable,composed:t.composed,detail:t.detail,view:t.view});return t.defaultPrevented&&i.preventDefault(),i}var o=s(t);return o.touches=t.touches,o.changedTouches=t.changedTouches,o.targetTouches=t.targetTouches,o},escapeStringForHTML:function(t){return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")},getElement:function(t){return i.getElementById(t)},getFakeMouseEvent:a,getHeadingTagNameForElement:function(t){var e=function(t){return"h"+Math.min(6,parseInt(t.slice(1),10)+1)},i=function(t){return/H[1-6]/.test(t)},n=function(t){for(var e=t;e=e.previousSibling;){var n=e.tagName||"";if(i(n))return n}return""},o=function(t){var r=n(t);if(r)return e(r);var s=t.parentElement;if(!s)return"p";var a=s.tagName;return i(a)?e(a):o(s)};return o(t)},removeChildNodes:function(t){for(;t.lastChild;)t.removeChild(t.lastChild)},removeClass:function(t,e){t.classList?t.classList.remove(e):t.className=t.className.replace(RegExp(e,"g"),"")},removeElement:function(t){t&&t.parentNode&&t.parentNode.removeChild(t)},reverseChildNodes:function(t){for(var e=t.childNodes.length;e--;)t.appendChild(t.childNodes[e])},simulatedEventTarget:r,stripHTMLTagsFromString:function(t,e){return void 0===e&&(e=!1),"string"==typeof t?e?t.replace(/<\/?[^>]+(>|$)/g,""):t.replace(/<\/?(?!\s)[^>]+(>|$)/g,""):t},visuallyHideElement:function(t){o(t,{position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:.01})}}}),i(e,"Accessibility/A11yI18n.js",[e["Core/Templating.js"],e["Core/Utilities.js"]],function(t,e){var i,n=t.format,o=e.getNestedProperty,r=e.pick;return function(t){function e(t,e,i){var s,a,c=[],l=0;do s=function(t,e){var i=t.slice(e||0),n=i.indexOf("{"),o=i.indexOf("}");if(n>-1&&o>n)return{statement:i.substring(n+1,o),begin:e+n+1,end:e+o}}(t,l),(a=t.substring(l,s&&s.begin-1)).length&&c.push({value:a,type:"constant"}),s&&c.push({value:s.statement,type:"statement"}),l=s?s.end+1:l+1;while(s);return c.forEach(function(t){"statement"===t.type&&(t.value=function(t,e){var i,n,s=t.indexOf("#each("),a=t.indexOf("#plural("),c=t.indexOf("["),l=t.indexOf("]");if(s>-1){var h=t.slice(s).indexOf(")")+s,d=t.substring(0,s),u=t.substring(h+1),p=t.substring(s+6,h).split(","),g=Number(p[1]),m=void 0;if(n="",i=o(p[0],e)){m=(g=isNaN(g)?i.length:g)<0?i.length+g:Math.min(g,i.length);for(var f=0;f<m;++f)n+=d+i[f]+u}return n.length?n:""}if(a>-1){var v,y=t.slice(a).indexOf(")")+a,b=t.substring(a+8,y).split(",");switch(Number(o(b[0],e))){case 0:n=r(b[4],b[1]);break;case 1:n=r(b[2],b[1]);break;case 2:n=r(b[3],b[1]);break;default:n=b[1]}return n?(v=n).trim&&v.trim()||v.replace(/^\s+|\s+$/g,""):""}if(c>-1){var x=t.substring(0,c),A=Number(t.substring(c+1,l)),C=void 0;return i=o(x,e),!isNaN(A)&&i&&(A<0?void 0===(C=i[i.length+A])&&(C=i[0]):void 0===(C=i[A])&&(C=i[i.length-1])),void 0!==C?C:""}return"{"+t+"}"}(t.value,e))}),n(c.reduce(function(t,e){return t+e.value},""),e,i)}function i(t,i){for(var n=t.split("."),o=this.options.lang,r=0;r<n.length;++r)o=o&&o[n[r]];return"string"==typeof o?e(o,i,this):""}t.compose=function(t){var e=t.prototype;e.langFormat||(e.langFormat=i)},t.i18nFormat=e}(i||(i={})),i}),i(e,"Accessibility/Utils/ChartUtilities.js",[e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i){var n=t.doc,o=e.stripHTMLTagsFromString,r=i.defined,s=i.find,a=i.fireEvent;function c(t){if(t.points&&t.points.length){var e=s(t.points,function(t){return!!t.graphic});return e&&e.graphic&&e.graphic.element}}function l(t){var e=c(t);return e&&e.parentNode||t.graph&&t.graph.element||t.group&&t.group.element}return{fireEventOnWrappedOrUnwrappedElement:function t(e,i){var o=i.type,r=e.hcEvents;n.createEvent&&(e.dispatchEvent||e.fireEvent)?e.dispatchEvent?e.dispatchEvent(i):e.fireEvent(o,i):r&&r[o]?a(e,o,i):e.element&&t(e.element,i)},getChartTitle:function(t){return o(t.options.title.text||t.langFormat("accessibility.defaultChartTitle",{chart:t}),t.renderer.forExport)},getAxisDescription:function(t){var e,i;return t&&((null===(e=t.options.accessibility)||void 0===e?void 0:e.description)||(null===(i=t.axisTitle)||void 0===i?void 0:i.textStr)||t.options.id||t.categories&&"categories"||t.dateTime&&"Time"||"values")},getAxisRangeDescription:function(t){var e,i,n,o,r,s,a,c,l,h,d,u,p=t.options||{};return p.accessibility&&void 0!==p.accessibility.rangeDescription?p.accessibility.rangeDescription:t.categories?(e=t.chart,t.dataMax&&t.dataMin?e.langFormat("accessibility.axis.rangeCategories",{chart:e,axis:t,numCategories:t.dataMax-t.dataMin+1}):""):t.dateTime&&(0===t.min||0===t.dataMin)?(i=t.chart,n={},o=t.dataMin||t.min||0,r=t.dataMax||t.max||0,s="Seconds",n.Seconds=(r-o)/1e3,n.Minutes=n.Seconds/60,n.Hours=n.Minutes/60,n.Days=n.Hours/24,["Minutes","Hours","Days"].forEach(function(t){n[t]>2&&(s=t)}),a=n[s].toFixed("Seconds"!==s&&"Minutes"!==s?1:0),i.langFormat("accessibility.axis.timeRange"+s,{chart:i,axis:t,range:a.replace(".0","")})):(h=(l=(c=t.chart).options)&&l.accessibility&&l.accessibility.screenReaderSection.axisRangeDateFormat||"",d={min:t.dataMin||t.min||0,max:t.dataMax||t.max||0},u=function(e){return t.dateTime?c.time.dateFormat(h,d[e]):d[e].toString()},c.langFormat("accessibility.axis.rangeFromTo",{chart:c,axis:t,rangeFrom:u("min"),rangeTo:u("max")}))},getPointFromXY:function(t,e,i){for(var n,o=t.length;o--;)if(n=s(t[o].points||[],function(t){return t.x===e&&t.y===i}))return n},getSeriesFirstPointElement:c,getSeriesFromName:function(t,e){return e?(t.series||[]).filter(function(t){return t.name===e}):t.series},getSeriesA11yElement:l,unhideChartElementFromAT:function t(e,i){i.setAttribute("aria-hidden",!1),i!==e.renderTo&&i.parentNode&&i.parentNode!==n.body&&(Array.prototype.forEach.call(i.parentNode.childNodes,function(t){t.hasAttribute("aria-hidden")||t.setAttribute("aria-hidden",!0)}),t(e,i.parentNode))},hideSeriesFromAT:function(t){var e=l(t);e&&e.setAttribute("aria-hidden",!0)},scrollAxisToPoint:function(t){var e=t.series.xAxis,i=t.series.yAxis,n=e&&e.scrollbar?e:i,o=n&&n.scrollbar;if(o&&r(o.to)&&r(o.from)){var s=o.to-o.from,c=function(t,e){if(!r(t.dataMin)||!r(t.dataMax))return 0;var i=t.toPixels(t.dataMin),n=t.toPixels(t.dataMax),o="xAxis"===t.coll?"x":"y";return(t.toPixels(e[o]||0)-i)/(n-i)}(n,t);o.updatePosition(c-s/2,c+s/2),a(o,"changed",{from:o.from,to:o.to,trigger:"scrollbar",DOMEvent:null})}}}}),i(e,"Accessibility/Utils/DOMElementProvider.js",[e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e){var i=t.doc,n=e.removeElement;return function(){function t(){this.elements=[]}return t.prototype.createElement=function(){var t=i.createElement.apply(i,arguments);return this.elements.push(t),t},t.prototype.removeElement=function(t){n(t),this.elements.splice(this.elements.indexOf(t),1)},t.prototype.destroyCreatedElements=function(){this.elements.forEach(function(t){n(t)}),this.elements=[]},t}()}),i(e,"Accessibility/Utils/EventProvider.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=e.addEvent;return function(){function e(){this.eventRemovers=[]}return e.prototype.addEvent=function(){var e=i.apply(t,arguments);return this.eventRemovers.push(e),e},e.prototype.removeEvent=function(t){var e=this.eventRemovers.indexOf(t);this.eventRemovers[e](),this.eventRemovers.splice(e,1)},e.prototype.removeAddedEvents=function(){this.eventRemovers.forEach(function(t){return t()}),this.eventRemovers=[]},e}()}),i(e,"Accessibility/AccessibilityComponent.js",[e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/DOMElementProvider.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=t.fireEventOnWrappedOrUnwrappedElement,s=n.getFakeMouseEvent,a=o.extend,c=function(){function t(){}return t.prototype.initBase=function(t,n){this.chart=t,this.eventProvider=new i,this.domElementProvider=new e,this.proxyProvider=n,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9,pageUp:33,pageDown:34,end:35,home:36}},t.prototype.addEvent=function(t,e,i,n){return this.eventProvider.addEvent(t,e,i,n)},t.prototype.createElement=function(t,e){return this.domElementProvider.createElement(t,e)},t.prototype.fakeClickEvent=function(t){r(t,s("click"))},t.prototype.destroyBase=function(){this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()},t}();return a(c.prototype,{init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}}),c}),i(e,"Accessibility/KeyboardNavigationHandler.js",[e["Core/Utilities.js"]],function(t){var e=t.find;return function(){function t(t,e){this.chart=t,this.keyCodeMap=e.keyCodeMap||[],this.validate=e.validate,this.init=e.init,this.terminate=e.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}return t.prototype.run=function(t){var i=t.which||t.keyCode,n=this.response.noHandler,o=e(this.keyCodeMap,function(t){return t[0].indexOf(i)>-1});return o?n=o[1].call(this,i,t):9===i&&(n=this.response[t.shiftKey?"prev":"next"]),n},t}()}),i(e,"Accessibility/Components/ContainerComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o){var r,s=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=i.unhideChartElementFromAT,c=i.getChartTitle,l=n.doc,h=o.stripHTMLTagsFromString;return function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s(i,t),i.prototype.onChartUpdate=function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},i.prototype.handleSVGTitleElement=function(){var t=this.chart,e="highcharts-title-"+t.index,i=h(t.langFormat("accessibility.svgContainerTitle",{chartTitle:c(t)}));if(i.length){var n=this.svgTitleElement=this.svgTitleElement||l.createElementNS("http://www.w3.org/2000/svg","title");n.textContent=i,n.id=e,t.renderTo.insertBefore(n,t.renderTo.firstChild)}},i.prototype.setSVGContainerLabel=function(){var t=this.chart,e=t.langFormat("accessibility.svgContainerLabel",{chartTitle:c(t)});t.renderer.box&&e.length&&t.renderer.box.setAttribute("aria-label",e)},i.prototype.setGraphicContainerAttrs=function(){var t=this.chart,e=t.langFormat("accessibility.graphicContainerLabel",{chartTitle:c(t)});e.length&&t.container.setAttribute("aria-label",e)},i.prototype.setRenderToAttrs=function(){var t=this.chart,e="disabled"!==t.options.accessibility.landmarkVerbosity,i=t.langFormat("accessibility.chartContainerLabel",{title:c(t),chart:t});i&&(t.renderTo.setAttribute("role",e?"region":"group"),t.renderTo.setAttribute("aria-label",i))},i.prototype.makeCreditsAccessible=function(){var t=this.chart,e=t.credits;e&&(e.textStr&&e.element.setAttribute("aria-label",t.langFormat("accessibility.credits",{creditsStr:h(e.textStr,t.renderer.forExport)})),a(t,e.element))},i.prototype.getKeyboardNavigation=function(){var t=this.chart;return new e(t,{keyCodeMap:[],validate:function(){return!0},init:function(){var e=t.accessibility;e&&e.keyboardNavigation.tabindexContainer.focus()}})},i.prototype.destroy=function(){this.chart.renderTo.setAttribute("aria-hidden",!0)},i}(t)}),i(e,"Accessibility/FocusBorder.js",[e["Core/Utilities.js"]],function(t){var e,i=t.addEvent,n=t.pick;return function(t){var e=["x","y","transform","width","height","r","d","stroke-width"];function o(){var t=this.focusElement,e=this.options.accessibility.keyboardNavigation.focusBorder;t&&(t.removeFocusBorder(),e.enabled&&t.addFocusBorder(e.margin,{stroke:e.style.color,strokeWidth:e.style.lineWidth,r:e.style.borderRadius}))}function r(t,e){var n=this.options.accessibility.keyboardNavigation.focusBorder,o=e||t.element;o&&o.focus&&(o.hcEvents&&o.hcEvents.focusin||i(o,"focusin",function(){}),o.focus(),n.hideBrowserFocusOutline&&(o.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=t,this.renderFocusBorder()}function s(t,i){this.focusBorder&&this.removeFocusBorder();var o=this.getBBox(),r=n(t,3),s=this.parentGroup,a=this.scaleX||s&&s.scaleX,c=this.scaleY||s&&s.scaleY,l=(a?!c:c)?Math.abs(a||c||1):(Math.abs(a||1)+Math.abs(c||1))/2;o.x+=this.translateX?this.translateX:0,o.y+=this.translateY?this.translateY:0;var h=o.x-r,d=o.y-r,u=o.width+2*r,p=o.height+2*r,g=!!this.text;if("text"===this.element.nodeName||g){var m,f,v=!!this.rotation,y=g?{x:v?1:0,y:0}:(m=0,f=0,"middle"===this.attr("text-anchor")?m=f=.5:this.rotation?m=.25:f=.75,{x:m,y:f}),b=+this.attr("x"),x=+this.attr("y");if(isNaN(b)||(h=b-o.width*y.x-r),isNaN(x)||(d=x-o.height*y.y-r),g&&v){var A=u;u=p,p=A,isNaN(b)||(h=b-o.height*y.x-r),isNaN(x)||(d=x-o.width*y.y-r)}}this.focusBorder=this.renderer.rect(h,d,u,p,parseInt((i&&i.r||0).toString(),10)/l).addClass("highcharts-focus-border").attr({zIndex:99}).add(s),this.renderer.styledMode||this.focusBorder.attr({stroke:i&&i.stroke,"stroke-width":(i&&i.strokeWidth||0)/l}),function(t){for(var i=[],n=1;n<arguments.length;n++)i[n-1]=arguments[n];t.focusBorderUpdateHooks||(t.focusBorderUpdateHooks={},e.forEach(function(e){var n=e+"Setter",o=t[n]||t._defaultSetter;t.focusBorderUpdateHooks[n]=o,t[n]=function(){var e=o.apply(t,arguments);return t.addFocusBorder.apply(t,i),e}}))}(this,t,i),function(t){if(!t.focusBorderDestroyHook){var e=t.destroy;t.destroy=function(){return t.focusBorder&&t.focusBorder.destroy&&t.focusBorder.destroy(),e.apply(t,arguments)},t.focusBorderDestroyHook=e}}(this)}function a(){var t;t=this,t.focusBorderUpdateHooks&&(Object.keys(t.focusBorderUpdateHooks).forEach(function(e){var i=t.focusBorderUpdateHooks[e];i===t._defaultSetter?delete t[e]:t[e]=i}),delete t.focusBorderUpdateHooks),this.focusBorderDestroyHook&&(this.destroy=this.focusBorderDestroyHook,delete this.focusBorderDestroyHook),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}t.compose=function(t,e){var i=t.prototype,n=e.prototype;i.renderFocusBorder||(i.renderFocusBorder=o,i.setFocusToElement=r),n.addFocusBorder||(n.addFocusBorder=s,n.removeFocusBorder=a)}}(e||(e={})),e}),i(e,"Accessibility/Utils/Announcer.js",[e["Core/Renderer/HTML/AST.js"],e["Accessibility/Utils/DOMElementProvider.js"],e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=i.doc,s=n.addClass,a=n.visuallyHideElement,c=o.attr;return function(){function i(t,i){this.chart=t,this.domElementProvider=new e,this.announceRegion=this.addAnnounceRegion(i)}return i.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},i.prototype.announce=function(e){var i=this;t.setElementHTML(this.announceRegion,e),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){i.announceRegion.innerHTML=t.emptyHTML,delete i.clearAnnouncementRegionTimer},3e3)},i.prototype.addAnnounceRegion=function(t){var e=this.chart.announcerContainer||this.createAnnouncerContainer(),i=this.domElementProvider.createElement("div");return c(i,{"aria-hidden":!1,"aria-live":t,"aria-atomic":!0}),this.chart.styledMode?s(i,"highcharts-visually-hidden"):a(i),e.appendChild(i),i},i.prototype.createAnnouncerContainer=function(){var t=this.chart,e=r.createElement("div");return c(e,{"aria-hidden":!1,class:"highcharts-announcer-container"}),e.style.position="relative",t.renderTo.insertBefore(e,t.renderTo.firstChild),t.announcerContainer=e,e},i}()}),i(e,"Accessibility/Components/AnnotationsA11y.js",[e["Accessibility/Utils/HTMLUtilities.js"]],function(t){var e=t.escapeStringForHTML,i=t.stripHTMLTagsFromString;function n(t){return(t.annotations||[]).reduce(function(t,e){return e.options&&!1!==e.options.visible&&(t=t.concat(e.labels)),t},[])}function o(t){return t.options&&t.options.accessibility&&t.options.accessibility.description||t.graphic&&t.graphic.text&&t.graphic.text.textStr||""}function r(t){var e=t.options&&t.options.accessibility&&t.options.accessibility.description;if(e)return e;var i=t.chart,n=o(t),r=t.points.filter(function(t){return!!t.graphic}).map(function(t){var e=t.accessibility&&t.accessibility.valueDescription||t.graphic&&t.graphic.element&&t.graphic.element.getAttribute("aria-label")||"",i=t&&t.series.name||"";return(i?i+", ":"")+"data point "+e}).filter(function(t){return!!t}),s=r.length,a=s>1?"MultiplePoints":s?"SinglePoint":"NoPoints",c={annotationText:n,annotation:t,numPoints:s,annotationPoint:r[0],additionalAnnotationPoints:r.slice(1)};return i.langFormat("accessibility.screenReaderSection.annotations.description"+a,c)}function s(t){return n(t).map(function(n){var o=e(i(r(n),t.renderer.forExport));return o?"<li>".concat(o,"</li>"):""})}return{getAnnotationsInfoHTML:function(t){var e=t.annotations;if(!(e&&e.length))return"";var i=s(t);return'<ul style="list-style-type: none">'.concat(i.join(" "),"</ul>")},getAnnotationLabelDescription:r,getAnnotationListItems:s,getPointAnnotationTexts:function(t){var e=n(t.series.chart).filter(function(e){return e.points.indexOf(t)>-1});return e.length?e.map(function(t){return"".concat(o(t))}):[]}}}),i(e,"Accessibility/Components/InfoRegionsComponent.js",[e["Accessibility/A11yI18n.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/Components/AnnotationsA11y.js"],e["Core/Renderer/HTML/AST.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Core/Templating.js"],e["Core/Globals.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r,s,a,c,l){var h,d=this&&this.__extends||(h=function(t,e){return(h=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}h(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),u=n.getAnnotationsInfoHTML,p=r.getAxisDescription,g=r.getAxisRangeDescription,m=r.getChartTitle,f=r.unhideChartElementFromAT,v=s.format,y=a.doc,b=c.addClass,x=c.getElement,A=c.getHeadingTagNameForElement,C=c.stripHTMLTagsFromString,w=c.visuallyHideElement,E=l.attr,T=l.pick,M=l.replaceNested;function S(t){return M(t,[/<([\w\-.:!]+)\b[^<>]*>\s*<\/\1>/g,""])}return function(e){function n(){var t=null!==e&&e.apply(this,arguments)||this;return t.screenReaderSections={},t}return d(n,e),n.prototype.init=function(){var t=this.chart,e=this;this.initRegionsDefinitions(),this.addEvent(t,"aftergetTableAST",function(t){e.onDataTableCreated(t)}),this.addEvent(t,"afterViewData",function(t){t.wasHidden&&(e.dataTableDiv=t.element,setTimeout(function(){e.focusDataTable()},300))}),this.addEvent(t,"afterHideData",function(){e.viewDataTableButton&&e.viewDataTableButton.setAttribute("aria-expanded","false")}),this.announcer=new i(t,"assertive")},n.prototype.initRegionsDefinitions=function(){var t=this,e=this.chart.options.accessibility;this.screenReaderSections={before:{element:null,buildContent:function(i){var n=e.screenReaderSection.beforeChartFormatter;return n?n(i):t.defaultBeforeChartFormatter(i)},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.renderTo.firstChild)},afterInserted:function(){void 0!==t.sonifyButtonId&&t.initSonifyButton(t.sonifyButtonId),void 0!==t.dataTableButtonId&&t.initDataTableButton(t.dataTableButtonId)}},after:{element:null,buildContent:function(i){var n=e.screenReaderSection.afterChartFormatter;return n?n(i):t.defaultAfterChartFormatter()},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.container.nextSibling)},afterInserted:function(){t.chart.accessibility&&e.keyboardNavigation.enabled&&t.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},n.prototype.onChartRender=function(){var t=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(e){t.updateScreenReaderSection(e)})},n.prototype.getLinkedDescriptionElement=function(){var t=this.chart.options.accessibility.linkedDescription;if(t){if("string"!=typeof t)return t;var e=v(t,this.chart),i=y.querySelectorAll(e);if(1===i.length)return i[0]}},n.prototype.setLinkedDescriptionAttrs=function(){var t=this.linkedDescriptionElement;t&&(t.setAttribute("aria-hidden","true"),b(t,"highcharts-linked-description"))},n.prototype.updateScreenReaderSection=function(t){var e=this.chart,i=this.screenReaderSections[t],n=i.buildContent(e),r=i.element=i.element||this.createElement("div"),s=r.firstChild||this.createElement("div");n?(this.setScreenReaderSectionAttribs(r,t),o.setElementHTML(s,n),r.appendChild(s),i.insertIntoDOM(r,e),e.styledMode?b(s,"highcharts-visually-hidden"):w(s),f(e,s),i.afterInserted&&i.afterInserted()):(r.parentNode&&r.parentNode.removeChild(r),i.element=null)},n.prototype.setScreenReaderSectionAttribs=function(t,e){var i=this.chart,n=i.langFormat("accessibility.screenReaderSection."+e+"RegionLabel",{chart:i,chartTitle:m(i)});E(t,{id:"highcharts-screen-reader-region-".concat(e,"-").concat(i.index),"aria-label":n||void 0}),t.style.position="relative",n&&t.setAttribute("role","all"===i.options.accessibility.landmarkVerbosity?"region":"group")},n.prototype.defaultBeforeChartFormatter=function(){var e=this.chart,i=e.options.accessibility.screenReaderSection.beforeChartFormat;if(!i)return"";var n=this.getAxesDescription(),o=e.sonify&&e.options.sonification&&e.options.sonification.enabled,r="highcharts-a11y-sonify-data-btn-"+e.index,s="hc-linkto-highcharts-data-table-"+e.index,a=u(e),c=e.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:e}),l={headingTagName:A(e.renderTo),chartTitle:m(e),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:n.xAxis,yAxisDescription:n.yAxis,playAsSoundButton:o?this.getSonifyButtonText(r):"",viewTableButton:e.getCSV?this.getDataTableButtonText(s):"",annotationsTitle:a?c:"",annotationsList:a},h=t.i18nFormat(i,l,e);return this.dataTableButtonId=s,this.sonifyButtonId=r,S(h)},n.prototype.defaultAfterChartFormatter=function(){var e=this.chart,i=e.options.accessibility.screenReaderSection.afterChartFormat;if(!i)return"";var n={endOfChartMarker:this.getEndOfChartMarkerText()};return S(t.i18nFormat(i,n,e))},n.prototype.getLinkedDescription=function(){var t=this.linkedDescriptionElement;return C(t&&t.innerHTML||"",this.chart.renderer.forExport)},n.prototype.getLongdescText=function(){var t=this.chart.options,e=t.caption,i=e&&e.text,n=this.getLinkedDescription();return t.accessibility.description||n||i||""},n.prototype.getTypeDescriptionText=function(){var t,e,i,n,o,r,s,a,c,l=this.chart;return l.types?l.options.accessibility.typeDescription||(t=l,r=(e=l.types)[0],s=t.series&&t.series[0]||{},a=t.mapView&&t.mapView.geoMap&&t.mapView.geoMap.title,c={numSeries:t.series.length,numPoints:s.points&&s.points.length,chart:t,mapTitle:a},r?"map"===r||"tiledwebmap"===r?c.mapTitle?t.langFormat("accessibility.chartTypes.mapTypeDescription",c):t.langFormat("accessibility.chartTypes.unknownMap",c):t.types.length>1?t.langFormat("accessibility.chartTypes.combinationChart",c):(i=e[0],n=t.langFormat("accessibility.seriesTypeDescriptions."+i,c),o=t.series&&t.series.length<2?"Single":"Multiple",(t.langFormat("accessibility.chartTypes."+i+o,c)||t.langFormat("accessibility.chartTypes.default"+o,c))+(n?" "+n:"")):t.langFormat("accessibility.chartTypes.emptyChart",c)):""},n.prototype.getDataTableButtonText=function(t){var e=this.chart;return'<button id="'+t+'">'+e.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:e,chartTitle:m(e)})+"</button>"},n.prototype.getSonifyButtonText=function(t){var e=this.chart;return e.options.sonification&&!1===e.options.sonification.enabled?"":'<button id="'+t+'">'+e.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:e,chartTitle:m(e)})+"</button>"},n.prototype.getSubtitleText=function(){var t=this.chart.options.subtitle;return C(t&&t.text||"",this.chart.renderer.forExport)},n.prototype.getEndOfChartMarkerText=function(){var t=x("highcharts-end-of-chart-marker-".concat(this.chart.index));if(t)return t.outerHTML;var e=this.chart,i=e.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:e});return'<div id="highcharts-end-of-chart-marker-'+e.index+'">'+i+"</div>"},n.prototype.onDataTableCreated=function(t){var e=this.chart;if(e.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var i=t.tree.attributes||{};i.tabindex=-1,i.summary=e.langFormat("accessibility.table.tableSummary",{chart:e}),t.tree.attributes=i}},n.prototype.focusDataTable=function(){var t=this.dataTableDiv,e=t&&t.getElementsByTagName("table")[0];e&&e.focus&&e.focus()},n.prototype.initSonifyButton=function(t){var e=this,i=this.sonifyButton=x(t),n=this.chart,o=function(t){i&&(i.setAttribute("aria-hidden","true"),i.setAttribute("aria-label","")),t.preventDefault(),t.stopPropagation();var o=n.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:n});e.announcer.announce(o),setTimeout(function(){i&&(i.removeAttribute("aria-hidden"),i.removeAttribute("aria-label")),n.sonify&&n.sonify()},1e3)};i&&n&&(i.setAttribute("tabindex",-1),i.onclick=function(t){(n.options.accessibility&&n.options.accessibility.screenReaderSection.onPlayAsSoundClick||o).call(this,t,n)})},n.prototype.initDataTableButton=function(t){var e=this.viewDataTableButton=x(t),i=this.chart,n=t.replace("hc-linkto-","");e&&(E(e,{tabindex:-1,"aria-expanded":!!x(n)}),e.onclick=i.options.accessibility.screenReaderSection.onViewDataTableClick||function(){i.viewData()})},n.prototype.getAxesDescription=function(){var t=this.chart,e=function(e,i){var n=t[e];return n.length>1||n[0]&&T(n[0].options.accessibility&&n[0].options.accessibility.enabled,i)},i=!!t.types&&0>t.types.indexOf("map")&&0>t.types.indexOf("treemap")&&0>t.types.indexOf("tilemap"),n=!!t.hasCartesianSeries,o=e("xAxis",!t.angular&&n&&i),r=e("yAxis",n&&i),s={};return o&&(s.xAxis=this.getAxisDescriptionText("xAxis")),r&&(s.yAxis=this.getAxisDescriptionText("yAxis")),s},n.prototype.getAxisDescriptionText=function(t){var e=this.chart,i=e[t];return e.langFormat("accessibility.axis."+t+"Description"+(i.length>1?"Plural":"Singular"),{chart:e,names:i.map(function(t){return p(t)}),ranges:i.map(function(t){return g(t)}),numAxes:i.length})},n.prototype.destroy=function(){this.announcer&&this.announcer.destroy()},n}(e)}),i(e,"Accessibility/Components/MenuComponent.js",[e["Core/Utilities.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o){var r,s=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=t.attr,c=n.getChartTitle,l=n.unhideChartElementFromAT,h=o.getFakeMouseEvent;function d(t){return t.exportSVGElements&&t.exportSVGElements[0]}var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s(e,t),e.prototype.init=function(){var t=this.chart,e=this;this.addEvent(t,"exportMenuShown",function(){e.onMenuShown()}),this.addEvent(t,"exportMenuHidden",function(){e.onMenuHidden()}),this.createProxyGroup()},e.prototype.onMenuHidden=function(){var t=this.chart.exportContextMenu;t&&t.setAttribute("aria-hidden","true"),this.setExportButtonExpandedState("false")},e.prototype.onMenuShown=function(){var t=this.chart,e=t.exportContextMenu;e&&(this.addAccessibleContextMenuAttribs(),l(t,e)),this.setExportButtonExpandedState("true")},e.prototype.setExportButtonExpandedState=function(t){this.exportButtonProxy&&this.exportButtonProxy.innerElement.setAttribute("aria-expanded",t)},e.prototype.onChartRender=function(){var t=this.chart,e=t.focusElement,i=t.accessibility;this.proxyProvider.clearGroup("chartMenu"),this.proxyMenuButton(),this.exportButtonProxy&&e&&e===t.exportingGroup&&(e.focusBorder?t.setFocusToElement(e,this.exportButtonProxy.innerElement):i&&i.keyboardNavigation.tabindexContainer.focus())},e.prototype.proxyMenuButton=function(){var t,e,i=this.chart,n=this.proxyProvider,o=d(i);t=i.options.exporting,e=d(i),t&&!1!==t.enabled&&t.accessibility&&t.accessibility.enabled&&e&&e.element&&o&&(this.exportButtonProxy=n.addProxyElement("chartMenu",{click:o},"button",{"aria-label":i.langFormat("accessibility.exporting.menuButtonLabel",{chart:i,chartTitle:c(i)}),"aria-expanded":!1,title:i.options.lang.contextButtonTitle||null}))},e.prototype.createProxyGroup=function(){this.chart&&this.proxyProvider&&this.proxyProvider.addGroup("chartMenu")},e.prototype.addAccessibleContextMenuAttribs=function(){var t=this.chart,e=t.exportDivElements;if(e&&e.length){e.forEach(function(t){t&&("LI"!==t.tagName||t.children&&t.children.length?t.setAttribute("aria-hidden","true"):t.setAttribute("tabindex",-1))});var i=e[0]&&e[0].parentNode;i&&a(i,{"aria-hidden":void 0,"aria-label":t.langFormat("accessibility.exporting.chartMenuLabel",{chart:t}),role:"list"})}},e.prototype.getKeyboardNavigation=function(){var t=this.keyCodes,e=this.chart,n=this;return new i(e,{keyCodeMap:[[[t.left,t.up],function(){return n.onKbdPrevious(this)}],[[t.right,t.down],function(){return n.onKbdNext(this)}],[[t.enter,t.space],function(){return n.onKbdClick(this)}]],validate:function(){return!!e.exporting&&!1!==e.options.exporting.enabled&&!1!==e.options.exporting.accessibility.enabled},init:function(){var t=n.exportButtonProxy,i=n.chart.exportingGroup;t&&i&&e.setFocusToElement(i,t.innerElement)},terminate:function(){e.hideExportMenu()}})},e.prototype.onKbdPrevious=function(t){for(var e=this.chart,i=e.options.accessibility,n=t.response,o=e.highlightedExportItemIx||0;o--;)if(e.highlightExportItem(o))return n.success;return i.keyboardNavigation.wrapAround?(e.highlightLastExportItem(),n.success):n.prev},e.prototype.onKbdNext=function(t){for(var e=this.chart,i=e.options.accessibility,n=t.response,o=(e.highlightedExportItemIx||0)+1;o<e.exportDivElements.length;++o)if(e.highlightExportItem(o))return n.success;return i.keyboardNavigation.wrapAround?(e.highlightExportItem(0),n.success):n.next},e.prototype.onKbdClick=function(t){var e=this.chart,i=e.exportDivElements[e.highlightedExportItemIx],n=d(e).element;return e.openMenu?this.fakeClickEvent(i):(this.fakeClickEvent(n),e.highlightExportItem(0)),t.response.success},e}(e);return function(t){function e(){var t=d(this);if(t){var e=t.element;e.onclick&&e.onclick(h("click"))}}function i(){var t=this.exportDivElements;t&&this.exportContextMenu&&this.openMenu&&(t.forEach(function(t){t&&"highcharts-menu-item"===t.className&&t.onmouseout&&t.onmouseout(h("mouseout"))}),this.highlightedExportItemIx=0,this.exportContextMenu.hideMenu(),this.container.focus())}function n(t){var e=this.exportDivElements&&this.exportDivElements[t],i=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx];if(e&&"LI"===e.tagName&&!(e.children&&e.children.length)){var n=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus;return e.focus&&n&&e.focus(),i&&i.onmouseout&&i.onmouseout(h("mouseout")),e.onmouseover&&e.onmouseover(h("mouseover")),this.highlightedExportItemIx=t,!0}return!1}function o(){if(this.exportDivElements){for(var t=this.exportDivElements.length;t--;)if(this.highlightExportItem(t))return!0}return!1}t.compose=function(t){var r=t.prototype;r.hideExportMenu||(r.hideExportMenu=i,r.highlightExportItem=n,r.highlightLastExportItem=o,r.showExportMenu=e)}}(u||(u={})),u}),i(e,"Accessibility/KeyboardNavigation.js",[e["Core/Globals.js"],e["Accessibility/Components/MenuComponent.js"],e["Core/Utilities.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o){var r=t.doc,s=t.win,a=i.addEvent,c=i.defined,l=i.fireEvent,h=o.getElement,d=o.simulatedEventTarget,u=function(){function t(t,e){this.currentModuleIx=NaN,this.modules=[],this.init(t,e)}return t.prototype.init=function(t,e){var i=this,o=this.eventProvider=new n;this.chart=t,this.components=e,this.modules=[],this.currentModuleIx=0,this.update(),o.addEvent(this.tabindexContainer,"keydown",function(t){return i.onKeydown(t)}),o.addEvent(this.tabindexContainer,"focus",function(t){return i.onFocus(t)}),["mouseup","touchend"].forEach(function(t){return o.addEvent(r,t,function(t){return i.onMouseUp(t)})}),["mousedown","touchstart"].forEach(function(e){return o.addEvent(t.renderTo,e,function(){i.isClickingChart=!0})})},t.prototype.update=function(t){var e=this.chart.options.accessibility,i=e&&e.keyboardNavigation,n=this.components;this.updateContainerTabindex(),i&&i.enabled&&t&&t.length?(this.modules=t.reduce(function(t,e){var i=n[e].getKeyboardNavigation();return t.concat(i)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},t.prototype.updateExitAnchor=function(){var t=h("highcharts-end-of-chart-marker-".concat(this.chart.index));this.removeExitAnchor(),t?(this.makeElementAnExitAnchor(t),this.exitAnchor=t):this.createExitAnchor()},t.prototype.move=function(t){var e=this.modules&&this.modules[this.currentModuleIx];e&&e.terminate&&e.terminate(t),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=t;var i=this.modules&&this.modules[this.currentModuleIx];if(i){if(i.validate&&!i.validate())return this.move(t);if(i.init)return i.init(t),!0}return this.currentModuleIx=0,this.exiting=!0,t>0?this.exitAnchor&&this.exitAnchor.focus():this.tabindexContainer.focus(),!1},t.prototype.onFocus=function(t){var e=this.chart,i=t.relatedTarget&&e.container.contains(t.relatedTarget),n=e.options.accessibility,o=n&&n.keyboardNavigation;if(o&&o.enabled&&!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!i){var r=this.getFirstValidModuleIx();null!==r&&(this.currentModuleIx=r,this.modules[r].init(1))}this.keyboardReset=!1,this.exiting=!1},t.prototype.onMouseUp=function(t){if(delete this.isClickingChart,!this.keyboardReset&&t.relatedTarget!==d){var e=this.chart;if(!t.target||!e.container.contains(t.target)){var i=this.modules&&this.modules[this.currentModuleIx||0];i&&i.terminate&&i.terminate(),this.currentModuleIx=0}e.focusElement&&(e.focusElement.removeFocusBorder(),delete e.focusElement),this.keyboardReset=!0}},t.prototype.onKeydown=function(t){var e,i=t||s.event,n=this.modules&&this.modules.length&&this.modules[this.currentModuleIx],o=i.target;if((!o||"INPUT"!==o.nodeName||o.classList.contains("highcharts-a11y-proxy-element"))&&(this.keyboardReset=!1,this.exiting=!1,n)){var r=n.run(i);r===n.response.success?e=!0:r===n.response.prev?e=this.move(-1):r===n.response.next&&(e=this.move(1)),e&&(i.preventDefault(),i.stopPropagation())}},t.prototype.updateContainerTabindex=function(){var t,e=this.chart.options.accessibility,i=e&&e.keyboardNavigation,n=!(i&&!1===i.enabled),o=this.chart,r=o.container;o.renderTo.hasAttribute("tabindex")?(r.removeAttribute("tabindex"),t=o.renderTo):t=r,this.tabindexContainer=t;var s=t.getAttribute("tabindex");n&&!s?t.setAttribute("tabindex","0"):n||o.container.removeAttribute("tabindex")},t.prototype.createExitAnchor=function(){var t=this.chart,e=this.exitAnchor=r.createElement("div");t.renderTo.appendChild(e),this.makeElementAnExitAnchor(e)},t.prototype.makeElementAnExitAnchor=function(t){var e=this.tabindexContainer.getAttribute("tabindex")||0;t.setAttribute("class","highcharts-exit-anchor"),t.setAttribute("tabindex",e),t.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(t)},t.prototype.removeExitAnchor=function(){this.exitAnchor&&(c(this.exitAnchor.focusEventRemover)&&(this.eventProvider.removeEvent(this.exitAnchor.focusEventRemover),delete this.exitAnchor.focusEventRemover),this.exitAnchor.parentNode&&this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},t.prototype.addExitAnchorEventsToEl=function(t){var e=this.chart,i=this;t.focusEventRemover=this.eventProvider.addEvent(t,"focus",function(t){var n=t||s.event,o=!(n.relatedTarget&&e.container.contains(n.relatedTarget)||i.exiting);if(e.focusElement&&delete e.focusElement,o){if(i.tabbingInBackwards=!0,i.tabindexContainer.focus(),delete i.tabbingInBackwards,n.preventDefault(),i.modules&&i.modules.length){i.currentModuleIx=i.modules.length-1;var r=i.modules[i.currentModuleIx];r&&r.validate&&!r.validate()?i.move(-1):r&&r.init(-1)}}else i.exiting=!1})},t.prototype.getFirstValidModuleIx=function(){for(var t=this.modules.length,e=0;e<t;++e){var i=this.modules[e];if(!i.validate||i.validate())return e}return null},t.prototype.destroy=function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")},t}();return function(i){function n(){var t=this;l(this,"dismissPopupContent",{},function(){t.tooltip&&t.tooltip.hide(0),t.hideExportMenu()})}function o(e){27===(e.which||e.keyCode)&&t.charts&&t.charts.forEach(function(t){t&&t.dismissPopupContent&&t.dismissPopupContent()})}i.compose=function(t){e.compose(t);var i=t.prototype;return i.dismissPopupContent||(i.dismissPopupContent=n,a(r,"keydown",o)),t}}(u||(u={})),u}),i(e,"Accessibility/Components/LegendComponent.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Legend/Legend.js"],e["Core/Utilities.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o,r,s,a){var c,l=this&&this.__extends||(c=function(t,e){return(c=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}c(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),h=t.animObject,d=e.doc,u=n.addEvent,p=n.fireEvent,g=n.isNumber,m=n.pick,f=n.syncTimeout,v=s.getChartTitle,y=a.stripHTMLTagsFromString,b=a.addClass,x=a.removeClass;function A(t){var e=t.legend&&t.legend.allItems,i=t.options.legend.accessibility||{},n=t.colorAxis&&t.colorAxis.some(function(t){return!t.dataClasses||!t.dataClasses.length});return!!(e&&e.length&&!n&&!1!==i.enabled)}function C(t,e){var i=e.legendItem||{};e.setState(t?"hover":"",!0);for(var n=0,o=["group","label","symbol"];n<o.length;n++){var r=i[o[n]],s=r&&r.element||r;s&&p(s,t?"mouseover":"mouseout")}}var w=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.highlightedLegendItemIx=NaN,e.proxyGroup=null,e}return l(e,t),e.prototype.init=function(){var t=this;this.recreateProxies(),this.addEvent(i,"afterScroll",function(){this.chart===t.chart&&(t.proxyProvider.updateGroupProxyElementPositions("legend"),t.updateLegendItemProxyVisibility(),t.highlightedLegendItemIx>-1&&this.chart.highlightLegendItem(t.highlightedLegendItemIx))}),this.addEvent(i,"afterPositionItem",function(e){this.chart===t.chart&&this.chart.renderer&&t.updateProxyPositionForItem(e.item)}),this.addEvent(i,"afterRender",function(){this.chart===t.chart&&this.chart.renderer&&t.recreateProxies()&&f(function(){return t.proxyProvider.updateGroupProxyElementPositions("legend")},h(m(this.chart.renderer.globalAnimation,!0)).duration)})},e.prototype.updateLegendItemProxyVisibility=function(){var t,e=this.chart,i=e.legend,n=i.allItems||[],o=i.currentPage||1,r=i.clipHeight||0;n.forEach(function(n){if(n.a11yProxyElement){var s=i.pages&&i.pages.length,a=n.a11yProxyElement.element,c=!1;if(t=n.legendItem||{},s){var l=t.pageIx||0;c=(t.y||0)+(t.label?Math.round(t.label.getBBox().height):0)-i.pages[l]>r||l!==o-1}c?e.styledMode?b(a,"highcharts-a11y-invisible"):a.style.visibility="hidden":(x(a,"highcharts-a11y-invisible"),a.style.visibility="")}})},e.prototype.onChartRender=function(){A(this.chart)||this.removeProxies()},e.prototype.highlightAdjacentLegendPage=function(t){var e=this.chart,i=e.legend,n=(i.currentPage||1)+t,o=i.pages||[];if(n>0&&n<=o.length)for(var r=0,s=0,a=i.allItems;s<a.length;s++)((a[s].legendItem||{}).pageIx||0)+1===n&&e.highlightLegendItem(r)&&(this.highlightedLegendItemIx=r),++r},e.prototype.updateProxyPositionForItem=function(t){t.a11yProxyElement&&t.a11yProxyElement.refreshPosition()},e.prototype.recreateProxies=function(){var t=d.activeElement,e=this.proxyGroup,i=t&&e&&e.contains(t);return this.removeProxies(),!!A(this.chart)&&(this.addLegendProxyGroup(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),this.updateLegendTitle(),i&&this.chart.highlightLegendItem(this.highlightedLegendItemIx),!0)},e.prototype.removeProxies=function(){this.proxyProvider.removeGroup("legend")},e.prototype.updateLegendTitle=function(){var t=this.chart,e=y((t.legend&&t.legend.options.title&&t.legend.options.title.text||"").replace(/<br ?\/?>/g," "),t.renderer.forExport),i=t.langFormat("accessibility.legend.legendLabel"+(e?"":"NoTitle"),{chart:t,legendTitle:e,chartTitle:v(t)});this.proxyProvider.updateGroupAttrs("legend",{"aria-label":i})},e.prototype.addLegendProxyGroup=function(){var t="all"===this.chart.options.accessibility.landmarkVerbosity?"region":null;this.proxyGroup=this.proxyProvider.addGroup("legend","ul",{"aria-label":"_placeholder_",role:t})},e.prototype.proxyLegendItems=function(){var t,e=this;((this.chart.legend||{}).allItems||[]).forEach(function(i){(t=i.legendItem||{}).label&&t.label.element&&e.proxyLegendItem(i)})},e.prototype.proxyLegendItem=function(t){var e=t.legendItem||{};if(e.label&&e.group){var i=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:y(t.name,this.chart.renderer.forExport),item:t}),n={tabindex:-1,"aria-pressed":t.visible,"aria-label":i},o=e.group.div?e.label:e.group;t.a11yProxyElement=this.proxyProvider.addProxyElement("legend",{click:e.label,visual:o.element},"button",n)}},e.prototype.getKeyboardNavigation=function(){var t=this.keyCodes,e=this,i=this.chart;return new r(i,{keyCodeMap:[[[t.left,t.right,t.up,t.down],function(t){return e.onKbdArrowKey(this,t)}],[[t.enter,t.space],function(){return e.onKbdClick(this)}],[[t.pageDown,t.pageUp],function(i){var n=i===t.pageDown?1:-1;return e.highlightAdjacentLegendPage(n),this.response.success}]],validate:function(){return e.shouldHaveLegendNavigation()},init:function(){i.highlightLegendItem(0),e.highlightedLegendItemIx=0},terminate:function(){e.highlightedLegendItemIx=-1,i.legend.allItems.forEach(function(t){return C(!1,t)})}})},e.prototype.onKbdArrowKey=function(t,e){var i=this.keyCodes,n=i.left,o=i.up,r=this.highlightedLegendItemIx,s=this.chart,a=s.legend.allItems.length,c=s.options.accessibility.keyboardNavigation.wrapAround,l=e===n||e===o?-1:1;return s.highlightLegendItem(r+l)?this.highlightedLegendItemIx+=l:c&&a>1&&(this.highlightedLegendItemIx=l>0?0:a-1,s.highlightLegendItem(this.highlightedLegendItemIx)),t.response.success},e.prototype.onKbdClick=function(t){var e=this.chart.legend.allItems[this.highlightedLegendItemIx];return e&&e.a11yProxyElement&&e.a11yProxyElement.click(),t.response.success},e.prototype.shouldHaveLegendNavigation=function(){if(!A(this.chart))return!1;var t=this.chart,e=(t.options.legend||{}).accessibility||{};return!!(t.legend.display&&e.keyboardNavigation&&e.keyboardNavigation.enabled)},e.prototype.destroy=function(){this.removeProxies()},e}(o);return function(t){function e(t){var e=this.legend.allItems,i=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx,n=e[t],o=(null==n?void 0:n.legendItem)||{};if(n){g(i)&&e[i]&&C(!1,e[i]),s=((r=this.legend).allItems[t].legendItem||{}).pageIx,a=r.currentPage,void 0!==s&&s+1!==a&&r.scroll(1+s-a);var r,s,a,c=o.label,l=n.a11yProxyElement&&n.a11yProxyElement.element;return c&&c.element&&l&&this.setFocusToElement(c,l),C(!0,n),!0}return!1}function i(t){var e=this.chart.options.accessibility,i=t.item;e.enabled&&i&&i.a11yProxyElement&&i.a11yProxyElement.innerElement.setAttribute("aria-pressed",t.visible?"true":"false")}t.compose=function(t,n){var o=t.prototype;o.highlightLegendItem||(o.highlightLegendItem=e,u(n,"afterColorizeItem",i))}}(w||(w={})),w}),i(e,"Stock/Navigator/ChartNavigatorComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i,n=t.isTouchDevice,o=e.addEvent,r=e.merge,s=e.pick,a=[];function c(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function l(){var t,e,i,n,o=this.legend,r=this.navigator;if(r){e=o&&o.options,i=r.xAxis,n=r.yAxis;var a=r.scrollbarHeight,c=r.scrollButtonSize;this.inverted?(r.left=r.opposite?this.chartWidth-a-r.height:this.spacing[3]+a,r.top=this.plotTop+c):(r.left=s(i.left,this.plotLeft+c),r.top=r.navigatorOptions.top||this.chartHeight-r.height-a-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(e&&"bottom"===e.verticalAlign&&"proximate"!==e.layout&&e.enabled&&!e.floating?o.legendHeight+s(e.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),i&&n&&(this.inverted?i.options.left=n.options.left=r.left:i.options.top=n.options.top=r.top,i.setAxisSize(),n.setAxisSize())}}function h(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new i(this),s(t.redraw,!0)&&this.redraw(t.animation))}function d(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new i(this))}function u(){var t=this.options,e=t.navigator,i=t.rangeSelector;if((e&&e.enabled||i&&i.enabled)&&(!n&&"x"===this.zooming.type||n&&"x"===this.zooming.pinchType))return!1}function p(t){var e=t.navigator;if(e&&t.xAxis[0]){var i=t.xAxis[0].getExtremes();e.render(i.min,i.max)}}function g(t){var e=t.options.navigator||{},i=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(e.enabled||i.enabled)&&(r(!0,this.options.navigator,e),r(!0,this.options.scrollbar,i),delete t.options.navigator,delete t.options.scrollbar)}return{compose:function(t,n){if(e.pushUnique(a,t)){var r=t.prototype;i=n,r.callbacks.push(p),o(t,"afterAddSeries",c),o(t,"afterSetChartSize",l),o(t,"afterUpdate",h),o(t,"beforeRender",d),o(t,"beforeShowResetZoom",u),o(t,"update",g)}}}}),i(e,"Core/Axis/NavigatorAxisComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i=t.isTouchDevice,n=e.addEvent,o=e.correctFloat,r=e.defined,s=e.isNumber,a=e.pick;function c(){this.navigatorAxis||(this.navigatorAxis=new h(this))}function l(t){var e,n=this.chart,o=n.options,s=o.navigator,a=this.navigatorAxis,c=n.zooming.pinchType,l=o.rangeSelector,h=n.zooming.type;if(this.isXAxis&&((null==s?void 0:s.enabled)||(null==l?void 0:l.enabled))){if("y"===h&&"zoom"===t.trigger)e=!1;else if(("zoom"===t.trigger&&"xy"===h||i&&"xy"===c)&&this.options.range){var d=a.previousZoom;r(t.min)?a.previousZoom=[this.min,this.max]:d&&(t.min=d[0],t.max=d[1],a.previousZoom=void 0)}}void 0!==e&&t.preventDefault()}var h=function(){function t(t){this.axis=t}return t.compose=function(t){t.keepProps.includes("navigatorAxis")||(t.keepProps.push("navigatorAxis"),n(t,"init",c),n(t,"setExtremes",l))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,e,i,n){var c,l=this.axis,h=l.chart,d=a(null===(c=l.ordinal)||void 0===c?void 0:c.convertOverscroll(l.options.overscroll),0),u=a(i,l.translate(t,!0,!l.horiz)),p=a(n,l.translate(e,!0,!l.horiz)),g=h&&h.fixedRange,m=(l.pointRange||0)/2;if(r(i)||(u=o(u+m)),r(n)||(p=o(p-m)),g&&l.dataMin&&l.dataMax){var f=l.dataMax+d;p>=f&&(u=o(f-g),p=o(f)),u<=l.dataMin&&(p=o(l.dataMin+g))}return s(u)&&s(p)||(u=p=void 0),{min:u,max:p}},t}();return h}),i(e,"Stock/Navigator/NavigatorDefaults.js",[e["Core/Color/Color.js"],e["Core/Series/SeriesRegistry.js"]],function(t,e){var i=t.parse,n=e.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:i("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===n.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),i(e,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,e,i,n,o){void 0===o&&(o={});var r=o.width?o.width/2:i,s=Math.round(r/3)+.5;return[["M",-r-1,.5],["L",r,.5],["L",r,(n=o.height||n)+.5],["L",-r-1,n+.5],["L",-r-1,.5],["M",-s,4],["L",-s,n-3],["M",s-1,4],["L",s-1,n-3]]}}}),i(e,"Stock/Utilities/StockUtilities.js",[e["Core/Utilities.js"]],function(t){var e=t.defined;return{setFixedRange:function(t){var i=this.xAxis[0];e(i.dataMax)&&e(i.dataMin)&&t?this.fixedRange=Math.min(t,i.dataMax-i.dataMin):this.fixedRange=t}}}),i(e,"Stock/Navigator/NavigatorComposition.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorDefaults.js"],e["Stock/Navigator/NavigatorSymbols.js"],e["Core/Renderer/RendererRegistry.js"],e["Stock/Utilities/StockUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r,s,a){var c=t.setOptions,l=e.composed,h=r.getRendererType,d=s.setFixedRange,u=a.addEvent,p=a.extend,g=a.pushUnique;function m(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,e,r){i.compose(e),g(l,"Navigator")&&(t.prototype.setFixedRange=d,p(h().prototype.symbols,o),u(r,"afterUpdate",m),c({navigator:n}))}}}),i(e,"Core/Axis/ScrollbarAxis.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i,n=t.composed,o=e.addEvent,r=e.defined,s=e.pick,a=e.pushUnique;return function(t){var e;function i(t){var e=s(t.options&&t.options.min,t.min),i=s(t.options&&t.options.max,t.max);return{axisMin:e,axisMax:i,scrollMin:r(t.dataMin)?Math.min(e,t.min,t.dataMin,s(t.threshold,1/0)):e,scrollMax:r(t.dataMax)?Math.max(i,t.max,t.dataMax,s(t.threshold,-1/0)):i}}function c(){var t=this.scrollbar,e=t&&!t.options.opposite,i=this.horiz?2:e?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[i]+=t.size+(t.options.margin||0))}function l(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new e(t.chart.renderer,t.options.scrollbar,t.chart),o(t.scrollbar,"changed",function(e){var n,o,s=i(t),a=s.axisMin,c=s.axisMax,l=s.scrollMin,h=s.scrollMax-l;if(r(a)&&r(c)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(n=l+h*this.to,o=l+h*this.from):(n=l+h*(1-this.from),o=l+h*(1-this.to)),this.shouldUpdateExtremes(e.DOMType)){var d="mousemove"!==e.DOMType&&"touchmove"!==e.DOMType&&void 0;t.setExtremes(o,n,!0,d,e)}else this.setRange(this.from,this.to)}}))}function h(){var t,e,n,o=i(this),s=o.scrollMin,a=o.scrollMax,c=this.scrollbar,l=this.axisTitleMargin+(this.titleOffset||0),h=this.chart.scrollbarsOffsets,d=this.options.margin||0;if(c&&h){if(this.horiz)this.opposite||(h[1]+=l),c.position(this.left,this.top+this.height+2+h[1]-(this.opposite?d:0),this.width,this.height),this.opposite||(h[1]+=d),t=1;else{this.opposite&&(h[0]+=l);var u=void 0;u=c.options.opposite?this.left+this.width+2+h[0]-(this.opposite?0:d):this.opposite?0:d,c.position(u,this.top,this.width,this.height),this.opposite&&(h[0]+=d),t=0}h[t]+=c.size+(c.options.margin||0),isNaN(s)||isNaN(a)||!r(this.min)||!r(this.max)||this.min===this.max?c.setRange(0,1):(e=(this.min-s)/(a-s),n=(this.max-s)/(a-s),this.horiz&&!this.reversed||!this.horiz&&this.reversed?c.setRange(e,n):c.setRange(1-n,1-e))}}t.compose=function(t,i){a(n,"Axis.Scrollbar")&&(e=i,o(t,"afterGetOffset",c),o(t,"afterInit",l),o(t,"afterRender",h))}}(i||(i={})),i}),i(e,"Stock/Scrollbar/ScrollbarDefaults.js",[],function(){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),i(e,"Stock/Scrollbar/Scrollbar.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/ScrollbarAxis.js"],e["Stock/Scrollbar/ScrollbarDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=t.defaultOptions,s=o.addEvent,a=o.correctFloat,c=o.defined,l=o.destroyObjectProperties,h=o.fireEvent,d=o.merge,u=o.pick,p=o.removeEvent,g=function(){function t(t,e,i){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,e,i)}return t.compose=function(e){i.compose(e,t)},t.swapXY=function(t,e){return e&&t.forEach(function(t){for(var e,i=t.length,n=0;n<i;n+=2)"number"==typeof(e=t[n+1])&&(t[n+1]=t[n+2],t[n+2]=e)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],e=this.scrollbarButtons,i=this.scrollbarGroup.element,n=this.track.element,o=this.mouseDownHandler.bind(this),r=this.mouseMoveHandler.bind(this),a=this.mouseUpHandler.bind(this),c=[[e[t[0]].element,"click",this.buttonToMinClick.bind(this)],[e[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[n,"click",this.trackClick.bind(this)],[i,"mousedown",o],[i.ownerDocument,"mousemove",r],[i.ownerDocument,"mouseup",a],[i,"touchstart",o],[i.ownerDocument,"touchmove",r],[i.ownerDocument,"touchend",a]];c.forEach(function(t){s.apply(null,t)}),this._events=c},t.prototype.buttonToMaxClick=function(t){var e=(this.to-this.from)*u(this.options.step,.2);this.updatePosition(this.from+e,this.to+e),h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var e=a(this.to-this.from)*u(this.options.step,.2);this.updatePosition(a(this.from-e),a(this.to-e)),h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var e=this.options,i=e.minWidth>this.calculatedWidth?e.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-i),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-i)}},t.prototype.destroy=function(){var t=this,e=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(e){t[e]&&t[e].destroy&&(t[e]=t[e].destroy())}),e&&t===e.scrollbar&&(e.scrollbar=null,l(e.scrollbarButtons))},t.prototype.drawScrollbarButton=function(e){var i=this.renderer,n=this.scrollbarButtons,o=this.options,r=this.size,s=i.g().add(this.group);if(n.push(s),o.buttonsEnabled){var a=i.rect().addClass("highcharts-scrollbar-button").add(s);this.chart.styledMode||a.attr({stroke:o.buttonBorderColor,"stroke-width":o.buttonBorderWidth,fill:o.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:r+1,height:r+1,r:o.buttonBorderRadius},a.strokeWidth()));var c=i.path(t.swapXY([["M",r/2+(e?-1:1),r/2-3],["L",r/2+(e?-1:1),r/2+3],["L",r/2+(e?2:-2),r/2]],o.vertical)).addClass("highcharts-scrollbar-arrow").add(n[e]);this.chart.styledMode||c.attr({fill:o.buttonArrowColor})}},t.prototype.init=function(t,e,i){this.scrollbarButtons=[],this.renderer=t,this.userOptions=e,this.options=d(n,r.scrollbar,e),this.options.margin=u(this.options.margin,10),this.chart=i,this.size=u(this.options.size,this.options.height),e.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var e,i=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t,n=this.cursorToScrollbarPosition(i);this.chartX=n.chartX,this.chartY=n.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var e,i,n=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t,o=this.options.vertical?"chartY":"chartX",r=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][o])&&(i=this.cursorToScrollbarPosition(n)[o]-this[o],this.hasDragged=!0,this.updatePosition(r[0]+i,r[1]+i),this.hasDragged&&h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,e,i,n){var o=this.options,r=o.buttonsEnabled,s=o.margin,a=void 0===s?0:s,c=o.vertical,l=this.rendered?"animate":"attr",h=n,d=0;this.group.show(),this.x=t,this.y=e+this.trackBorderWidth,this.width=i,this.height=n,this.xOffset=h,this.yOffset=d,c?(this.width=this.yOffset=i=d=this.size,this.xOffset=h=0,this.yOffset=d=r?this.size:0,this.barWidth=n-(r?2*i:0),this.x=t+=a):(this.height=n=this.size,this.xOffset=h=r?this.size:0,this.barWidth=i-(r?2*n:0),this.y=this.y+a),this.group[l]({translateX:t,translateY:this.y}),this.track[l]({width:i,height:n}),this.scrollbarButtons[1][l]({translateX:c?0:i-h,translateY:c?n-d:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){p.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var e=this.renderer,i=this.options,n=this.size,o=this.chart.styledMode,r=e.g("scrollbar").attr({zIndex:i.zIndex}).hide().add();this.group=r,this.track=e.rect().addClass("highcharts-scrollbar-track").attr({r:i.trackBorderRadius||0,height:n,width:n}).add(r),o||this.track.attr({fill:i.trackBackgroundColor,stroke:i.trackBorderColor,"stroke-width":i.trackBorderWidth});var s=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-s%2/2,y:-s%2/2}),this.scrollbarGroup=e.g().add(r),this.scrollbar=e.rect().addClass("highcharts-scrollbar-thumb").attr({height:n-s,width:n-s,r:i.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=e.path(t.swapXY([["M",-3,n/4],["L",-3,2*n/3],["M",0,n/4],["L",0,2*n/3],["M",3,n/4],["L",3,2*n/3]],i.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),o||(this.scrollbar.attr({fill:i.barBackgroundColor,stroke:i.barBorderColor,"stroke-width":i.barBorderWidth}),this.scrollbarRifles.attr({stroke:i.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,e){var i,n,o=this.options,r=o.vertical,s=o.minWidth,l=this.barWidth,h=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(c(l)){var d=l*Math.min(e,1);i=Math.ceil(l*(t=Math.max(t,0))),this.calculatedWidth=n=a(d-i),n<s&&(i=(l-s+n)*t,n=s);var u=Math.floor(i+this.xOffset+this.yOffset),p=n/2-.5;this.from=t,this.to=e,r?(this.scrollbarGroup[h]({translateY:u}),this.scrollbar[h]({height:n}),this.scrollbarRifles[h]({translateY:p}),this.scrollbarTop=u,this.scrollbarLeft=0):(this.scrollbarGroup[h]({translateX:u}),this.scrollbar[h]({width:n}),this.scrollbarRifles[h]({translateX:p}),this.scrollbarLeft=u,this.scrollbarTop=0),n<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===o.showFull&&(t<=0&&e>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return u(this.options.liveRedraw,e.svg&&!e.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!c(t)},t.prototype.trackClick=function(t){var e,i=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t,n=this.to-this.from,o=this.y+this.scrollbarTop,r=this.x+this.scrollbarLeft;this.options.vertical&&i.chartY>o||!this.options.vertical&&i.chartX>r?this.updatePosition(this.from+n,this.to+n):this.updatePosition(this.from-n,this.to-n),h(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,d(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,e){e>1&&(t=a(1-a(e-t)),e=1),t<0&&(e=a(e-t),t=0),this.from=t,this.to=e},t.defaultOptions=n,t}();return r.scrollbar=d(!0,g.defaultOptions,r.scrollbar),g}),i(e,"Stock/Navigator/Navigator.js",[e["Core/Axis/Axis.js"],e["Stock/Navigator/ChartNavigatorComposition.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorComposition.js"],e["Stock/Scrollbar/Scrollbar.js"],e["Core/Utilities.js"]],function(t,e,i,n,o,r,s,a){var c=i.defaultOptions,l=n.isTouchDevice,h=a.addEvent,d=a.clamp,u=a.correctFloat,p=a.defined,g=a.destroyObjectProperties,m=a.erase,f=a.extend,v=a.find,y=a.fireEvent,b=a.isArray,x=a.isNumber,A=a.merge,C=a.pick,w=a.removeEvent,E=a.splat;function T(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=[].filter.call(e,x);if(n.length)return Math[t].apply(0,n)}return function(){function i(t){this.scrollbarHeight=0,this.init(t)}return i.compose=function(t,n,o){e.compose(t,i),r.compose(t,n,o)},i.prototype.drawHandle=function(t,e,i,n){var o=this.navigatorOptions.handles.height;this.handles[e][n](i?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-o)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-o/2-1)})},i.prototype.drawOutline=function(t,e,i,n){var o,r,s=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),c=a/2,l=a%2/2,h=this.scrollButtonSize,d=this.size,u=this.top,p=this.height,g=u-c,m=u+p,f=this.left;i?(o=u+e+l,e=u+t+l,r=[["M",f+p,u-h-l],["L",f+p,o],["L",f,o],["M",f,e],["L",f+p,e],["L",f+p,u+d+h]],s&&r.push(["M",f+p,o-c],["L",f+p,e+c])):(f-=h,t+=f+h-l,e+=f+h-l,r=[["M",f,g],["L",t,g],["L",t,m],["M",e,m],["L",e,g],["L",f+d+2*h,u+c]],s&&r.push(["M",t-c,g],["L",e+c,g])),this.outline[n]({d:r})},i.prototype.drawMasks=function(t,e,i,n){var o,r,s,a,c=this.left,l=this.top,h=this.height;i?(s=[c,c,c],a=[l,l+t,l+e],r=[h,h,h],o=[t,e-t,this.size-e]):(s=[c,c+t,c+e],a=[l,l,l],r=[t,e-t,this.size-e],o=[h,h,h]),this.shades.forEach(function(t,e){t[n]({x:s[e],y:a[e],width:r[e],height:o[e]})})},i.prototype.renderElements=function(){var t=this,e=t.navigatorOptions,i=e.maskInside,n=t.chart,o=n.inverted,r=n.renderer,s={cursor:o?"ns-resize":"ew-resize"},a=t.navigatorGroup=r.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!i,i,!i].forEach(function(i,o){var c=r.rect().addClass("highcharts-navigator-mask"+(1===o?"-inside":"-outside")).add(a);n.styledMode||(c.attr({fill:i?e.maskFill:"rgba(0,0,0,0)"}),1===o&&c.css(s)),t.shades[o]=c}),t.outline=r.path().addClass("highcharts-navigator-outline").add(a),n.styledMode||t.outline.attr({"stroke-width":e.outlineWidth,stroke:e.outlineColor}),e.handles&&e.handles.enabled){var c=e.handles,l=c.height,h=c.width;[0,1].forEach(function(e){t.handles[e]=r.symbol(c.symbols[e],-h/2-1,0,h,l,c),n.inverted&&t.handles[e].attr({rotation:90,rotationOriginX:Math.floor(-h/2),rotationOriginY:(l+h)/2}),t.handles[e].attr({zIndex:7-e}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][e]).add(a),n.styledMode||t.handles[e].attr({fill:c.backgroundColor,stroke:c.borderColor,"stroke-width":c.lineWidth}).css(s)})}},i.prototype.update=function(t){(this.series||[]).forEach(function(t){t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),A(!0,this.chart.options.navigator,t),this.init(this.chart)},i.prototype.render=function(t,e,i,n){var o,r,s,a,c,l=this.chart,h=this.xAxis,g=h.pointRange||0,m=h.navigatorAxis.fake?l.xAxis[0]:h,f=this.navigatorEnabled,v=this.rendered,b=l.inverted,A=l.xAxis[0].minRange,w=l.xAxis[0].options.maxRange,E=this.scrollButtonSize,T=this.scrollbarHeight;if(!this.hasDragged||p(i)){if(t=u(t-g/2),e=u(e+g/2),!x(t)||!x(e)){if(!v)return;i=0,n=C(h.width,m.width)}this.left=C(h.left,l.plotLeft+E+(b?l.plotWidth:0));var M=this.size=a=C(h.len,(b?l.plotHeight:l.plotWidth)-2*E);o=b?T:a+2*E,i=C(i,h.toPixels(t,!0)),n=C(n,h.toPixels(e,!0)),x(i)&&Math.abs(i)!==1/0||(i=0,n=o);var S=h.toValue(i,!0),k=h.toValue(n,!0),P=Math.abs(u(k-S));P<A?this.grabbedLeft?i=h.toPixels(k-A-g,!0):this.grabbedRight&&(n=h.toPixels(S+A+g,!0)):p(w)&&u(P-g)>w&&(this.grabbedLeft?i=h.toPixels(k-w-g,!0):this.grabbedRight&&(n=h.toPixels(S+w+g,!0))),this.zoomedMax=d(Math.max(i,n),0,M),this.zoomedMin=d(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(i,n),0,M),this.range=this.zoomedMax-this.zoomedMin,M=Math.round(this.zoomedMax);var D=Math.round(this.zoomedMin);f&&(this.navigatorGroup.attr({visibility:"inherit"}),c=v&&!this.hasDragged?"animate":"attr",this.drawMasks(D,M,b,c),this.drawOutline(D,M,b,c),this.navigatorOptions.handles.enabled&&(this.drawHandle(D,0,b,c),this.drawHandle(M,1,b,c))),this.scrollbar&&(b?(s=this.top-E,r=this.left-T+(f||!m.opposite?0:(m.titleOffset||0)+m.axisTitleMargin),T=a+2*E):(s=this.top+(f?this.height:-T),r=this.left-E),this.scrollbar.position(r,s,o,T),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1))),this.rendered=!0,y(this,"afterRender")}},i.prototype.addMouseEvents=function(){var t,e,i=this,n=i.chart,o=n.container,r=[];i.mouseMoveHandler=t=function(t){i.onMouseMove(t)},i.mouseUpHandler=e=function(t){i.onMouseUp(t)},(r=i.getPartsEvents("mousedown")).push(h(n.renderTo,"mousemove",t),h(o.ownerDocument,"mouseup",e),h(n.renderTo,"touchmove",t),h(o.ownerDocument,"touchend",e)),r.concat(i.getPartsEvents("touchstart")),i.eventsToUnbind=r,i.series&&i.series[0]&&r.push(h(i.series[0].xAxis,"foundExtremes",function(){n.navigator.modifyNavigatorAxisExtremes()}))},i.prototype.getPartsEvents=function(t){var e=this,i=[];return["shades","handles"].forEach(function(n){e[n].forEach(function(o,r){i.push(h(o.element,t,function(t){e[n+"Mousedown"](t,r)}))})}),i},i.prototype.shadesMousedown=function(t,e){t=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t;var i,n,o,r,s,a=this.chart,c=this.xAxis,l=this.zoomedMin,h=this.size,d=this.range,u=this.left,g=t.chartX;a.inverted&&(g=t.chartY,u=this.top),1===e?(this.grabbedCenter=g,this.fixedWidth=d,this.dragOffset=g-l):(s=g-u-d/2,0===e?s=Math.max(0,s):2===e&&s+d>=h&&(s=h-d,this.reversedExtremes?(s-=d,o=this.getUnionExtremes().dataMin):n=this.getUnionExtremes().dataMax),s!==l&&(this.fixedWidth=d,p((r=c.navigatorAxis.toFixedRange(s,s+d,o,n)).min)&&y(this,"setRange",{min:Math.min(r.min,r.max),max:Math.max(r.min,r.max),redraw:!0,eventArguments:{trigger:"navigator"}})))},i.prototype.handlesMousedown=function(t,e){t=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t;var i,n=this.chart,o=n.xAxis[0],r=this.reversedExtremes;0===e?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=r?o.min:o.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=r?o.max:o.min),n.setFixedRange(void 0)},i.prototype.onMouseMove=function(t){var e,i,n=this,o=n.chart,r=n.navigatorSize,s=n.range,a=n.dragOffset,c=o.inverted,h=n.left;(!t.touches||0!==t.touches[0].pageX)&&(i=(t=(null===(e=o.pointer)||void 0===e?void 0:e.normalize(t))||t).chartX,c&&(h=n.top,i=t.chartY),n.grabbedLeft?(n.hasDragged=!0,n.render(0,0,i-h,n.otherHandlePos)):n.grabbedRight?(n.hasDragged=!0,n.render(0,0,n.otherHandlePos,i-h)):n.grabbedCenter&&(n.hasDragged=!0,i<a?i=a:i>r+a-s&&(i=r+a-s),n.render(0,0,i-a,i-a+s)),n.hasDragged&&n.scrollbar&&C(n.scrollbar.options.liveRedraw,!l&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){n.onMouseUp(t)},0)))},i.prototype.onMouseUp=function(t){var e,i,n,o,r,s,a=this.chart,c=this.xAxis,l=this.scrollbar,h=t.DOMEvent||t,d=a.inverted,u=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!l||!l.hasDragged)||"scrollbar"===t.trigger)&&(n=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?o=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(r=this.fixedExtreme),this.zoomedMax===this.size&&(r=this.reversedExtremes?n.dataMin:n.dataMax),0===this.zoomedMin&&(o=this.reversedExtremes?n.dataMax:n.dataMin),p((s=c.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,o,r)).min)&&y(this,"setRange",{min:Math.min(s.min,s.max),max:Math.max(s.min,s.max),redraw:!0,animation:!this.hasDragged&&null,eventArguments:{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:h}})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&x(this.zoomedMin)&&x(this.zoomedMax)&&(i=Math.round(this.zoomedMin),e=Math.round(this.zoomedMax),this.shades&&this.drawMasks(i,e,d,u),this.outline&&this.drawOutline(i,e,d,u),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(i,0,d,u),this.drawHandle(e,1,d,u)))},i.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},i.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){w(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&w(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},i.prototype.init=function(e){var i=e.options,n=i.navigator||{},r=n.enabled,a=i.scrollbar||{},c=a.enabled,l=r&&n.height||0,d=c&&a.height||0,u=a.buttonsEnabled&&d||0;this.handles=[],this.shades=[],this.chart=e,this.setBaseSeries(),this.height=l,this.scrollbarHeight=d,this.scrollButtonSize=u,this.scrollbarEnabled=c,this.navigatorEnabled=r,this.navigatorOptions=n,this.scrollbarOptions=a,this.opposite=C(n.opposite,!!(!r&&e.inverted));var p=this,g=p.baseSeries,m=e.xAxis.length,f=e.yAxis.length,v=g&&g[0]&&g[0].xAxis||e.xAxis[0]||{options:{}};if(e.isDirtyBox=!0,p.navigatorEnabled?(p.xAxis=new t(e,A({breaks:v.options.breaks,ordinal:v.options.ordinal,overscroll:v.options.overscroll},n.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:m,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},e.inverted?{offsets:[u,0,-u,0],width:l}:{offsets:[0,-u,0,u],height:l}),"xAxis"),p.yAxis=new t(e,A(n.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:f,isInternal:!0,reversed:C(n.yAxis&&n.yAxis.reversed,e.yAxis[0]&&e.yAxis[0].reversed,!1),zoomEnabled:!1},e.inverted?{width:l}:{height:l}),"yAxis"),g||n.series.data?p.updateNavigatorSeries(!1):0===e.series.length&&(p.unbindRedraw=h(e,"beforeRedraw",function(){e.series.length>0&&!p.series&&(p.setBaseSeries(),p.unbindRedraw())})),p.reversedExtremes=e.inverted&&!p.xAxis.reversed||!e.inverted&&p.xAxis.reversed,p.renderElements(),p.addMouseEvents()):(p.xAxis={chart:e,navigatorAxis:{fake:!0},translate:function(t,i){var n=e.xAxis[0],o=n.getExtremes(),r=n.len-2*u,s=T("min",n.options.min,o.dataMin),a=T("max",n.options.max,o.dataMax)-s;return i?t*a/r+s:r*(t-s)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},p.xAxis.navigatorAxis.axis=p.xAxis,p.xAxis.navigatorAxis.toFixedRange=o.prototype.toFixedRange.bind(p.xAxis.navigatorAxis)),e.options.scrollbar.enabled){var y=A(e.options.scrollbar,{vertical:e.inverted});!x(y.margin)&&p.navigatorEnabled&&(y.margin=e.inverted?-3:3),e.scrollbar=p.scrollbar=new s(e.renderer,y,e),h(p.scrollbar,"changed",function(t){var e=p.size,i=e*this.to,n=e*this.from;p.hasDragged=p.scrollbar.hasDragged,p.render(0,0,n,i),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){p.onMouseUp(t)})})}p.addBaseSeriesEvents(),p.addChartEvents()},i.prototype.getUnionExtremes=function(t){var e,i=this.chart.xAxis[0],n=this.xAxis,o=n.options,r=i.options;return t&&null===i.dataMin||(e={dataMin:C(o&&o.min,T("min",r.min,i.dataMin,n.dataMin,n.min)),dataMax:C(o&&o.max,T("max",r.max,i.dataMax,n.dataMax,n.max))}),e},i.prototype.setBaseSeries=function(t,e){var i=this.chart,n=this.baseSeries=[];t=t||i.options&&i.options.navigator.baseSeries||(i.series.length?v(i.series,function(t){return!t.options.isInternal}).index:0),(i.series||[]).forEach(function(e,i){!e.options.isInternal&&(e.options.showInNavigator||(i===t||e.options.id===t)&&!1!==e.options.showInNavigator)&&n.push(e)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,e)},i.prototype.updateNavigatorSeries=function(t,e){var i,n,o,r=this,s=r.chart,a=r.baseSeries,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},h=r.series=(r.series||[]).filter(function(t){var e=t.baseSeries;return!(0>a.indexOf(e))||(e&&(w(e,"updatedData",r.updatedDataHandler),delete e.navigatorSeries),t.chart&&t.destroy(),!1)}),d=r.navigatorOptions.series;a&&a.length&&a.forEach(function(t){var u=t.navigatorSeries,p=f({color:t.color,visible:t.visible},b(d)?c.navigator.series:d);if(!u||!1!==r.navigatorOptions.adaptToUpdatedData){l.name="Navigator "+a.length,o=(i=t.options||{}).navigatorOptions||{},p.dataLabels=E(p.dataLabels),(n=A(i,l,p,o)).pointRange=C(p.pointRange,o.pointRange,c.plotOptions[n.type||"line"].pointRange);var g=o.data||p.data;r.hasNavigatorData=r.hasNavigatorData||!!g,n.data=g||i.data&&i.data.slice(0),u&&u.options?u.update(n,e):(t.navigatorSeries=s.initSeries(n),s.setSortedData(),t.navigatorSeries.baseSeries=t,h.push(t.navigatorSeries))}}),(d.data&&!(a&&a.length)||b(d))&&(r.hasNavigatorData=!1,(d=E(d)).forEach(function(t,e){l.name="Navigator "+(h.length+1),(n=A(c.navigator.series,{color:s.series[e]&&!s.series[e].options.isInternal&&s.series[e].color||s.options.colors[e]||s.options.colors[0]},l,t)).data=t.data,n.data&&(r.hasNavigatorData=!0,h.push(s.initSeries(n)))})),t&&this.addBaseSeriesEvents()},i.prototype.addBaseSeriesEvents=function(){var t=this,e=this,i=e.baseSeries||[];i[0]&&i[0].xAxis&&i[0].eventsToUnbind.push(h(i[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),i.forEach(function(i){i.eventsToUnbind.push(h(i,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),i.eventsToUnbind.push(h(i,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&i.xAxis&&i.eventsToUnbind.push(h(i,"updatedData",t.updatedDataHandler)),i.eventsToUnbind.push(h(i,"remove",function(){this.navigatorSeries&&(m(e.series,this.navigatorSeries),p(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},i.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,e){return Math.min(t,e.xData&&e.xData.length?e.xData[0]:t)},t)},i.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var e=this.getUnionExtremes(!0);e&&(e.dataMin!==t.min||e.dataMax!==t.max)&&(t.min=e.dataMin,t.max=e.dataMax)}},i.prototype.modifyBaseAxisExtremes=function(){var t,e,i,n=this.chart.navigator,o=this.getExtremes(),r=o.min,s=o.max,a=o.dataMin,c=o.dataMax,l=s-r,h=n.stickToMin,d=n.stickToMax,u=C(null===(t=this.ordinal)||void 0===t?void 0:t.convertOverscroll(this.options.overscroll),0),p=n.series&&n.series[0],g=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(h&&(e=(i=a)+l),d&&(e=c+u,h||(i=Math.max(a,e-l,n.getBaseSeriesMin(p&&p.xData?p.xData[0]:-Number.MAX_VALUE)))),g&&(h||d)&&x(i)&&(this.min=this.userMin=i,this.max=this.userMax=e)),n.stickToMin=n.stickToMax=null},i.prototype.updatedDataHandler=function(){var t=this.chart.navigator,e=this.navigatorSeries,i=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=C(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,i),t.stickToMin=t.shouldStickToMin(this,t),e&&!t.hasNavigatorData&&(e.options.pointStart=this.xData[0],e.setData(this.options.data,!1,null,!1))},i.prototype.shouldStickToMin=function(t,e){var i=e.getBaseSeriesMin(t.xData[0]),n=t.xAxis,o=n.max,r=n.min,s=n.options.range;return!!(x(o)&&x(r))&&(s&&o-i>0?o-i<s:r<=i)},i.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(h(this.chart,"redraw",function(){var t=this.navigator,e=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);e&&t.render(e.min,e.max)}),h(this.chart,"getMargins",function(){var t=this.navigator,e=t.opposite?"plotTop":"marginBottom";this.inverted&&(e=t.opposite?"marginRight":"plotLeft"),this[e]=(this[e]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}),h(i,"setRange",function(t){this.chart.xAxis[0].setExtremes(t.min,t.max,t.redraw,t.animation,t.eventArguments)}))},i.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(m(this.chart.xAxis,this.xAxis),m(this.chart.axes,this.xAxis)),this.yAxis&&(m(this.chart.yAxis,this.yAxis),m(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(e){t[e]&&t[e].destroy&&t[e].destroy(),t[e]=null}),[this.handles].forEach(function(t){g(t)})},i}()}),i(e,"Accessibility/Components/NavigatorComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Stock/Navigator/Navigator.js"],e["Core/Animation/AnimationUtilities.js"],e["Core/Templating.js"],e["Core/Utilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/Utils/ChartUtilities.js"]],function(t,e,i,n,o,r,s,a,c){var l,h=this&&this.__extends||(l=function(t,e){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}l(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),d=o.animObject,u=r.format,p=s.clamp,g=s.pick,m=s.syncTimeout,f=a.getFakeMouseEvent,v=c.getAxisRangeDescription,y=c.fireEventOnWrappedOrUnwrappedElement;return function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return h(o,t),o.prototype.init=function(){var t=this.chart,i=this;this.announcer=new e(t,"polite"),this.addEvent(n,"afterRender",function(){this.chart===i.chart&&this.chart.renderer&&m(function(){i.proxyProvider.updateGroupProxyElementPositions("navigator"),i.updateHandleValues()},d(g(this.chart.renderer.globalAnimation,!0)).duration)})},o.prototype.onChartUpdate=function(){var t,e,i,n=this,o=this.chart,r=o.options;if(null===(t=r.navigator.accessibility)||void 0===t?void 0:t.enabled){var s=r.accessibility.landmarkVerbosity,a=null===(e=r.lang.accessibility)||void 0===e?void 0:e.navigator.groupLabel;this.proxyProvider.removeGroup("navigator"),this.proxyProvider.addGroup("navigator","div",{role:"all"===s?"region":"group","aria-label":u(a,{chart:o},o)});var c=null===(i=r.lang.accessibility)||void 0===i?void 0:i.navigator.handleLabel;[0,1].forEach(function(t){var e=n.getHandleByIx(t);if(e){var i=n.proxyProvider.addProxyElement("navigator",{click:e},"input",{type:"range","aria-label":u(c,{handleIx:t,chart:o},o)});n[t?"maxHandleProxy":"minHandleProxy"]=i.innerElement,i.innerElement.style.pointerEvents="none",i.innerElement.oninput=function(){return n.updateNavigator()}}}),this.updateHandleValues()}else this.proxyProvider.removeGroup("navigator")},o.prototype.getNavigatorHandleNavigation=function(t){var e=this,n=this,o=this.chart,r=t?this.maxHandleProxy:this.minHandleProxy,s=this.keyCodes;return new i(o,{keyCodeMap:[[[s.left,s.right,s.up,s.down],function(e){if(r){var i=e===s.left||e===s.up?-1:1;r.value=""+p(parseFloat(r.value)+i,0,100),n.updateNavigator(function(){var e=n.getHandleByIx(t);e&&o.setFocusToElement(e,r)})}return this.response.success}]],init:function(){o.setFocusToElement(e.getHandleByIx(t),r)},validate:function(){var i;return!!(e.getHandleByIx(t)&&r&&(null===(i=o.options.navigator.accessibility)||void 0===i?void 0:i.enabled))}})},o.prototype.getKeyboardNavigation=function(){return[this.getNavigatorHandleNavigation(0),this.getNavigatorHandleNavigation(1)]},o.prototype.destroy=function(){this.updateNavigatorThrottleTimer&&clearTimeout(this.updateNavigatorThrottleTimer),this.proxyProvider.removeGroup("navigator"),this.announcer&&this.announcer.destroy()},o.prototype.updateHandleValues=function(){var t=this.chart.navigator;if(t&&this.minHandleProxy&&this.maxHandleProxy){var e=t.size;this.minHandleProxy.value=""+Math.round(t.zoomedMin/e*100),this.maxHandleProxy.value=""+Math.round(t.zoomedMax/e*100)}},o.prototype.getHandleByIx=function(t){var e=this.chart.navigator;return e&&e.handles&&e.handles[t]},o.prototype.updateNavigator=function(t){var e=this;this.updateNavigatorThrottleTimer&&clearTimeout(this.updateNavigatorThrottleTimer),this.updateNavigatorThrottleTimer=setTimeout((function(t){var i,n=e.chart,o=n.navigator,r=n.pointer;if(o&&r&&e.minHandleProxy&&e.maxHandleProxy){var s=r.getChartPosition(),a=parseFloat(e.minHandleProxy.value)/100*o.size,c=parseFloat(e.maxHandleProxy.value)/100*o.size;[[0,"mousedown",o.zoomedMin],[0,"mousemove",a],[0,"mouseup",a],[1,"mousedown",o.zoomedMax],[1,"mousemove",c],[1,"mouseup",c]].forEach(function(t){var i,n=t[0],r=t[1],a=t[2],c=null===(i=e.getHandleByIx(n))||void 0===i?void 0:i.element;c&&y(c,f(r,{x:s.left+o.left+a,y:s.top+o.top},c))}),t&&t();var l=null===(i=n.options.lang.accessibility)||void 0===i?void 0:i.navigator.changeAnnouncement,h=v(n.xAxis[0]);e.announcer.announce(u(l,{axisRangeDescription:h,chart:n},n))}}).bind(this,t),20)},o}(t)}),i(e,"Accessibility/Components/SeriesComponent/SeriesDescriber.js",[e["Accessibility/Components/AnnotationsA11y.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Core/Templating.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r=t.getPointAnnotationTexts,s=e.getAxisDescription,a=e.getSeriesFirstPointElement,c=e.getSeriesA11yElement,l=e.unhideChartElementFromAT,h=i.format,d=i.numberFormat,u=n.reverseChildNodes,p=n.stripHTMLTagsFromString,g=o.find,m=o.isNumber,f=o.isString,v=o.pick,y=o.defined;function b(t){var e=t.chart.options.accessibility.series.pointDescriptionEnabledThreshold;return!!(!1!==e&&t.points&&t.points.length>=+e)}function x(t,e){var i=t.series,n=i.chart,o=n.options.accessibility.point||{},r=i.options.accessibility&&i.options.accessibility.point||{},s=i.tooltipOptions||{},a=n.options.lang;return m(e)?d(e,r.valueDecimals||o.valueDecimals||s.valueDecimals||-1,a.decimalPoint,a.accessibility.thousandsSep||a.thousandsSep):e}function A(t,e){var i=t[e];return t.chart.langFormat("accessibility.series."+e+"Description",{name:s(i),series:t})}function C(t){var e,i,n,o,s,a,c,l,d,u,p,g,m,f,b,A,C,w,E,T,M,S,k,P,D=t.series,N=D.chart.series.length>1||D.options.name,j=(w=(C=t.series).chart,T=(E=C.options.accessibility)&&E.point&&E.point.valueDescriptionFormat||w.options.accessibility.point.valueDescriptionFormat,S=(M=v(C.xAxis&&C.xAxis.options.accessibility&&C.xAxis.options.accessibility.enabled,!w.angular&&"flowmap"!==C.type))?(m=function(t){var e=t.series,i=e.chart,n=e.options.accessibility&&e.options.accessibility.point||{},o=i.options.accessibility.point||{},r=e.xAxis&&e.xAxis.dateTime;if(r){var s=r.getXDateFormat(t.x||0,i.options.tooltip.dateTimeLabelFormats),a=n.dateFormatter&&n.dateFormatter(t)||o.dateFormatter&&o.dateFormatter(t)||n.dateFormat||o.dateFormat||s;return i.time.dateFormat(a,t.x||0,void 0)}}(t),f=(t.series.xAxis||{}).categories&&y(t.category)&&(""+t.category).replace("<br/>"," "),b=y(t.id)&&0>(""+t.id).indexOf("highcharts-"),A="x, "+t.x,t.name||m||f||(b?t.id:A)):"",h(T,{point:t,index:y(t.index)?t.index+1:"",xDescription:S,value:(a=(s=(e=t).series).chart.options.accessibility.point||{},c=s.chart.options.accessibility&&s.chart.options.accessibility.point||{},l=s.tooltipOptions||{},d=c.valuePrefix||a.valuePrefix||l.valuePrefix||"",u=c.valueSuffix||a.valueSuffix||l.valueSuffix||"",p=void 0!==e.value?"value":"y",g=x(e,e[p]),e.isNull?s.chart.langFormat("accessibility.series.nullPointValue",{point:e}):s.pointArrayMap?(i=d||"",n=u||"",o=function(t){var o=x(e,v(e[t],e.options[t]));return void 0!==o?t+": "+i+o+n:o},e.series.pointArrayMap.reduce(function(t,e){var i=o(e);return i?t+(t.length?", ":"")+i:t},"")):d+g+u),separator:M?", ":""},w)),B=t.options&&t.options.accessibility&&t.options.accessibility.description,I=N?" "+D.name+".":"",O=(k=t.series.chart,(P=r(t)).length?k.langFormat("accessibility.series.pointAnnotationsDescription",{point:t,annotations:P}):"");return t.accessibility=t.accessibility||{},t.accessibility.valueDescription=j,j+(B?" "+B:"")+I+(O?" "+O:"")}function w(t){var e,i=t.chart,n=i.types||[],o=(e=(t.options.accessibility||{}).description)&&t.chart.langFormat("accessibility.series.description",{description:e,series:t})||"",r=function(e){return i[e]&&i[e].length>1&&t[e]},s=t.index+1,a=A(t,"xAxis"),c=A(t,"yAxis"),l={seriesNumber:s,series:t,chart:i},d=n.length>1?"Combination":"",u=i.langFormat("accessibility.series.summary."+t.type+d,l)||i.langFormat("accessibility.series.summary.default"+d,l),p=(r("yAxis")?" "+c+".":"")+(r("xAxis")?" "+a+".":"");return h(v(t.options.accessibility&&t.options.accessibility.descriptionFormat,i.options.accessibility.series.descriptionFormat,""),{seriesDescription:u,authorDescription:o?" "+o:"",axisDescription:p,series:t,chart:i,seriesNumber:s},void 0)}return{defaultPointDescriptionFormatter:C,defaultSeriesDescriptionFormatter:w,describeSeries:function(t){var e,i,n,o,r,s,d,m,x,A,E,T,M,S,k=t.chart,P=a(t),D=c(t),N=k.is3d&&k.is3d();D&&((D.lastChild!==P||N||u(D),e=t.options.accessibility||{},n=!b(t)&&!e.exposeAsGroupOnly,i=t.chart.options.accessibility.keyboardNavigation.seriesNavigation,o=!!(t.points&&(t.points.length<+i.pointNavigationEnabledThreshold||!1===i.pointNavigationEnabledThreshold)),r=t.chart.options.accessibility.point.describeNull,(n||o)&&t.points.forEach(function(e){var i,o,s,a,c,l,d,u,m,b,x,A,w=e.graphic&&e.graphic.element||(o=(i=e.series)&&i.chart,s=i&&i.is("sunburst"),a=e.isNull,c=o&&o.options.accessibility.point.describeNull,a&&!s&&c&&function(t){var e,i,n=t.series,o=(e=t.index,t.series&&t.series.data&&y(e)&&g(t.series.data,function(t){return!!(t&&void 0!==t.index&&t.index>e&&t.graphic&&t.graphic.element)})||null),r=o&&o.graphic,s=r?r.parentGroup:n.graph||n.group,a=o?{x:v(t.plotX,o.plotX,0),y:v(t.plotY,o.plotY,0)}:{x:v(t.plotX,0),y:v(t.plotY,0)},c=((i=t.series.chart.renderer.rect(a.x,a.y,1,1)).attr({class:"highcharts-a11y-mock-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),i);if(s&&s.element)return t.graphic=c,t.hasMockGraphic=!0,c.add(s),s.element.insertBefore(c.element,r?r.element:null),c.element}(e)),E=e.options&&e.options.accessibility&&!1===e.options.accessibility.enabled;if(w){if(e.isNull&&!r){w.setAttribute("aria-hidden",!0);return}(w.setAttribute("tabindex","-1"),t.chart.styledMode||(w.style.outline="none"),n&&!E)?(b=(null===(l=(m=e.series).options.accessibility)||void 0===l?void 0:l.point)||{},x=m.chart.options.accessibility.point||{},A=p(f(b.descriptionFormat)&&h(b.descriptionFormat,e,m.chart)||(null===(d=b.descriptionFormatter)||void 0===d?void 0:d.call(b,e))||f(x.descriptionFormat)&&h(x.descriptionFormat,e,m.chart)||(null===(u=x.descriptionFormatter)||void 0===u?void 0:u.call(x,e))||C(e),m.chart.renderer.forExport),w.setAttribute("role","img"),w.setAttribute("aria-label",A)):w.setAttribute("aria-hidden",!0)}}),l(k,D),m=(d=(s=t.chart).options.chart).options3d&&d.options3d.enabled,x=s.series.length>1,A=s.options.accessibility.series.describeSingleSeries,E=(t.options.accessibility||{}).exposeAsGroupOnly,!(m&&x)&&(x||A||E||b(t)))?(T=t.options.accessibility||{},S=(M=t.chart.options.accessibility).landmarkVerbosity,T.exposeAsGroupOnly?D.setAttribute("role","img"):"all"===S?D.setAttribute("role","region"):D.setAttribute("role","group"),D.setAttribute("tabindex","-1"),t.chart.styledMode||(D.style.outline="none"),D.setAttribute("aria-label",p(M.series.descriptionFormatter&&M.series.descriptionFormatter(t)||w(t),t.chart.renderer.forExport))):D.removeAttribute("aria-label"))}}}),i(e,"Accessibility/Components/SeriesComponent/NewDataAnnouncer.js",[e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(t,e,i,n,o,r){var s=t.composed,a=e.addEvent,c=e.defined,l=e.pushUnique,h=n.getChartTitle,d=r.defaultPointDescriptionFormatter,u=r.defaultSeriesDescriptionFormatter;function p(t){return!!t.options.accessibility.announceNewData.enabled}var g=function(){function e(t){this.dirty={allSeries:{}},this.lastAnnouncementTime=0,this.chart=t}return e.prototype.init=function(){var t=this.chart,e=t.options.accessibility.announceNewData.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new o,this.announcer=new i(t,e),this.addEventListeners()},e.prototype.destroy=function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},e.prototype.addEventListeners=function(){var t=this,e=this.chart,i=this.eventProvider;i.addEvent(e,"afterApplyDrilldown",function(){t.lastAnnouncementTime=0}),i.addEvent(e,"afterAddSeries",function(e){t.onSeriesAdded(e.series)}),i.addEvent(e,"redraw",function(){t.announceDirtyData()})},e.prototype.onSeriesAdded=function(t){p(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[t.name+t.index]=t,this.dirty.newSeries=c(this.dirty.newSeries)?void 0:t)},e.prototype.announceDirtyData=function(){var t=this.chart,e=this;if(t.options.accessibility.announceNewData&&this.dirty.hasDirty){var i,n,o=this.dirty.newPoint;o&&(o=1===(n=(i=o).series.data.filter(function(t){return i.x===t.x&&i.y===t.y})).length?n[0]:i),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(t){return e.dirty.allSeries[t]}),this.dirty.newSeries,o),this.dirty={allSeries:{}}}},e.prototype.queueAnnouncement=function(t,e,i){var n=this,o=this.chart.options.accessibility.announceNewData;if(o.enabled){var r,s=+new Date,a=s-this.lastAnnouncementTime,c=Math.max(0,o.minAnnounceInterval-a),l=Object.keys(r=(this.queuedAnnouncement&&this.queuedAnnouncement.series||[]).concat(t||[]).reduce(function(t,e){return t[e.name+e.index]=e,t},{})).map(function(t){return r[t]}),h=this.buildAnnouncementMessage(l,e,i);h&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:s,message:h,series:l},this.queuedAnnouncementTimer=setTimeout(function(){n&&n.announcer&&(n.lastAnnouncementTime=+new Date,n.announcer.announce(n.queuedAnnouncement.message),delete n.queuedAnnouncement,delete n.queuedAnnouncementTimer)},c))}},e.prototype.buildAnnouncementMessage=function(e,i,n){var o=this.chart,r=o.options.accessibility.announceNewData;if(r.announcementFormatter){var s=r.announcementFormatter(e,i,n);if(!1!==s)return s.length?s:null}var a=t.charts&&t.charts.length>1?"Multiple":"Single",c=i?"newSeriesAnnounce"+a:n?"newPointAnnounce"+a:"newDataAnnounce",l=h(o);return o.langFormat("accessibility.announceNewData."+c,{chartTitle:l,seriesDesc:i?u(i):null,pointDesc:n?d(n):null,point:n,series:i})},e}();return function(t){function e(t){var e,i=this.chart,n=null===(e=i.accessibility)||void 0===e?void 0:e.components.series.newDataAnnouncer;n&&n.chart===i&&p(i)&&(n.dirty.newPoint=c(n.dirty.newPoint)?void 0:t.point)}function i(){var t,e=this.chart,i=null===(t=e.accessibility)||void 0===t?void 0:t.components.series.newDataAnnouncer;i&&i.chart===e&&p(e)&&(i.dirty.hasDirty=!0,i.dirty.allSeries[this.name+this.index]=this)}t.compose=function(t){l(s,"A11y.NDA")&&(a(t,"addPoint",e),a(t,"updatedData",i))}}(g||(g={})),g}),i(e,"Accessibility/ProxyElement.js",[e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,n,o){var r=t.doc,s=e.attr,a=e.css,c=e.merge,l=n.fireEventOnWrappedOrUnwrappedElement,h=o.cloneMouseEvent,d=o.cloneTouchEvent,u=o.getFakeMouseEvent,p=o.removeElement;return function(){function t(t,e,n,o,s){void 0===n&&(n="button"),this.chart=t,this.target=e,this.eventProvider=new i;var a=this.innerElement=r.createElement(n),c=this.element=o?r.createElement(o):a;t.styledMode||this.hideElementVisually(a),o&&("li"!==o||t.styledMode||(c.style.listStyle="none"),c.appendChild(a),this.element=c),this.updateTarget(e,s)}return t.prototype.click=function(){var t=this.getTargetPosition();t.x+=t.width/2,t.y+=t.height/2;var e=u("click",t);l(this.target.click,e)},t.prototype.updateTarget=function(t,e){this.target=t,this.updateCSSClassName();var i=e||{};Object.keys(i).forEach(function(t){null===i[t]&&delete i[t]});var n=this.getTargetAttr(t.click,"aria-label");s(this.innerElement,c(n?{"aria-label":n}:{},i)),this.eventProvider.removeAddedEvents(),this.addProxyEventsToElement(this.innerElement,t.click),this.refreshPosition()},t.prototype.refreshPosition=function(){var t=this.getTargetPosition();a(this.innerElement,{width:(t.width||1)+"px",height:(t.height||1)+"px",left:(Math.round(t.x)||0)+"px",top:(Math.round(t.y)||0)+"px"})},t.prototype.remove=function(){this.eventProvider.removeAddedEvents(),p(this.element)},t.prototype.updateCSSClassName=function(){var t=function(t){return t.indexOf("highcharts-no-tooltip")>-1},e=this.chart.legend,i=e.group&&e.group.div,n=t(i&&i.className||""),o=t(this.getTargetAttr(this.target.click,"class")||"");this.innerElement.className=n||o?"highcharts-a11y-proxy-element highcharts-no-tooltip":"highcharts-a11y-proxy-element"},t.prototype.addProxyEventsToElement=function(t,e){var i=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(n){var o=0===n.indexOf("touch");i.eventProvider.addEvent(t,n,function(t){var i=o?d(t):h(t);e&&l(e,i),t.stopPropagation(),o||t.preventDefault()},{passive:!1})})},t.prototype.hideElementVisually=function(t){a(t,{borderWidth:0,backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:.001,filter:"alpha(opacity=1)",zIndex:999,overflow:"hidden",padding:0,margin:0,display:"block",position:"absolute","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"})},t.prototype.getTargetPosition=function(){var t=this.target.click,e=t.element?t.element:t,i=this.target.visual||e,n=this.chart.renderTo,o=this.chart.pointer;if(n&&(null==i?void 0:i.getBoundingClientRect)&&o){var r=i.getBoundingClientRect(),s=o.getChartPosition();return{x:(r.left-s.left)/s.scaleX,y:(r.top-s.top)/s.scaleY,width:r.right/s.scaleX-r.left/s.scaleX,height:r.bottom/s.scaleY-r.top/s.scaleY}}return{x:0,y:0,width:1,height:1}},t.prototype.getTargetAttr=function(t,e){return t.element?t.element.getAttribute(e):t.getAttribute(e)},t}()}),i(e,"Accessibility/ProxyProvider.js",[e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/DOMElementProvider.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/ProxyElement.js"]],function(t,e,i,n,o,r){var s=t.doc,a=e.attr,c=e.css,l=i.unhideChartElementFromAT,h=o.removeChildNodes;return function(){function t(t){this.chart=t,this.domElementProvider=new n,this.groups={},this.groupOrder=[],this.beforeChartProxyPosContainer=this.createProxyPosContainer("before"),this.afterChartProxyPosContainer=this.createProxyPosContainer("after"),this.update()}return t.prototype.addProxyElement=function(t,e,i,n){void 0===i&&(i="button");var o=this.groups[t];if(!o)throw Error("ProxyProvider.addProxyElement: Invalid group key "+t);var s="ul"===o.type||"ol"===o.type?"li":void 0,a=new r(this.chart,e,i,s,n);return o.proxyContainerElement.appendChild(a.element),o.proxyElements.push(a),a},t.prototype.addGroup=function(t,e,i){void 0===e&&(e="div");var n,o=this.groups[t];if(o)return o.groupElement;var r=this.domElementProvider.createElement(e);return i&&i.role&&"div"!==e?(n=this.domElementProvider.createElement("div")).appendChild(r):n=r,n.className="highcharts-a11y-proxy-group highcharts-a11y-proxy-group-"+t.replace(/\W/g,"-"),this.groups[t]={proxyContainerElement:r,groupElement:n,type:e,proxyElements:[]},a(n,i||{}),"ul"===e&&r.setAttribute("role","list"),this.afterChartProxyPosContainer.appendChild(n),this.updateGroupOrder(this.groupOrder),n},t.prototype.updateGroupAttrs=function(t,e){var i=this.groups[t];if(!i)throw Error("ProxyProvider.updateGroupAttrs: Invalid group key "+t);a(i.groupElement,e)},t.prototype.updateGroupOrder=function(t){var e=this;if(this.groupOrder=t.slice(),!this.isDOMOrderGroupOrder()){var i=t.indexOf("series"),n=i>-1?t.slice(0,i):t,o=i>-1?t.slice(i+1):[],r=s.activeElement;["before","after"].forEach(function(t){var i=e["before"===t?"beforeChartProxyPosContainer":"afterChartProxyPosContainer"];h(i),("before"===t?n:o).forEach(function(t){var n=e.groups[t];n&&i.appendChild(n.groupElement)})}),(this.beforeChartProxyPosContainer.contains(r)||this.afterChartProxyPosContainer.contains(r))&&r&&r.focus&&r.focus()}},t.prototype.clearGroup=function(t){var e=this.groups[t];if(!e)throw Error("ProxyProvider.clearGroup: Invalid group key "+t);h(e.proxyContainerElement)},t.prototype.removeGroup=function(t){var e=this.groups[t];e&&(this.domElementProvider.removeElement(e.groupElement),e.groupElement!==e.proxyContainerElement&&this.domElementProvider.removeElement(e.proxyContainerElement),delete this.groups[t])},t.prototype.update=function(){this.updatePosContainerPositions(),this.updateGroupOrder(this.groupOrder),this.updateProxyElementPositions()},t.prototype.updateProxyElementPositions=function(){Object.keys(this.groups).forEach(this.updateGroupProxyElementPositions.bind(this))},t.prototype.updateGroupProxyElementPositions=function(t){var e=this.groups[t];e&&e.proxyElements.forEach(function(t){return t.refreshPosition()})},t.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},t.prototype.createProxyPosContainer=function(t){var e=this.domElementProvider.createElement("div");return e.setAttribute("aria-hidden","false"),e.className="highcharts-a11y-proxy-container"+(t?"-"+t:""),c(e,{top:"0",left:"0"}),this.chart.styledMode||(e.style.whiteSpace="nowrap",e.style.position="absolute"),e},t.prototype.getCurrentGroupOrderInDOM=function(){var t=this,e=function(e){for(var i=Object.keys(t.groups),n=i.length;n--;){var o=i[n],r=t.groups[o];if(r&&e===r.groupElement)return o}},i=function(t){for(var i=[],n=t.children,o=0;o<n.length;++o){var r=e(n[o]);r&&i.push(r)}return i},n=i(this.beforeChartProxyPosContainer),o=i(this.afterChartProxyPosContainer);return n.push("series"),n.concat(o)},t.prototype.isDOMOrderGroupOrder=function(){var t=this,e=this.getCurrentGroupOrderInDOM(),i=this.groupOrder.filter(function(e){return"series"===e||!!t.groups[e]}),n=e.length;if(n!==i.length)return!1;for(;n--;)if(e[n]!==i[n])return!1;return!0},t.prototype.updatePosContainerPositions=function(){var t=this.chart;if(!t.renderer.forExport){var e=t.renderer.box;t.container.insertBefore(this.afterChartProxyPosContainer,e.nextSibling),t.container.insertBefore(this.beforeChartProxyPosContainer,e),l(this.chart,this.afterChartProxyPosContainer),l(this.chart,this.beforeChartProxyPosContainer)}},t}()}),i(e,"Accessibility/Components/RangeSelectorComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/Announcer.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r,s=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=i.unhideChartElementFromAT,c=i.getAxisRangeDescription,l=o.addEvent,h=o.attr,d=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s(i,t),i.prototype.init=function(){var t=this.chart;this.announcer=new e(t,"polite")},i.prototype.onChartUpdate=function(){var t=this.chart,e=this,i=t.rangeSelector;i&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),i.buttons&&i.buttons.length&&i.buttons.forEach(function(t){e.setRangeButtonAttrs(t)}),i.maxInput&&i.minInput&&["minInput","maxInput"].forEach(function(n,o){var r=i[n];r&&(a(t,r),e.setRangeInputAttrs(r,"accessibility.rangeSelector."+(o?"max":"min")+"InputLabel"))}))},i.prototype.updateSelectorVisibility=function(){var t=this.chart,e=t.rangeSelector,i=e&&e.dropdown,n=e&&e.buttons||[],o=function(t){return t.setAttribute("aria-hidden",!0)};e&&e.hasVisibleDropdown&&i?(a(t,i),n.forEach(function(t){return o(t.element)})):(i&&o(i),n.forEach(function(e){return a(t,e.element)}))},i.prototype.setDropdownAttrs=function(){var t=this.chart,e=t.rangeSelector&&t.rangeSelector.dropdown;if(e){var i=t.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:t.options.lang.rangeSelectorZoom});e.setAttribute("aria-label",i),e.setAttribute("tabindex",-1)}},i.prototype.setRangeButtonAttrs=function(t){h(t.element,{tabindex:-1,role:"button"})},i.prototype.setRangeInputAttrs=function(t,e){var i=this.chart;h(t,{tabindex:-1,"aria-label":i.langFormat(e,{chart:i})})},i.prototype.onButtonNavKbdArrowKey=function(t,e){var i=t.response,n=this.keyCodes,o=this.chart,r=o.options.accessibility.keyboardNavigation.wrapAround,s=e===n.left||e===n.up?-1:1;return o.highlightRangeSelectorButton(o.highlightedRangeSelectorItemIx+s)?i.success:r?(t.init(s),i.success):i[s>0?"next":"prev"]},i.prototype.onButtonNavKbdClick=function(t){var e=t.response,i=this.chart;return 3!==i.oldRangeSelectorItemState&&this.fakeClickEvent(i.rangeSelector.buttons[i.highlightedRangeSelectorItemIx].element),e.success},i.prototype.onAfterBtnClick=function(){var t=this.chart,e=c(t.xAxis[0]),i=t.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:t,axisRangeDescription:e});i&&this.announcer.announce(i)},i.prototype.onInputKbdMove=function(t){var e=this.chart,i=e.rangeSelector,n=e.highlightedInputRangeIx=(e.highlightedInputRangeIx||0)+t;if(n>1||n<0){if(e.accessibility)return e.accessibility.keyboardNavigation.exiting=!0,e.accessibility.keyboardNavigation.tabindexContainer.focus(),e.accessibility.keyboardNavigation.move(t)}else if(i){var o=i[n?"maxDateBox":"minDateBox"],r=i[n?"maxInput":"minInput"];o&&r&&e.setFocusToElement(o,r)}return!0},i.prototype.onInputNavInit=function(t){var e=this,i=this,n=this.chart,o=t>0?0:1,r=n.rangeSelector,s=r&&r[o?"maxDateBox":"minDateBox"],a=r&&r.minInput,c=r&&r.maxInput;if(n.highlightedInputRangeIx=o,s&&a&&c){n.setFocusToElement(s,o?c:a),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var h=function(t){(t.which||t.keyCode)===e.keyCodes.tab&&i.onInputKbdMove(t.shiftKey?-1:1)&&(t.preventDefault(),t.stopPropagation())},d=l(a,"keydown",h),u=l(c,"keydown",h);this.removeInputKeydownHandler=function(){d(),u()}}},i.prototype.onInputNavTerminate=function(){var t=this.chart.rangeSelector||{};t.maxInput&&t.hideInput("max"),t.minInput&&t.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},i.prototype.initDropdownNav=function(){var t=this,e=this.chart,i=e.rangeSelector,n=i&&i.dropdown;i&&n&&(e.setFocusToElement(i.buttonGroup,n),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=l(n,"keydown",function(i){var n=(i.which||i.keyCode)===t.keyCodes.tab,o=e.accessibility;n&&(i.preventDefault(),i.stopPropagation(),o&&(o.keyboardNavigation.tabindexContainer.focus(),o.keyboardNavigation.move(i.shiftKey?-1:1)))}))},i.prototype.getRangeSelectorButtonNavigation=function(){var t=this.chart,e=this.keyCodes,i=this;return new n(t,{keyCodeMap:[[[e.left,e.right,e.up,e.down],function(t){return i.onButtonNavKbdArrowKey(this,t)}],[[e.enter,e.space],function(){return i.onButtonNavKbdClick(this)}]],validate:function(){return!!(t.rangeSelector&&t.rangeSelector.buttons&&t.rangeSelector.buttons.length)},init:function(e){var n=t.rangeSelector;if(n&&n.hasVisibleDropdown)i.initDropdownNav();else if(n){var o=n.buttons.length-1;t.highlightRangeSelectorButton(e>0?0:o)}},terminate:function(){i.removeDropdownKeydownHandler&&(i.removeDropdownKeydownHandler(),delete i.removeDropdownKeydownHandler)}})},i.prototype.getRangeSelectorInputNavigation=function(){var t=this.chart,e=this;return new n(t,{keyCodeMap:[],validate:function(){return!!(t.rangeSelector&&t.rangeSelector.inputGroup&&"hidden"!==t.rangeSelector.inputGroup.element.style.visibility&&!1!==t.options.rangeSelector.inputEnabled&&t.rangeSelector.minInput&&t.rangeSelector.maxInput)},init:function(t){e.onInputNavInit(t)},terminate:function(){e.onInputNavTerminate()}})},i.prototype.getKeyboardNavigation=function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},i.prototype.destroy=function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()},i}(t);return function(t){function e(t){var e=this.rangeSelector&&this.rangeSelector.buttons||[],i=this.highlightedRangeSelectorItemIx,n=this.rangeSelector&&this.rangeSelector.selected;return void 0!==i&&e[i]&&i!==n&&e[i].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=t,!!e[t]&&(this.setFocusToElement(e[t].box,e[t].element),t!==n&&(this.oldRangeSelectorItemState=e[t].state,e[t].setState(1)),!0)}function i(){var t=this.chart.accessibility;if(t&&t.components.rangeSelector)return t.components.rangeSelector.onAfterBtnClick()}t.compose=function(t,n){var o=t.prototype;o.highlightRangeSelectorButton||(o.highlightRangeSelectorButton=e,l(n,"afterBtnClick",i))}}(d||(d={})),d}),i(e,"Accessibility/Components/SeriesComponent/ForcedMarkers.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i,n=t.composed,o=e.addEvent,r=e.merge,s=e.pushUnique;return function(t){function e(t){r(!0,t,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function i(t){return t.marker.states&&t.marker.states.normal&&t.marker.states.normal.opacity}function a(t){return!!(t._hasPointMarkers&&t.points&&t.points.length)}function c(){this.chart.styledMode&&(this.markerGroup&&this.markerGroup[this.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),a(this)&&this.points.forEach(function(t){t.graphic&&(t.graphic[t.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),t.graphic[!1===t.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))}function l(t){this.resetA11yMarkerOptions=r(t.options.marker||{},this.userOptions.marker||{})}function h(){var t,n,o,s,c=this.options;(t=this,o=t.chart.options.accessibility.enabled,s=!1!==(t.options.accessibility&&t.options.accessibility.enabled),o&&s&&(n=t.chart.options.accessibility,t.points.length<n.series.pointDescriptionEnabledThreshold||!1===n.series.pointDescriptionEnabledThreshold))?(c.marker&&!1===c.marker.enabled&&(this.a11yMarkersForced=!0,e(this.options)),a(this)&&function(t){for(var n=t.points.length;n--;){var o=t.points[n],s=o.options,a=o.hasForcedA11yMarker;if(delete o.hasForcedA11yMarker,s.marker){var c=a&&0===i(s);s.marker.enabled&&!c?(r(!0,s.marker,{states:{normal:{opacity:i(s)||1}}}),o.hasForcedA11yMarker=!1):!1===s.marker.enabled&&(e(s),o.hasForcedA11yMarker=!0)}}}(this)):this.a11yMarkersForced&&(delete this.a11yMarkersForced,function(t){var e=t.resetA11yMarkerOptions;if(e){var i=e.states&&e.states.normal&&e.states.normal.opacity;t.userOptions&&t.userOptions.marker&&(t.userOptions.marker.enabled=!0),t.update({marker:{enabled:e.enabled,states:{normal:{opacity:i}}}})}}(this),delete this.resetA11yMarkerOptions)}function d(){this.boosted&&this.a11yMarkersForced&&(r(!0,this.options,{marker:{enabled:!1}}),delete this.a11yMarkersForced)}t.compose=function(t){s(n,"A11y.FM")&&(o(t,"afterSetOptions",l),o(t,"render",h),o(t,"afterRender",c),o(t,"renderCanvas",d))}}(i||(i={})),i}),i(e,"Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js",[e["Core/Series/Point.js"],e["Core/Series/Series.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Utils/EventProvider.js"],e["Accessibility/Utils/ChartUtilities.js"]],function(t,e,i,n,o,r,s,a){var c=i.seriesTypes,l=n.doc,h=o.defined,d=o.fireEvent,u=a.getPointFromXY,p=a.getSeriesFromName,g=a.scrollAxisToPoint;function m(t){var e=t.index,i=t.series.points,n=i.length;if(i[e]===t)return e;for(;n--;)if(i[n]===t)return n}function f(t){var e=t.chart.options.accessibility.keyboardNavigation.seriesNavigation,i=t.options.accessibility||{},n=i.keyboardNavigation;return n&&!1===n.enabled||!1===i.enabled||!1===t.options.enableMouseTracking||!t.visible||e.pointNavigationEnabledThreshold&&+e.pointNavigationEnabledThreshold<=t.points.length}function v(t){var e=t.series.chart.options.accessibility,i=t.options.accessibility&&!1===t.options.accessibility.enabled;return t.isNull&&e.keyboardNavigation.seriesNavigation.skipNullPoints||!1===t.visible||!1===t.isInside||i||f(t.series)}function y(t){for(var e=t.series||[],i=e.length,n=0;n<i;++n)if(!f(e[n])){var o=function(t){for(var e=t.points||[],i=e.length,n=0;n<i;++n)if(!v(e[n]))return e[n];return null}(e[n]);if(o)return o}return null}function b(t){for(var e=t.series.length,i=!1;e--&&(t.highlightedPoint=t.series[e].points[t.series[e].points.length-1],!(i=t.series[e].highlightNextValidPoint())););return i}function x(t){delete t.highlightedPoint;var e=y(t);return!!e&&e.highlight()}var A=function(){function i(t,e){this.keyCodes=e,this.chart=t}return i.prototype.init=function(){var i=this,n=this.chart,o=this.eventProvider=new s;o.addEvent(e,"destroy",function(){return i.onSeriesDestroy(this)}),o.addEvent(n,"afterApplyDrilldown",function(){var t;(t=y(this))&&t.highlight(!1)}),o.addEvent(n,"drilldown",function(t){var e=t.point,n=e.series;i.lastDrilledDownPoint={x:e.x,y:e.y,seriesName:n?n.name:""}}),o.addEvent(n,"drillupall",function(){setTimeout(function(){i.onDrillupAll()},10)}),o.addEvent(t,"afterSetState",function(){var t=this.graphic&&this.graphic.element,e=l.activeElement,i=e&&e.getAttribute("class"),o=i&&i.indexOf("highcharts-a11y-proxy-element")>-1;n.highlightedPoint===this&&e!==t&&!o&&t&&t.focus&&t.focus()})},i.prototype.onDrillupAll=function(){var t,e=this.lastDrilledDownPoint,i=this.chart,n=e&&p(i,e.seriesName);e&&n&&h(e.x)&&h(e.y)&&(t=u(n,e.x,e.y)),t=t||y(i),i.container&&i.container.focus(),t&&t.highlight&&t.highlight(!1)},i.prototype.getKeyboardNavigationHandler=function(){var t=this,e=this.keyCodes,i=this.chart,n=i.inverted;return new r(i,{keyCodeMap:[[n?[e.up,e.down]:[e.left,e.right],function(e){return t.onKbdSideways(this,e)}],[n?[e.left,e.right]:[e.up,e.down],function(e){return t.onKbdVertical(this,e)}],[[e.enter,e.space],function(t,e){var n=i.highlightedPoint;return n&&(e.point=n,d(n.series,"click",e),n.firePointEvent("click")),this.response.success}],[[e.home],function(){return x(i),this.response.success}],[[e.end],function(){return b(i),this.response.success}],[[e.pageDown,e.pageUp],function(t){return i.highlightAdjacentSeries(t===e.pageDown),this.response.success}]],init:function(){return t.onHandlerInit(this)},validate:function(){return!!y(i)},terminate:function(){return t.onHandlerTerminate()}})},i.prototype.onKbdSideways=function(t,e){var i=this.keyCodes,n=e===i.right||e===i.down;return this.attemptHighlightAdjacentPoint(t,n)},i.prototype.onHandlerInit=function(t){var e=this.chart;return e.options.accessibility.keyboardNavigation.seriesNavigation.rememberPointFocus&&e.highlightedPoint?e.highlightedPoint.highlight():x(e),t.response.success},i.prototype.onKbdVertical=function(t,e){var i=this.chart,n=this.keyCodes,o=e===n.down||e===n.right,r=i.options.accessibility.keyboardNavigation.seriesNavigation;if(r.mode&&"serialize"===r.mode)return this.attemptHighlightAdjacentPoint(t,o);var s=i.highlightedPoint&&i.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return i[s](o),t.response.success},i.prototype.onHandlerTerminate=function(){var t=this.chart,e=t.options.accessibility.keyboardNavigation;t.tooltip&&t.tooltip.hide(0);var i=t.highlightedPoint&&t.highlightedPoint.series;i&&i.onMouseOut&&i.onMouseOut(),t.highlightedPoint&&t.highlightedPoint.onMouseOut&&t.highlightedPoint.onMouseOut(),e.seriesNavigation.rememberPointFocus||delete t.highlightedPoint},i.prototype.attemptHighlightAdjacentPoint=function(t,e){var i=this.chart,n=i.options.accessibility.keyboardNavigation.wrapAround;return i.highlightAdjacentPoint(e)?t.response.success:n&&(e?x(i):b(i))?t.response.success:t.response[e?"next":"prev"]},i.prototype.onSeriesDestroy=function(t){var e=this.chart;e.highlightedPoint&&e.highlightedPoint.series===t&&(delete e.highlightedPoint,e.focusElement&&e.focusElement.removeFocusBorder())},i.prototype.destroy=function(){this.eventProvider.removeAddedEvents()},i}();return function(t){function e(t){var e,i,n=this.series,o=this.highlightedPoint,r=o&&m(o)||0,s=o&&o.series.points||[],a=this.series&&this.series[this.series.length-1],c=a&&a.points&&a.points[a.points.length-1];if(!n[0]||!n[0].points)return!1;if(o){if(e=n[o.series.index+(t?1:-1)],(i=s[r+(t?1:-1)])||!e||(i=e.points[t?0:e.points.length-1]),!i)return!1}else i=t?n[0].points[0]:c;return v(i)?(f(e=i.series)?this.highlightedPoint=t?e.points[e.points.length-1]:e.points[0]:this.highlightedPoint=i,this.highlightAdjacentPoint(t)):i.highlight()}function i(t){var e,i=this.highlightedPoint,n=1/0;return!!(h(i.plotX)&&h(i.plotY))&&(this.series.forEach(function(o){f(o)||o.points.forEach(function(r){if(h(r.plotY)&&h(r.plotX)&&r!==i){var s=r.plotY-i.plotY,a=Math.abs(r.plotX-i.plotX),c=Math.abs(s)*Math.abs(s)+a*a*4;o.yAxis&&o.yAxis.reversed&&(s*=-1),!(s<=0&&t||s>=0&&!t||c<5||v(r))&&c<n&&(n=c,e=r)}})}),!!e&&e.highlight())}function n(t){var e,i,n,o=this.highlightedPoint,r=this.series&&this.series[this.series.length-1],s=r&&r.points&&r.points[r.points.length-1];return this.highlightedPoint?!!((e=this.series[o.series.index+(t?-1:1)])&&(i=function(t,e,i,n){var o,r,s,a=1/0,c=e.points.length,l=function(t){return!(h(t.plotX)&&h(t.plotY))};if(!l(t)){for(;c--;)!l(o=e.points[c])&&(s=(t.plotX-o.plotX)*(t.plotX-o.plotX)*4+(t.plotY-o.plotY)*(t.plotY-o.plotY)*1)<a&&(a=s,r=c);return h(r)?e.points[r]:void 0}}(o,e,0)))&&(f(e)?(i.highlight(),n=this.highlightAdjacentSeries(t))?n:(o.highlight(),!1):(i.highlight(),i.series.highlightNextValidPoint())):(e=t?this.series&&this.series[0]:r,!!(i=t?e&&e.points&&e.points[0]:s)&&i.highlight())}function o(t){void 0===t&&(t=!0);var e,i,n=this.series.chart,o=null===(i=null===(e=n.tooltip)||void 0===e?void 0:e.label)||void 0===i?void 0:i.element;!this.isNull&&t?this.onMouseOver():n.tooltip&&n.tooltip.hide(0),g(this),this.graphic&&(n.setFocusToElement(this.graphic),!t&&n.focusElement&&n.focusElement.removeFocusBorder()),n.highlightedPoint=this;var r=null==o?void 0:o.getBoundingClientRect().top;if(o&&r&&r<0){var s=window.scrollY;window.scrollTo({behavior:"smooth",top:s+r})}return this}function r(){var t=this.chart.highlightedPoint,e=(t&&t.series)===this?m(t):0,i=this.points,n=i.length;if(i&&n){for(var o=e;o<n;++o)if(!v(i[o]))return i[o].highlight();for(var r=e;r>=0;--r)if(!v(i[r]))return i[r].highlight()}return!1}t.compose=function(t,s,a){var l=t.prototype,h=s.prototype,d=a.prototype;l.highlightAdjacentPoint||(l.highlightAdjacentPoint=e,l.highlightAdjacentPointVertical=i,l.highlightAdjacentSeries=n,h.highlight=o,d.keyboardMoveVertical=!0,["column","gantt","pie"].forEach(function(t){c[t]&&(c[t].prototype.keyboardMoveVertical=!1)}),d.highlightNextValidPoint=r)}}(A||(A={})),A}),i(e,"Accessibility/Components/SeriesComponent/SeriesComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Components/SeriesComponent/ForcedMarkers.js"],e["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],e["Accessibility/Components/SeriesComponent/SeriesDescriber.js"],e["Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js"]],function(t,e,i,n,o,r){var s,a=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),c=e.hideSeriesFromAT,l=o.describeSeries;return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a(e,t),e.compose=function(t,e,o){n.compose(o),i.compose(o),r.compose(t,e,o)},e.prototype.init=function(){this.newDataAnnouncer=new n(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new r(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},e.prototype.hideTooltipFromATWhenShown=function(){var t=this;this.chart.tooltip&&this.addEvent(this.chart.tooltip.constructor,"refresh",function(){this.chart===t.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},e.prototype.hideSeriesLabelsFromATWhenShown=function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(t){t.labelBySeries&&t.labelBySeries.attr("aria-hidden",!0)})})},e.prototype.onChartRender=function(){this.chart.series.forEach(function(t){!1!==(t.options.accessibility&&t.options.accessibility.enabled)&&t.visible&&0!==t.data.length?l(t):c(t)})},e.prototype.getKeyboardNavigation=function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},e.prototype.destroy=function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()},e}(t)}),i(e,"Accessibility/Components/ZoomComponent.js",[e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Core/Utilities.js"]],function(t,e,i,n,o){var r,s=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),a=e.unhideChartElementFromAT,c=i.getFakeMouseEvent,l=o.attr,h=o.pick;return function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.focusedMapNavButtonIx=-1,e}return s(e,t),e.prototype.init=function(){var t=this,e=this.chart;this.proxyProvider.addGroup("zoom","div"),["afterShowResetZoom","afterApplyDrilldown","drillupall"].forEach(function(i){t.addEvent(e,i,function(){t.updateProxyOverlays()})})},e.prototype.onChartUpdate=function(){var t=this.chart,e=this;t.mapNavigation&&t.mapNavigation.navButtons.forEach(function(i,n){a(t,i.element),e.setMapNavButtonAttrs(i.element,"accessibility.zoom.mapZoom"+(n?"Out":"In"))})},e.prototype.setMapNavButtonAttrs=function(t,e){var i=this.chart;l(t,{tabindex:-1,role:"button","aria-label":i.langFormat(e,{chart:i})})},e.prototype.onChartRender=function(){this.updateProxyOverlays()},e.prototype.updateProxyOverlays=function(){var t=this.chart;if(this.proxyProvider.clearGroup("zoom"),t.resetZoomButton&&this.createZoomProxyButton(t.resetZoomButton,"resetZoomProxyButton",t.langFormat("accessibility.zoom.resetZoomButton",{chart:t})),t.drillUpButton&&t.breadcrumbs&&t.breadcrumbs.list){var e=t.breadcrumbs.list[t.breadcrumbs.list.length-1];this.createZoomProxyButton(t.drillUpButton,"drillUpProxyButton",t.langFormat("accessibility.drillUpButton",{chart:t,buttonText:t.breadcrumbs.getButtonText(e)}))}},e.prototype.createZoomProxyButton=function(t,e,i){this[e]=this.proxyProvider.addProxyElement("zoom",{click:t},"button",{"aria-label":i,tabindex:-1})},e.prototype.getMapZoomNavigation=function(){var t=this.keyCodes,e=this.chart,i=this;return new n(e,{keyCodeMap:[[[t.up,t.down,t.left,t.right],function(t){return i.onMapKbdArrow(this,t)}],[[t.tab],function(t,e){return i.onMapKbdTab(this,e)}],[[t.space,t.enter],function(){return i.onMapKbdClick(this)}]],validate:function(){return!!(e.mapView&&e.mapNavigation&&e.mapNavigation.navButtons.length)},init:function(t){return i.onMapNavInit(t)}})},e.prototype.onMapKbdArrow=function(t,e){var i=this.chart,n=this.keyCodes,o=i.container,r=e===n.up||e===n.down,s=e===n.left||e===n.up?1:-1,a=(r?i.plotHeight:i.plotWidth)/10*s,l=10*Math.random(),h={x:o.offsetLeft+i.plotLeft+i.plotWidth/2+l,y:o.offsetTop+i.plotTop+i.plotHeight/2+l},d=r?{x:h.x,y:h.y+a}:{x:h.x+a,y:h.y};return[c("mousedown",h),c("mousemove",d),c("mouseup",d)].forEach(function(t){return o.dispatchEvent(t)}),t.response.success},e.prototype.onMapKbdTab=function(t,e){var i=this.chart,n=t.response,o=e.shiftKey,r=o&&!this.focusedMapNavButtonIx||!o&&this.focusedMapNavButtonIx;if(i.mapNavigation.navButtons[this.focusedMapNavButtonIx].setState(0),r)return i.mapView&&i.mapView.zoomBy(),n[o?"prev":"next"];this.focusedMapNavButtonIx+=o?-1:1;var s=i.mapNavigation.navButtons[this.focusedMapNavButtonIx];return i.setFocusToElement(s.box,s.element),s.setState(2),n.success},e.prototype.onMapKbdClick=function(t){var e=this.chart.mapNavigation.navButtons[this.focusedMapNavButtonIx].element;return this.fakeClickEvent(e),t.response.success},e.prototype.onMapNavInit=function(t){var e=this.chart,i=e.mapNavigation.navButtons[0],n=e.mapNavigation.navButtons[1],o=t>0?i:n;e.setFocusToElement(o.box,o.element),o.setState(2),this.focusedMapNavButtonIx=t>0?0:1},e.prototype.simpleButtonNavigation=function(t,e,i){var o=this.keyCodes,r=this,s=this.chart;return new n(s,{keyCodeMap:[[[o.tab,o.up,o.down,o.left,o.right],function(t,e){var i=t===o.tab&&e.shiftKey||t===o.left||t===o.up;return this.response[i?"prev":"next"]}],[[o.space,o.enter],function(){return h(i(this,s),this.response.success)}]],validate:function(){return s[t]&&s[t].box&&r[e].innerElement},init:function(){s.setFocusToElement(s[t].box,r[e].innerElement)}})},e.prototype.getKeyboardNavigation=function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(t,e){e.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(t,e){return e.drillUp(),t.response.prev}),this.getMapZoomNavigation()]},e}(t)}),i(e,"Accessibility/HighContrastMode.js",[e["Core/Globals.js"]],function(t){var e=t.doc,i=t.isMS,n=t.win;return{isHighContrastModeActive:function(){var t=/(Edg)/.test(n.navigator.userAgent);if(n.matchMedia&&t)return n.matchMedia("(-ms-high-contrast: active)").matches;if(i&&n.getComputedStyle){var o=e.createElement("div");o.style.backgroundImage="url(".concat("data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",")"),e.body.appendChild(o);var r=(o.currentStyle||n.getComputedStyle(o)).backgroundImage;return e.body.removeChild(o),"none"===r}return n.matchMedia&&n.matchMedia("(forced-colors: active)").matches},setHighContrastTheme:function(t){t.highContrastModeActive=!0;var e,i=t.options.accessibility.highContrastTheme;t.update(i,!1);var n=(null===(e=i.colors)||void 0===e?void 0:e.length)>1;t.series.forEach(function(t){var e=i.plotOptions[t.type]||{},o=n&&void 0!==t.colorIndex?i.colors[t.colorIndex]:e.color||"window",r={color:e.color||"windowText",colors:n?i.colors:[e.color||"windowText"],borderColor:e.borderColor||"window",fillColor:o};t.update(r,!1),t.points&&t.points.forEach(function(t){t.options&&t.options.color&&t.update({color:e.color||"windowText",borderColor:e.borderColor||"window"},!1)})}),t.redraw()}}}),i(e,"Accessibility/HighContrastTheme.js",[],function(){return{chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[],dataClasses:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}}}),i(e,"Accessibility/Options/A11yDefaults.js",[],function(){return{accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{descriptionFormat:"{seriesDescription}{authorDescription}{axisDescription}",describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{xDescription}{separator}{value}.",describeNull:!0},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',highContrastMode:"auto",keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:"#334eff",lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","navigator","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1,rememberPointFocus:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}},navigator:{accessibility:{enabled:!0}}}}),i(e,"Accessibility/Options/LangDefaults.js",[],function(){return{accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{#each additionalAnnotationPoints}, also related to {this}{/each}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},navigator:{handleLabel:"{#eq handleIx 0}Start, percent{else}End, percent{/eq}",groupLabel:"Axis zoom",changeAnnouncement:"{axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#eq numPoints 1}point{else}points{/eq}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#eq numPoints 1}point{else}points{/eq}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#eq numPoints 1}point{else}points{/eq}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#eq numPoints 1}bar{else}bars{/eq}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#eq numPoints 1}bar{else}bars{/eq}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#eq numPoints 1}slice{else}slices{/eq}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#eq numPoints 1}point{else}points{/eq}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#eq numPoints 1}box{else}boxes{/eq}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#eq numPoints 1}bubbles{else}bubble{/eq}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each names}{#unless @first},{/unless}{#if @last} and{/if} {this}{/each}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each names}{#unless @first},{/unless}{#if @last} and{/if} {this}{/each}.",timeRangeDays:"Data range: {range} days.",timeRangeHours:"Data range: {range} hours.",timeRangeMinutes:"Data range: {range} minutes.",timeRangeSeconds:"Data range: {range} seconds.",rangeFromTo:"Data ranges from {rangeFrom} to {rangeTo}.",rangeCategories:"Data range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu, {chartTitle}"},series:{summary:{default:"{series.name}, series {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",defaultCombination:"{series.name}, series {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",line:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",lineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",spline:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",splineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",column:"{series.name}, bar series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",columnCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bar series with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",bar:"{series.name}, bar series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",barCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bar series with {series.points.length} {#eq series.points.length 1}bar{else}bars{/eq}.",pie:"{series.name}, pie {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}slice{else}slices{/eq}.",pieCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Pie with {series.points.length} {#eq series.points.length 1}slice{else}slices{/eq}.",scatter:"{series.name}, scatter plot {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}point{else}points{/eq}.",scatterCombination:"{series.name}, series {seriesNumber} of {chart.series.length}, scatter plot with {series.points.length} {#eq series.points.length 1}point{else}points{/eq}.",boxplot:"{series.name}, boxplot {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}box{else}boxes{/eq}.",boxplotCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Boxplot with {series.points.length} {#eq series.points.length 1}box{else}boxes{/eq}.",bubble:"{series.name}, bubble series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}.",bubbleCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bubble series with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}.",map:"{series.name}, map {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}area{else}areas{/eq}.",mapCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Map with {series.points.length} {#eq series.points.length 1}area{else}areas{/eq}.",mapline:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",maplineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#eq series.points.length 1}point{else}points{/eq}.",mapbubble:"{series.name}, bubble series {seriesNumber} of {chart.series.length} with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}.",mapbubbleCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bubble series with {series.points.length} {#eq series.points.length 1}bubble{else}bubbles{/eq}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{#each annotations}Annotation: {this}{/each}"}}}}),i(e,"Accessibility/Options/DeprecatedOptions.js",[e["Core/Utilities.js"]],function(t){var e=t.error,i=t.pick;function n(t,e,n){for(var o,r=t,s=0;s<e.length-1;++s)r=r[o=e[s]]=i(r[o],{});r[e[e.length-1]]=n}function o(t,i,o,r){function s(t,e){return e.reduce(function(t,e){return t[e]},t)}var a=s(t.options,i),c=s(t.options,o);Object.keys(r).forEach(function(s){var l,h=a[s];void 0!==h&&(n(c,r[s],h),e(32,!1,t,((l={})[i.join(".")+"."+s]=o.join(".")+"."+r[s].join("."),l)))})}return function(t){var i,r;i=t.options.chart,r=t.options.accessibility||{},["description","typeDescription"].forEach(function(n){var o;i[n]&&(r[n]=i[n],e(32,!1,t,((o={})["chart.".concat(n)]="use accessibility.".concat(n),o)))}),function(t){t.axes.forEach(function(i){var n=i.options;n&&n.description&&(n.accessibility=n.accessibility||{},n.accessibility.description=n.description,e(32,!1,t,{"axis.description":"use axis.accessibility.description"}))})}(t),t.series&&function(t){var i={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","point","descriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"],"accessibility.pointDescriptionFormatter":["accessibility","point","descriptionFormatter"]};t.series.forEach(function(o){Object.keys(i).forEach(function(r){var s,a=o.options[r];"accessibility.pointDescriptionFormatter"===r&&(a=o.options.accessibility&&o.options.accessibility.pointDescriptionFormatter),void 0!==a&&(n(o.options,i[r],"skipKeyboardNavigation"===r?!a:a),e(32,!1,t,((s={})["series.".concat(r)]="series."+i[r].join("."),s)))})})}(t),o(t,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]}),o(t,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]}),o(t,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}}),i(e,"Accessibility/Accessibility.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/A11yI18n.js"],e["Accessibility/Components/ContainerComponent.js"],e["Accessibility/FocusBorder.js"],e["Accessibility/Components/InfoRegionsComponent.js"],e["Accessibility/KeyboardNavigation.js"],e["Accessibility/Components/LegendComponent.js"],e["Accessibility/Components/MenuComponent.js"],e["Accessibility/Components/NavigatorComponent.js"],e["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],e["Accessibility/ProxyProvider.js"],e["Accessibility/Components/RangeSelectorComponent.js"],e["Accessibility/Components/SeriesComponent/SeriesComponent.js"],e["Accessibility/Components/ZoomComponent.js"],e["Accessibility/HighContrastMode.js"],e["Accessibility/HighContrastTheme.js"],e["Accessibility/Options/A11yDefaults.js"],e["Accessibility/Options/LangDefaults.js"],e["Accessibility/Options/DeprecatedOptions.js"]],function(t,e,i,n,o,r,s,a,c,l,h,d,u,p,g,m,f,v,y,b,x,A){var C=t.defaultOptions,w=e.doc,E=i.addEvent,T=i.extend,M=i.fireEvent,S=i.merge,k=n.removeElement,P=function(){function t(t){this.init(t)}return t.prototype.init=function(t){if(this.chart=t,!w.addEventListener){this.zombie=!0,this.components={},t.renderTo.setAttribute("aria-hidden",!0);return}A(t),this.proxyProvider=new p(this.chart),this.initComponents(),this.keyboardNavigation=new c(t,this.components)},t.prototype.initComponents=function(){var t=this.chart,e=this.proxyProvider,i=t.options.accessibility;this.components={container:new r,infoRegions:new a,legend:new l,chartMenu:new h,rangeSelector:new g,series:new m,zoom:new f,navigator:new d},i.customComponents&&T(this.components,i.customComponents);var n=this.components;this.getComponentOrder().forEach(function(i){n[i].initBase(t,e),n[i].init()})},t.prototype.getComponentOrder=function(){return this.components?this.components.series?["series"].concat(Object.keys(this.components).filter(function(t){return"series"!==t})):Object.keys(this.components):[]},t.prototype.update=function(){var t=this.components,e=this.chart,i=e.options.accessibility;M(e,"beforeA11yUpdate"),e.types=this.getChartTypes();var n=i.keyboardNavigation.order;this.proxyProvider.updateGroupOrder(n),this.getComponentOrder().forEach(function(i){t[i].onChartUpdate(),M(e,"afterA11yComponentUpdate",{name:i,component:t[i]})}),this.keyboardNavigation.update(n),!e.highContrastModeActive&&!1!==i.highContrastMode&&(v.isHighContrastModeActive()||!0===i.highContrastMode)&&v.setHighContrastTheme(e),M(e,"afterA11yUpdate",{accessibility:this})},t.prototype.destroy=function(){var t=this.chart||{},e=this.components;Object.keys(e).forEach(function(t){e[t].destroy(),e[t].destroyBase()}),this.proxyProvider&&this.proxyProvider.destroy(),t.announcerContainer&&k(t.announcerContainer),this.keyboardNavigation&&this.keyboardNavigation.destroy(),t.renderTo&&t.renderTo.setAttribute("aria-hidden",!0),t.focusElement&&t.focusElement.removeFocusBorder()},t.prototype.getChartTypes=function(){var t={};return this.chart.series.forEach(function(e){t[e.type]=1}),Object.keys(t)},t}();return function(t){function e(){this.accessibility&&this.accessibility.destroy()}function i(){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var t=this.accessibility;t&&!t.zombie&&(t.proxyProvider.updateProxyElementPositions(),t.getComponentOrder().forEach(function(e){t.components[e].onChartRender()}))}function n(t){var e=t.options.accessibility;e&&(e.customComponents&&(this.options.accessibility.customComponents=e.customComponents,delete e.customComponents),S(!0,this.options.accessibility,e),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0}function r(){var e=this.accessibility,i=this.options.accessibility;i&&i.enabled?e&&!e.zombie?e.update():(this.accessibility=e=new t(this),e&&!e.zombie&&e.update()):e?(e.destroy&&e.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)}function a(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)}t.i18nFormat=o.i18nFormat,t.compose=function(t,d,p,f,v,y){c.compose(t),u.compose(f),l.compose(t,d),h.compose(t),m.compose(t,p,f),o.compose(t),s.compose(t,v),y&&g.compose(t,y);var b=t.prototype;b.updateA11yEnabled||(b.updateA11yEnabled=r,E(t,"destroy",e),E(t,"render",i),E(t,"update",n),["addSeries","init"].forEach(function(e){E(t,e,function(){this.a11yDirty=!0})}),["afterApplyDrilldown","drillupall"].forEach(function(e){E(t,e,function(){var t=this.accessibility;t&&!t.zombie&&t.update()})}),E(p,"update",a),["update","updatedData","remove"].forEach(function(t){E(f,t,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})}))}}(P||(P={})),S(!0,C,b,{accessibility:{highContrastTheme:y},lang:x}),P}),i(e,"masters/modules/accessibility.src.js",[e["Core/Globals.js"],e["Accessibility/Accessibility.js"],e["Accessibility/AccessibilityComponent.js"],e["Accessibility/Utils/ChartUtilities.js"],e["Accessibility/Utils/HTMLUtilities.js"],e["Accessibility/KeyboardNavigationHandler.js"],e["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(t,e,i,n,o,r,s){return t.i18nFormat=e.i18nFormat,t.A11yChartUtilities=n,t.A11yHTMLUtilities=o,t.AccessibilityComponent=i,t.KeyboardNavigationHandler=r,t.SeriesAccessibilityDescriber=s,e.compose(t.Chart,t.Legend,t.Point,t.Series,t.SVGElement,t.RangeSelector),t})});