<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/formation", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    // print_r(validation_list_errors());

                    // echo "<pre>";
                    // print_r($formation);
                    // echo "</pre>";
                    ?>
                </div>

                <?php echo form_open_multipart($locale . $route, NULL, ['id' => (string)$formation->id]); ?>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <?= form_label("Intitule de la formation", 'intituleFormation'); ?>
                        <?php
                        $intituleFormation = [
                            'type'  => 'text',
                            'name'  => 'intituleFormation',
                            'id'    => 'intituleFormation',
                            'value' => set_value('intituleFormation', $formation->intituleFormation),
                            'placeholder' => "Intitule de la formation",
                            'class' => 'form-control',
                        ];

                        echo form_input($intituleFormation);
                        ?>
                        <?= !empty(validation_show_error('intituleFormation')) ? "<p class='text-danger'>" . validation_show_error('intituleFormation') . "</p>" : "" ?>
                    </div>
                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $formation->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $formation->communeId,
                    ];

                    echo form_input($cm);

                    $zn = [
                        'type'  => 'hidden',
                        'name'  => 'zone_id_load',
                        'id'    => 'zone_id_load',
                        'value' => $formation->zoneId,
                    ];

                    echo form_input($zn);

                    $cl = [
                        'type'  => 'hidden',
                        'name'  => 'colline_id_load',
                        'id'    => 'colline_id_load',
                        'value' => $formation->collineId,
                    ];

                    echo form_input($cl);
                    ?>

                    <div class="col-md-4">
                        <?= form_label("Province"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $formation->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $formation->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Zone/CPEV"); ?>
                        <?php
                        echo form_dropdown('zoneId', [], set_value('zoneId', $formation->zoneId), "class = 'form-control' id='zoneId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Colline"); ?>
                        <?php
                        echo form_dropdown('collineId', [], set_value('collineId', $formation->collineId), "class = 'form-control' id='collineId'");
                        ?>
                    </div>
                    <div class="col-md-4">
                    <?= form_label("Lieu de la formation"); ?>

                        <?php
                        $lieuFormation = [
                            'type'  => 'text',
                            'name'  => 'lieuFormation',
                            'id'    => 'lieuFormation',
                            'value' => set_value('lieuFormation', $formation->lieuFormation),
                            'placeholder' => "Lieu de la formation",
                            'class' => 'form-control',
                        ];

                        echo form_input($lieuFormation);
                        ?>
                        <?= !empty(validation_show_error('lieuFormation')) ? "<p class='text-danger'>" . validation_show_error('lieuFormation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Type de formation"); ?>
                        <?php
                        echo form_dropdown('typeFormationId', $typeFormations, set_value('typeFormationId', $formation->typeFormationId), "class = 'form-control' id='typeFormationId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre de participant homme"); ?>

                        <?php
                        $nbParticipantHomme = [
                            'type'  => 'text',
                            'name'  => 'nbParticipantHomme',
                            'id'    => 'nbParticipantHomme',
                            'value' => set_value('nbParticipantHomme', $formation->nbParticipantHomme),
                            'placeholder' => "Nombre de participant homme",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbParticipantHomme);
                        ?>
                        <?= !empty(validation_show_error('nbParticipantHomme')) ? "<p class='text-danger'>" . validation_show_error('nbParticipantHomme') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre de participant femme"); ?>

                        <?php
                        $nbParticipantFemme = [
                            'type'  => 'text',
                            'name'  => 'nbParticipantFemme',
                            'id'    => 'nbParticipantFemme',
                            'value' => set_value('nbParticipantFemme', $formation->nbParticipantFemme),
                            'placeholder' => "Nombre de participant femme",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbParticipantFemme);
                        ?>
                        <?= !empty(validation_show_error('nbParticipantFemme')) ? "<p class='text-danger'>" . validation_show_error('nbParticipantFemme') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Est une formation certifiante ?"); ?>
                        <?php
                        echo form_dropdown('certifiant', $certifiants, set_value('certifiant', $formation->certifiant), "class = 'form-control' id='certifiant'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Date de debut <font color='red'>*</font>"); ?>
                        <?php $date = $formation->dateDebut ? $formation->dateDebut : set_value('dateDebut') ?>
                        <div class="input-group date" id="dateDebut" data-target-input="nearest">
                            <?= form_input('dateDebut', $date, "class='form-control datetimepicker-input', id='dateDebut' placeholder='Date debut'") ?>
                            <div class="input-group-append" data-target="#dateDebut" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateDebut')) ? "<p class='text-danger'>" . validation_show_error('dateDebut') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-4">
                        <?= form_label("Date fin <font color='red'>*</font>"); ?>
                        <?php $date = $formation->dateFin ? $formation->dateFin : set_value('dateFin') ?>
                        <div class="input-group date" id="dateFin" data-target-input="nearest">
                            <?= form_input('dateFin', $date, "class='form-control datetimepicker-input', id='dateFin' placeholder='Date fin'") ?>
                            <div class="input-group-append" data-target="#dateFin" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateFin')) ? "<p class='text-danger'>" . validation_show_error('dateFin') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre d'heure"); ?>

                        <?php
                        $nbHeureDuree = [
                            'type'  => 'text',
                            'name'  => 'nbHeureDuree',
                            'id'    => 'nbHeureDuree',
                            'value' => set_value('nbHeureDuree', $formation->nbHeureDuree),
                            'placeholder' => "Nombre d'heure",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbHeureDuree);
                        ?>
                        <?= !empty(validation_show_error('nbHeureDuree')) ? "<p class='text-danger'>" . validation_show_error('nbHeureDuree') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Commentaire"); ?>

                        <?php
                        $commentaire = [
                            'type'  => 'text',
                            'name'  => 'commentaire',
                            'id'    => 'commentaire',
                            'value' => set_value('commentaire', $formation->commentaire),
                            'placeholder' => "Commentaire",
                            'class' => 'form-control',
                        ];

                        echo form_input($commentaire);
                        ?>
                        <?= !empty(validation_show_error('commentaire')) ? "<p class='text-danger'>" . validation_show_error('commentaire') . "</p>" : "" ?>
                    </div>


                    <div class="col-md-4 mb-3">
                        <?= form_label("Fichier"); ?>
                        <?php

                        $pathFile = [
                            'type'  => 'file',
                            'name'  => 'pathFile',
                            'id'    => 'pathFile',
                            'class' => 'form-control',
                        ];

                        echo form_upload($pathFile);
                        if(!empty($formation->pathFile)){
                           echo anchor(base_url()."files/formation/".$formation->pathFile, $formation->pathFile, "target='_blank'");
                        }
                        ?>                        
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>