<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/data/vulnerable", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }

                    ?>
                </div>

                <?php echo form_open_multipart($locale . $route, NULL, ['id' => (string)$vulnerable->id]); ?>
                <div class="row mb-3">

                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $vulnerable->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $vulnerable->communeId,
                    ];

                    echo form_input($cm);

                    $zn = [
                        'type'  => 'hidden',
                        'name'  => 'zone_id_load',
                        'id'    => 'zone_id_load',
                        'value' => $vulnerable->zoneId,
                    ];

                    echo form_input($zn);

                    $cl = [
                        'type'  => 'hidden',
                        'name'  => 'colline_id_load',
                        'id'    => 'colline_id_load',
                        'value' => $vulnerable->collineId,
                    ];

                    echo form_input($cl);
                    ?>

                    <div class="col-md-4">
                        <?= form_label("Province <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $vulnerable->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Branche <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $vulnerable->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Zone/CPEV <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('zoneId', [], set_value('zoneId', $vulnerable->zoneId), "class = 'form-control' id='zoneId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Colline <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('collineId', [], set_value('collineId', $vulnerable->collineId), "class = 'form-control' id='collineId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Categorie d’assistance <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('categorieAssistanceId', $categorieAssistances, set_value('categorieAssistanceId', $vulnerable->categorieAssistanceId), "class = 'form-control' id='categorieAssistanceId'");
                        ?>
                        <?= !empty(validation_show_error('categorieAssistanceId')) ? "<p class='text-danger'>" . validation_show_error('categorieAssistanceId') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nom et Prénom du chef de ménage <font color='red'>*</font>"); ?>

                        <?php
                        $nomPrenomChefMenage = [
                            'type'  => 'text',
                            'name'  => 'nomPrenomChefMenage',
                            'id'    => 'nomPrenomChefMenage',
                            'value' => set_value('nomPrenomChefMenage', $vulnerable->nomPrenomChefMenage),
                            'placeholder' => "Nom et Prénom du chef de ménage",
                            'class' => 'form-control',
                        ];

                        echo form_input($nomPrenomChefMenage);
                        ?>
                        <?= !empty(validation_show_error('nomPrenomChefMenage')) ? "<p class='text-danger'>" . validation_show_error('nomPrenomChefMenage') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Age"); ?>

                        <?php
                        $age = [
                            'type'  => 'text',
                            'name'  => 'age',
                            'id'    => 'age',
                            'value' => set_value('age', $vulnerable->age),
                            'placeholder' => "Age",
                            'class' => 'form-control',
                        ];

                        echo form_input($age);
                        ?>
                        <?= !empty(validation_show_error('age')) ? "<p class='text-danger'>" . validation_show_error('age') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Taille du ménage <font color='red'>*</font>"); ?>

                        <?php
                        $tailleMenage = [
                            'type'  => 'text',
                            'name'  => 'tailleMenage',
                            'id'    => 'tailleMenage',
                            'value' => set_value('tailleMenage', $vulnerable->tailleMenage),
                            'placeholder' => "Taille du ménage",
                            'class' => 'form-control',
                        ];

                        echo form_input($tailleMenage);
                        ?>
                        <?= !empty(validation_show_error('tailleMenage')) ? "<p class='text-danger'>" . validation_show_error('tailleMenage') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Coût estimatif de l'assistance"); ?>

                        <?php
                        $coutEstimatifAssistance = [
                            'type'  => 'text',
                            'name'  => 'coutEstimatifAssistance',
                            'id'    => 'coutEstimatifAssistance',
                            'value' => set_value('coutEstimatifAssistance', $vulnerable->coutEstimatifAssistance),
                            'placeholder' => "Coût estimatif de l'assistance",
                            'class' => 'form-control',
                        ];

                        echo form_input($coutEstimatifAssistance);
                        ?>
                        <?= !empty(validation_show_error('coutEstimatifAssistance')) ? "<p class='text-danger'>" . validation_show_error('coutEstimatifAssistance') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Type de Vulnérabilité <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('typeVulnerabiliteId', $vulnerabilites, set_value('typeVulnerabiliteId', $vulnerable->typeVulnerabiliteId), "class = 'form-control' id='typeVulnerabiliteId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Type d'assistance <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('typeAssistanceId', $assistances, set_value('typeAssistanceId', $vulnerable->typeAssistanceId), "class = 'form-control' id='typeAssistanceId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre de personnes assistées (H) <font color='red'>*</font>"); ?>

                        <?php
                        $nbPersonneAssisteH = [
                            'type'  => 'text',
                            'name'  => 'nbPersonneAssisteH',
                            'id'    => 'nbPersonneAssisteH',
                            'value' => set_value('nbPersonneAssisteH', $vulnerable->nbPersonneAssisteH),
                            'placeholder' => "Nombre de personnes assistées (H)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbPersonneAssisteH);
                        ?>
                        <?= !empty(validation_show_error('nbPersonneAssisteH')) ? "<p class='text-danger'>" . validation_show_error('nbPersonneAssisteH') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre de personnes Assistées (F) <font color='red'>*</font>"); ?>

                        <?php
                        $nbPersonneAssisteF = [
                            'type'  => 'text',
                            'name'  => 'nbPersonneAssisteF',
                            'id'    => 'nbPersonneAssisteF',
                            'value' => set_value('nbPersonneAssisteF', $vulnerable->nbPersonneAssisteF),
                            'placeholder' => "Nombre de personnes Assistées (F)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbPersonneAssisteF);
                        ?>
                        <?= !empty(validation_show_error('nbPersonneAssisteF')) ? "<p class='text-danger'>" . validation_show_error('nbPersonneAssisteF') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Date d'assistance <font color='red'>*</font>"); ?>
                        <?php $date = $vulnerable->dateAssistance ? $vulnerable->dateAssistance : set_value('dateAssistance') ?>
                        <div class="input-group date" id="dateAssistance" data-target-input="nearest">
                            <?= form_input('dateAssistance', $date, "class='form-control datetimepicker-input', id='dateAssistance' placeholder='Date assistance'") ?>
                            <div class="input-group-append" data-target="#dateAssistance" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateAssistance')) ? "<p class='text-danger'>" . validation_show_error('dateAssistance') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4 mb-3">
                        <?= form_label("Fichier"); ?>
                        <?php

                        $pathFile = [
                            'type'  => 'file',
                            'name'  => 'pathFile',
                            'id'    => 'pathFile',
                            'class' => 'form-control',
                        ];

                        echo form_upload($pathFile);
                        if (!empty($vulnerable->pathFile)) {
                            echo anchor(base_url() . "files/vulnerable/" . $vulnerable->pathFile, $vulnerable->pathFile, "target='_blank'");
                        }
                        ?>
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>