<?php

namespace Modules\Formation\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Formation\Models\MenageModeleModel;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\TypeFormationModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

use function PHPUnit\Framework\fileExists;

class MenageModeleController extends BaseController
{
    protected MenageModeleModel $menageModeleModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->menageModeleModel = new MenageModeleModel();
    }
    public function index()
    {
        $this->viewData['url_list'] = "/menageModele/data";
        $this->viewData['js'] = "Common.js";
        $this->viewData['title'] = "Liste des menages modeles";
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());

        return view('menageModele/index', $this->viewData);
    }
    public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['route'] = "/menageModele/save";
        $this->viewData['menageModele'] =  $this->initMenageModele($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['years'] = CommonTrait::getYears();

        if ($id > 0)
            $title = "Editer un menage modele";
        else
            $title = "Nouveau menage modele";

        $this->viewData['title'] = $title;

        return view('menageModele/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/menageModele/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/menageModele/save";
            $this->viewData['menageModele'] =  $this->initMenageModele($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['years'] = CommonTrait::getYears();

            if ($id > 0)
                $title = "Editer un menage modele";
            else
                $title = "Nouveau menage modele";

            $this->viewData['title'] = $title;


            return view('menageModele/add', $this->viewData);
        } else {

            $uneMenageModele = $this->uneMenageModele();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le menage modele a été modifiée</div>");
                $stmt = $this->menageModeleModel->update($id, $uneMenageModele);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le menage modele a été bien enregistrée</div>");
                $stmt = $this->menageModeleModel->save($uneMenageModele);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/menageModele'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->menageModeleModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un menage modele a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/formation'));
        }
    }

    private function uneMenageModele()
    {
        $menageModele = [];
        $menageModele['brancheId'] = $this->request->getPost('brancheId');
        $menageModele['communeId'] = $this->request->getPost('communeId');
        $menageModele['zoneId'] = $this->request->getPost('zoneId');
        $menageModele['collineId'] = $this->request->getPost('collineId');
        $menageModele['nbMenageEnTransformation'] = $this->request->getPost('nbMenageEnTransformation');
        $menageModele['nbMenageACertifier'] = $this->request->getPost('nbMenageACertifier');
        $menageModele['nbMenageDejaCertifier'] = $this->request->getPost('nbMenageDejaCertifier');
        $menageModele['commentaire'] = $this->request->getPost('commentaire');
        $menageModele['anneeCertification'] = $this->request->getPost('anneeCertification');
        $menageModele['userId'] = \auth()->user()->id;

        return $menageModele;
    }

    private function initMenageModele($id = NULL)
    {
        $menageModele = NULL;
        if ($id) {
            $menageModele = $this->menageModeleModel->find($id);
        } else {
            $menageModele = new stdClass();
            $menageModele->id = 0;
            $menageModele->brancheId = NULL;
            $menageModele->communeId = NULL;
            $menageModele->zoneId = NULL;
            $menageModele->collineId = NULL;
            $menageModele->nbMenageEnTransformation = '';
            $menageModele->nbMenageACertifier = NULL;
            $menageModele->nbMenageDejaCertifier = 0;
            $menageModele->commentaire = "";
            $menageModele->anneeCertification = "";
        }

        return $menageModele;
    }

    private function _rules()
    {
        $rules = [];
        $rules['brancheId'] = ['rules'  => 'required'];
        $rules['communeId'] = ['rules'  => 'required'];
        $rules['zoneId'] = ['rules'  => 'required'];
        $rules['collineId'] = ['rules'  => 'required'];
        $rules['nbMenageEnTransformation'] = ['rules'  => 'required|is_natural'];
        $rules['nbMenageACertifier'] = ['rules'  => 'required|is_natural'];
        $rules['nbMenageDejaCertifier'] = ['rules'  => 'required'];
        $rules['commentaire'] = ['rules'  => 'required'];

        return $rules;
    }

    function fecth()
    {
        $search_column = ['intituleFormation', 'brancheId', 'communeId', 'zoneId', 'collineId', 'lieuFormation', 'typeFormationId', 'nbParticipantHomme', 'nbParticipantFemme', 'certifiant', 'dateDebut', 'dateFin', 'nbHeureDuree', 'commentaire'];
        $order_column = ['intituleFormation', 'brancheId', 'communeId', 'zoneId', 'collineId', 'lieuFormation', 'typeFormationId', 'nbParticipantHomme', 'nbParticipantFemme', 'certifiant', 'dateDebut', 'dateFin', 'nbHeureDuree', 'commentaire'];

        $menageModeleMdl = $this->menageModeleModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $menageModeleMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $menageModeleMdl->where('communeId', \auth()->user()->communeId);
        }

        if ($this->request->getPost('brancheId') > 0) {
            $menageModeleMdl->where('brancheId', $this->request->getPost('brancheId'));
        }

        $fetch_data = DatatableQuery::build_query($menageModeleMdl, $search_column, $order_column);
        $output = $this->formatMenageModele($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatMenageModele($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  $data->nbMenageEnTransformation;
                $sub_array[] =  $data->nbMenageACertifier;
                $sub_array[] =  $data->nbMenageDejaCertifier;

                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/menageModele/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/menageModele/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
    function export()
    {
        $uri = current_url(true);
        $brancheId = $uri->getSegment(4);

        if ($brancheId > 0) {
            $branche = CommonTrait::formatData(new BrancheModel(), $brancheId);
        } else {
            $branche = "Toutes les branches";
        }

        $fileName = str_replace(' ', '', $branche);
        $csv_file_name = "rapportExport/menages/menages_" . $fileName . ".csv";
        $file = fopen($csv_file_name, 'w');

        $arrays = [];
        $arrays[0] = ['', $this->formatText("Les ménages modèles ")];
        $arrays[1] = ['', $this->formatText($branche)];
        $arrays[2] = [];
        $arrays[3] = [
            '#',
            $this->formatText('Branche'),
            $this->formatText('Commune'),
            $this->formatText('Ménages en cours de transformation'),
            $this->formatText('Ménages prêts pour la certification'),
            $this->formatText('Ménages modèles déjà certifiés'),
            $this->formatText('Commentaire'),
            $this->formatText('Année de certification')
        ];

        if ($brancheId > 0) {
            $menages = $this->menageModeleModel->where('brancheId', $brancheId)->findAll();
        } else {
            $menages = $this->menageModeleModel->findAll();
        }

        $i = 1;
        foreach ($menages as $menage) {
            $sub_array = [];
            $sub_array[] = $i;
            $sub_array[] =  $this->formatText($menage->brancheId > 0?CommonTrait::formatData(new BrancheModel(), $menage->brancheId):"");
            $sub_array[] =  $this->formatText($menage->communeId > 0?CommonTrait::formatData(new CommuneModel(), $menage->communeId):"");
            $sub_array[] =  $menage->nbMenageEnTransformation;
            $sub_array[] =  $menage->nbMenageACertifier;
            $sub_array[] =  $menage->nbMenageDejaCertifier;
            $sub_array[] =  $menage->commentaire;
            $sub_array[] =  $menage->anneeCertification;

            $arrays[] = $sub_array;
            $i++;
        }


        foreach ($arrays as $array) {
            fputcsv($file, $array,";");
        }
        fclose($file);
        $btn = anchor($csv_file_name, "Exporter un <i class='fa fa-file-csv'></i>", ['class' => 'text-success', 'target' => '_blank']);

        $status = 0;
        if (fileExists($csv_file_name)) {
            $status = 1;
        }

        return $this->response->setJSON(['status' => $status, 'btnExport' => $btn]);
    }

    function formatText($string = "")
    {
        return UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
    }
}
