<?php

namespace Config;

use App\Models\Pays;
use CodeIgniter\Events\Events;
use CodeIgniter\Exceptions\FrameworkException;
use CodeIgniter\HotReloader\HotReloader;
use Modules\Poste\Models\Poste;
use Modules\Volontaire\Models\Volontaire;

/*
 * --------------------------------------------------------------------
 * Application Events
 * --------------------------------------------------------------------
 * Events allow you to tap into the execution of the program without
 * modifying or extending core files. This file provides a central
 * location to define your events, though they can always be added
 * at run-time, also, if needed.
 *
 * You create code that can execute by subscribing to events with
 * the 'on()' method. This accepts any form of callable, including
 * Closures, that will be executed when the event is triggered.
 *
 * Example:
 *      Events::on('create', [$myInstance, 'myMethod']);
 */

Events::on('pre_system', static function () {
    if (ENVIRONMENT !== 'testing') {
        if (ini_get('zlib.output_compression')) {
            throw FrameworkException::forEnabledZlibOutputCompression();
        }

        while (ob_get_level() > 0) {
            ob_end_flush();
        }

        ob_start(static fn($buffer) => $buffer);
    }

    /*
     * --------------------------------------------------------------------
     * Debug Toolbar Listeners.
     * --------------------------------------------------------------------
     * If you delete, they will no longer be collected.
     */
    if (CI_DEBUG && ! is_cli()) {
        Events::on('DBQuery', 'CodeIgniter\Debug\Toolbar\Collectors\Database::collect');
        Services::toolbar()->respond();
        // Hot Reload route - for framework use on the hot reloader.
        if (ENVIRONMENT === 'development') {
            Services::routes()->get('__hot-reload', static function () {
                (new HotReloader())->run();
            });
        }
    }
});

//Send notification
Events::on('sendEmail', function ($posteId) {
    // $poste = (new Poste())->find($posteId);
    $pays = (new Pays())->find($poste->pays_id);
    $volontaires = (new Volontaire())->get()->getResult();

    $to = [];
    foreach ($volontaires as $volontaire) {
        if ($volontaire->email) {
            $to[] = $volontaire->email;
        }
    }

    $subject = "Postuler : Nouveau poste";
    $message = "Bonjour <br> <b>IFRC - Bureau cluster KINSHASA-RDC</b>, souhaite porter à votre connaissance qu'il vient de publier un nouveau poste.<br>
        <b>Poste</b>:" . $poste->nom . "<br> 
        <b>Durée du poste</b>: " . $poste->dateDebut . " au " . $poste->dateFin . "<br> 
        <b>Candidature ouverte jusqu'au </b>:" . $poste->dateFin_publication . "<br> 
        <b>Place(s)</b>:" . $poste->nbPlace . "<br> 
        <b>Localité</b>:" . $pays->description . " " . $poste->ville . "<br> 
        <b>Description</b>:" . $poste->description . "<br> 
        <a class='btn btn-secondary' href='".base_url()."'> Connectez-vous pour postuler</a>
        <br> Cordialement !";

    $email = \Config\Services::email();
    $email->setTo($to);
    $email->setSubject($subject);
    $email->setMessage($message);

    if ($email->send()) {
        echo "Message sent";
    }
});
