<?php

namespace Modules\data\Database\Migrations;

use CodeIgniter\Database\Migration;

class VulnerableMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'zoneId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'collineId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nomPrenomChefMenage' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'age' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'tailleMenage' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'coutEstimatifAssistance' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'typeVulnerabiliteId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'typeAssistanceId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbPersonneAssisteH' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbPersonneAssisteF' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'dateAssistance' => [
                'type' => 'DATE',
                'default'    => NULL
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('dt_vulnerable');
    }

    public function down()
    {
        $this->forge->dropTable('dt_vulnerable');
    }
}
