<?php
// Initialisation des variables de session
  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];

  //Verfication si l'utilisateur est authentifié
  if($user_id < 1){
    // Si non on fait une redirection sur la page d'authefication
    header('Location: ./index.php');
  }

  //Connection a la base de donnees
  $mysqli = new mysqli("localhost","root","","crb_care");


  //Recuperation de toute les periodes ou nous avons des donnees
  $sql = "SELECT DISTINCT(pr.periode) AS periode FROM partenaires as pr JOIN indicateurs as ind ON ind.partenaire_id = pr.partenaire_id";
  $results = $mysqli->query($sql);

  //Recuperation de tous les partenaires
  $sql_partenaire = "SELECT * FROM partenaires";
  $result_partenaire = $mysqli->query($sql_partenaire);
  $mysqli -> close();

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de partenaire - Synthèse des indicateurs</title>
	<link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>
</head>
<body>
  <?php
    include('sous_menu_projet.php');
    ?>
	<div class="container">
   	  <div class="row">
   	  	<legend>
   	  		Rapport de synthèse

   	  	    <div class="pull-right">
	   	  		  <a href="./indicateur_liste.php" class='btn btn-primary btn-sm'>Liste</a>
	   	  	</div>
	   	</legend>
   	  </div>

      <div class="row" style="margin-bottom: 20px">
        <!-- Filtres -->
        <!-- Filtre des partenaires -->
        <div class="col-md-4">
          <label>partenaire</label>
          <?php
            $partenaires = $result_partenaire->fetch_all(MYSQLI_ASSOC);
          ?>
          <select class="form-control" id="partenaire_id" name="partenaire_id">
            <option value="0"> - Sélectionner - </option>
            <?php
             foreach ($partenaires as $partenaire) {
              ?>
               <option value="<?=$partenaire['partenaire_id']?>"><?=$partenaire['partenaire_name']." (".$partenaire['partenaire_code'].")"?></option>
              <?php
             }
            ?>
          </select>
        </div>

        <!-- Filtre des periodes -->
        <div class="col-md-4">
          <label>Période</label>
          <?php
            $results = $results->fetch_all(MYSQLI_ASSOC);
          ?>
          <select class="form-control" id="periode" name="periode">
            <option value="0"> - Sélectionner - </option>
            <?php
             foreach ($results as $result) {
              ?>
               <option value="<?=$result['periode']?>"><?=$result['periode']?></option>
              <?php
             }
            ?>
          </select>
        </div>

      </div>

      <!-- Champ d'affichage des indicateurs -->
      <div id="indicateurs"></div>

      <!-- Champ d'affichage des messages apres operations-->
   	  <div id="message"></div>

   	</div>
    <?php
     include('footer.php');
     ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){

    //Chargement de tous les indicateurs
    $.ajax({
            url: './model/model_indicateur_synthese.php',
            type: 'POST',
            dataType: 'JSON',
            success:function(data){
              $("#indicateurs").html(data.indicateurs);
              $("#message").html(data.message);
            }
        });


    //Chargement des indicateurs correspondant au filtre selectionné
    $("#partenaire_id,#periode").change(function(){
      var periode = $("#periode").val();
      var partenaire_id = $("#partenaire_id").val();

       $.ajax({
            url: './model/model_indicateur_synthese.php',
            type: 'POST',
            dataType: 'JSON',
            data:{partenaire_id:partenaire_id,periode:periode},
            success:function(data){
              $("#indicateurs").html(data.indicateurs);
              $("#message").html(data.message);
            }
        });
    });

	});

</script>
</html>
