<?php
// Initialisatiion des valiables de session
  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];

// Verification si l'utilisateur est connecté
  if($user_id < 1){
    // Redirection sur la page de connection
    header('Location: ./index.php');
  }

// Verification du profil de l'utilisateur connecté
  if($profil_id != 1){
    header('Location: ./projet_liste.php');
  }
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de projet - Utilisateurs</title>
	<link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>
</head>
<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
  <?php
    include('sous_menu_projet.php');
    ?>
	<div class="container-fluid">
   	  <div class="row">
   	  	<legend>
   	  		Liste des utilisateurs

   	  	    <div class="pull-right">
              <!-- Lien vers l'inteface d'enregistrement du noveau utilisateur -->
	   	  		<a class="btn btn-primary btn-sm" href="./utilisateur_nouveau.php">Nouveau</a>
	   	  	</div>
	   	</legend>
   	  </div>
     <!-- Tableau des utilisateur -->
   	  <div id="table" style='background:whitesmoke'></div>
        <!-- Pagination -->
      <nav id="pagination"></nav>

   	</div>
    <?php
    // include('footer.php');
     ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){
    // Recuperation des utilisateurs
		$.ajax({
            url: './model/model_utilisateur_liste.php',
            type: 'POST',
            dataType: 'JSON',
            success:function(data){
              $("#table").html(data.table);
              $("#pagination").html(data.pagination);
            }
        });
	});

// Quand on fait un click sur le boutton correspondant a une page qu'on veut afficher
  function getLink(){
    const start = event.target.id;
    $.ajax({
            url: './model/model_utilisateur_liste.php',
            type: 'POST',
            data:{start:start},
            dataType: 'JSON',
            success:function(data){
              $("#table").html(data.table);
              $("#pagination").html(data.pagination);
            }
        });
  }

// Quand on click sur le bouton supprimer
  function supprimer(){
   const user_id = event.target.id;

   $.ajax({
            url: './model/model_utilisateur_delete.php',
            type: 'POST',
            data:{user_id:user_id},
            dataType: 'JSON',
            success:function(data){
              if(data.status == 201){
                // Message apres operation
                $("#message"+user_id).html(data.message);
                // Redirection si la suppression a bien passée
                setTimeout(function(){
                    window.location.href = './utilisateur_liste.php';
                }, 2000);
              }

            }
        });
  }

</script>
</html>
