<?php
// Initialisation des variables de session

  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];
  $partenaire_id = $_SESSION['partenaire_id'];
  $groupe_id = $_SESSION['groupe_id'];

  //Verfication si l'utilisateur est authentifié

  if($user_id < 1 || $profil_id == 14){
    // Si non on fait une redirection sur la page d'authefication
    header('Location: ./index.php');
  }

  //Recuperation de l'ID du prjet
  $partenaire_id = $_GET['partenaire_id'];
  $partenaire = array();
  if($partenaire_id < 1){
    // Si le partenaire n'a pas été selectionné
    header('Location: ./parternaire_liste.php');
  }else{
    // Connection a la base de donnees
    // $mysqli = new mysqli("localhost","root","","crb_care");
	include ('connexion.php');
 
    // Recuperation des informations du partenaire
     $sql = "SELECT * FROM partenaires WHERE partenaire_id = $partenaire_id";
     $partenaire = $mysqli->query($sql);

     //Recuperation des budgets annuels
     $sql_budget = "SELECT * FROM partenaires_annees WHERE partenaire_id = $partenaire_id";
     $budgets = $mysqli->query($sql_budget);

     //Recuperation des tranches
     $sql_tranche = "SELECT * FROM tranches";
     $tranches = $mysqli->query($sql_tranche);
  }
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de partenaire - Budget du partenaire en fonction des années</title>
	<link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>

</head>
<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
   <?php
    include('sous_menu_projet.php');
    ?>
   <div class="container">
   	  <div class="row">
   	  	<legend>
           <?php $partenaire = $partenaire->fetch_array(MYSQLI_ASSOC);?>
            <?=$partenaire['partenaire_name']."(".$partenaire['partenaire_code'].") partenaireé sur ".$partenaire['periode']."ans ,De ".$partenaire['annee_debut']?>
   	  	    <div class="pull-right">
	   	  		<a class="btn btn-primary btn-sm" href="./partenaire_liste.php">Liste des partenaires</a>
	   	  	</div>
	   	</legend>
   	  </div>

      <!-- Zone d'affichage des messages  -->
	  <div class="col-md-12" style='background:whitesmoke' >
   	     <p id="message"></p>
   	  	 <div class="row">
            <!-- Champ du nom  du partenaire -->
   	  	    <div class="col-md-3">
   	  		    Montant global<br>
              <input type="number" name="budget_annuel" id="budget_annuel" value="0" class="form-control">
              <p id="error_budget_annuel" class="text-danger"></p>
   	  	    </div>

             <div class="col-md-3">
   	  		    Date de demande<br>
              <input type="date" name="demande_le" id="demande_le" class="form-control">
              <p id="error_demande_le" class="text-danger"></p>
   	  	    </div>

             <div class="col-md-3">
   	  		    Montant reçu<br>
              <input type="number" name="budget_accepte" id="budget_accepte" value="0" class="form-control">
              <p id="error_budget_accepte" class="text-danger"></p>
   	  	    </div>

             <div class="col-md-3">
   	  		    Date de décaissement<br>
              <input type="date" name="accepte_le" id="accepte_le" class="form-control">
              <p id="error_accepte_le" class="text-danger"></p>
   	  	    </div>

             <div class="col-md-3">
   	  		    Tranches<br>
               <select class="form-control" name="tranche_id" id="tranche_id">
                 <option value="0"> - Sélectionner - </option>
                 <?php
                 foreach ($tranches AS $tranche) {
                  ?>
                   <option value="<?=$tranche['id']?>"><?=$tranche['tranche_nom']?></option>
                  <?php
                 }
               ?>
               <p id="error_tranche_id" class="text-danger"></p>
               </select>
   	  	    </div>

            <!-- Champ de l'année du partenaire -->
   	  	  	<div class="col-md-3">
   	  		     Année<br>
               <input type="hidden" name="partenaire_id" id="partenaire_id" value="<?=$partenaire['partenaire_id']?>">
               <select class="form-control" name="annee_partenaire" id="annee_partenaire">
                 <option value="0"> - Sélectionner - </option>
                 <?php
                 for ($i=$partenaire['annee_debut']; $i < ($partenaire['annee_debut']+$partenaire['periode']+1); $i++) {
                  ?>
                   <option value="<?=$i?>"><?=$i?></option>
                  <?php
                 }
               ?>
               <p id="error_annee_partenaire" class="text-danger"></p>
               </select>
   	  	    </div>
            <!-- Champ de l'année debut du partenaire -->
   	  	    <div class="col-md-4">
   	  		    Commentaire<br>
              <textarea class="form-control" name="commentaire" id="commentaire"></textarea>
   	  	    </div>

           <!-- Boutton d'enregistrement du partenaire -->
             <div class="col-md-2">
              <button class="btn btn-primary btn-sm" style="margin-top:20px" id="save">Ajouter</button>
           </div>
        </div>
	</div>
        <div class="row" style="margin-top:20px;">

          <?php
           $budgets = $budgets->fetch_all(MYSQLI_ASSOC);
            if(!empty($budgets)){
              ?>
              <legend>Les budgets annuels</legend>
               <table class="table table-striped" style="background:whitesmoke">
                 <tr>
                   <th>#</th>
                   <th>B.Global</th>
                   <th>D.Demande</th>
                   <th>B.Reçu</th>
                   <th>D.Décaissement</th>
                   <th>Tranche</th>
                   <th>Année</th>
                   <th>Observation</th>
                   <th>Actions</th>
                 </tr>
              <?php
               $i = 1;
               $budget_total = 0;
               $trs = array(
                        "1"=>"Tranche 1",
                        "2"=>"Tranche 2",
                        "3"=>"Tranche 3",
                        "4"=>"Tranche 4",
                      );

                foreach ($budgets as $budget) {
                  $budget_total += $budget['budget_annuel'];
                  
                  ?>
                   <tr>
                     <td><?=$i?></td>
                     <td><?=number_format($budget['budget_annuel'],0,'',' ')?> BIF</td>
                     <td><?=$budget['demande_le']?></td>

                     <td><?=number_format($budget['budget_accepte'],0,'',' ')?> BIF</td>
                     <td><?=$budget['accepte_le']?></td>

                     <td><?=$trs[$budget['tranche_id']]?></td>
                     <td><?=$budget['annee_partenaire']?></td>
                     <td><?=$budget['commentaire']?></td>
                     <td>
                       <a href='#' class='text-danger' data-toggle='modal' data-target='#myModal<?=$budget['id']?>'>
					    <span  class='glyphicon glyphicon-trash'></span>
					   </a>
                       <div class='modal fade' id='myModal<?=$budget['id']?>' role='dialog'>
                         <div class='modal-dialog'>

                           <div class='modal-content'>
                             <div class='modal-body'>
                               <p>Voulez-vous vraiement supprimer le budget pour cette année ?<br></p>
                               <p class='text-warning'>Toutes les activités y relatives seront supprimés ainsi que ses decaissements.</p>
                             </div>
                             <div class='modal-footer'>
                               <button type='button' class='btn btn-default btn-sm' data-dismiss='modal'>Anuller</button>
                               <a class='btn btn-danger' href='./partenaire_budget_delete.php?id=<?=$budget['id']?>'>Supprimer</a>
                             </div>
                           </div>

                         </div>
                       </div>

                     </td>
                   </tr>
                  <?php
                  $i ++;
                }
                ?>
            <tr>
              <th>TOTAL</th>
              <th><?=number_format($budget_total,0,'',' ')?> BIF</th>
              <th colspan="7"></th>
            </tr>
          </table>
          <?php
            }
          ?>
        </div>
   </div>
   <?php
    include('footer.php');
    ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){

    // Lors du click sur le bouton Enregistrer
      $("#save").click(function(){
        // Recuperation des informations du formulaire

      	var partenaire_id = $("#partenaire_id").val();
      	var annee_partenaire = $("#annee_partenaire").val();
      	var budget_annuel = $("#budget_annuel").val();
      	var commentaire = $("#commentaire").val();

      	var tranche_id = $("#tranche_id").val();
      	var budget_accepte = $("#budget_accepte").val();
      	var accepte_le = $("#accepte_le").val();
      	var demande_le = $("#demande_le").val();

        

        // Vider les champs des messages d'erreurs
      $("#error_annee_partenaire").html(" ");
		  $("#error_budget_annuel").html(" ");


      // Validation du code du partenaire
      	if(partenaire_id<1){
        //  console.log('Test ID '+partenaire_id);
          // message si le champ est invalide
            $("#message").html("Retournez sur la liste et sélectionné le bon partenaire");
      	}

        if(annee_partenaire < 1){
        //  console.log('Test ANNE '+annee_partenaire);
          // message si le champ est invalide
            $("#error_annee_partenaire").html("Le champ <b>année du partenaire</b> est réquis");
      	}

        // Validation du nom du partenaire
      	if(budget_annuel<1){
        //  console.log('Test BUDGET '+budget_annuel);
          // message si le champ est invalide
            $("#error_budget_annuel").html("Le champ <b>budget annuel</b> est réquis");
      	}

        // console.log('Test BUDGET '+budget_annuel);
        // console.log('Test ANNE '+annee_partenaire);
        // console.log('Test ID '+partenaire_id);

        // Si les champs obligatoires sont valides
      	if(partenaire_id >0 && annee_partenaire >0 && budget_annuel >0 && budget_accepte > 0){
          console.log('Test AJAX');
          // Envoie des donnees a enregistrer par la methode POST
          $.ajax({
                url: './model/model_budget_save.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                 	  partenaire_id:partenaire_id,
                	  annee_partenaire:annee_partenaire,
                    budget_annuel:budget_annuel,
                    commentaire:commentaire,
                    tranche_id:tranche_id,
                    budget_accepte:budget_accepte,
                    accepte_le:accepte_le,
                    demande_le:demande_le
                },

                success:function(data){
                  // Message retourne apres operation
                  $("#message").html(data.message);

                  if(data.status == 200){
                    // Si l'operation a bien passé on fait une redirection apres 1 seconde sur la liste des partenaire
                    setTimeout(function(){
                        window.location.href = './partenaire_budget.php?partenaire_id='+partenaire_id;
                    }, 1000);
                  }

                }
            });
      	}
      });

	});
</script>
</html>
